/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4;

import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import sttp.client4.GenericRequestBody;
import sttp.client4.RequestBuilder;
import sttp.client4.ResponseAsDelegate;
import sttp.client4.WebSocketRequest;
import sttp.client4.WebSocketStreamRequest;
import sttp.client4.internal.ToCurlConverter$;
import sttp.client4.internal.ToRfc2616Converter$;
import sttp.model.HasHeaders;
import sttp.model.Header;
import sttp.model.Method;
import sttp.model.RequestMetadata;
import sttp.model.ResponseMetadata;
import sttp.model.Uri;

public interface GenericRequest<T, R>
extends RequestBuilder<GenericRequest<T, R>>,
RequestMetadata {
    @Override
    public GenericRequestBody<R> body();

    @Override
    public ResponseAsDelegate<T, R> response();

    public <T2> GenericRequest<T2, R> mapResponse(Function1<T, T2> var1);

    public <T2> GenericRequest<T2, R> mapResponseWithMetadata(Function2<T, ResponseMetadata, T2> var1);

    public static String toCurl$(GenericRequest $this) {
        return $this.toCurl();
    }

    default public String toCurl() {
        return ToCurlConverter$.MODULE$.apply(this, ToCurlConverter$.MODULE$.apply$default$2(), ToCurlConverter$.MODULE$.apply$default$3(), ToCurlConverter$.MODULE$.apply$default$4());
    }

    public static String toCurl$(GenericRequest $this, Set sensitiveHeaders) {
        return $this.toCurl((Set<String>)sensitiveHeaders);
    }

    default public String toCurl(Set<String> sensitiveHeaders) {
        return ToCurlConverter$.MODULE$.apply(this, ToCurlConverter$.MODULE$.apply$default$2(), sensitiveHeaders, ToCurlConverter$.MODULE$.apply$default$4());
    }

    public static String toCurl$(GenericRequest $this, Set sensitiveHeaders, Set sensitiveQueryParams) {
        return $this.toCurl((Set<String>)sensitiveHeaders, (Set<String>)sensitiveQueryParams);
    }

    default public String toCurl(Set<String> sensitiveHeaders, Set<String> sensitiveQueryParams) {
        return ToCurlConverter$.MODULE$.apply(this, ToCurlConverter$.MODULE$.apply$default$2(), sensitiveHeaders, sensitiveQueryParams);
    }

    public static String toCurl$(GenericRequest $this, boolean omitAcceptEncoding) {
        return $this.toCurl(omitAcceptEncoding);
    }

    default public String toCurl(boolean omitAcceptEncoding) {
        return ToCurlConverter$.MODULE$.apply(this, omitAcceptEncoding, ToCurlConverter$.MODULE$.apply$default$3(), ToCurlConverter$.MODULE$.apply$default$4());
    }

    public static String toCurl$(GenericRequest $this, Set sensitiveHeaders, boolean omitAcceptEncoding) {
        return $this.toCurl((Set<String>)sensitiveHeaders, omitAcceptEncoding);
    }

    default public String toCurl(Set<String> sensitiveHeaders, boolean omitAcceptEncoding) {
        return ToCurlConverter$.MODULE$.apply(this, omitAcceptEncoding, sensitiveHeaders, ToCurlConverter$.MODULE$.apply$default$4());
    }

    public static String toCurl$(GenericRequest $this, Set sensitiveHeaders, Set sensitiveQueryParams, boolean omitAcceptEncoding) {
        return $this.toCurl((Set<String>)sensitiveHeaders, (Set<String>)sensitiveQueryParams, omitAcceptEncoding);
    }

    default public String toCurl(Set<String> sensitiveHeaders, Set<String> sensitiveQueryParams, boolean omitAcceptEncoding) {
        return ToCurlConverter$.MODULE$.apply(this, omitAcceptEncoding, sensitiveHeaders, sensitiveQueryParams);
    }

    public static String toRfc2616Format$(GenericRequest $this) {
        return $this.toRfc2616Format();
    }

    default public String toRfc2616Format() {
        return ToRfc2616Converter$.MODULE$.apply(this, ToRfc2616Converter$.MODULE$.apply$default$2(), ToRfc2616Converter$.MODULE$.apply$default$3());
    }

    public static String toRfc2616Format$(GenericRequest $this, Set sensitiveHeaders) {
        return $this.toRfc2616Format((Set<String>)sensitiveHeaders);
    }

    default public String toRfc2616Format(Set<String> sensitiveHeaders) {
        return ToRfc2616Converter$.MODULE$.apply(this, sensitiveHeaders, ToRfc2616Converter$.MODULE$.apply$default$3());
    }

    public static String toRfc2616Format$(GenericRequest $this, Set sensitiveHeaders, Set sensitiveQueryParams) {
        return $this.toRfc2616Format((Set<String>)sensitiveHeaders, (Set<String>)sensitiveQueryParams);
    }

    default public String toRfc2616Format(Set<String> sensitiveHeaders, Set<String> sensitiveQueryParams) {
        return ToRfc2616Converter$.MODULE$.apply(this, sensitiveHeaders, sensitiveQueryParams);
    }

    public static RequestMetadata onlyMetadata$(GenericRequest $this) {
        return $this.onlyMetadata();
    }

    default public RequestMetadata onlyMetadata() {
        String m = this.method();
        Uri u = this.uri();
        Seq<Header> h = this.headers();
        return new HasHeaders(m, u, h){
            private final String method;
            private final Uri uri;
            private final Seq headers;
            {
                this.method = m$1;
                this.uri = u$1;
                this.headers = h$1;
            }

            public String method() {
                return this.method;
            }

            public Uri uri() {
                return this.uri;
            }

            public Seq headers() {
                return this.headers;
            }
        };
    }

    public static boolean isWebSocket$(GenericRequest $this) {
        return $this.isWebSocket();
    }

    default public boolean isWebSocket() {
        GenericRequest genericRequest = this;
        if (genericRequest instanceof WebSocketRequest) {
            return true;
        }
        return genericRequest instanceof WebSocketStreamRequest;
    }

    public static String showBasic$(GenericRequest $this) {
        return $this.showBasic();
    }

    @Override
    default public String showBasic() {
        return this.showBasicSafe(this.showBasicSafe$default$1());
    }

    public static String showBasicSafe$(GenericRequest $this, Set sensitiveQueryParams) {
        return $this.showBasicSafe((Set<String>)sensitiveQueryParams);
    }

    @Override
    default public String showBasicSafe(Set<String> sensitiveQueryParams) {
        return new StringBuilder(1).append(new Method(this.method())).append(" ").append(this.uri().toStringSafe(sensitiveQueryParams)).toString();
    }

    public static Set showBasicSafe$default$1$(GenericRequest $this) {
        return $this.showBasicSafe$default$1();
    }

    default public Set<String> showBasicSafe$default$1() {
        return Predef$.MODULE$.Set().empty();
    }
}

