/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4;

import scala.;
import scala.$less$colon$less$;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import sttp.client4.ResponseException$;
import sttp.client4.ResponseException$DeserializationException$;
import sttp.client4.ResponseException$UnexpectedStatusCode$;
import sttp.model.ResponseMetadata;
import sttp.model.StatusCode;

public abstract class ResponseException<HE>
extends Exception {
    private final ResponseMetadata response;

    public static Option<ResponseException<?>> find(Throwable throwable) {
        return ResponseException$.MODULE$.find(throwable);
    }

    public static int ordinal(ResponseException<?> responseException) {
        return ResponseException$.MODULE$.ordinal(responseException);
    }

    public ResponseException(String error, Option<Throwable> cause, ResponseMetadata response) {
        this.response = response;
        super(error, (Throwable)cause.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public ResponseMetadata response() {
        return this.response;
    }

    public static class DeserializationException
    extends ResponseException<Nothing$>
    implements Product {
        private final String body;
        private final Exception cause;
        private final ResponseMetadata response;

        public static DeserializationException apply(String string, Exception exception, ResponseMetadata responseMetadata) {
            return ResponseException$DeserializationException$.MODULE$.apply(string, exception, responseMetadata);
        }

        public static DeserializationException fromProduct(Product product) {
            return ResponseException$DeserializationException$.MODULE$.fromProduct(product);
        }

        public static DeserializationException unapply(DeserializationException deserializationException) {
            return ResponseException$DeserializationException$.MODULE$.unapply(deserializationException);
        }

        public DeserializationException(String body, Exception cause, ResponseMetadata response) {
            this.body = body;
            this.cause = cause;
            this.response = response;
            super(cause.getMessage(), (Option<Throwable>)Some$.MODULE$.apply((Object)cause), response);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DeserializationException)) return false;
            DeserializationException deserializationException = (DeserializationException)object;
            String string = this.body();
            String string2 = deserializationException.body();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Exception exception = this.cause();
            Exception exception2 = deserializationException.cause();
            if (exception == null) {
                if (exception2 != null) {
                    return false;
                }
            } else if (!exception.equals(exception2)) return false;
            ResponseMetadata responseMetadata = this.response();
            ResponseMetadata responseMetadata2 = deserializationException.response();
            if (responseMetadata == null) {
                if (responseMetadata2 != null) {
                    return false;
                }
            } else if (!responseMetadata.equals(responseMetadata2)) return false;
            if (!deserializationException.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof DeserializationException;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "DeserializationException";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "body";
                }
                case 1: {
                    return "cause";
                }
                case 2: {
                    return "response";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String body() {
            return this.body;
        }

        public Exception cause() {
            return this.cause;
        }

        @Override
        public ResponseMetadata response() {
            return this.response;
        }

        public DeserializationException copy(String body, Exception cause, ResponseMetadata response) {
            return new DeserializationException(body, cause, response);
        }

        public String copy$default$1() {
            return this.body();
        }

        public Exception copy$default$2() {
            return this.cause();
        }

        public ResponseMetadata copy$default$3() {
            return this.response();
        }

        public String _1() {
            return this.body();
        }

        public Exception _2() {
            return this.cause();
        }

        public ResponseMetadata _3() {
            return this.response();
        }
    }

    public static class UnexpectedStatusCode<HE>
    extends ResponseException<HE>
    implements Product {
        private final Object body;
        private final ResponseMetadata response;

        public static <HE> UnexpectedStatusCode<HE> apply(HE HE, ResponseMetadata responseMetadata) {
            return ResponseException$UnexpectedStatusCode$.MODULE$.apply(HE, responseMetadata);
        }

        public static UnexpectedStatusCode<?> fromProduct(Product product) {
            return ResponseException$UnexpectedStatusCode$.MODULE$.fromProduct(product);
        }

        public static <HE> UnexpectedStatusCode<HE> unapply(UnexpectedStatusCode<HE> unexpectedStatusCode) {
            return ResponseException$UnexpectedStatusCode$.MODULE$.unapply(unexpectedStatusCode);
        }

        public UnexpectedStatusCode(HE body, ResponseMetadata response) {
            this.body = body;
            this.response = response;
            super(new StringBuilder(24).append("statusCode: ").append(new StatusCode(response.code())).append(", response: ").append(body).toString(), (Option<Throwable>)None$.MODULE$, response);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnexpectedStatusCode)) return false;
            UnexpectedStatusCode unexpectedStatusCode = (UnexpectedStatusCode)object;
            if (!BoxesRunTime.equals(this.body(), unexpectedStatusCode.body())) return false;
            ResponseMetadata responseMetadata = this.response();
            ResponseMetadata responseMetadata2 = unexpectedStatusCode.response();
            if (responseMetadata == null) {
                if (responseMetadata2 != null) {
                    return false;
                }
            } else if (!responseMetadata.equals(responseMetadata2)) return false;
            if (!unexpectedStatusCode.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnexpectedStatusCode;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UnexpectedStatusCode";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "body";
            }
            if (1 == n2) {
                return "response";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HE body() {
            return (HE)this.body;
        }

        @Override
        public ResponseMetadata response() {
            return this.response;
        }

        public <HE> UnexpectedStatusCode<HE> copy(HE body, ResponseMetadata response) {
            return new UnexpectedStatusCode<HE>(body, response);
        }

        public <HE> HE copy$default$1() {
            return this.body();
        }

        public <HE> ResponseMetadata copy$default$2() {
            return this.response();
        }

        public HE _1() {
            return this.body();
        }

        public ResponseMetadata _2() {
            return this.response();
        }
    }
}

