/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4;

import java.io.Serializable;
import scala.;
import scala.Function1;
import scala.Function2;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sttp.attributes.AttributeMap;
import sttp.capabilities.package;
import sttp.client4.BasicBody;
import sttp.client4.GenericRequest;
import sttp.client4.RequestOptions;
import sttp.client4.Response;
import sttp.client4.ResponseAsDelegate;
import sttp.client4.StreamBody$;
import sttp.client4.WebSocketBackend;
import sttp.client4.WebSocketRequest$;
import sttp.client4.WebSocketResponseAs;
import sttp.client4.WebSocketStreamRequest;
import sttp.client4.WebSocketStreamRequest$;
import sttp.client4.WebSocketStreamResponseAs$;
import sttp.client4.WebSocketSyncBackend;
import sttp.model.Header;
import sttp.model.Method;
import sttp.model.ResponseMetadata;
import sttp.model.Uri;

public final class WebSocketRequest<F, T>
implements GenericRequest<T, package.Effect<F>>,
Product,
Serializable {
    private final String method;
    private final Uri uri;
    private final BasicBody body;
    private final Seq headers;
    private final WebSocketResponseAs response;
    private final RequestOptions options;
    private final AttributeMap attributes;

    public static <F, T> WebSocketRequest<F, T> apply(String string, Uri uri, BasicBody basicBody, Seq<Header> seq, WebSocketResponseAs<F, T> webSocketResponseAs, RequestOptions requestOptions, AttributeMap attributeMap) {
        return WebSocketRequest$.MODULE$.apply(string, uri, basicBody, seq, webSocketResponseAs, requestOptions, attributeMap);
    }

    public static WebSocketRequest<?, ?> fromProduct(Product product) {
        return WebSocketRequest$.MODULE$.fromProduct(product);
    }

    public static <F, T> WebSocketRequest<F, T> unapply(WebSocketRequest<F, T> webSocketRequest) {
        return WebSocketRequest$.MODULE$.unapply(webSocketRequest);
    }

    public WebSocketRequest(String method, Uri uri, BasicBody body, Seq<Header> headers, WebSocketResponseAs<F, T> response, RequestOptions options, AttributeMap attributes) {
        this.method = method;
        this.uri = uri;
        this.body = body;
        this.headers = headers;
        this.response = response;
        this.options = options;
        this.attributes = attributes;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof WebSocketRequest)) return false;
        WebSocketRequest webSocketRequest = (WebSocketRequest)object;
        String string = this.method();
        String string2 = webSocketRequest.method();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Uri uri = this.uri();
        Uri uri2 = webSocketRequest.uri();
        if (uri == null) {
            if (uri2 != null) {
                return false;
            }
        } else if (!uri.equals(uri2)) return false;
        BasicBody basicBody = this.body();
        BasicBody basicBody2 = webSocketRequest.body();
        if (basicBody == null) {
            if (basicBody2 != null) {
                return false;
            }
        } else if (!basicBody.equals(basicBody2)) return false;
        Seq<Header> seq = this.headers();
        Seq<Header> seq2 = webSocketRequest.headers();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        ResponseAsDelegate responseAsDelegate = this.response();
        ResponseAsDelegate responseAsDelegate2 = webSocketRequest.response();
        if (responseAsDelegate == null) {
            if (responseAsDelegate2 != null) {
                return false;
            }
        } else if (!responseAsDelegate.equals(responseAsDelegate2)) return false;
        RequestOptions requestOptions = this.options();
        RequestOptions requestOptions2 = webSocketRequest.options();
        if (requestOptions == null) {
            if (requestOptions2 != null) {
                return false;
            }
        } else if (!((Object)requestOptions).equals(requestOptions2)) return false;
        AttributeMap attributeMap = this.attributes();
        AttributeMap attributeMap2 = webSocketRequest.attributes();
        if (attributeMap == null) {
            if (attributeMap2 == null) return true;
            return false;
        } else {
            if (!attributeMap.equals(attributeMap2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof WebSocketRequest;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "WebSocketRequest";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return new Method(this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "method";
            }
            case 1: {
                return "uri";
            }
            case 2: {
                return "body";
            }
            case 3: {
                return "headers";
            }
            case 4: {
                return "response";
            }
            case 5: {
                return "options";
            }
            case 6: {
                return "attributes";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String method() {
        return this.method;
    }

    public Uri uri() {
        return this.uri;
    }

    public BasicBody body() {
        return this.body;
    }

    @Override
    public Seq<Header> headers() {
        return this.headers;
    }

    @Override
    public WebSocketResponseAs<F, T> response() {
        return this.response;
    }

    @Override
    public RequestOptions options() {
        return this.options;
    }

    @Override
    public AttributeMap attributes() {
        return this.attributes;
    }

    @Override
    public WebSocketRequest<F, T> method(String method, Uri uri) {
        return this.copy(method, uri, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public WebSocketRequest<F, T> withHeaders(Seq<Header> headers) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), headers, this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public WebSocketRequest<F, T> withOptions(RequestOptions options) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), options, this.copy$default$7());
    }

    @Override
    public WebSocketRequest<F, T> withAttributes(AttributeMap attributes) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), attributes);
    }

    @Override
    public WebSocketRequest<F, T> copyWithBody(BasicBody body) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), body, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public <S> WebSocketStreamRequest<T, S> streamBody(package.Streams<S> s, Object b) {
        return WebSocketStreamRequest$.MODULE$.apply(this.method(), this.uri(), StreamBody$.MODULE$.apply(s, b), this.headers(), WebSocketStreamResponseAs$.MODULE$.apply(((WebSocketResponseAs)this.response()).delegate()), this.options(), this.attributes());
    }

    @Override
    public <T2> WebSocketRequest<F, T2> mapResponse(Function1<T, T2> f) {
        WebSocketResponseAs webSocketResponseAs = ((WebSocketResponseAs)this.response()).map(f);
        String string = this.copy$default$1();
        Uri uri = this.copy$default$2();
        BasicBody basicBody = this.copy$default$3();
        Seq<Header> seq = this.copy$default$4();
        RequestOptions requestOptions = this.copy$default$6();
        AttributeMap attributeMap = this.copy$default$7();
        return this.copy(string, uri, basicBody, seq, webSocketResponseAs, requestOptions, attributeMap);
    }

    @Override
    public <T2> WebSocketRequest<F, T2> mapResponseWithMetadata(Function2<T, ResponseMetadata, T2> f) {
        WebSocketResponseAs webSocketResponseAs = ((WebSocketResponseAs)this.response()).mapWithMetadata(f);
        String string = this.copy$default$1();
        Uri uri = this.copy$default$2();
        BasicBody basicBody = this.copy$default$3();
        Seq<Header> seq = this.copy$default$4();
        RequestOptions requestOptions = this.copy$default$6();
        AttributeMap attributeMap = this.copy$default$7();
        return this.copy(string, uri, basicBody, seq, webSocketResponseAs, requestOptions, attributeMap);
    }

    public F send(WebSocketBackend<F> backend) {
        return backend.send(this);
    }

    public Response<T> send(WebSocketSyncBackend backend, .eq.colon.eq<T, F> ev) {
        return (Response)backend.send(this);
    }

    public <F, T> WebSocketRequest<F, T> copy(String method, Uri uri, BasicBody body, Seq<Header> headers, WebSocketResponseAs<F, T> response, RequestOptions options, AttributeMap attributes) {
        return new WebSocketRequest<F, T>(method, uri, body, headers, response, options, attributes);
    }

    public <F, T> String copy$default$1() {
        return this.method();
    }

    public <F, T> Uri copy$default$2() {
        return this.uri();
    }

    public <F, T> BasicBody copy$default$3() {
        return this.body();
    }

    public <F, T> Seq<Header> copy$default$4() {
        return this.headers();
    }

    public <F, T> WebSocketResponseAs<F, T> copy$default$5() {
        return this.response();
    }

    public <F, T> RequestOptions copy$default$6() {
        return this.options();
    }

    public <F, T> AttributeMap copy$default$7() {
        return this.attributes();
    }

    public String _1() {
        return this.method();
    }

    public Uri _2() {
        return this.uri();
    }

    public BasicBody _3() {
        return this.body();
    }

    public Seq<Header> _4() {
        return this.headers();
    }

    public WebSocketResponseAs<F, T> _5() {
        return this.response();
    }

    public RequestOptions _6() {
        return this.options();
    }

    public AttributeMap _7() {
        return this.attributes();
    }
}

