/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.compression;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import scala.MatchError;
import scala.Product;
import scala.collection.immutable.Seq;
import sttp.client4.BasicBodyPart;
import sttp.client4.BasicMultipartBody;
import sttp.client4.BasicMultipartBody$;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.FileBody$;
import sttp.client4.GenericRequestBody;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.MultipartStreamBody;
import sttp.client4.MultipartStreamBody$;
import sttp.client4.NoBody$;
import sttp.client4.StreamBody;
import sttp.client4.StreamBody$;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.compression.Compressor;
import sttp.client4.compression.Compressor$;
import sttp.client4.internal.SttpFile;
import sttp.model.Encodings$;
import sttp.model.MediaType;
import sttp.model.Part;

public class DeflateDefaultCompressor<R>
implements Compressor<R> {
    private final String encoding = Encodings$.MODULE$.Deflate();

    @Override
    public String encoding() {
        return this.encoding;
    }

    @Override
    public <R2 extends R> GenericRequestBody<R> apply(GenericRequestBody<R2> body) {
        Product product;
        GenericRequestBody<R2> genericRequestBody = body;
        if (NoBody$.MODULE$.equals(genericRequestBody)) {
            product = NoBody$.MODULE$;
        } else if (genericRequestBody instanceof StringBody) {
            StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)genericRequestBody);
            String string = stringBody._1();
            String string2 = stringBody._2();
            MediaType mediaType = stringBody._3();
            String s = string;
            String encoding = string2;
            MediaType defaultContentType = mediaType;
            product = ByteArrayBody$.MODULE$.apply(this.byteArray(s.getBytes(encoding)), defaultContentType);
        } else if (genericRequestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)genericRequestBody);
            byte[] byArray = byteArrayBody._1();
            MediaType mediaType = byteArrayBody._2();
            byte[] b = byArray;
            MediaType defaultContentType = mediaType;
            product = ByteArrayBody$.MODULE$.apply(this.byteArray(b), defaultContentType);
        } else if (genericRequestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)genericRequestBody);
            ByteBuffer byteBuffer = byteBufferBody._1();
            MediaType mediaType = byteBufferBody._2();
            ByteBuffer b = byteBuffer;
            MediaType defaultContentType = mediaType;
            product = ByteArrayBody$.MODULE$.apply(this.byteArray(Compressor$.MODULE$.byteBufferToArray(b)), defaultContentType);
        } else if (genericRequestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = InputStreamBody$.MODULE$.unapply((InputStreamBody)genericRequestBody);
            InputStream inputStream = inputStreamBody._1();
            MediaType mediaType = inputStreamBody._2();
            InputStream b = inputStream;
            MediaType defaultContentType = mediaType;
            product = InputStreamBody$.MODULE$.apply(new DeflaterInputStream(b), defaultContentType);
        } else {
            if (genericRequestBody instanceof StreamBody) {
                Object BinaryStream;
                StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)genericRequestBody);
                Object b = BinaryStream = streamBody._1();
                throw Compressor$.MODULE$.streamsNotSupported();
            }
            if (genericRequestBody instanceof FileBody) {
                FileBody fileBody = FileBody$.MODULE$.unapply((FileBody)genericRequestBody);
                SttpFile sttpFile = fileBody._1();
                MediaType mediaType = fileBody._2();
                SttpFile f = sttpFile;
                MediaType defaultContentType = mediaType;
                product = InputStreamBody$.MODULE$.apply(new DeflaterInputStream(f.openStream()), defaultContentType);
            } else {
                if (genericRequestBody instanceof MultipartStreamBody) {
                    Seq seq;
                    MultipartStreamBody multipartStreamBody = MultipartStreamBody$.MODULE$.unapply((MultipartStreamBody)genericRequestBody);
                    Seq parts = seq = multipartStreamBody._1();
                    throw Compressor$.MODULE$.compressingMultipartBodiesNotSupported();
                }
                if (genericRequestBody instanceof BasicMultipartBody) {
                    Seq<Part<BasicBodyPart>> seq;
                    BasicMultipartBody basicMultipartBody = BasicMultipartBody$.MODULE$.unapply((BasicMultipartBody)genericRequestBody);
                    Seq<Part<BasicBodyPart>> parts = seq = basicMultipartBody._1();
                    throw Compressor$.MODULE$.compressingMultipartBodiesNotSupported();
                }
                throw new MatchError(genericRequestBody);
            }
        }
        return product;
    }

    private byte[] byteArray(byte[] bytes) {
        byte[] byArray;
        Deflater deflater = new Deflater();
        try {
            deflater.setInput(bytes);
            deflater.finish();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] readBuffer = new byte[1024];
            while (!deflater.finished()) {
                int readCount = deflater.deflate(readBuffer);
                if (readCount <= 0) continue;
                byteArrayOutputStream.write(readBuffer, 0, readCount);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        finally {
            deflater.end();
        }
        return byArray;
    }
}

