/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.compression;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import scala.Enumeration;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import sttp.client4.compression.GZIPCompressingInputStream$;
import sttp.client4.compression.GZIPCompressingInputStream$State$;

public class GZIPCompressingInputStream
extends InputStream {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(GZIPCompressingInputStream.class.getDeclaredField("State$lzy1"));
    private final InputStream source;
    private volatile Object State$lzy1;
    private final Deflater deflater;
    private final CRC32 crc;
    private ByteArrayInputStream trailer;
    private final ByteArrayInputStream header;
    private byte[] deflationBuffer;
    private Enumeration.Value stage;

    public static int $lessinit$greater$default$2() {
        return GZIPCompressingInputStream$.MODULE$.$lessinit$greater$default$2();
    }

    public GZIPCompressingInputStream(InputStream source, int compressionLevel) {
        this.source = source;
        int GZIP_MAGIC = 35615;
        byte[] HEADER_DATA = new byte[]{(byte)GZIP_MAGIC, (byte)(GZIP_MAGIC >> 8), (byte)8, 0, 0, 0, 0, 0, 0, 0};
        int INITIAL_BUFFER_SIZE = 8192;
        this.deflater = new Deflater(8, true);
        this.deflater.setLevel(compressionLevel);
        this.crc = new CRC32();
        this.header = new ByteArrayInputStream(HEADER_DATA);
        this.deflationBuffer = new byte[INITIAL_BUFFER_SIZE];
        this.stage = this.State().HEADER();
        this.crc.reset();
    }

    private final GZIPCompressingInputStream$State$ State() {
        Object object = this.State$lzy1;
        if (object instanceof GZIPCompressingInputStream$State$) {
            return (GZIPCompressingInputStream$State$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (GZIPCompressingInputStream$State$)this.State$lzyINIT1();
    }

    private Object State$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.State$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    GZIPCompressingInputStream$State$ gZIPCompressingInputStream$State$ = null;
                    try {
                        gZIPCompressingInputStream$State$ = new GZIPCompressingInputStream$State$();
                        object2 = gZIPCompressingInputStream$State$ == null ? LazyVals.NullValue$.MODULE$ : gZIPCompressingInputStream$State$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.State$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return gZIPCompressingInputStream$State$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public int read() {
        byte[] readBytes = new byte[1];
        int bytesRead = 0;
        while (bytesRead == 0) {
            bytesRead = this.read(readBytes, 0, 1);
        }
        if (bytesRead != -1) {
            return readBytes[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] readBuffer, int readOffset, int readLength) throws IOException {
        Enumeration.Value value = this.stage;
        Enumeration.Value value2 = this.State().HEADER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            int bytesRead = this.header.read(readBuffer, readOffset, readLength);
            if (this.header.available() == 0) {
                this.stage = this.State().DATA();
            }
            return bytesRead;
        }
        Enumeration.Value value4 = this.State().DATA();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            int bytesRead;
            if (!this.deflater.needsInput()) {
                return this.deflatePendingInput(readBuffer, readOffset, readLength);
            }
            if (this.deflationBuffer.length < readLength) {
                this.deflationBuffer = new byte[readLength];
            }
            if ((bytesRead = this.source.read(this.deflationBuffer, 0, readLength)) <= 0) {
                this.stage = this.State().FINALISE();
                this.deflater.finish();
                return 0;
            }
            this.crc.update(this.deflationBuffer, 0, bytesRead);
            this.deflater.setInput(this.deflationBuffer, 0, bytesRead);
            return this.deflatePendingInput(readBuffer, readOffset, readLength);
        }
        Enumeration.Value value6 = this.State().FINALISE();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            if (this.deflater.finished()) {
                this.stage = this.State().TRAILER();
                int crcValue = (int)this.crc.getValue();
                int totalIn = this.deflater.getTotalIn();
                this.trailer = this.createTrailer(crcValue, totalIn);
                return 0;
            }
            return this.deflater.deflate(readBuffer, readOffset, readLength, 3);
        }
        Enumeration.Value value8 = this.State().TRAILER();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            int bytesRead = this.trailer.read(readBuffer, readOffset, readLength);
            if (this.trailer.available() == 0) {
                this.stage = this.State().DONE();
            }
            return bytesRead;
        }
        Enumeration.Value value10 = this.State().DONE();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return -1;
        }
        throw new IllegalArgumentException(new StringBuilder(15).append("Invalid state: ").append(this.stage).toString());
    }

    private int deflatePendingInput(byte[] readBuffer, int readOffset, int readLength) {
        int bytesCompressed = 0;
        while (!this.deflater.needsInput() && readLength - bytesCompressed > 0) {
            bytesCompressed += this.deflater.deflate(readBuffer, readOffset + bytesCompressed, readLength - bytesCompressed, 3);
        }
        return bytesCompressed;
    }

    private ByteArrayInputStream createTrailer(int crcValue, int totalIn) {
        return new ByteArrayInputStream(new byte[]{(byte)(crcValue >> 0), (byte)(crcValue >> 8), (byte)(crcValue >> 16), (byte)(crcValue >> 24), (byte)(totalIn >> 0), (byte)(totalIn >> 8), (byte)(totalIn >> 16), (byte)(totalIn >> 24)});
    }

    @Override
    public int available() {
        Enumeration.Value value = this.stage;
        Enumeration.Value value2 = this.State().DONE();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            return 0;
        }
        return 1;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
        this.deflater.end();
        if (this.trailer != null) {
            this.trailer.close();
        }
        this.header.close();
    }
}

