/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.httpclient;

import java.io.InputStream;
import java.io.Serializable;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.net.http.WebSocketHandshakeException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sttp.capabilities.package;
import sttp.client4.BackendOptions;
import sttp.client4.GenericRequest;
import sttp.client4.Response;
import sttp.client4.Response$;
import sttp.client4.WebSocketSyncBackend;
import sttp.client4.compression.CompressionHandlers;
import sttp.client4.httpclient.HttpClientBackend;
import sttp.client4.httpclient.HttpClientSyncBackend$;
import sttp.client4.internal.BodyFromResponseAs;
import sttp.client4.internal.FailingLimitedInputStream;
import sttp.client4.internal.NoStreams;
import sttp.client4.internal.NoStreams$;
import sttp.client4.internal.OnEndInputStream;
import sttp.client4.internal.httpclient.AddToQueueListener;
import sttp.client4.internal.httpclient.BodyFromHttpClient;
import sttp.client4.internal.httpclient.BodyToHttpClient;
import sttp.client4.internal.httpclient.DelegatingWebSocketListener;
import sttp.client4.internal.httpclient.IdSequencer;
import sttp.client4.internal.httpclient.InputStreamBodyFromHttpClient;
import sttp.client4.internal.httpclient.MultipartBodyBuilder;
import sttp.client4.internal.httpclient.NonStreamMultipartBodyBuilder;
import sttp.client4.internal.httpclient.Sequencer;
import sttp.client4.internal.httpclient.WebSocketImpl;
import sttp.client4.internal.ws.SimpleQueue;
import sttp.client4.internal.ws.SyncQueue;
import sttp.client4.internal.ws.WebSocketEvent;
import sttp.client4.testing.WebSocketSyncBackendStub;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.ResponseMetadata;
import sttp.model.StatusCode$;
import sttp.monad.IdentityMonad$;
import sttp.monad.MonadError;

public class HttpClientSyncBackend
extends HttpClientBackend<Object, Nothing$, package.WebSockets, InputStream>
implements WebSocketSyncBackend {
    private final HttpClient client;
    private final Function1<HttpRequest, HttpRequest> customizeRequest;
    public final CompressionHandlers<Object, InputStream> sttp$client4$httpclient$HttpClientSyncBackend$$compression;
    private final NoStreams streams;
    private final BodyToHttpClient bodyToHttpClient;
    private final BodyFromHttpClient bodyFromHttpClient;

    public static CompressionHandlers<Object, InputStream> DefaultCompressionHandlers() {
        return HttpClientSyncBackend$.MODULE$.DefaultCompressionHandlers();
    }

    public static WebSocketSyncBackend apply(BackendOptions backendOptions, Function1<HttpRequest, HttpRequest> function1, CompressionHandlers<Object, InputStream> compressionHandlers) {
        return HttpClientSyncBackend$.MODULE$.apply(backendOptions, function1, compressionHandlers);
    }

    public static WebSocketSyncBackendStub stub() {
        return HttpClientSyncBackend$.MODULE$.stub();
    }

    public static WebSocketSyncBackend usingClient(HttpClient httpClient, Function1<HttpRequest, HttpRequest> function1, CompressionHandlers<Object, InputStream> compressionHandlers) {
        return HttpClientSyncBackend$.MODULE$.usingClient(httpClient, function1, compressionHandlers);
    }

    public static BackendOptions apply$default$1() {
        return HttpClientSyncBackend$.MODULE$.apply$default$1();
    }

    public static Function1<HttpRequest, HttpRequest> apply$default$2() {
        return HttpClientSyncBackend$.MODULE$.apply$default$2();
    }

    public static Function1<HttpRequest, HttpRequest> usingClient$default$2() {
        return HttpClientSyncBackend$.MODULE$.usingClient$default$2();
    }

    public static CompressionHandlers<Object, InputStream> apply$default$3() {
        return HttpClientSyncBackend$.MODULE$.apply$default$3();
    }

    public static CompressionHandlers<Object, InputStream> usingClient$default$3() {
        return HttpClientSyncBackend$.MODULE$.usingClient$default$3();
    }

    public HttpClientSyncBackend(HttpClient client, boolean closeClient, Function1<HttpRequest, HttpRequest> customizeRequest, CompressionHandlers<Object, InputStream> compression) {
        this.client = client;
        this.customizeRequest = customizeRequest;
        this.sttp$client4$httpclient$HttpClientSyncBackend$$compression = compression;
        super(client, closeClient, compression);
        this.streams = NoStreams$.MODULE$;
        this.bodyToHttpClient = new BodyToHttpClient<Object, Nothing$, package.Effect<Object>>(this){
            private final NoStreams streams;
            private final MonadError monad;
            private final MultipartBodyBuilder multiPartBodyBuilder;
            private final /* synthetic */ HttpClientSyncBackend $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.streams = NoStreams$.MODULE$;
                this.monad = IdentityMonad$.MODULE$;
                this.multiPartBodyBuilder = new NonStreamMultipartBodyBuilder<Nothing$, Object>(){};
            }

            public NoStreams streams() {
                return this.streams;
            }

            public MonadError monad() {
                return this.monad;
            }

            public MultipartBodyBuilder multiPartBodyBuilder() {
                return this.multiPartBodyBuilder;
            }

            public HttpRequest.BodyPublisher streamToPublisher(Nothing$ stream) {
                throw stream;
            }

            public List compressors() {
                return this.$outer.sttp$client4$httpclient$HttpClientSyncBackend$$compression.compressors();
            }
        };
        this.bodyFromHttpClient = new InputStreamBodyFromHttpClient<Object, Nothing$>(){
            public static final long OFFSET$0;
            private volatile Object bodyFromResponseAs$lzy1;
            private final NoStreams streams;
            {
                InputStreamBodyFromHttpClient.$init$(this);
                this.streams = NoStreams$.MODULE$;
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$3.class.getDeclaredField("bodyFromResponseAs$lzy1"));
            }

            public BodyFromResponseAs bodyFromResponseAs() {
                Object object = this.bodyFromResponseAs$lzy1;
                if (object instanceof BodyFromResponseAs) {
                    return (BodyFromResponseAs)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (BodyFromResponseAs)this.bodyFromResponseAs$lzyINIT1();
            }

            private Object bodyFromResponseAs$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.bodyFromResponseAs$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            BodyFromResponseAs bodyFromResponseAs = null;
                            try {
                                bodyFromResponseAs = InputStreamBodyFromHttpClient.bodyFromResponseAs$(this);
                                object2 = bodyFromResponseAs == null ? LazyVals.NullValue$.MODULE$ : bodyFromResponseAs;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.bodyFromResponseAs$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return bodyFromResponseAs;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public Tuple2 inputStreamToStream(InputStream is) {
                return (Tuple2)this.monad().error((Throwable)new IllegalStateException("Streaming is not supported"));
            }

            public NoStreams streams() {
                return this.streams;
            }

            public MonadError monad() {
                return IdentityMonad$.MODULE$;
            }

            public BoxedUnit compileWebSocketPipe(sttp.ws.WebSocket ws, Nothing$ pipe) {
                throw pipe;
            }
        };
    }

    public NoStreams streams() {
        return this.streams;
    }

    @Override
    public <T> Response<T> sendRegular(GenericRequest<T, package.Effect<Object>> request) {
        Response response;
        HttpRequest jRequest = (HttpRequest)this.customizeRequest.apply(this.convertRequest(request));
        HttpResponse<InputStream> response2 = this.client.send(jRequest, HttpResponse.BodyHandlers.ofInputStream());
        try {
            InputStream body = response2.body();
            InputStream limitedBody = (InputStream)request.options().maxResponseBodyLength().fold(() -> HttpClientSyncBackend.$anonfun$1(body), (Function1 & Serializable)_$1 -> HttpClientSyncBackend.$anonfun$2(body, BoxesRunTime.unboxToLong((Object)_$1)));
            response = (Response)this.readResponse(response2, package$.MODULE$.Left().apply((Object)limitedBody), request);
        }
        catch (Throwable e) {
            try {
                response2.body().close();
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
        return response;
    }

    @Override
    public <T> Response<T> sendWebSocket(GenericRequest<T, package.Effect<Object>> request) {
        Response response;
        SyncQueue<WebSocketEvent> queue = new SyncQueue<WebSocketEvent>((Option<Object>)None$.MODULE$);
        IdSequencer sequencer = new IdSequencer();
        AtomicReference<WebSocket> lowLevelWS = new AtomicReference<WebSocket>();
        try {
            response = this.sendWebSocket(request, queue, sequencer, lowLevelWS);
        }
        catch (Throwable throwable) {
            CompletionException e;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof CompletionException && (e = (CompletionException)throwable2).getCause() instanceof WebSocketHandshakeException) {
                response = (Response)this.readResponse(((WebSocketHandshakeException)e.getCause()).getResponse(), package$.MODULE$.Left().apply((Object)sttp.client4.internal.package$.MODULE$.emptyInputStream()), request);
            }
            if (throwable2 != null) {
                Throwable e2 = throwable2;
                try {
                    WebSocket llws = lowLevelWS.get();
                    if (llws != null) {
                        llws.abort();
                    }
                }
                catch (Throwable e22) {
                    e2.addSuppressed(e22);
                }
                throw e2;
            }
            throw throwable;
        }
        return response;
    }

    private <T> Response<T> sendWebSocket(GenericRequest<T, package.Effect<Object>> request, SimpleQueue<Object, WebSocketEvent> queue, Sequencer<Object> sequencer, AtomicReference<WebSocket> lowLevelWS) {
        AtomicBoolean isOpen = new AtomicBoolean(false);
        ArrayBlockingQueue responseCell = new ArrayBlockingQueue(1);
        DelegatingWebSocketListener listener = new DelegatingWebSocketListener(new AddToQueueListener<Object>(queue, isOpen), (Function1<WebSocket, BoxedUnit>)(JProcedure1 & Serializable)ws -> {
            lowLevelWS.set((WebSocket)ws);
            WebSocketImpl webSocket = new WebSocketImpl((WebSocket)ws, queue, isOpen, sequencer, this.monad(), (Function1<CompletableFuture<WebSocket>, Object>)(Function1 & Serializable)cf -> {
                WebSocket webSocket = (WebSocket)cf.get();
                return BoxedUnit.UNIT;
            });
            String subprotocol = ws.getSubprotocol();
            Nil$ headers = subprotocol != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(subprotocol)) ? (List)new .colon.colon((Object)Header$.MODULE$.apply(HeaderNames$.MODULE$.SecWebSocketProtocol(), subprotocol), (List)Nil$.MODULE$) : package$.MODULE$.Nil();
            Response<BoxedUnit> baseResponse = Response$.MODULE$.apply(BoxedUnit.UNIT, StatusCode$.MODULE$.SwitchingProtocols(), "", (Seq<Header>)headers, (List<ResponseMetadata>)package$.MODULE$.Nil(), request.onlyMetadata());
            Function0 & Serializable body = (Function0 & Serializable)() -> this.bodyFromHttpClient().apply((Either<InputStream, sttp.ws.WebSocket<Object>>)package$.MODULE$.Right().apply((Object)webSocket), request.response(), baseResponse);
            HttpClientSyncBackend.fillCell$1(responseCell, (Function0 & Serializable)() -> baseResponse.copy((BoxedUnit)body.apply(), baseResponse.copy$default$2(), baseResponse.copy$default$3(), baseResponse.copy$default$4(), baseResponse.copy$default$5(), baseResponse.copy$default$6()));
        }, (Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)t -> HttpClientSyncBackend.fillCellError$1(responseCell, t));
        this.prepareWebSocketBuilder(request, this.client).buildAsync(request.uri().toJavaUri(), listener).get();
        return (Response)((Either)responseCell.take()).fold((Function1 & Serializable)_$2 -> {
            throw _$2;
        }, (Function1 & Serializable)f -> (Response)f.apply());
    }

    @Override
    public BodyToHttpClient<Object, Nothing$, package.Effect<Object>> bodyToHttpClient() {
        return this.bodyToHttpClient;
    }

    @Override
    public BodyFromHttpClient<Object, Nothing$, InputStream> bodyFromHttpClient() {
        return this.bodyFromHttpClient;
    }

    @Override
    public InputStream addOnEndCallbackToBody(InputStream b, Function0<BoxedUnit> callback) {
        return new OnEndInputStream(b, callback);
    }

    private static final InputStream $anonfun$1(InputStream body$1) {
        return body$1;
    }

    private static final /* synthetic */ InputStream $anonfun$2(InputStream body$2, long _$1) {
        return new FailingLimitedInputStream(body$2, _$1);
    }

    private static final void fillCellError$1(ArrayBlockingQueue responseCell$1, Throwable t) {
        boolean bl = responseCell$1.add(package$.MODULE$.Left().apply((Object)t));
    }

    private static final void fillCell$1(ArrayBlockingQueue responseCell$2, Function0 wr) {
        boolean bl = responseCell$2.add(package$.MODULE$.Right().apply((Object)wr));
    }
}

