/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal.httpclient;

import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.runtime.BoxedUnit;

public class DelegatingWebSocketListener<WS_RESULT>
implements WebSocket.Listener {
    private final WebSocket.Listener delegate;
    private final Function1<WebSocket, BoxedUnit> onInitialOpen;
    private final Function1<Throwable, BoxedUnit> onInitialError;
    private final AtomicBoolean initialised;

    public DelegatingWebSocketListener(WebSocket.Listener delegate, Function1<WebSocket, BoxedUnit> onInitialOpen, Function1<Throwable, BoxedUnit> onInitialError) {
        this.delegate = delegate;
        this.onInitialOpen = onInitialOpen;
        this.onInitialError = onInitialError;
        this.initialised = new AtomicBoolean(false);
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        if (!this.initialised.getAndSet(true)) {
            this.onInitialOpen.apply((Object)webSocket);
        }
        this.delegate.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        return this.delegate.onText(webSocket, data, last);
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        return this.delegate.onBinary(webSocket, data, last);
    }

    @Override
    public CompletionStage<?> onPing(WebSocket webSocket, ByteBuffer message) {
        return this.delegate.onPing(webSocket, message);
    }

    @Override
    public CompletionStage<?> onPong(WebSocket webSocket, ByteBuffer message) {
        return this.delegate.onPong(webSocket, message);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        return this.delegate.onClose(webSocket, statusCode, reason);
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        if (!this.initialised.getAndSet(true)) {
            this.onInitialError.apply((Object)error);
        }
        this.delegate.onError(webSocket, error);
    }
}

