/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal.httpclient;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.FileBody$;
import sttp.client4.GenericRequestBody;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.MultipartBody;
import sttp.client4.NoBody$;
import sttp.client4.StreamBody;
import sttp.client4.StreamBody$;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.internal.SttpFile;
import sttp.client4.internal.httpclient.ByteBufferBackedInputStream;
import sttp.client4.internal.httpclient.MultiPartBodyPublisher;
import sttp.client4.internal.httpclient.MultipartBodyBuilder;
import sttp.client4.internal.package$;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Part;
import sttp.monad.MonadError;
import sttp.monad.syntax;
import sttp.monad.syntax$;

public interface NonStreamMultipartBodyBuilder<BinaryStream, F>
extends MultipartBodyBuilder<BinaryStream, F> {
    public static Tuple2 apply$(NonStreamMultipartBodyBuilder $this, Seq parts, MonadError m) {
        return $this.apply(parts, m);
    }

    @Override
    default public Tuple2<F, String> apply(Seq<Part<GenericRequestBody<?>>> parts, MonadError<F> m) {
        MultiPartBodyPublisher multipartBuilder = new MultiPartBodyPublisher();
        parts.foreach((Function1 & Serializable)p -> {
            Header header = Header$.MODULE$.apply(HeaderNames$.MODULE$.ContentDisposition(), p.contentDispositionHeaderValue());
            Seq allHeaders = (Seq)p.headers().$plus$colon((Object)header);
            java.util.Map partHeaders = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((IterableOnceOps)allHeaders.map((Function1 & Serializable)h -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.value());
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            GenericRequestBody genericRequestBody = (GenericRequestBody)p.body();
            if (NoBody$.MODULE$.equals(genericRequestBody)) {
                return BoxedUnit.UNIT;
            }
            if (genericRequestBody instanceof FileBody) {
                FileBody fileBody = FileBody$.MODULE$.unapply((FileBody)genericRequestBody);
                SttpFile sttpFile = fileBody._1();
                MediaType mediaType = fileBody._2();
                SttpFile f = sttpFile;
                return multipartBuilder.addPart(p.name(), f.toFile().toPath(), (java.util.Map<String, String>)partHeaders);
            }
            if (genericRequestBody instanceof StringBody) {
                StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)genericRequestBody);
                String string = stringBody._1();
                String string2 = stringBody._2();
                MediaType mediaType = stringBody._3();
                String b = string;
                String e = string2;
                if (e.equalsIgnoreCase(package$.MODULE$.Utf8())) {
                    return multipartBuilder.addPart(p.name(), b, (java.util.Map<String, String>)partHeaders);
                }
                String b2 = string;
                String e2 = string2;
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)((Function0 & Serializable)() -> NonStreamMultipartBodyBuilder.apply$$anonfun$1$$anonfun$1(b2, e2))), (java.util.Map<String, String>)partHeaders);
            }
            if (genericRequestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)genericRequestBody);
                byte[] byArray = byteArrayBody._1();
                MediaType mediaType = byteArrayBody._2();
                byte[] b = byArray;
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)((Function0 & Serializable)() -> NonStreamMultipartBodyBuilder.apply$$anonfun$1$$anonfun$2(b))), (java.util.Map<String, String>)partHeaders);
            }
            if (genericRequestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)genericRequestBody);
                ByteBuffer byteBuffer = byteBufferBody._1();
                MediaType mediaType = byteBufferBody._2();
                ByteBuffer b = byteBuffer;
                if (b.isReadOnly()) {
                    return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)((Function0 & Serializable)() -> NonStreamMultipartBodyBuilder.apply$$anonfun$1$$anonfun$3(b))), (java.util.Map<String, String>)partHeaders);
                }
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)((Function0 & Serializable)() -> NonStreamMultipartBodyBuilder.apply$$anonfun$1$$anonfun$4(b))), (java.util.Map<String, String>)partHeaders);
            }
            if (genericRequestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = InputStreamBody$.MODULE$.unapply((InputStreamBody)genericRequestBody);
                InputStream inputStream = inputStreamBody._1();
                MediaType mediaType = inputStreamBody._2();
                InputStream b = inputStream;
                return multipartBuilder.addPart(p.name(), this.supplier((Function0<InputStream>)((Function0 & Serializable)() -> NonStreamMultipartBodyBuilder.apply$$anonfun$1$$anonfun$5(b))), (java.util.Map<String, String>)partHeaders);
            }
            if (genericRequestBody instanceof StreamBody) {
                StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)genericRequestBody);
                Object BinaryStream = streamBody._1();
                throw new IllegalArgumentException("Multipart streaming bodies are not supported with this backend");
            }
            if (genericRequestBody instanceof MultipartBody) {
                MultipartBody m = (MultipartBody)genericRequestBody;
                throw package$.MODULE$.throwNestedMultipartNotAllowed();
            }
            throw new MatchError((Object)genericRequestBody);
        });
        HttpRequest.BodyPublisher bodyPublisher = (HttpRequest.BodyPublisher)syntax$.MODULE$.MonadErrorValueOps((Object)multipartBuilder.build());
        return Tuple2$.MODULE$.apply(syntax.MonadErrorValueOps$.MODULE$.unit$extension((Object)bodyPublisher, m), (Object)multipartBuilder.getBoundary());
    }

    private Supplier<InputStream> supplier(Function0<InputStream> t) {
        return new Supplier<InputStream>(t){
            private final Function0 t$1;
            {
                this.t$1 = t$2;
            }

            public InputStream get() {
                return (InputStream)this.t$1.apply();
            }
        };
    }

    private static InputStream apply$$anonfun$1$$anonfun$1(String b$1, String e$1) {
        return new ByteArrayInputStream(b$1.getBytes(e$1));
    }

    private static InputStream apply$$anonfun$1$$anonfun$2(byte[] b$2) {
        return new ByteArrayInputStream(b$2);
    }

    private static InputStream apply$$anonfun$1$$anonfun$3(ByteBuffer b$3) {
        return new ByteBufferBackedInputStream(b$3);
    }

    private static InputStream apply$$anonfun$1$$anonfun$4(ByteBuffer b$4) {
        return new ByteArrayInputStream(b$4.array());
    }

    private static InputStream apply$$anonfun$1$$anonfun$5(InputStream b$5) {
        return b$5;
    }
}

