/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal.httpclient;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.FileBody$;
import sttp.client4.GenericRequestBody;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.MultipartBody;
import sttp.client4.NoBody$;
import sttp.client4.StreamBody;
import sttp.client4.StreamBody$;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.internal.SttpFile;
import sttp.client4.internal.httpclient.ByteBufferBackedInputStream;
import sttp.client4.internal.httpclient.MultipartBodyBuilder;
import sttp.client4.internal.package$;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Part;
import sttp.monad.MonadError;

public interface StreamMultipartBodyBuilder<BinaryStream, F>
extends MultipartBodyBuilder<BinaryStream, F> {
    public static void $init$(StreamMultipartBodyBuilder $this) {
        $this.sttp$client4$internal$httpclient$StreamMultipartBodyBuilder$_setter_$sttp$client4$internal$httpclient$StreamMultipartBodyBuilder$$CRLFBytes_$eq("\r\n".getBytes(StandardCharsets.UTF_8));
    }

    public BinaryStream fileToStream(File var1);

    public BinaryStream byteArrayToStream(byte[] var1);

    public BinaryStream concatStreams(BinaryStream var1, BinaryStream var2);

    public F toPublisher(BinaryStream var1);

    public BinaryStream inputStreamToStream(InputStream var1);

    public static Tuple2 apply$(StreamMultipartBodyBuilder $this, Seq parts, MonadError m) {
        return $this.apply(parts, m);
    }

    @Override
    default public Tuple2<F, String> apply(Seq<Part<GenericRequestBody<?>>> parts, MonadError<F> m) {
        String boundary = UUID.randomUUID().toString();
        Object resultStream = parts.foldLeft(this.byteArrayToStream((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE))), (Function2 & Serializable)(accumulatedStream, part) -> {
            Header header = Header$.MODULE$.apply(HeaderNames$.MODULE$.ContentDisposition(), part.contentDispositionHeaderValue());
            Seq allHeaders = (Seq)part.headers().$plus$colon((Object)header);
            Map partHeaders = ((IterableOnceOps)allHeaders.map((Function1 & Serializable)h -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.value());
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            GenericRequestBody genericRequestBody = (GenericRequestBody)part.body();
            if (NoBody$.MODULE$.equals(genericRequestBody)) {
                return accumulatedStream;
            }
            if (genericRequestBody instanceof FileBody) {
                FileBody fileBody = FileBody$.MODULE$.unapply((FileBody)genericRequestBody);
                SttpFile sttpFile = fileBody._1();
                MediaType mediaType = fileBody._2();
                SttpFile f = sttpFile;
                BinaryStream encodedHeaders = this.byteArrayToStream(this.encodeHeaders((Map<String, String>)partHeaders, boundary));
                BinaryStream endPartBytes = this.byteArrayToStream(this.sttp$client4$internal$httpclient$StreamMultipartBodyBuilder$$CRLFBytes());
                BinaryStream headersWithContent = this.concatStreams(encodedHeaders, this.fileToStream(f.toFile()));
                return this.concatStreams(accumulatedStream, this.concatStreams(headersWithContent, endPartBytes));
            }
            if (genericRequestBody instanceof StringBody) {
                StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)genericRequestBody);
                String string = stringBody._1();
                String string2 = stringBody._2();
                MediaType mediaType = stringBody._3();
                String b = string;
                String e = string2;
                if (e.equalsIgnoreCase(package$.MODULE$.Utf8())) {
                    return this.concatBytesToStream(accumulatedStream, this.encodeString(b, (Map<String, String>)partHeaders, boundary));
                }
                String b2 = string;
                String e2 = string2;
                return this.concatBytesToStream(accumulatedStream, this.encodeBytes(b2.getBytes(e2), (Map<String, String>)partHeaders, boundary));
            }
            if (genericRequestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)genericRequestBody);
                byte[] byArray = byteArrayBody._1();
                MediaType mediaType = byteArrayBody._2();
                byte[] b = byArray;
                return this.concatBytesToStream(accumulatedStream, this.encodeBytes(b, (Map<String, String>)partHeaders, boundary));
            }
            if (genericRequestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)genericRequestBody);
                ByteBuffer byteBuffer = byteBufferBody._1();
                MediaType mediaType = byteBufferBody._2();
                ByteBuffer b = byteBuffer;
                if (b.isReadOnly()) {
                    ByteBufferBackedInputStream buffer = new ByteBufferBackedInputStream(b);
                    return this.concatStreams(accumulatedStream, this.encodeStream(this.inputStreamToStream(buffer), (Map<String, String>)partHeaders, boundary));
                }
                return this.concatBytesToStream(accumulatedStream, this.encodeBytes(b.array(), (Map<String, String>)partHeaders, boundary));
            }
            if (genericRequestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = InputStreamBody$.MODULE$.unapply((InputStreamBody)genericRequestBody);
                InputStream inputStream = inputStreamBody._1();
                MediaType mediaType = inputStreamBody._2();
                InputStream b = inputStream;
                return this.concatStreams(accumulatedStream, this.encodeStream(this.inputStreamToStream(b), (Map<String, String>)partHeaders, boundary));
            }
            if (genericRequestBody instanceof StreamBody) {
                Object BinaryStream;
                StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)genericRequestBody);
                Object s = BinaryStream = streamBody._1();
                return this.concatStreams(accumulatedStream, this.encodeStream(s, (Map<String, String>)partHeaders, boundary));
            }
            if (genericRequestBody instanceof MultipartBody) {
                throw package$.MODULE$.throwNestedMultipartNotAllowed();
            }
            throw new MatchError((Object)genericRequestBody);
        });
        return Tuple2$.MODULE$.apply(this.toPublisher(this.concatBytesToStream(resultStream, this.lastBoundary(boundary))), (Object)boundary);
    }

    private BinaryStream encodeStream(BinaryStream stream, Map<String, String> headers, String boundary) {
        return this.concatBytesToStream(this.concatStreams(this.byteArrayToStream(this.encodeHeaders(headers, boundary)), stream), this.sttp$client4$internal$httpclient$StreamMultipartBodyBuilder$$CRLFBytes());
    }

    private BinaryStream concatBytesToStream(BinaryStream stream, byte[] array) {
        return this.concatStreams(stream, this.byteArrayToStream(array));
    }

    private String headersToString(Map<String, String> headers) {
        return ((IterableOnceOps)headers.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(2).append(k).append(": ").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\r\n");
    }

    private byte[] encodeHeaders(Map<String, String> headers, String boundary) {
        return new StringBuilder(8).append("--").append(boundary).append("\r\n").append(this.headersToString(headers)).append("\r\n\r\n").toString().getBytes(StandardCharsets.UTF_8);
    }

    public byte[] sttp$client4$internal$httpclient$StreamMultipartBodyBuilder$$CRLFBytes();

    public void sttp$client4$internal$httpclient$StreamMultipartBodyBuilder$_setter_$sttp$client4$internal$httpclient$StreamMultipartBodyBuilder$$CRLFBytes_$eq(byte[] var1);

    private byte[] encodeString(String value, Map<String, String> headers, String boundary) {
        Object object = Predef$.MODULE$.byteArrayOps(this.encodeHeaders(headers, boundary));
        Object object2 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)value.getBytes(StandardCharsets.UTF_8), ClassTag$.MODULE$.apply(Byte.TYPE)));
        return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object2, (Object)this.sttp$client4$internal$httpclient$StreamMultipartBodyBuilder$$CRLFBytes(), ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    private byte[] encodeBytes(byte[] value, Map<String, String> headers, String boundary) {
        Object object = Predef$.MODULE$.byteArrayOps(this.encodeHeaders(headers, boundary));
        Object object2 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.$plus$plus$extension(object, (Object)value, ClassTag$.MODULE$.apply(Byte.TYPE)));
        return (byte[])ArrayOps$.MODULE$.$plus$plus$extension(object2, (Object)this.sttp$client4$internal$httpclient$StreamMultipartBodyBuilder$$CRLFBytes(), ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    private byte[] lastBoundary(String boundary) {
        String lastPart = new StringBuilder(4).append("--").append(boundary).append("--").toString();
        return lastPart.getBytes(StandardCharsets.UTF_8);
    }
}

