/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal.httpclient;

import java.io.Serializable;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import sttp.client4.internal.httpclient.Sequencer;
import sttp.client4.internal.ws.SimpleQueue;
import sttp.client4.internal.ws.WebSocketEvent;
import sttp.client4.internal.ws.WebSocketEvent$Error$;
import sttp.client4.internal.ws.WebSocketEvent$Frame$;
import sttp.client4.internal.ws.WebSocketEvent$Open$;
import sttp.model.Headers;
import sttp.model.Headers$;
import sttp.monad.MonadError;
import sttp.monad.syntax;
import sttp.monad.syntax$;
import sttp.ws.WebSocketClosed$;
import sttp.ws.WebSocketFrame;

public class WebSocketImpl<F>
implements sttp.ws.WebSocket<F> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WebSocketImpl.class.getDeclaredField("upgradeHeaders$lzy1"));
    private final WebSocket ws;
    private final SimpleQueue<F, WebSocketEvent> queue;
    private final AtomicBoolean _isOpen;
    private final Sequencer<F> sequencer;
    private final MonadError<F> _monad;
    private final Function1<CompletableFuture<WebSocket>, F> fromCompletableFutureToEffect;
    private volatile Object upgradeHeaders$lzy1;

    public WebSocketImpl(WebSocket ws, SimpleQueue<F, WebSocketEvent> queue, AtomicBoolean _isOpen, Sequencer<F> sequencer, MonadError<F> _monad, Function1<CompletableFuture<WebSocket>, Object> fromCompletableFutureToEffect) {
        this.ws = ws;
        this.queue = queue;
        this._isOpen = _isOpen;
        this.sequencer = sequencer;
        this._monad = _monad;
        this.fromCompletableFutureToEffect = fromCompletableFutureToEffect;
    }

    public F receive() {
        return (F)syntax$.MODULE$.MonadErrorOps(this::receive$$anonfun$1).flatMap((Function1 & Serializable)x$1 -> {
            WebSocketEvent.Frame frame;
            WebSocketFrame webSocketFrame;
            WebSocketEvent.Frame frame2;
            WebSocketFrame webSocketFrame2;
            WebSocketEvent webSocketEvent = x$1;
            if (webSocketEvent instanceof WebSocketEvent.Open && WebSocketEvent$Open$.MODULE$.unapply((WebSocketEvent.Open)webSocketEvent)) {
                return this.receive();
            }
            if (webSocketEvent instanceof WebSocketEvent.Frame && (webSocketFrame2 = (frame2 = WebSocketEvent$Frame$.MODULE$.unapply((WebSocketEvent.Frame)webSocketEvent))._1()) instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close c = (WebSocketFrame.Close)webSocketFrame2;
                this.queue.offer(WebSocketEvent$Error$.MODULE$.apply((Throwable)WebSocketClosed$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)c))));
                return this.monad().unit((Object)c);
            }
            if (webSocketEvent instanceof WebSocketEvent.Error) {
                WebSocketEvent.Error error = (WebSocketEvent.Error)webSocketEvent;
                WebSocketEvent.Error error2 = WebSocketEvent$Error$.MODULE$.unapply(error);
                Throwable throwable = error2._1();
                if (throwable instanceof Exception) {
                    Exception t = (Exception)throwable;
                    WebSocketEvent.Error e = error;
                    this.queue.offer(e);
                    return this.monad().error((Throwable)t);
                }
                Throwable t = throwable;
                throw t;
            }
            if (webSocketEvent instanceof WebSocketEvent.Frame && (webSocketFrame = (frame = WebSocketEvent$Frame$.MODULE$.unapply((WebSocketEvent.Frame)webSocketEvent))._1()) != null) {
                WebSocketFrame f = webSocketFrame;
                return this.monad().eval(() -> this.receive$$anonfun$2$$anonfun$1(f));
            }
            throw new MatchError((Object)webSocketEvent);
        }, this.monad());
    }

    public F send(WebSocketFrame f, boolean isContinuation) {
        return this.sequencer.apply(() -> this.send$$anonfun$1(f));
    }

    public boolean send$default$2() {
        return false;
    }

    public Headers upgradeHeaders() {
        Object object = this.upgradeHeaders$lzy1;
        if (object instanceof Headers) {
            return (Headers)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Headers)this.upgradeHeaders$lzyINIT1();
    }

    private Object upgradeHeaders$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.upgradeHeaders$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Headers headers = null;
                    try {
                        headers = Headers$.MODULE$.apply((Seq)package$.MODULE$.Nil());
                        object2 = headers == null ? LazyVals.NullValue$.MODULE$ : headers;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.upgradeHeaders$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return headers;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public MonadError<F> monad() {
        return this._monad;
    }

    public F isOpen() {
        return (F)this.monad().eval(this::isOpen$$anonfun$1);
    }

    private final Object receive$$anonfun$1() {
        return this.queue.poll();
    }

    private final WebSocketFrame receive$$anonfun$2$$anonfun$1(WebSocketFrame f$1) {
        this.ws.request(1L);
        return f$1;
    }

    private final Object send$$anonfun$1$$anonfun$1(WebSocketFrame f$3) {
        WebSocketFrame webSocketFrame = f$3;
        if (webSocketFrame instanceof WebSocketFrame.Text) {
            WebSocketFrame.Text text = WebSocketFrame.Text$.MODULE$.unapply((WebSocketFrame.Text)webSocketFrame);
            String string = text._1();
            boolean bl = text._2();
            Option option = text._3();
            String payload = string;
            boolean finalFragment = bl;
            return this.fromCompletableFutureToEffect.apply(this.ws.sendText(payload, finalFragment));
        }
        if (webSocketFrame instanceof WebSocketFrame.Binary) {
            WebSocketFrame.Binary binary = WebSocketFrame.Binary$.MODULE$.unapply((WebSocketFrame.Binary)webSocketFrame);
            byte[] byArray = binary._1();
            boolean bl = binary._2();
            Option option = binary._3();
            byte[] payload = byArray;
            boolean finalFragment = bl;
            return this.fromCompletableFutureToEffect.apply(this.ws.sendBinary(ByteBuffer.wrap(payload), finalFragment));
        }
        if (webSocketFrame instanceof WebSocketFrame.Ping) {
            byte[] byArray;
            WebSocketFrame.Ping ping = WebSocketFrame.Ping$.MODULE$.unapply((WebSocketFrame.Ping)webSocketFrame);
            byte[] payload = byArray = ping._1();
            return this.fromCompletableFutureToEffect.apply(this.ws.sendPing(ByteBuffer.wrap(payload)));
        }
        if (webSocketFrame instanceof WebSocketFrame.Pong) {
            byte[] byArray;
            WebSocketFrame.Pong pong = WebSocketFrame.Pong$.MODULE$.unapply((WebSocketFrame.Pong)webSocketFrame);
            byte[] payload = byArray = pong._1();
            return this.fromCompletableFutureToEffect.apply(this.ws.sendPong(ByteBuffer.wrap(payload)));
        }
        if (webSocketFrame instanceof WebSocketFrame.Close) {
            WebSocketFrame.Close close = WebSocketFrame.Close$.MODULE$.unapply((WebSocketFrame.Close)webSocketFrame);
            int n = close._1();
            String string = close._2();
            int statusCode = n;
            String reasonText = string;
            boolean wasOpen = this._isOpen.getAndSet(false);
            if (wasOpen) {
                return this.fromCompletableFutureToEffect.apply(this.ws.sendClose(statusCode, reasonText));
            }
            BoxedUnit boxedUnit = (BoxedUnit)syntax$.MODULE$.MonadErrorValueOps((Object)BoxedUnit.UNIT);
            return syntax.MonadErrorValueOps$.MODULE$.unit$extension((Object)boxedUnit, this.monad());
        }
        throw new MatchError((Object)webSocketFrame);
    }

    private final Object send$$anonfun$1(WebSocketFrame f$2) {
        return this.monad().suspend(() -> this.send$$anonfun$1$$anonfun$1(f$2));
    }

    private final boolean isOpen$$anonfun$1() {
        return this._isOpen.get();
    }
}

