/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.server.CharsetNegotiator;
import org.apache.pekko.http.scaladsl.server.ContentNegotiator;
import org.apache.pekko.http.scaladsl.server.ContentNegotiator$;
import org.apache.pekko.http.scaladsl.server.ContentNegotiator$Alternative$;
import org.apache.pekko.http.scaladsl.server.ContentNegotiator$Alternative$ContentType$;
import org.apache.pekko.http.scaladsl.server.ContentNegotiator$Alternative$MediaType$;
import org.apache.pekko.http.scaladsl.server.MediaTypeNegotiator;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ContentNegotiator {
    private final MediaTypeNegotiator mtn;
    private final CharsetNegotiator csn;

    public static ContentNegotiator apply(Seq<HttpHeader> seq) {
        return ContentNegotiator$.MODULE$.apply(seq);
    }

    public ContentNegotiator(Seq<HttpHeader> requestHeaders) {
        this.mtn = new MediaTypeNegotiator(requestHeaders);
        this.csn = new CharsetNegotiator(requestHeaders);
    }

    public MediaTypeNegotiator mtn() {
        return this.mtn;
    }

    public CharsetNegotiator csn() {
        return this.csn;
    }

    public float qValueFor(Alternative alternative) {
        Alternative.ContentType contentType;
        ContentType contentType2;
        Alternative alternative2 = alternative;
        if (alternative2 instanceof Alternative.ContentType && (contentType2 = (contentType = ContentNegotiator$Alternative$ContentType$.MODULE$.unapply((Alternative.ContentType)alternative2))._1()) instanceof ContentType.NonBinary) {
            ContentType.NonBinary ct = (ContentType.NonBinary)contentType2;
            return package$.MODULE$.min(this.mtn().qValueFor(ct.mediaType()), this.csn().qValueFor(ct.charset()));
        }
        Alternative x = alternative2;
        return this.mtn().qValueFor(x.mediaType());
    }

    public Option<ContentType> pickContentType(List<Alternative> alternatives) {
        return ((IterableOnceOps)alternatives.map((Function1 & Serializable)alt -> {
            Alternative alternative = (Alternative)Predef$.MODULE$.ArrowAssoc(alt);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)alternative, (Object)BoxesRunTime.boxToFloat((float)this.qValueFor((Alternative)alt)));
        }).sortBy((Function1 & Serializable)_$1 -> -BoxesRunTime.unboxToFloat((Object)_$1._2()), (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$)).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Alternative alt = (Alternative)tuple2._1();
                    float q = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    if (q > 0.0f) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Alternative alt = (Alternative)tuple2._1();
                    float q = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    if (q > 0.0f) {
                        return alt;
                    }
                }
                return function1.apply((Object)x);
            }
        }).flatMap((Function1 & Serializable)x$1 -> {
            Alternative alternative = x$1;
            if (alternative instanceof Alternative.ContentType) {
                ContentType contentType;
                Alternative.ContentType contentType2 = ContentNegotiator$Alternative$ContentType$.MODULE$.unapply((Alternative.ContentType)alternative);
                ContentType ct = contentType = contentType2._1();
                return Some$.MODULE$.apply((Object)ct);
            }
            if (alternative instanceof Alternative.MediaType) {
                MediaType.WithOpenCharset withOpenCharset;
                Alternative.MediaType mediaType = ContentNegotiator$Alternative$MediaType$.MODULE$.unapply((Alternative.MediaType)alternative);
                MediaType.WithOpenCharset mt = withOpenCharset = mediaType._1();
                return this.csn().pickBest().map((Function1 & Serializable)charset -> mt.withCharset(charset));
            }
            throw new MatchError((Object)alternative);
        });
    }

    public static interface Alternative {
        public static ContentType apply(org.apache.pekko.http.scaladsl.model.ContentType contentType) {
            return ContentNegotiator$Alternative$.MODULE$.apply(contentType);
        }

        public static Alternative apply(org.apache.pekko.http.scaladsl.model.MediaType mediaType) {
            return ContentNegotiator$Alternative$.MODULE$.apply(mediaType);
        }

        public static int ordinal(Alternative alternative) {
            return ContentNegotiator$Alternative$.MODULE$.ordinal(alternative);
        }

        public org.apache.pekko.http.scaladsl.model.MediaType mediaType();

        public String format();

        public static final class ContentType
        implements Alternative,
        Product,
        Serializable {
            private final org.apache.pekko.http.scaladsl.model.ContentType contentType;

            public static ContentType apply(org.apache.pekko.http.scaladsl.model.ContentType contentType) {
                return ContentNegotiator$Alternative$ContentType$.MODULE$.apply(contentType);
            }

            public static ContentType fromProduct(Product product) {
                return ContentNegotiator$Alternative$ContentType$.MODULE$.fromProduct(product);
            }

            public static ContentType unapply(ContentType contentType) {
                return ContentNegotiator$Alternative$ContentType$.MODULE$.unapply(contentType);
            }

            public ContentType(org.apache.pekko.http.scaladsl.model.ContentType contentType) {
                this.contentType = contentType;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof ContentType)) return false;
                ContentType contentType = (ContentType)object;
                org.apache.pekko.http.scaladsl.model.ContentType contentType2 = this.contentType();
                org.apache.pekko.http.scaladsl.model.ContentType contentType3 = contentType.contentType();
                if (contentType2 != null) {
                    if (!contentType2.equals(contentType3)) return false;
                    return true;
                }
                if (contentType3 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof ContentType;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "ContentType";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "contentType";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public org.apache.pekko.http.scaladsl.model.ContentType contentType() {
                return this.contentType;
            }

            @Override
            public org.apache.pekko.http.scaladsl.model.MediaType mediaType() {
                return this.contentType().mediaType();
            }

            @Override
            public String format() {
                return this.contentType().toString();
            }

            public ContentType copy(org.apache.pekko.http.scaladsl.model.ContentType contentType) {
                return new ContentType(contentType);
            }

            public org.apache.pekko.http.scaladsl.model.ContentType copy$default$1() {
                return this.contentType();
            }

            public org.apache.pekko.http.scaladsl.model.ContentType _1() {
                return this.contentType();
            }
        }
    }
}

