/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.Done;
import org.apache.pekko.Version$;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefProvider;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$Settings$;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.actor.ChildStats;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.actor.CoordinatedShutdown$ActorSystemTerminateReason$;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.ExtensionIdProvider;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.LocalActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.ReflectiveDynamicAccess;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.StopChild;
import org.apache.pekko.actor.StopChild$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.dungeon.ChildrenContainer;
import org.apache.pekko.actor.dungeon.ChildrenContainer$EmptyChildrenContainer$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$TerminatedChildrenContainer$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$TerminatingChildrenContainer$;
import org.apache.pekko.actor.setup.ActorSystemSetup;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.DefaultDispatcherPrerequisites$;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.dispatch.Mailboxes;
import org.apache.pekko.dispatch.MonitorableThreadFactory;
import org.apache.pekko.dispatch.MonitorableThreadFactory$;
import org.apache.pekko.event.DeadLetterListener;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.LoggingFilter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.FutureConverters$FutureOps$;
import org.apache.pekko.util.ManifestInfo;
import org.apache.pekko.util.ManifestInfo$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

@InternalApi
public class ActorSystemImpl
extends ExtendedActorSystem {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ActorSystemImpl.class.getDeclaredField("_start$lzy1"));
    private final String name;
    private final ClassLoader classLoader;
    private final Option guardianProps;
    private final long uid;
    private volatile Option<ActorRef> logDeadLetterListener;
    private final DynamicAccess _dynamicAccess;
    private final ActorSystem.Settings settings;
    private final MonitorableThreadFactory threadFactory;
    private final EventStream eventStream;
    private final LoggingFilter logFilter;
    public final MarkerLoggingAdapter org$apache$pekko$actor$ActorSystemImpl$$markerLogging;
    private final LoggingAdapter log;
    private final Scheduler scheduler;
    private final ActorRefProvider provider;
    private final Mailboxes mailboxes;
    private final Dispatchers dispatchers;
    private final ExecutionContextExecutor dispatcher;
    private final TerminationCallbacks<Terminated> terminationCallbacks;
    private volatile boolean _initialized;
    private volatile Object _start$lzy1;
    private volatile boolean terminating;
    private volatile boolean aborting;
    private final ConcurrentHashMap<ExtensionId<?>, Object> extensions;

    public ActorSystemImpl(String name, Config applicationConfig, ClassLoader classLoader, Option<ExecutionContext> defaultExecutionContext, Option<Props> guardianProps, ActorSystemSetup setup) {
        ActorRefProvider actorRefProvider;
        this.name = name;
        this.classLoader = classLoader;
        this.guardianProps = guardianProps;
        this.uid = ThreadLocalRandom.current().nextLong();
        if (!name.matches("^[a-zA-Z0-9][a-zA-Z0-9-_]*$")) {
            throw new IllegalArgumentException(new StringBuilder(109).append("invalid ActorSystem name [").append(name).append("], must contain only word characters (i.e. [a-zA-Z0-9] plus non-leading '-' or '_')").toString());
        }
        this.logDeadLetterListener = None$.MODULE$;
        this._dynamicAccess = this.createDynamicAccess();
        Config config = ActorSystem$Settings$.MODULE$.amendSlf4jConfig(applicationConfig.withFallback((ConfigMergeable)ConfigFactory.defaultReference((ClassLoader)classLoader)), this._dynamicAccess);
        this.settings = new ActorSystem.Settings(classLoader, config, name, setup);
        this.threadFactory = MonitorableThreadFactory$.MODULE$.apply(name, this.settings().Daemonicity(), (Option<ClassLoader>)Option$.MODULE$.apply((Object)classLoader), this.uncaughtExceptionHandler(), MonitorableThreadFactory$.MODULE$.$lessinit$greater$default$5());
        this.eventStream = new EventStream(this, this.settings().DebugEventStream());
        this.eventStream().startStdoutLogger(this.settings());
        Object[] objectArray = new Tuple2[2];
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(ActorSystem.Settings.class);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.settings());
        Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(EventStream.class);
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)this.eventStream());
        Vector arguments = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.logFilter = (LoggingFilter)this.dynamicAccess().createInstanceFor(this.settings().LoggingFilter(), (Seq<Tuple2<Class<?>, Object>>)arguments, ClassTag$.MODULE$.apply(LoggingFilter.class)).get();
        this.org$apache$pekko$actor$ActorSystemImpl$$markerLogging = new MarkerLoggingAdapter(this.eventStream(), new StringBuilder(2).append(this.getClass().getName()).append("(").append(name).append(")").toString(), this.getClass(), this.logFilter());
        this.log = this.org$apache$pekko$actor$ActorSystemImpl$$markerLogging;
        this.scheduler = this.createScheduler();
        ActorSystemImpl actorSystemImpl = this;
        try {
            Object[] objectArray2 = new Tuple2[4];
            Class clazz3 = (Class)Predef$.MODULE$.ArrowAssoc(String.class);
            objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz3, (Object)name);
            Class clazz4 = (Class)Predef$.MODULE$.ArrowAssoc(ActorSystem.Settings.class);
            objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz4, (Object)this.settings());
            Class clazz5 = (Class)Predef$.MODULE$.ArrowAssoc(EventStream.class);
            objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz5, (Object)this.eventStream());
            Class clazz6 = (Class)Predef$.MODULE$.ArrowAssoc(DynamicAccess.class);
            objectArray2[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz6, (Object)this.dynamicAccess());
            Vector arguments2 = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            actorRefProvider = (ActorRefProvider)this.dynamicAccess().createInstanceFor(this.settings().ProviderClass(), (Seq<Tuple2<Class<?>, Object>>)arguments2, ClassTag$.MODULE$.apply(ActorRefProvider.class)).get();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.$init$$$anonfun$4();
                    return BoxedUnit.UNIT;
                });
                throw e;
            }
            throw throwable;
        }
        ActorRefProvider actorRefProvider2 = actorRefProvider;
        ActorSystemImpl actorSystemImpl2 = actorSystemImpl;
        actorSystemImpl = null;
        ActorRefProvider actorRefProvider3 = actorRefProvider2;
        actorRefProvider2 = null;
        actorSystemImpl2.provider = actorRefProvider3;
        this.mailboxes = new Mailboxes(this.settings(), this.eventStream(), this.dynamicAccess(), this.deadLetters());
        this.dispatchers = new Dispatchers(this.settings(), DefaultDispatcherPrerequisites$.MODULE$.apply(this.threadFactory(), this.eventStream(), this.scheduler(), this.dynamicAccess(), this.settings(), this.mailboxes(), defaultExecutionContext), this.log());
        this.dispatcher = this.dispatchers().defaultGlobalDispatcher();
        this.terminationCallbacks = new TerminationCallbacks<Terminated>(this, this.provider().terminationFuture(), (ExecutionContext)this.dispatcher());
        this._initialized = false;
        this.terminating = false;
        this.aborting = false;
        this.extensions = new ConcurrentHashMap();
    }

    @Override
    public String name() {
        return this.name;
    }

    public Option<Props> guardianProps() {
        return this.guardianProps;
    }

    @Override
    public long uid() {
        return this.uid;
    }

    @Override
    public final ActorSystem.Settings settings() {
        return this.settings;
    }

    public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return new Thread.UncaughtExceptionHandler(this){
            private final /* synthetic */ ActorSystemImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void uncaughtException(Thread thread, Throwable cause) {
                block16: {
                    block15: {
                        Throwable throwable;
                        block14: {
                            Option option;
                            throwable = cause;
                            if (throwable == null || (option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) break block14;
                            Throwable throwable2 = (Throwable)option.get();
                            break block15;
                        }
                        if (!(throwable instanceof InterruptedException) && !(throwable instanceof NotImplementedError) && !(throwable instanceof ControlThrowable)) break block16;
                    }
                    this.$outer.log().error(cause, "Uncaught error from thread [{}]", (Object)thread.getName());
                    return;
                }
                if (cause instanceof IncompatibleClassChangeError && cause.getMessage().startsWith("org.apache.pekko")) {
                    System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(578).append("Detected ").append(cause.getClass().getName()).append(" error, which MAY be caused by incompatible Pekko versions on the classpath.\n                  | Please note that a given Pekko version MUST be the same across all modules of Pekko that you are using,\n                  | e.g. if you use pekko-actor [").append(Version$.MODULE$.current()).append(" (resolved from current classpath)] all other core\n                  | Pekko modules MUST be of the same version. External projects like Connectors, Persistence plugins or Pekko\n                  | HTTP etc. have their own version numbers - please make sure you're using a compatible set of libraries.\n                 ").toString())).replaceAll("[\r\n]", ""));
                }
                if (this.$outer.settings().JvmExitOnFatalError()) {
                    try {
                        this.logFatalError("shutting down JVM since 'pekko.jvm-exit-on-fatal-error' is enabled for", cause, thread);
                    }
                    finally {
                        System.exit(-1);
                    }
                    return;
                }
                try {
                    this.logFatalError("shutting down", cause, thread);
                }
                finally {
                    this.$outer.terminate();
                }
            }

            private void logFatalError(String message, Throwable cause, Thread thread) {
                System.err.print("Uncaught error from thread [");
                System.err.print(thread.getName());
                System.err.print("]: ");
                System.err.print(cause.getMessage());
                System.err.print(", ");
                System.err.print(message);
                System.err.print(" ActorSystem[");
                System.err.print(this.$outer.name());
                System.err.println("]");
                System.err.flush();
                cause.printStackTrace(System.err);
                System.err.flush();
                this.$outer.org$apache$pekko$actor$ActorSystemImpl$$markerLogging.error(LogMarker$.MODULE$.Security(), cause, new StringBuilder(51).append("Uncaught error from thread [{}]: ").append(cause.getMessage()).append(", ").append(message).append(" ActorSystem[{}]").toString(), (Object)thread.getName(), (Object)this.$outer.name());
            }
        };
    }

    @Override
    public final MonitorableThreadFactory threadFactory() {
        return this.threadFactory;
    }

    public DynamicAccess createDynamicAccess() {
        return new ReflectiveDynamicAccess(this.classLoader);
    }

    @Override
    public DynamicAccess dynamicAccess() {
        return this._dynamicAccess;
    }

    @Override
    public void logConfiguration() {
        this.log().info(this.settings().toString());
    }

    @Override
    public ActorSystemImpl systemImpl() {
        return this;
    }

    @Override
    public ActorRef systemActorOf(Props props, String name) {
        return this.systemGuardian().underlying().attachChild(props, name, true);
    }

    @Override
    public ActorRef actorOf(Props props, String name) {
        if (this.guardianProps().isEmpty()) {
            return this.guardian().underlying().attachChild(props, name, false);
        }
        throw new UnsupportedOperationException(new StringBuilder(90).append("cannot create top-level actor [").append(name).append("] from the outside on ActorSystem with custom user guardian").toString());
    }

    @Override
    public ActorRef actorOf(Props props) {
        if (this.guardianProps().isEmpty()) {
            return this.guardian().underlying().attachChild(props, false);
        }
        throw new UnsupportedOperationException("cannot create top-level actor from the outside on ActorSystem with custom user guardian");
    }

    @Override
    public void stop(ActorRef actor) {
        ActorPath path = actor.path();
        ActorPath guard = this.guardian().path();
        ActorPath sys = this.systemGuardian().path();
        ActorPath actorPath = path.parent();
        ActorPath actorPath2 = guard;
        ActorPath actorPath3 = actorPath;
        if (!(actorPath2 != null ? !actorPath2.equals(actorPath3) : actorPath3 != null)) {
            LocalActorRef localActorRef = this.guardian();
            StopChild stopChild = StopChild$.MODULE$.apply(actor);
            localActorRef.$bang(stopChild, localActorRef.$bang$default$2(stopChild));
            return;
        }
        ActorPath actorPath4 = sys;
        ActorPath actorPath5 = actorPath;
        if (!(actorPath4 != null ? !actorPath4.equals(actorPath5) : actorPath5 != null)) {
            LocalActorRef localActorRef = this.systemGuardian();
            StopChild stopChild = StopChild$.MODULE$.apply(actor);
            localActorRef.$bang(stopChild, localActorRef.$bang$default$2(stopChild));
            return;
        }
        ((InternalActorRef)actor).stop();
    }

    @Override
    public EventStream eventStream() {
        return this.eventStream;
    }

    @Override
    public LoggingFilter logFilter() {
        return this.logFilter;
    }

    @Override
    public LoggingAdapter log() {
        return this.log;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public ActorRefProvider provider() {
        return this.provider;
    }

    @Override
    public ActorRef deadLetters() {
        return this.provider().deadLetters();
    }

    @Override
    public Mailboxes mailboxes() {
        return this.mailboxes;
    }

    @Override
    public Dispatchers dispatchers() {
        return this.dispatchers;
    }

    @Override
    public ExecutionContextExecutor dispatcher() {
        return this.dispatcher;
    }

    @Override
    public Future<Terminated> whenTerminated() {
        return this.terminationCallbacks.terminationFuture();
    }

    @Override
    public CompletionStage<Terminated> getWhenTerminated() {
        Future future = FutureConverters$.MODULE$.FutureOps(this.whenTerminated());
        return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
    }

    @Override
    public InternalActorRef lookupRoot() {
        return this.provider().rootGuardian();
    }

    @Override
    public LocalActorRef guardian() {
        return this.provider().guardian();
    }

    @Override
    public LocalActorRef systemGuardian() {
        return this.provider().systemGuardian();
    }

    @Override
    public ActorPath $div(String actorName) {
        return this.guardian().path().$div(actorName);
    }

    @Override
    public ActorPath $div(Iterable<String> path) {
        return this.guardian().path().$div(path);
    }

    @Override
    public ActorSystem classicSystem() {
        return this;
    }

    private List<String> allModules() {
        return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pekko-actor", "pekko-actor-testkit-typed", "pekko-actor-typed", "pekko-cluster", "pekko-cluster-metrics", "pekko-cluster-sharding", "pekko-cluster-sharding-typed", "pekko-cluster-tools", "pekko-cluster-typed", "pekko-coordination", "pekko-discovery", "pekko-distributed-data", "pekko-testkit", "pekko-multi-node-testkit", "pekko-osgi", "pekko-persistence", "pekko-persistence-query", "pekko-persistence-shared", "pekko-persistence-testkit", "pekko-persistence-typed", "pekko-pki", "pekko-protobuf", "pekko-protobuf-v3", "pekko-remote", "pekko-serialization-jackson", "pekko-slf4j", "pekko-stream", "pekko-stream-testkit", "pekko-stream-typed", "pekko-stream-testkit"}));
    }

    public void assertInitialized() {
        if (!this._initialized) {
            throw new IllegalStateException("The calling code expected that the ActorSystem was initialized but it wasn't yet. This is probably a bug in the ActorSystem initialization sequence often related to initialization of extensions. Please report at https://github.com/apache/pekko/issues.");
        }
    }

    private ActorSystemImpl _start() {
        Object object = this._start$lzy1;
        if (object instanceof ActorSystemImpl) {
            return (ActorSystemImpl)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ActorSystemImpl)this._start$lzyINIT1();
    }

    private Object _start$lzyINIT1() {
        Object object;
        block18: {
            while (true) {
                if ((object = this._start$lzy1) == null) {
                    ActorSystemImpl actorSystemImpl;
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ActorSystemImpl actorSystemImpl2 = null;
                    try {
                        try {
                            this.registerOnTermination((Function0 & Serializable)() -> {
                                this._start$lzyINIT1$$anonfun$1();
                                return BoxedUnit.UNIT;
                            });
                            this.provider().init(this);
                            this._initialized = true;
                            if (this.settings().LogDeadLetters() > 0) {
                                this.logDeadLetterListener = Some$.MODULE$.apply((Object)this.systemActorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(DeadLetterListener.class)), "deadLetterListener"));
                            }
                            this.eventStream().startUnsubscriber();
                            ((ManifestInfo)ManifestInfo$.MODULE$.apply(this)).checkSameVersion("Apache Pekko", (Seq<String>)this.allModules(), true);
                            if (!this.terminating) {
                                this.loadExtensions();
                            }
                            if (this.settings().LogConfigOnStart()) {
                                this.logConfiguration();
                            }
                            actorSystemImpl = this;
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable e;
                                block17: {
                                    Try try_;
                                    Throwable throwable3;
                                    e = throwable3 = (Throwable)option.get();
                                    try {
                                        try_ = this.terminate();
                                    }
                                    catch (Throwable throwable4) {
                                        Option option2;
                                        Throwable throwable5 = throwable4;
                                        if (throwable5 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                                            Throwable throwable6 = (Throwable)option2.get();
                                            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                                                this._start$lzyINIT1$$anonfun$2();
                                                return BoxedUnit.UNIT;
                                            });
                                            break block17;
                                        }
                                        throw throwable4;
                                    }
                                }
                                throw e;
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this._start$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    actorSystemImpl2 = actorSystemImpl;
                    object2 = actorSystemImpl2 == null ? LazyVals.NullValue$.MODULE$ : actorSystemImpl2;
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this._start$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return actorSystemImpl2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block18;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ActorSystemImpl start() {
        return this._start();
    }

    @Override
    public <T> void registerOnTermination(Function0<T> code) {
        this.registerOnTermination(new Runnable(code){
            private final Function0 code$1;
            {
                this.code$1 = code$2;
            }

            public void run() {
                this.code$1.apply();
            }
        });
    }

    @Override
    public void registerOnTermination(Runnable code) {
        this.terminationCallbacks.add(code);
    }

    @Override
    public Future<Terminated> terminate() {
        Future<Done> future;
        this.terminating = true;
        if (this.settings().CoordinatedShutdownRunByActorSystemTerminate() && !this.aborting()) {
            future = ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this)).run(CoordinatedShutdown$ActorSystemTerminateReason$.MODULE$);
        } else {
            this.finalTerminate();
            future = BoxedUnit.UNIT;
        }
        return this.whenTerminated();
    }

    @Override
    public void finalTerminate() {
        this.terminating = true;
        if (!this.settings().LogDeadLettersDuringShutdown()) {
            this.logDeadLetterListener.foreach((Function1)(JProcedure1 & Serializable)actor -> this.stop((ActorRef)actor));
        }
        this.guardian().stop();
    }

    @Override
    public boolean isTerminating() {
        return this.terminating || this.aborting() || ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this)).shutdownReason().isDefined();
    }

    public boolean aborting() {
        return this.aborting;
    }

    public void aborting_$eq(boolean x$1) {
        this.aborting = x$1;
    }

    public void abort() {
        this.aborting_$eq(true);
        this.terminate();
    }

    public Scheduler createScheduler() {
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(Config.class);
        Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class);
        Class clazz3 = (Class)Predef$.MODULE$.ArrowAssoc(ThreadFactory.class);
        return (Scheduler)this.dynamicAccess().createInstanceFor(this.settings().SchedulerClass(), (Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.settings().config()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)this.log()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz3, (Object)this.threadFactory().withName(new StringBuilder(10).append(this.threadFactory().name()).append("-scheduler").toString())), (List)Nil$.MODULE$)))), ClassTag$.MODULE$.apply(Scheduler.class)).get();
    }

    public void stopScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Closeable x = (Closeable)((Object)scheduler);
            x.close();
            return;
        }
    }

    private <T extends Extension> T findExtension(ExtensionId<T> ext) {
        Object object;
        while ((object = this.extensions.get(ext)) instanceof CountDownLatch) {
            CountDownLatch c = (CountDownLatch)object;
            package$.MODULE$.blocking((Function0 & Serializable)() -> {
                this.findExtension$$anonfun$1(c, ext);
                return BoxedUnit.UNIT;
            });
        }
        if (object instanceof Throwable) {
            Throwable t = (Throwable)object;
            throw t;
        }
        Object other = object;
        return (T)((Extension)other);
    }

    @Override
    public final <T extends Extension> T registerExtension(ExtensionId<T> ext) {
        T t;
        while ((t = this.findExtension(ext)) == null) {
            T t2;
            CountDownLatch inProcessOfRegistration = new CountDownLatch(1);
            Object object = this.extensions.putIfAbsent(ext, inProcessOfRegistration);
            if (object != null) continue;
            try {
                try {
                    T t3 = ext.createExtension(this);
                    if (t3 == null) {
                        throw new IllegalStateException(new StringBuilder(53).append("Extension instance created as 'null' for extension [").append(ext).append("]").toString());
                    }
                    T instance = t3;
                    this.extensions.replace(ext, inProcessOfRegistration, instance);
                    t2 = instance;
                }
                catch (Throwable t4) {
                    this.extensions.replace(ext, inProcessOfRegistration, t4);
                    throw t4;
                }
            }
            finally {
                inProcessOfRegistration.countDown();
            }
            return t2;
        }
        T existing = t;
        return existing;
    }

    @Override
    public <T extends Extension> T extension(ExtensionId<T> ext) {
        T t = this.findExtension(ext);
        if (t == null) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Trying to get non-registered extension [").append(ext).append("]").toString());
        }
        T some = t;
        return some;
    }

    @Override
    public boolean hasExtension(ExtensionId<? extends Extension> ext) {
        return this.findExtension(ext) != null;
    }

    private void loadExtensions() {
        this.loadExtensions$1("pekko.library-extensions", true);
        this.loadExtensions$1("pekko.extensions", false);
    }

    public String toString() {
        return this.lookupRoot().path().root().address().toString();
    }

    @Override
    public String printTree() {
        return ActorSystemImpl.printNode$1(this.lookupRoot(), "");
    }

    private final void $init$$$anonfun$4() {
        this.stopScheduler();
    }

    private final void _start$lzyINIT1$$anonfun$1() {
        this.stopScheduler();
    }

    private final void _start$lzyINIT1$$anonfun$2() {
        this.stopScheduler();
    }

    private final void findExtension$$anonfun$1(CountDownLatch c$1, ExtensionId ext$1) {
        long awaitMillis = this.settings().CreationTimeout().duration().toMillis();
        if (!c$1.await(awaitMillis, TimeUnit.MILLISECONDS)) {
            ExtensionId extensionId = ext$1;
            SerializationExtension$ serializationExtension$ = SerializationExtension$.MODULE$;
            throw new IllegalStateException(new StringBuilder(43).append("Initialization of [").append(ext$1).append("] took more than [").append(awaitMillis).append(" ms]. ").append(!(extensionId != null ? !((Object)extensionId).equals(serializationExtension$) : serializationExtension$ != null) ? "A serializer must not access the SerializationExtension from its constructor. Use lazy init." : "Could be deadlock due to cyclic initialization of extensions.").toString());
        }
    }

    private final void loadExtensions$1(String key, boolean throwOnLoadFail) {
        package$JavaConverters$.MODULE$.ListHasAsScala(this.settings().config().getStringList(key)).asScala().foreach((Function1 & Serializable)fqcn -> {
            Try try_ = this.dynamicAccess().getObjectFor((String)fqcn, ClassTag$.MODULE$.apply(Object.class)).recoverWith((PartialFunction)new Serializable((String)fqcn, this){
                private final String fqcn$1;
                private final /* synthetic */ ActorSystemImpl $outer;
                {
                    this.fqcn$1 = fqcn$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable;
                    Throwable firstProblem = throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable;
                    Throwable firstProblem = throwable = x;
                    return this.$outer.dynamicAccess().createInstanceFor(this.fqcn$1, (Seq<Tuple2<Class<?>, Object>>)scala.package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(Object.class)).recoverWith((PartialFunction)new Serializable(firstProblem){
                        private final Throwable firstProblem$1;
                        {
                            this.firstProblem$1 = firstProblem$2;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable = x;
                            return true;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable = x;
                            return Failure$.MODULE$.apply(this.firstProblem$1);
                        }
                    });
                }
            });
            if (try_ instanceof Success) {
                Object object = ((Success)try_).value();
                if (object instanceof ExtensionIdProvider) {
                    ExtensionIdProvider p = (ExtensionIdProvider)object;
                    return this.registerExtension(p.lookup());
                }
                if (object instanceof ExtensionId) {
                    ExtensionId p = (ExtensionId)object;
                    return this.registerExtension(p);
                }
                if (!throwOnLoadFail) {
                    this.log().error("[{}] is not an 'ExtensionIdProvider' or 'ExtensionId', skipping...", fqcn);
                    return BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(51).append("[").append((String)fqcn).append("] is not an 'ExtensionIdProvider' or 'ExtensionId'").toString());
            }
            if (try_ instanceof Failure) {
                Throwable problem = ((Failure)try_).exception();
                if (!throwOnLoadFail) {
                    this.log().error(problem, "While trying to load extension [{}], skipping...", fqcn);
                    return BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(33).append("While trying to load extension [").append((String)fqcn).append("]").toString(), problem);
            }
            throw new MatchError((Object)try_);
        });
    }

    private static final String printNode$1(ActorRef node, String indent) {
        ActorRef actorRef = node;
        if (actorRef instanceof ActorRefWithCell) {
            String string;
            String string2;
            ActorCell real;
            Actor realActor;
            Cell cell;
            ActorRefWithCell wc = (ActorRefWithCell)actorRef;
            Cell cell2 = wc.underlying();
            StringBuilder stringBuilder = new StringBuilder(3).append(indent.isEmpty() ? "-> " : new StringBuilder(4).append(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(indent), 1)).append("\u230a-> ").toString()).append(node.path().name()).append(" ").append(Logging$.MODULE$.simpleName(node)).append(" ").append((cell = cell2) instanceof ActorCell ? ((realActor = (real = (ActorCell)cell).actor()) != null ? realActor.getClass() : "null") : Logging$.MODULE$.simpleName(cell2));
            Cell cell3 = cell2;
            if (cell3 instanceof ActorCell) {
                ActorCell real2 = (ActorCell)cell3;
                string2 = new StringBuilder(8).append(" status=").append(real2.mailbox().currentStatus()).toString();
            } else {
                string2 = "";
            }
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" ");
            ChildrenContainer childrenContainer = cell2.childrenRefs();
            if (childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer) {
                ChildrenContainer.TerminatingChildrenContainer terminatingChildrenContainer = ChildrenContainer$TerminatingChildrenContainer$.MODULE$.unapply((ChildrenContainer.TerminatingChildrenContainer)childrenContainer);
                TreeMap<String, ChildStats> treeMap = terminatingChildrenContainer._1();
                Set<ActorRef> set = terminatingChildrenContainer._2();
                ChildrenContainer.SuspendReason suspendReason = terminatingChildrenContainer._3();
                Set<ActorRef> toDie = set;
                ChildrenContainer.SuspendReason reason = suspendReason;
                string = new StringBuilder(13).append("Terminating(").append(reason).append(")").append(((IterableOnceOps)toDie.toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).mkString(new StringBuilder(16).append("\n").append(indent).append("   |    toDie: ").toString(), new StringBuilder(16).append("\n").append(indent).append("   |           ").toString(), "")).toString();
            } else if (ChildrenContainer$TerminatedChildrenContainer$.MODULE$.equals(childrenContainer) || ChildrenContainer$EmptyChildrenContainer$.MODULE$.equals(childrenContainer)) {
                ChildrenContainer.EmptyChildrenContainer x = (ChildrenContainer.EmptyChildrenContainer)childrenContainer;
                string = x.toString();
            } else if (childrenContainer instanceof ChildrenContainer.NormalChildrenContainer) {
                ChildrenContainer.NormalChildrenContainer n = (ChildrenContainer.NormalChildrenContainer)childrenContainer;
                string = new StringBuilder(9).append(BoxesRunTime.boxToInteger((int)n.c().size()).toString()).append(" children").toString();
            } else {
                ChildrenContainer x = childrenContainer;
                string = Logging$.MODULE$.simpleName(x);
            }
            Seq children = (Seq)cell2.childrenRefs().children().toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            Seq bulk = (Seq)((IterableOps)children.dropRight(1)).map((Function1 & Serializable)_$7 -> ActorSystemImpl.printNode$1(_$7, new StringBuilder(4).append(indent).append("   |").toString()));
            return stringBuilder2.append(string).append(cell2.childrenRefs().children().isEmpty() ? "" : "\n").append(((IterableOnceOps)bulk.$plus$plus((IterableOnce)children.lastOption().map((Function1 & Serializable)_$8 -> ActorSystemImpl.printNode$1(_$8, new StringBuilder(4).append(indent).append("    ").toString())))).mkString("\n")).toString();
        }
        return new StringBuilder(1).append(indent).append(node.path().name()).append(" ").append(Logging$.MODULE$.simpleName(node)).toString();
    }

    public final class TerminationCallbacks<T> {
        private final ExecutionContext ec;
        private final Promise<T> done;
        private final AtomicReference<Promise<T>> ref;
        private final /* synthetic */ ActorSystemImpl $outer;

        public TerminationCallbacks(ActorSystemImpl $outer, Future<T> upStreamTerminated, ExecutionContext ec) {
            this.ec = ec;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.done = Promise$.MODULE$.apply();
            this.ref = new AtomicReference<Promise<T>>(this.done);
            upStreamTerminated.onComplete((Function1 & Serializable)t -> ((Promise)this.ref.getAndSet(null)).complete(t), ec);
        }

        public final void add(Runnable r) {
            this.addRec$1(r, Promise$.MODULE$.apply());
        }

        public Future<T> terminationFuture() {
            return this.done.future();
        }

        public final /* synthetic */ ActorSystemImpl org$apache$pekko$actor$ActorSystemImpl$TerminationCallbacks$$$outer() {
            return this.$outer;
        }

        private final void addRec$1(Runnable r, Promise p) {
            Promise<T> promise;
            Promise<T> some;
            do {
                if ((promise = this.ref.get()) != null) continue;
                throw new RejectedExecutionException("ActorSystem already terminated.");
            } while (!this.ref.compareAndSet(some = promise, p));
            some.completeWith(p.future().andThen((PartialFunction)new Serializable(r){
                private final Runnable r$1;
                {
                    this.r$1 = r$2;
                }

                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    return true;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Try try_ = x;
                    this.r$1.run();
                    return BoxedUnit.UNIT;
                }
            }, this.ec));
        }
    }
}

