/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorPath$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Deploy;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.Deployer$;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.InvalidActorNameException$;
import org.apache.pekko.actor.NoScopeGiven$;
import org.apache.pekko.routing.NoRouter$;
import org.apache.pekko.routing.RouterConfig;
import org.apache.pekko.util.WildcardIndex;
import org.apache.pekko.util.WildcardIndex$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Deployer {
    private final ActorSystem.Settings settings;
    private final DynamicAccess dynamicAccess;
    private final Config resizerEnabled;
    private final AtomicReference<WildcardIndex<Deploy>> deployments;
    private final Config default;
    private final scala.collection.immutable.Map routerTypeMapping;

    public Deployer(ActorSystem.Settings settings, DynamicAccess dynamicAccess) {
        this.settings = settings;
        this.dynamicAccess = dynamicAccess;
        this.resizerEnabled = ConfigFactory.parseString((String)"resizer.enabled=on");
        this.deployments = new AtomicReference(WildcardIndex$.MODULE$.apply(WildcardIndex$.MODULE$.$lessinit$greater$default$1(), WildcardIndex$.MODULE$.$lessinit$greater$default$2()));
        Config config = settings.config().getConfig("pekko.actor.deployment");
        this.default = config.getConfig("default");
        this.routerTypeMapping = package$JavaConverters$.MODULE$.MapHasAsScala(settings.config().getConfig("pekko.actor.router.type-mapping").root().unwrapped()).asScala().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Object object = tuple2._2();
                    String key = (String)tuple2._1();
                    if (object instanceof String) {
                        String value = (String)object;
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Object object = tuple2._2();
                    String key = (String)tuple2._1();
                    if (object instanceof String) {
                        String value = (String)object;
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value);
                    }
                }
                return function1.apply((Object)x);
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ((IterableOnceOps)package$JavaConverters$.MODULE$.MapHasAsScala((Map)config.root()).asScala().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                ConfigValue configValue = (ConfigValue)tuple2._2();
                if ("default".equals(string)) {
                    return None$.MODULE$;
                }
                String key = string;
                if (configValue instanceof ConfigObject) {
                    ConfigObject value = (ConfigObject)configValue;
                    return this.parseConfig(key, value.toConfig());
                }
            }
            return None$.MODULE$;
        })).foreach((Function1)(JProcedure1 & Serializable)d -> this.deploy((Deploy)d));
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public DynamicAccess dynamicAccess() {
        return this.dynamicAccess;
    }

    public Config default() {
        return this.default;
    }

    public scala.collection.immutable.Map<String, String> routerTypeMapping() {
        return this.routerTypeMapping;
    }

    public Option<Deploy> lookup(ActorPath path) {
        return this.lookup((Iterable<String>)((Iterable)path.elements().drop(1)));
    }

    public Option<Deploy> lookup(Iterable<String> path) {
        return this.deployments.get().find(path);
    }

    public void deploy(Deploy d) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])d.path().split("/"));
        this.add$1((String[])ArrayOps$.MODULE$.drop$extension(object, 1), d);
    }

    public Option<Deploy> parseConfig(String key, Config config) {
        Config deployment = config.withFallback((ConfigMergeable)this.default());
        RouterConfig router = this.createRouterConfig(deployment.getString("router"), key, config, deployment);
        String dispatcher = deployment.getString("dispatcher");
        String mailbox = deployment.getString("mailbox");
        return Some$.MODULE$.apply((Object)Deploy$.MODULE$.apply(key, deployment, router, NoScopeGiven$.MODULE$, dispatcher, mailbox));
    }

    public RouterConfig createRouterConfig(String routerType, String key, Config config, Config deployment) {
        String string = routerType;
        String string2 = "from-code";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return NoRouter$.MODULE$;
        }
        Config deployment2 = config.hasPath("resizer") && !deployment.getBoolean("resizer.enabled") ? this.resizerEnabled.withFallback((ConfigMergeable)deployment) : deployment;
        String fqn = (String)this.routerTypeMapping().getOrElse((Object)routerType, () -> Deployer.$anonfun$1(routerType));
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(Config.class);
        List args1 = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)deployment2), (List)Nil$.MODULE$);
        Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(Config.class);
        Class clazz3 = (Class)Predef$.MODULE$.ArrowAssoc(DynamicAccess.class);
        List args2 = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)deployment2), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz3, (Object)this.dynamicAccess()), (List)Nil$.MODULE$));
        return (RouterConfig)this.dynamicAccess().createInstanceFor(fqn, (Seq<Tuple2<Class<?>, Object>>)args1, ClassTag$.MODULE$.apply(RouterConfig.class)).recover((PartialFunction)new Serializable(fqn, args2, key, this){
            public final String org$apache$pekko$actor$Deployer$$anon$2$$fqn$2;
            public final List org$apache$pekko$actor$Deployer$$anon$2$$args2$1;
            public final String org$apache$pekko$actor$Deployer$$anon$2$$key$2;
            private final /* synthetic */ Deployer $outer;
            {
                this.org$apache$pekko$actor$Deployer$$anon$2$$fqn$2 = fqn$3;
                this.org$apache$pekko$actor$Deployer$$anon$2$$args2$1 = args2$2;
                this.org$apache$pekko$actor$Deployer$$anon$2$$key$2 = key$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof IllegalArgumentException || throwable instanceof ConfigException) {
                    RuntimeException e = (RuntimeException)throwable;
                    return true;
                }
                if (throwable instanceof NoSuchMethodException) {
                    NoSuchMethodException e = (NoSuchMethodException)throwable;
                    return true;
                }
                Throwable e = throwable;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof IllegalArgumentException || throwable instanceof ConfigException) {
                    RuntimeException e = (RuntimeException)throwable;
                    throw e;
                }
                if (throwable instanceof NoSuchMethodException) {
                    NoSuchMethodException e = (NoSuchMethodException)throwable;
                    return (RouterConfig)this.$outer.dynamicAccess().createInstanceFor(this.org$apache$pekko$actor$Deployer$$anon$2$$fqn$2, (Seq<Tuple2<Class<?>, Object>>)this.org$apache$pekko$actor$Deployer$$anon$2$$args2$1, ClassTag$.MODULE$.apply(RouterConfig.class)).recover((PartialFunction)new Serializable(e, this){
                        private final NoSuchMethodException e$1;
                        private final /* synthetic */ $anon$2 $outer;
                        {
                            this.e$1 = e$2;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable = x;
                            if (throwable instanceof IllegalArgumentException || throwable instanceof ConfigException) {
                                RuntimeException innerException = (RuntimeException)throwable;
                                return true;
                            }
                            return true;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable = x;
                            if (throwable instanceof IllegalArgumentException || throwable instanceof ConfigException) {
                                RuntimeException innerException = (RuntimeException)throwable;
                                throw innerException;
                            }
                            throw Deployer.org$apache$pekko$actor$Deployer$$_$throwCannotInstantiateRouter$1(this.$outer.org$apache$pekko$actor$Deployer$$anon$2$$fqn$2, this.$outer.org$apache$pekko$actor$Deployer$$anon$2$$key$2, (Seq)this.$outer.org$apache$pekko$actor$Deployer$$anon$2$$args2$1, this.e$1);
                        }
                    }).get();
                }
                Throwable e = throwable;
                throw Deployer.org$apache$pekko$actor$Deployer$$_$throwCannotInstantiateRouter$1(this.org$apache$pekko$actor$Deployer$$anon$2$$fqn$2, this.org$apache$pekko$actor$Deployer$$anon$2$$key$2, (Seq)this.org$apache$pekko$actor$Deployer$$anon$2$$args2$1, e);
            }
        }).get();
    }

    private final void add$1(String[] path, Deploy d) {
        WildcardIndex<Deploy> w;
        do {
            w = this.deployments.get();
            Object object = Predef$.MODULE$.refArrayOps((Object[])path);
            ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                String string = path[i];
                if ("".equals(string)) {
                    throw InvalidActorNameException$.MODULE$.apply(new StringBuilder(45).append("Actor name in deployment [").append(d.path()).append("] must not be empty").toString());
                }
                String el = string;
                ActorPath$.MODULE$.validatePathElement(el, d.path());
            });
        } while (!this.deployments.compareAndSet(w, w.insert(path, d)));
    }

    private static final String $anonfun$1(String routerType$1) {
        return routerType$1;
    }

    public static final Nothing$ org$apache$pekko$actor$Deployer$$_$throwCannotInstantiateRouter$1(String fqn$1, String key$1, Seq args, Throwable cause) {
        throw new IllegalArgumentException(new StringBuilder(45).append("Cannot instantiate router [").append(fqn$1).append("], defined in [").append(key$1).append("], ").append(new StringBuilder(49).append("make sure it extends [").append(RouterConfig.class).append("] and has constructor with ").toString()).append(new StringBuilder(28).append("[").append(((Class)((Tuple2)args.apply(0))._1()).getName()).append("] and optional [").append(((Class)((Tuple2)args.apply(1))._1()).getName()).append("] parameter").toString()).toString(), cause);
    }
}

