/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefProvider;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.ActorSelectionMessage$;
import org.apache.pekko.actor.EmptyLocalActorRef;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.LocalRef;
import org.apache.pekko.actor.MinimalActorRef;
import org.apache.pekko.actor.Nobody$;
import org.apache.pekko.actor.SelectChildName;
import org.apache.pekko.actor.SelectChildName$;
import org.apache.pekko.actor.SelectionPathElement;
import org.apache.pekko.event.MarkerLoggingAdapter;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;

public class VirtualPathContainer
extends InternalActorRef
implements LocalRef,
MinimalActorRef {
    private final ActorRefProvider provider;
    private final ActorPath path;
    private final InternalActorRef getParent;
    private final MarkerLoggingAdapter log;
    private final ConcurrentHashMap<String, InternalActorRef> children;

    public VirtualPathContainer(ActorRefProvider provider, ActorPath path, InternalActorRef getParent, MarkerLoggingAdapter log) {
        this.provider = provider;
        this.path = path;
        this.getParent = getParent;
        this.log = log;
        this.children = new ConcurrentHashMap();
    }

    @Override
    public ActorRefProvider provider() {
        return this.provider;
    }

    @Override
    public ActorPath path() {
        return this.path;
    }

    @Override
    public InternalActorRef getParent() {
        return this.getParent;
    }

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    @Override
    public void $bang(Object message, ActorRef sender) {
        Object object = message;
        if (object instanceof ActorSelectionMessage) {
            ActorSelectionMessage actorSelectionMessage = (ActorSelectionMessage)object;
            ActorSelectionMessage actorSelectionMessage2 = ActorSelectionMessage$.MODULE$.unapply(actorSelectionMessage);
            Object object2 = actorSelectionMessage2._1();
            scala.collection.immutable.Iterable<SelectionPathElement> iterable = actorSelectionMessage2._2();
            boolean bl = actorSelectionMessage2._3();
            Object msg = object2;
            scala.collection.immutable.Iterable<SelectionPathElement> elements = iterable;
            boolean wildcardFanOut = bl;
            ActorSelectionMessage sel = actorSelectionMessage;
            Predef$.MODULE$.require(elements.nonEmpty());
            SelectionPathElement selectionPathElement = (SelectionPathElement)elements.head();
            if (selectionPathElement instanceof SelectChildName) {
                SelectChildName selectChildName = SelectChildName$.MODULE$.unapply((SelectChildName)selectionPathElement);
                String string = selectChildName._1();
                String name = string;
                InternalActorRef internalActorRef = this.getChild(name);
                if (internalActorRef == null) {
                    if (!wildcardFanOut) {
                        this.emptyRef$1(sel).tell(msg, sender);
                        return;
                    }
                    return;
                }
                InternalActorRef child = internalActorRef;
                if (((IterableOnceOps)elements.tail()).isEmpty()) {
                    child.$bang(msg, sender);
                    return;
                }
                if (!wildcardFanOut) {
                    this.emptyRef$1(sel).tell(msg, sender);
                    return;
                }
                return;
            }
            if (!wildcardFanOut) {
                this.emptyRef$1(sel).tell(msg, sender);
                return;
            }
            return;
        }
        MinimalActorRef.$bang$(this, message, sender);
    }

    @Override
    public ActorRef $bang$default$2(Object message) {
        return Actor$.MODULE$.noSender();
    }

    public void addChild(String name, InternalActorRef ref) {
        InternalActorRef internalActorRef = this.children.put(name, ref);
        if (internalActorRef == null) {
            return;
        }
        InternalActorRef old = internalActorRef;
        this.log().debug("{} replacing child {} ({} -> {})", this.path(), (Object)name, (Object)old, (Object)ref);
        old.stop();
    }

    public void removeChild(String name) {
        if (this.children.remove(name) == null) {
            this.log().warning("{} trying to remove non-child {}", this.path(), (Object)name);
            return;
        }
    }

    public void removeChild(String name, ActorRef ref) {
        InternalActorRef current = this.getChild(name);
        if (current == null) {
            this.log().warning("{} trying to remove non-child {}", this.path(), (Object)name);
            return;
        }
        InternalActorRef internalActorRef = current;
        ActorRef actorRef = ref;
        if (!(internalActorRef != null ? !((Object)internalActorRef).equals(actorRef) : actorRef != null)) {
            this.children.remove(name, current);
            return;
        }
    }

    public InternalActorRef getChild(String name) {
        return this.children.get(name);
    }

    @Override
    public InternalActorRef getChild(Iterator<String> name) {
        if (name.isEmpty()) {
            return this;
        }
        String n = (String)name.next();
        if (n.isEmpty()) {
            return this;
        }
        InternalActorRef internalActorRef = this.children.get(n);
        if (internalActorRef == null) {
            return Nobody$.MODULE$;
        }
        InternalActorRef some = internalActorRef;
        if (name.isEmpty()) {
            return some;
        }
        return some.getChild(name);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void foreachChild(Function1<ActorRef, BoxedUnit> f) {
        java.util.Iterator<InternalActorRef> iter = this.children.values().iterator();
        while (iter.hasNext()) {
            f.apply((Object)iter.next());
        }
    }

    private final EmptyLocalActorRef emptyRef$1(ActorSelectionMessage sel$1) {
        return new EmptyLocalActorRef(this.provider(), this.path().$div((Iterable<String>)((Iterable)sel$1.elements().map((Function1 & Serializable)_$2 -> _$2.toString()))), this.provider().systemGuardian().underlying().system().eventStream());
    }
}

