/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.dungeon;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorInitializationException;
import org.apache.pekko.actor.ActorInitializationException$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.actor.DeadLetter;
import org.apache.pekko.actor.DeadLetter$;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.dungeon.AbstractActorCell;
import org.apache.pekko.actor.dungeon.SerializationCheckFailedException$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.Mailbox;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.ProducesMessageQueue;
import org.apache.pekko.dispatch.UnboundedMailbox;
import org.apache.pekko.dispatch.sysmsg.Create;
import org.apache.pekko.dispatch.sysmsg.Create$;
import org.apache.pekko.dispatch.sysmsg.Recreate$;
import org.apache.pekko.dispatch.sysmsg.Resume$;
import org.apache.pekko.dispatch.sysmsg.Supervise$;
import org.apache.pekko.dispatch.sysmsg.Suspend$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.dispatch.sysmsg.Terminate$;
import org.apache.pekko.event.Logging$Error$;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.Unsafe;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

@InternalApi
public interface Dispatch {
    public static void $init$(Dispatch $this) {
    }

    public Mailbox org$apache$pekko$actor$dungeon$Dispatch$$_mailboxDoNotCallMeDirectly();

    public void org$apache$pekko$actor$dungeon$Dispatch$$_mailboxDoNotCallMeDirectly_$eq(Mailbox var1);

    private Mailbox _preventPrivateUnusedErasure() {
        return this.org$apache$pekko$actor$dungeon$Dispatch$$_mailboxDoNotCallMeDirectly();
    }

    public static Mailbox mailbox$(Dispatch $this) {
        return $this.mailbox();
    }

    default public Mailbox mailbox() {
        return (Mailbox)Unsafe.instance.getObjectVolatile(this, AbstractActorCell.mailboxOffset);
    }

    public static Mailbox swapMailbox$(Dispatch $this, Mailbox newMailbox) {
        return $this.swapMailbox(newMailbox);
    }

    default public Mailbox swapMailbox(Mailbox newMailbox) {
        Mailbox oldMailbox;
        while (!Unsafe.instance.compareAndSwapObject(this, AbstractActorCell.mailboxOffset, oldMailbox = this.mailbox(), newMailbox)) {
        }
        return oldMailbox;
    }

    public static boolean hasMessages$(Dispatch $this) {
        return $this.hasMessages();
    }

    default public boolean hasMessages() {
        return this.mailbox().hasMessages();
    }

    public static int numberOfMessages$(Dispatch $this) {
        return $this.numberOfMessages();
    }

    default public int numberOfMessages() {
        return this.mailbox().numberOfMessages();
    }

    public static boolean isTerminated$(Dispatch $this) {
        return $this.isTerminated();
    }

    default public boolean isTerminated() {
        return this.mailbox().isClosed();
    }

    public static ActorCell init$(Dispatch $this, boolean sendSupervise, MailboxType mailboxType) {
        return $this.init(sendSupervise, mailboxType);
    }

    default public ActorCell init(boolean sendSupervise, MailboxType mailboxType) {
        Create create;
        Mailbox mbox = ((ActorCell)this).dispatcher().createMailbox((Cell)((Object)this), mailboxType);
        Class<? extends Actor> actorClass = ((ActorCell)this).props().actorClass();
        MailboxType mailboxType2 = mailboxType;
        if (mailboxType2 instanceof ProducesMessageQueue && ((ActorCell)this).system().mailboxes().hasRequiredType(actorClass)) {
            Class<?> req = ((ActorCell)this).system().mailboxes().getRequiredType(actorClass);
            if (req.isInstance(mbox.messageQueue())) {
                create = Create$.MODULE$.apply((Option<ActorInitializationException>)None$.MODULE$);
            } else {
                String gotType = mbox.messageQueue() == null ? "null" : mbox.messageQueue().getClass().getName();
                create = Create$.MODULE$.apply((Option<ActorInitializationException>)Some$.MODULE$.apply((Object)ActorInitializationException$.MODULE$.apply(((ActorCell)this).self(), new StringBuilder(40).append("Actor [").append(((ActorCell)this).self()).append("] requires mailbox type [").append(req).append("] got [").append(gotType).append("]").toString(), ActorInitializationException$.MODULE$.apply$default$3())));
            }
        } else {
            create = Create$.MODULE$.apply((Option<ActorInitializationException>)None$.MODULE$);
        }
        Create createMessage = create;
        this.swapMailbox(mbox);
        this.mailbox().setActor((ActorCell)this);
        this.mailbox().systemEnqueue(((ActorCell)this).self(), createMessage);
        if (sendSupervise) {
            ((ActorCell)this).parent().sendSystemMessage(Supervise$.MODULE$.apply(((ActorCell)this).self(), false));
        }
        return (ActorCell)this;
    }

    public static ActorCell initWithFailure$(Dispatch $this, Throwable failure) {
        return $this.initWithFailure(failure);
    }

    default public ActorCell initWithFailure(Throwable failure) {
        Mailbox mbox = ((ActorCell)this).dispatcher().createMailbox((Cell)((Object)this), new UnboundedMailbox());
        this.swapMailbox(mbox);
        this.mailbox().setActor((ActorCell)this);
        Create createMessage = Create$.MODULE$.apply((Option<ActorInitializationException>)Some$.MODULE$.apply((Object)ActorInitializationException$.MODULE$.apply(((ActorCell)this).self(), "failure while creating ActorCell", failure)));
        this.mailbox().systemEnqueue(((ActorCell)this).self(), createMessage);
        return (ActorCell)this;
    }

    public static ActorCell start$(Dispatch $this) {
        return $this.start();
    }

    default public ActorCell start() {
        ((ActorCell)this).dispatcher().attach((ActorCell)this);
        return (ActorCell)this;
    }

    private PartialFunction<Throwable, BoxedUnit> handleException() {
        return new Serializable(this){
            private final /* synthetic */ Dispatch $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof InterruptedException) {
                    InterruptedException e = (InterruptedException)throwable;
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Throwable throwable = x;
                if (throwable instanceof InterruptedException) {
                    InterruptedException e = (InterruptedException)throwable;
                    ((ActorCell)this.$outer).system().eventStream().publish(Logging$Error$.MODULE$.apply(e, ((ActorCell)this.$outer).self().path().toString(), ((ActorCell)this.$outer).clazz(((ActorCell)this.$outer).actor()), "interrupted during message send"));
                    Thread.currentThread().interrupt();
                    return BoxedUnit.UNIT;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    String string;
                    Throwable throwable2 = (Throwable)option.get();
                    Throwable e = throwable2;
                    Throwable throwable3 = e;
                    if (throwable3 instanceof NoStackTrace) {
                        NoStackTrace n = (NoStackTrace)throwable3;
                        string = new StringBuilder(42).append("swallowing exception during message send: ").append(((Throwable)n).getMessage()).toString();
                    } else {
                        string = "swallowing exception during message send";
                    }
                    String message = string;
                    ((ActorCell)this.$outer).system().eventStream().publish(Logging$Error$.MODULE$.apply(e, ((ActorCell)this.$outer).self().path().toString(), ((ActorCell)this.$outer).clazz(((ActorCell)this.$outer).actor()), message));
                    return BoxedUnit.UNIT;
                }
                return function1.apply((Object)x);
            }
        };
    }

    public static void suspend$(Dispatch $this) {
        $this.suspend();
    }

    default public void suspend() {
        try {
            ((ActorCell)this).dispatcher().systemDispatch((ActorCell)this, Suspend$.MODULE$.apply());
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $1$ = this.handleException();
            if ($1$.isDefinedAt((Object)ex$)) {
                $1$.apply((Object)ex$);
            }
            throw ex$;
        }
    }

    public static void resume$(Dispatch $this, Throwable causedByFailure) {
        $this.resume(causedByFailure);
    }

    default public void resume(Throwable causedByFailure) {
        try {
            ((ActorCell)this).dispatcher().systemDispatch((ActorCell)this, Resume$.MODULE$.apply(causedByFailure));
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $2$ = this.handleException();
            if ($2$.isDefinedAt((Object)ex$)) {
                $2$.apply((Object)ex$);
            }
            throw ex$;
        }
    }

    public static void restart$(Dispatch $this, Throwable cause) {
        $this.restart(cause);
    }

    default public void restart(Throwable cause) {
        try {
            ((ActorCell)this).dispatcher().systemDispatch((ActorCell)this, Recreate$.MODULE$.apply(cause));
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $3$ = this.handleException();
            if ($3$.isDefinedAt((Object)ex$)) {
                $3$.apply((Object)ex$);
            }
            throw ex$;
        }
    }

    public static void stop$(Dispatch $this) {
        $this.stop();
    }

    default public void stop() {
        try {
            ((ActorCell)this).dispatcher().systemDispatch((ActorCell)this, Terminate$.MODULE$.apply());
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $4$ = this.handleException();
            if ($4$.isDefinedAt((Object)ex$)) {
                $4$.apply((Object)ex$);
            }
            throw ex$;
        }
    }

    public static void sendMessage$(Dispatch $this, Envelope msg) {
        $this.sendMessage(msg);
    }

    default public void sendMessage(Envelope msg) {
        try {
            Envelope msgToDispatch = ((ActorCell)this).system().settings().SerializeAllMessages() ? this.serializeAndDeserialize(msg) : msg;
            ((ActorCell)this).dispatcher().dispatch((ActorCell)this, msgToDispatch);
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $5$ = this.handleException();
            if ($5$.isDefinedAt((Object)ex$)) {
                $5$.apply((Object)ex$);
            }
            throw ex$;
        }
    }

    private Envelope serializeAndDeserialize(Envelope envelope) {
        Object object;
        Object unwrappedMessage;
        Object object2;
        Object object3 = envelope.message();
        if (object3 instanceof DeadLetter) {
            Object wrapped;
            DeadLetter deadLetter = DeadLetter$.MODULE$.unapply((DeadLetter)object3);
            Object object4 = deadLetter._1();
            ActorRef actorRef = deadLetter._2();
            ActorRef actorRef2 = deadLetter._3();
            object2 = wrapped = object4;
        } else {
            Object other;
            object2 = other = object3;
        }
        Object object5 = unwrappedMessage = object2;
        if (object5 instanceof NoSerializationVerificationNeeded) {
            return envelope;
        }
        Object msg = object5;
        String string = msg.getClass().getName();
        if (((ActorCell)this).system().settings().NoSerializationVerificationNeededClassPrefix().exists((Function1 & Serializable)x$0 -> string.startsWith((String)x$0))) {
            return envelope;
        }
        try {
            object = this.serializeAndDeserializePayload(msg);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw SerializationCheckFailedException$.MODULE$.apply(msg, e);
            }
            throw throwable;
        }
        Object deserializedMsg = object;
        Object object6 = envelope.message();
        if (object6 instanceof DeadLetter) {
            DeadLetter dl = (DeadLetter)object6;
            return envelope.copy(dl.copy(deserializedMsg, dl.copy$default$2(), dl.copy$default$3()), envelope.copy$default$2());
        }
        return envelope.copy(deserializedMsg, envelope.copy$default$2());
    }

    private Object serializeAndDeserializePayload(Object obj) {
        Object object;
        Serialization s = (Serialization)SerializationExtension$.MODULE$.apply(((ActorCell)this).system());
        Serializer serializer = s.findSerializerFor(obj);
        if (serializer instanceof DisabledJavaSerializer && !s.shouldWarnAboutJavaSerializer(obj.getClass(), serializer)) {
            return obj;
        }
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)((ActorCell)this).system().provider().serializationInformation());
            }
            byte[] bytes = serializer.toBinary(obj);
            String ms = Serializers$.MODULE$.manifestFor(serializer, obj);
            object = s.deserialize(bytes, serializer.identifier(), ms).get();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return object;
    }

    public static void sendSystemMessage$(Dispatch $this, SystemMessage message) {
        $this.sendSystemMessage(message);
    }

    default public void sendSystemMessage(SystemMessage message) {
        try {
            ((ActorCell)this).dispatcher().systemDispatch((ActorCell)this, message);
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $7$ = this.handleException();
            if ($7$.isDefinedAt((Object)ex$)) {
                $7$.apply((Object)ex$);
            }
            throw ex$;
        }
    }
}

