/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.dispatch.BoundedQueueBasedMessageQueue;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.ProducesMessageQueue;
import org.apache.pekko.dispatch.ProducesPushTimeoutSemanticsMailbox;
import org.apache.pekko.util.BoundedBlockingQueue;
import org.apache.pekko.util.StablePriorityQueue;
import scala.Option;
import scala.concurrent.duration.Duration;

public class BoundedStablePriorityMailbox
implements MailboxType,
ProducesMessageQueue<MessageQueue>,
ProducesPushTimeoutSemanticsMailbox {
    private final Comparator cmp;
    private final int capacity;
    private final Duration pushTimeOut;

    public BoundedStablePriorityMailbox(Comparator<Envelope> cmp, int capacity, Duration pushTimeOut) {
        this.cmp = cmp;
        this.capacity = capacity;
        this.pushTimeOut = pushTimeOut;
        if (capacity < 0) {
            throw new IllegalArgumentException("The capacity for BoundedMailbox can not be negative");
        }
        if (pushTimeOut == null) {
            throw new IllegalArgumentException("The push time-out for BoundedMailbox can not be null");
        }
    }

    public final Comparator<Envelope> cmp() {
        return this.cmp;
    }

    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final Duration pushTimeOut() {
        return this.pushTimeOut;
    }

    @Override
    public final org.apache.pekko.dispatch.MessageQueue create(Option<ActorRef> owner, Option<ActorSystem> system) {
        return new MessageQueue(this.capacity(), this.cmp(), this.pushTimeOut());
    }

    public static class MessageQueue
    extends BoundedBlockingQueue<Envelope>
    implements BoundedQueueBasedMessageQueue {
        private final Duration pushTimeOut;

        public MessageQueue(int capacity, Comparator<Envelope> cmp, Duration pushTimeOut) {
            this.pushTimeOut = pushTimeOut;
            super(capacity, new StablePriorityQueue<Envelope>(11, cmp));
        }

        @Override
        public Duration pushTimeOut() {
            return this.pushTimeOut;
        }

        @Override
        public final BlockingQueue<Envelope> queue() {
            return this;
        }
    }
}

