/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMemorySize;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.dispatch.CachingConfig$;
import org.apache.pekko.dispatch.CachingConfig$StringPathEntry$;
import org.apache.pekko.dispatch.CachingConfig$ValuePathEntry$;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class CachingConfig
implements Config {
    private final Config config;
    private final ConcurrentHashMap entryMap;

    public static Config emptyConfig() {
        return CachingConfig$.MODULE$.emptyConfig();
    }

    public static ValuePathEntry emptyPathEntry() {
        return CachingConfig$.MODULE$.emptyPathEntry();
    }

    public static ValuePathEntry invalidPathEntry() {
        return CachingConfig$.MODULE$.invalidPathEntry();
    }

    public static ValuePathEntry nonExistingPathEntry() {
        return CachingConfig$.MODULE$.nonExistingPathEntry();
    }

    public CachingConfig(Config _config) {
        Config config;
        ConcurrentHashMap concurrentHashMap;
        block6: {
            Tuple2 tuple2;
            block5: {
                Tuple2 tuple22;
                Config config2 = _config;
                if (config2 instanceof CachingConfig) {
                    CachingConfig cc = (CachingConfig)config2;
                    tuple22 = Tuple2$.MODULE$.apply((Object)cc.config(), cc.entryMap());
                } else {
                    tuple22 = tuple2 = Tuple2$.MODULE$.apply((Object)_config, new ConcurrentHashMap());
                }
                if (tuple2 == null) break block5;
                Config config3 = (Config)tuple2._1();
                concurrentHashMap = (ConcurrentHashMap)tuple2._2();
                if (config3 == null) break block5;
                config = config3;
                if (concurrentHashMap != null) break block6;
            }
            throw new MatchError((Object)tuple2);
        }
        ConcurrentHashMap entryMap = concurrentHashMap;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)config, (Object)entryMap);
        this.config = (Config)tuple2._1();
        this.entryMap = (ConcurrentHashMap)tuple2._2();
    }

    private Config config() {
        return this.config;
    }

    private ConcurrentHashMap<String, PathEntry> entryMap() {
        return this.entryMap;
    }

    private PathEntry getPathEntry(String path) {
        PathEntry pathEntry = this.entryMap().get(path);
        if (pathEntry == null) {
            Product product;
            Try try_ = Try$.MODULE$.apply(() -> this.$anonfun$1(path));
            if (try_ instanceof Failure) {
                product = CachingConfig$.MODULE$.invalidPathEntry();
            } else if (try_ instanceof Success && !BoxesRunTime.unboxToBoolean((Object)((Success)try_).value())) {
                product = CachingConfig$.MODULE$.nonExistingPathEntry();
            } else {
                Try try_2 = Try$.MODULE$.apply(() -> this.$anonfun$2(path));
                if (try_2 instanceof Failure) {
                    product = CachingConfig$.MODULE$.emptyPathEntry();
                } else if (try_2 instanceof Success) {
                    ConfigValue v = (ConfigValue)((Success)try_2).value();
                    ConfigValueType configValueType = v.valueType();
                    ConfigValueType configValueType2 = ConfigValueType.STRING;
                    product = !(configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null) ? CachingConfig$StringPathEntry$.MODULE$.apply(true, true, v.atKey("cached"), (String)v.unwrapped()) : CachingConfig$ValuePathEntry$.MODULE$.apply(true, true, v.atKey("cached"));
                } else {
                    throw new MatchError((Object)try_2);
                }
            }
            PathEntry ne = product;
            PathEntry pathEntry2 = this.entryMap().putIfAbsent(path, ne);
            if (pathEntry2 == null) {
                return ne;
            }
            PathEntry e = pathEntry2;
            return e;
        }
        PathEntry e = pathEntry;
        return e;
    }

    public void checkValid(Config reference, Seq<String> restrictToPaths) {
        this.config().checkValid(reference, (String[])Arrays$.MODULE$.seqToArray(restrictToPaths, String.class));
    }

    public /* synthetic */ void checkValid(Config reference, String ... restrictToPaths) {
        this.checkValid(reference, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])restrictToPaths));
    }

    public ConfigObject root() {
        return this.config().root();
    }

    public ConfigOrigin origin() {
        return this.config().origin();
    }

    public Config withFallback(ConfigMergeable other) {
        return new CachingConfig(this.config().withFallback(other));
    }

    public Config resolve() {
        return this.resolve(ConfigResolveOptions.defaults());
    }

    public Config resolve(ConfigResolveOptions options) {
        Config resolved = this.config().resolve(options);
        if (resolved == this.config()) {
            return this;
        }
        return new CachingConfig(resolved);
    }

    public boolean hasPath(String path) {
        PathEntry entry = this.getPathEntry(path);
        if (entry.valid()) {
            return entry.exists();
        }
        return this.config().hasPath(path);
    }

    public boolean hasPathOrNull(String path) {
        return this.config().hasPathOrNull(path);
    }

    public boolean isEmpty() {
        return this.config().isEmpty();
    }

    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        return this.config().entrySet();
    }

    public boolean getBoolean(String path) {
        return this.config().getBoolean(path);
    }

    public Number getNumber(String path) {
        return this.config().getNumber(path);
    }

    public int getInt(String path) {
        return this.config().getInt(path);
    }

    public long getLong(String path) {
        return this.config().getLong(path);
    }

    public double getDouble(String path) {
        return this.config().getDouble(path);
    }

    public String getString(String path) {
        PathEntry pathEntry = this.getPathEntry(path);
        if (pathEntry instanceof StringPathEntry) {
            String string;
            StringPathEntry stringPathEntry = CachingConfig$StringPathEntry$.MODULE$.unapply((StringPathEntry)pathEntry);
            boolean bl = stringPathEntry._1();
            boolean bl2 = stringPathEntry._2();
            Config config = stringPathEntry._3();
            String string2 = string = stringPathEntry._4();
            return string2;
        }
        PathEntry e = pathEntry;
        return e.config().getString("cached");
    }

    public ConfigObject getObject(String path) {
        return this.config().getObject(path);
    }

    public Config getConfig(String path) {
        return this.config().getConfig(path);
    }

    public Object getAnyRef(String path) {
        return this.config().getAnyRef(path);
    }

    public ConfigValue getValue(String path) {
        return this.config().getValue(path);
    }

    public Long getBytes(String path) {
        return this.config().getBytes(path);
    }

    public Long getMilliseconds(String path) {
        return Predef$.MODULE$.long2Long(this.config().getDuration(path, TimeUnit.MILLISECONDS));
    }

    public Long getNanoseconds(String path) {
        return Predef$.MODULE$.long2Long(this.config().getDuration(path, TimeUnit.NANOSECONDS));
    }

    public ConfigList getList(String path) {
        return this.config().getList(path);
    }

    public List<Boolean> getBooleanList(String path) {
        return this.config().getBooleanList(path);
    }

    public List<Number> getNumberList(String path) {
        return this.config().getNumberList(path);
    }

    public List<Integer> getIntList(String path) {
        return this.config().getIntList(path);
    }

    public List<Long> getLongList(String path) {
        return this.config().getLongList(path);
    }

    public List<Double> getDoubleList(String path) {
        return this.config().getDoubleList(path);
    }

    public List<String> getStringList(String path) {
        return this.config().getStringList(path);
    }

    public List<? extends ConfigObject> getObjectList(String path) {
        return this.config().getObjectList(path);
    }

    public List<? extends Config> getConfigList(String path) {
        return this.config().getConfigList(path);
    }

    public List<?> getAnyRefList(String path) {
        return this.config().getAnyRefList(path);
    }

    public List<Long> getBytesList(String path) {
        return this.config().getBytesList(path);
    }

    public List<Long> getMillisecondsList(String path) {
        return this.config().getDurationList(path, TimeUnit.MILLISECONDS);
    }

    public List<Long> getNanosecondsList(String path) {
        return this.config().getDurationList(path, TimeUnit.NANOSECONDS);
    }

    public Config withOnlyPath(String path) {
        return new CachingConfig(this.config().withOnlyPath(path));
    }

    public Config withoutPath(String path) {
        return new CachingConfig(this.config().withoutPath(path));
    }

    public Config atPath(String path) {
        return new CachingConfig(this.config().atPath(path));
    }

    public Config atKey(String key) {
        return new CachingConfig(this.config().atKey(key));
    }

    public Config withValue(String path, ConfigValue value) {
        return new CachingConfig(this.config().withValue(path, value));
    }

    public long getDuration(String path, TimeUnit unit) {
        return this.config().getDuration(path, unit);
    }

    public List<Long> getDurationList(String path, TimeUnit unit) {
        return this.config().getDurationList(path, unit);
    }

    public Duration getDuration(String path) {
        return this.config().getDuration(path);
    }

    public List<Duration> getDurationList(String path) {
        return this.config().getDurationList(path);
    }

    public Period getPeriod(String path) {
        return this.config().getPeriod(path);
    }

    public TemporalAmount getTemporal(String path) {
        return this.config().getTemporal(path);
    }

    public boolean getIsNull(String path) {
        return this.config().getIsNull(path);
    }

    public ConfigMemorySize getMemorySize(String path) {
        return this.config().getMemorySize(path);
    }

    public List<ConfigMemorySize> getMemorySizeList(String path) {
        return this.config().getMemorySizeList(path);
    }

    public boolean isResolved() {
        return this.config().isResolved();
    }

    public Config resolveWith(Config source, ConfigResolveOptions options) {
        return this.config().resolveWith(source, options);
    }

    public Config resolveWith(Config source) {
        return this.config().resolveWith(source);
    }

    public <T extends Enum<T>> List<T> getEnumList(Class<T> enumClass, String path) {
        return this.config().getEnumList(enumClass, path);
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumClass, String path) {
        return (T)this.config().getEnum(enumClass, path);
    }

    private final boolean $anonfun$1(String path$1) {
        return this.config().hasPath(path$1);
    }

    private final ConfigValue $anonfun$2(String path$2) {
        return this.config().getValue(path$2);
    }

    public static interface PathEntry {
        public boolean valid();

        public boolean exists();

        public Config config();
    }

    public static final class StringPathEntry
    implements PathEntry,
    Product,
    Serializable {
        private final boolean valid;
        private final boolean exists;
        private final Config config;
        private final String value;

        public static StringPathEntry apply(boolean bl, boolean bl2, Config config, String string) {
            return CachingConfig$StringPathEntry$.MODULE$.apply(bl, bl2, config, string);
        }

        public static StringPathEntry fromProduct(Product product) {
            return CachingConfig$StringPathEntry$.MODULE$.fromProduct(product);
        }

        public static StringPathEntry unapply(StringPathEntry stringPathEntry) {
            return CachingConfig$StringPathEntry$.MODULE$.unapply(stringPathEntry);
        }

        public StringPathEntry(boolean valid, boolean exists, Config config, String value) {
            this.valid = valid;
            this.exists = exists;
            this.config = config;
            this.value = value;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.valid() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.exists() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.config()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.value()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StringPathEntry)) return false;
            StringPathEntry stringPathEntry = (StringPathEntry)object;
            if (this.valid() != stringPathEntry.valid()) return false;
            if (this.exists() != stringPathEntry.exists()) return false;
            Config config = this.config();
            Config config2 = stringPathEntry.config();
            if (config == null) {
                if (config2 != null) {
                    return false;
                }
            } else if (!config.equals(config2)) return false;
            String string = this.value();
            String string2 = stringPathEntry.value();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StringPathEntry;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "StringPathEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "valid";
                }
                case 1: {
                    return "exists";
                }
                case 2: {
                    return "config";
                }
                case 3: {
                    return "value";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public boolean valid() {
            return this.valid;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public Config config() {
            return this.config;
        }

        public String value() {
            return this.value;
        }

        public StringPathEntry copy(boolean valid, boolean exists, Config config, String value) {
            return new StringPathEntry(valid, exists, config, value);
        }

        public boolean copy$default$1() {
            return this.valid();
        }

        public boolean copy$default$2() {
            return this.exists();
        }

        public Config copy$default$3() {
            return this.config();
        }

        public String copy$default$4() {
            return this.value();
        }

        public boolean _1() {
            return this.valid();
        }

        public boolean _2() {
            return this.exists();
        }

        public Config _3() {
            return this.config();
        }

        public String _4() {
            return this.value();
        }
    }

    public static final class ValuePathEntry
    implements PathEntry,
    Product,
    Serializable {
        private final boolean valid;
        private final boolean exists;
        private final Config config;

        public static ValuePathEntry apply(boolean bl, boolean bl2, Config config) {
            return CachingConfig$ValuePathEntry$.MODULE$.apply(bl, bl2, config);
        }

        public static ValuePathEntry fromProduct(Product product) {
            return CachingConfig$ValuePathEntry$.MODULE$.fromProduct(product);
        }

        public static ValuePathEntry unapply(ValuePathEntry valuePathEntry) {
            return CachingConfig$ValuePathEntry$.MODULE$.unapply(valuePathEntry);
        }

        public static Config $lessinit$greater$default$3() {
            return CachingConfig$ValuePathEntry$.MODULE$.$lessinit$greater$default$3();
        }

        public ValuePathEntry(boolean valid, boolean exists, Config config) {
            this.valid = valid;
            this.exists = exists;
            this.config = config;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.valid() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.exists() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.config()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ValuePathEntry)) return false;
            ValuePathEntry valuePathEntry = (ValuePathEntry)object;
            if (this.valid() != valuePathEntry.valid()) return false;
            if (this.exists() != valuePathEntry.exists()) return false;
            Config config = this.config();
            Config config2 = valuePathEntry.config();
            if (config != null) {
                if (!config.equals(config2)) return false;
                return true;
            }
            if (config2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ValuePathEntry;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ValuePathEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "valid";
                }
                case 1: {
                    return "exists";
                }
                case 2: {
                    return "config";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public boolean valid() {
            return this.valid;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public Config config() {
            return this.config;
        }

        public ValuePathEntry copy(boolean valid, boolean exists, Config config) {
            return new ValuePathEntry(valid, exists, config);
        }

        public boolean copy$default$1() {
            return this.valid();
        }

        public boolean copy$default$2() {
            return this.exists();
        }

        public Config copy$default$3() {
            return this.config();
        }

        public boolean _1() {
            return this.valid();
        }

        public boolean _2() {
            return this.exists();
        }

        public Config _3() {
            return this.config();
        }
    }
}

