/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.dispatch.DefaultSystemMessageQueue;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.ExecutorServiceDelegate;
import org.apache.pekko.dispatch.ExecutorServiceFactory;
import org.apache.pekko.dispatch.ExecutorServiceFactoryProvider;
import org.apache.pekko.dispatch.Mailbox;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.dispatch.MessageDispatcherConfigurator;
import org.apache.pekko.dispatch.TaskInvocation;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Error$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class Dispatcher
extends MessageDispatcher {
    private final String id;
    private final int throughput;
    private final Duration throughputDeadlineTime;
    private final FiniteDuration shutdownTimeout;
    private volatile LazyExecutorServiceDelegate executorServiceDelegate;
    private final AtomicReferenceFieldUpdater<Dispatcher, LazyExecutorServiceDelegate> esUpdater;
    private final String toString;

    public Dispatcher(MessageDispatcherConfigurator _configurator, String id, int throughput, Duration throughputDeadlineTime, ExecutorServiceFactoryProvider executorServiceFactoryProvider, FiniteDuration shutdownTimeout) {
        this.id = id;
        this.throughput = throughput;
        this.throughputDeadlineTime = throughputDeadlineTime;
        this.shutdownTimeout = shutdownTimeout;
        super(_configurator);
        this.executorServiceDelegate = new LazyExecutorServiceDelegate(this, executorServiceFactoryProvider.createExecutorServiceFactory(id, this.configurator().prerequisites().threadFactory()));
        this.esUpdater = AtomicReferenceFieldUpdater.newUpdater(Dispatcher.class, LazyExecutorServiceDelegate.class, "executorServiceDelegate");
        this.toString = new StringBuilder(2).append(Logging$.MODULE$.simpleName(this)).append("[").append(id).append("]").toString();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public int throughput() {
        return this.throughput;
    }

    @Override
    public Duration throughputDeadlineTime() {
        return this.throughputDeadlineTime;
    }

    @Override
    public FiniteDuration shutdownTimeout() {
        return this.shutdownTimeout;
    }

    public final ExecutorServiceDelegate executorService() {
        return this.executorServiceDelegate;
    }

    @Override
    public void dispatch(ActorCell receiver, Envelope invocation) {
        Mailbox mbox = receiver.mailbox();
        mbox.enqueue(receiver.self(), invocation);
        this.registerForExecution(mbox, true, false);
    }

    @Override
    public void systemDispatch(ActorCell receiver, SystemMessage invocation) {
        Mailbox mbox = receiver.mailbox();
        mbox.systemEnqueue(receiver.self(), invocation);
        this.registerForExecution(mbox, false, true);
    }

    @Override
    public void executeTask(TaskInvocation invocation) {
        try {
            this.executorService().execute(invocation);
        }
        catch (RejectedExecutionException e) {
            try {
                this.executorService().execute(invocation);
            }
            catch (RejectedExecutionException e2) {
                this.eventStream().publish(Logging$Error$.MODULE$.apply(e, this.getClass().getName(), this.getClass(), "executeTask was rejected twice!"));
                throw e2;
            }
        }
    }

    @Override
    public Mailbox createMailbox(Cell actor, MailboxType mailboxType) {
        return new DefaultSystemMessageQueue(mailboxType, actor){};
    }

    @Override
    public void shutdown() {
        LazyExecutorServiceDelegate newDelegate = this.executorServiceDelegate.copy();
        LazyExecutorServiceDelegate es = this.esUpdater.getAndSet(this, newDelegate);
        es.shutdown();
    }

    @Override
    public boolean registerForExecution(Mailbox mbox, boolean hasMessageHint, boolean hasSystemMessageHint) {
        if (mbox.canBeScheduledForExecution(hasMessageHint, hasSystemMessageHint)) {
            if (mbox.setAsScheduled()) {
                boolean bl;
                try {
                    this.executorService().execute(mbox);
                    bl = true;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    try {
                        this.executorService().execute(mbox);
                        bl = true;
                    }
                    catch (RejectedExecutionException e) {
                        mbox.setAsIdle();
                        this.eventStream().publish(Logging$Error$.MODULE$.apply(e, this.getClass().getName(), this.getClass(), "registerForExecution was rejected twice!"));
                        throw e;
                    }
                }
                return bl;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.toString;
    }

    public class LazyExecutorServiceDelegate
    implements ExecutorServiceDelegate {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LazyExecutorServiceDelegate.class.getDeclaredField("executor$lzy1"));
        private final ExecutorServiceFactory factory;
        private volatile Object executor$lzy1;
        private final /* synthetic */ Dispatcher $outer;

        public LazyExecutorServiceDelegate(Dispatcher $outer, ExecutorServiceFactory factory) {
            this.factory = factory;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public ExecutorService executor() {
            Object object = this.executor$lzy1;
            if (object instanceof ExecutorService) {
                return (ExecutorService)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ExecutorService)this.executor$lzyINIT1();
        }

        private Object executor$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.executor$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ExecutorService executorService = null;
                        try {
                            executorService = this.factory.createExecutorService();
                            object2 = executorService == null ? LazyVals.NullValue$.MODULE$ : executorService;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.executor$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return executorService;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public LazyExecutorServiceDelegate copy() {
            return new LazyExecutorServiceDelegate(this.$outer, this.factory);
        }

        public final /* synthetic */ Dispatcher org$apache$pekko$dispatch$Dispatcher$LazyExecutorServiceDelegate$$$outer() {
            return this.$outer;
        }
    }
}

