/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import com.typesafe.config.Config;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ThreadFactory;
import org.apache.pekko.dispatch.DispatcherPrerequisites;
import org.apache.pekko.dispatch.ExecutorServiceConfigurator;
import org.apache.pekko.dispatch.ExecutorServiceFactory;
import org.apache.pekko.dispatch.ForkJoinPoolConstants$;
import org.apache.pekko.dispatch.LoadMetrics;
import org.apache.pekko.dispatch.MonitorableThreadFactory;
import org.apache.pekko.dispatch.MonitorableThreadFactory$;
import org.apache.pekko.dispatch.ThreadPoolConfig$;
import org.apache.pekko.util.JavaVersion$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Try$;

public class ForkJoinExecutorConfigurator
extends ExecutorServiceConfigurator {
    private final Config config;

    public ForkJoinExecutorConfigurator(Config config, DispatcherPrerequisites prerequisites) {
        this.config = config;
        super(config, prerequisites);
    }

    public ForkJoinPool.ForkJoinWorkerThreadFactory validate(ThreadFactory t) {
        ThreadFactory threadFactory = t;
        if (threadFactory instanceof ForkJoinPool.ForkJoinWorkerThreadFactory) {
            ForkJoinPool.ForkJoinWorkerThreadFactory correct = (ForkJoinPool.ForkJoinWorkerThreadFactory)((Object)threadFactory);
            return correct;
        }
        throw new IllegalStateException("The prerequisites for the ForkJoinExecutorConfigurator is a ForkJoinPool.ForkJoinWorkerThreadFactory!");
    }

    @Override
    public final ExecutorServiceFactory createExecutorServiceFactory(String id, ThreadFactory threadFactory) {
        boolean bl;
        ThreadFactory threadFactory2;
        ThreadFactory threadFactory3 = threadFactory;
        if (threadFactory3 instanceof MonitorableThreadFactory) {
            MonitorableThreadFactory m = (MonitorableThreadFactory)threadFactory3;
            threadFactory2 = m.withName(new StringBuilder(1).append(m.name()).append("-").append(id).toString());
        } else {
            ThreadFactory other;
            threadFactory2 = other = threadFactory3;
        }
        ThreadFactory tf = threadFactory2;
        String string = this.config.getString("task-peeking-mode");
        if ("FIFO".equals(string)) {
            bl = true;
        } else if ("LIFO".equals(string)) {
            bl = false;
        } else {
            throw new IllegalArgumentException("Cannot instantiate ForkJoinExecutorServiceFactory. \"task-peeking-mode\" in \"fork-join-executor\" section could only set to \"FIFO\" or \"LIFO\".");
        }
        boolean asyncMode = bl;
        return new ForkJoinExecutorServiceFactory(this, this.validate(tf), ThreadPoolConfig$.MODULE$.scaledPoolSize(this.config.getInt("parallelism-min"), this.config.getDouble("parallelism-factor"), this.config.getInt("parallelism-max")), asyncMode, this.config.getInt("maximum-pool-size"));
    }

    public static final Class org$apache$pekko$dispatch$ForkJoinExecutorConfigurator$ForkJoinExecutorServiceFactory$$_$pekkoJdk9ForkJoinPoolClassOpt$$anonfun$1() {
        return Class.forName("org.apache.pekko.dispatch.PekkoJdk9ForkJoinPool");
    }

    public static final /* synthetic */ MethodHandle org$apache$pekko$dispatch$ForkJoinExecutorConfigurator$ForkJoinExecutorServiceFactory$$_$pekkoJdk9ForkJoinPoolHandleOpt$lzyINIT1$$anonfun$1(Class clz) {
        MethodHandles.Lookup methodHandleLookup = MethodHandles.lookup();
        MethodType mt = MethodType.methodType(Void.TYPE, Integer.TYPE, ForkJoinPool.ForkJoinWorkerThreadFactory.class, Integer.TYPE, Thread.UncaughtExceptionHandler.class, Boolean.TYPE);
        return methodHandleLookup.findConstructor(clz, mt);
    }

    public class ForkJoinExecutorServiceFactory
    implements ExecutorServiceFactory {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ForkJoinExecutorServiceFactory.class.getDeclaredField("pekkoJdk9ForkJoinPoolHandleOpt$lzy1"));
        private final ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory;
        private final int parallelism;
        private final boolean asyncMode;
        private final int maxPoolSize;
        private volatile Object pekkoJdk9ForkJoinPoolHandleOpt$lzy1;
        private final /* synthetic */ ForkJoinExecutorConfigurator $outer;

        public ForkJoinExecutorServiceFactory(ForkJoinExecutorConfigurator $outer, ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory, int parallelism, boolean asyncMode, int maxPoolSize) {
            this.threadFactory = threadFactory;
            this.parallelism = parallelism;
            this.asyncMode = asyncMode;
            this.maxPoolSize = maxPoolSize;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public int parallelism() {
            return this.parallelism;
        }

        public boolean asyncMode() {
            return this.asyncMode;
        }

        public int maxPoolSize() {
            return this.maxPoolSize;
        }

        public ForkJoinExecutorServiceFactory(ForkJoinExecutorConfigurator $outer, ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory, int parallelism, boolean asyncMode) {
            this($outer, threadFactory, parallelism, asyncMode, ForkJoinPoolConstants$.MODULE$.MaxCap());
        }

        private Option<Class<?>> pekkoJdk9ForkJoinPoolClassOpt() {
            return Try$.MODULE$.apply(ForkJoinExecutorConfigurator::org$apache$pekko$dispatch$ForkJoinExecutorConfigurator$ForkJoinExecutorServiceFactory$$_$pekkoJdk9ForkJoinPoolClassOpt$$anonfun$1).toOption();
        }

        private Option<MethodHandle> pekkoJdk9ForkJoinPoolHandleOpt() {
            Object object = this.pekkoJdk9ForkJoinPoolHandleOpt$lzy1;
            if (object instanceof Option) {
                return (Option)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Option)this.pekkoJdk9ForkJoinPoolHandleOpt$lzyINIT1();
        }

        private Object pekkoJdk9ForkJoinPoolHandleOpt$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.pekkoJdk9ForkJoinPoolHandleOpt$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        None$ none$ = null;
                        try {
                            Object object3 = none$ = JavaVersion$.MODULE$.majorVersion() == 8 ? None$.MODULE$ : this.pekkoJdk9ForkJoinPoolClassOpt().map(ForkJoinExecutorConfigurator::org$apache$pekko$dispatch$ForkJoinExecutorConfigurator$ForkJoinExecutorServiceFactory$$_$pekkoJdk9ForkJoinPoolHandleOpt$lzyINIT1$$anonfun$1);
                            object2 = none$ == null ? LazyVals.NullValue$.MODULE$ : none$;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.pekkoJdk9ForkJoinPoolHandleOpt$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return none$;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public ForkJoinExecutorServiceFactory(ForkJoinExecutorConfigurator $outer, ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory, int parallelism) {
            this($outer, threadFactory, parallelism, true);
        }

        @Override
        public ExecutorService createExecutorService() {
            Option<MethodHandle> option = this.pekkoJdk9ForkJoinPoolHandleOpt();
            if (option instanceof Some) {
                MethodHandle handle = (MethodHandle)((Some)option).value();
                return handle.invoke(this.parallelism(), this.threadFactory(), this.maxPoolSize(), MonitorableThreadFactory$.MODULE$.doNothing(), this.asyncMode());
            }
            return new PekkoForkJoinPool(this.parallelism(), this.threadFactory(), MonitorableThreadFactory$.MODULE$.doNothing(), this.asyncMode());
        }

        public final /* synthetic */ ForkJoinExecutorConfigurator org$apache$pekko$dispatch$ForkJoinExecutorConfigurator$ForkJoinExecutorServiceFactory$$$outer() {
            return this.$outer;
        }
    }

    public static final class PekkoForkJoinPool
    extends ForkJoinPool
    implements LoadMetrics {
        public PekkoForkJoinPool(int parallelism, ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory, Thread.UncaughtExceptionHandler unhandledExceptionHandler, boolean asyncMode) {
            super(parallelism, threadFactory, unhandledExceptionHandler, asyncMode);
        }

        public PekkoForkJoinPool(int parallelism, ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory, Thread.UncaughtExceptionHandler unhandledExceptionHandler) {
            this(parallelism, threadFactory, unhandledExceptionHandler, true);
        }

        @Override
        public void execute(Runnable r) {
            if (r != null) {
                super.execute((ForkJoinTask)(r instanceof ForkJoinTask ? r : new PekkoForkJoinTask(r)));
                return;
            }
            throw new NullPointerException("Runnable was null");
        }

        @Override
        public boolean atFullThrottle() {
            return this.getActiveThreadCount() >= this.getParallelism();
        }
    }

    public static final class PekkoForkJoinTask
    extends ForkJoinTask<BoxedUnit> {
        private static final long serialVersionUID = 1L;
        private final Runnable runnable;

        public PekkoForkJoinTask(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void getRawResult() {
        }

        @Override
        public void setRawResult(BoxedUnit unit) {
        }

        @Override
        public boolean exec() {
            boolean bl;
            try {
                this.runnable.run();
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                bl = false;
            }
            catch (Throwable anything) {
                Thread t = Thread.currentThread();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = t.getUncaughtExceptionHandler();
                if (uncaughtExceptionHandler != null) {
                    Thread.UncaughtExceptionHandler some = uncaughtExceptionHandler;
                    some.uncaughtException(t, anything);
                }
                throw anything;
            }
            return bl;
        }
    }
}

