/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.DeadLetter;
import org.apache.pekko.actor.DeadLetter$;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.dispatch.BoundedMailbox;
import org.apache.pekko.dispatch.Dispatchers$;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.Mailbox;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.Mailboxes$;
import org.apache.pekko.dispatch.MessageQueue;
import org.apache.pekko.dispatch.ProducesMessageQueue;
import org.apache.pekko.dispatch.ProducesPushTimeoutSemanticsMailbox;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMailbox;
import org.apache.pekko.dispatch.UnboundedMailbox$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.dispatch.sysmsg.SystemMessageList$;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$Warning$;
import org.apache.pekko.util.Reflect$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class Mailboxes {
    private final ActorSystem.Settings settings;
    private final EventStream eventStream;
    private final DynamicAccess dynamicAccess;
    public final ActorRef org$apache$pekko$dispatch$Mailboxes$$deadLetters;
    private final Mailbox deadLetterMailbox;
    private final ConcurrentHashMap<String, MailboxType> mailboxTypeConfigurators;
    private final scala.collection.immutable.Map<Class<?>, String> mailboxBindings;
    private boolean mailboxSizeWarningIssued;
    private boolean mailboxNonZeroPushTimeoutWarningIssued;
    private final Config defaultMailboxConfig;
    private final AtomicReference<scala.collection.immutable.Map<String, Object>> stashCapacityCache;
    private final int defaultStashCapacity;

    public static String BoundedCapacityPrefix() {
        return Mailboxes$.MODULE$.BoundedCapacityPrefix();
    }

    public static String DefaultMailboxId() {
        return Mailboxes$.MODULE$.DefaultMailboxId();
    }

    public static String NoMailboxRequirement() {
        return Mailboxes$.MODULE$.NoMailboxRequirement();
    }

    public Mailboxes(ActorSystem.Settings settings, EventStream eventStream, DynamicAccess dynamicAccess, ActorRef deadLetters) {
        this.settings = settings;
        this.eventStream = eventStream;
        this.dynamicAccess = dynamicAccess;
        this.org$apache$pekko$dispatch$Mailboxes$$deadLetters = deadLetters;
        this.deadLetterMailbox = new Mailbox(this){
            private final /* synthetic */ Mailboxes $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.org$apache$pekko$dispatch$Mailboxes$$_$$anon$superArg$1$1());
                this.becomeClosed();
            }

            public void systemEnqueue(ActorRef receiver, SystemMessage handle) {
                DeadLetter deadLetter = DeadLetter$.MODULE$.apply(handle, receiver, receiver);
                this.$outer.org$apache$pekko$dispatch$Mailboxes$$deadLetters.$bang(deadLetter, this.$outer.org$apache$pekko$dispatch$Mailboxes$$deadLetters.$bang$default$2(deadLetter));
            }

            public SystemMessage systemDrain(SystemMessage newContents) {
                return SystemMessageList$.MODULE$.ENil();
            }

            public boolean hasSystemMessages() {
                return false;
            }
        };
        this.mailboxTypeConfigurators = new ConcurrentHashMap();
        this.mailboxBindings = (scala.collection.immutable.Map)package$JavaConverters$.MODULE$.MapHasAsScala(settings.config().getConfig("pekko.actor.mailbox.requirements").root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                scala.collection.immutable.Map m = (scala.collection.immutable.Map)tuple2._1();
                if (tuple22 != null) {
                    String k = (String)tuple22._1();
                    Object v = tuple22._2();
                    return (scala.collection.immutable.Map)dynamicAccess.getClassFor(k, ClassTag$.MODULE$.Any()).map((Function1 & Serializable)x -> (scala.collection.immutable.Map)m.updated(x, (Object)v.toString())).recover((PartialFunction)new Serializable(k, v){
                        private final String k$1;
                        private final Object v$2;
                        {
                            this.k$1 = k$2;
                            this.v$2 = v$3;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable;
                            Throwable e = throwable = x;
                            return true;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable;
                            Throwable e = throwable = x;
                            throw new ConfigurationException(new StringBuilder(53).append("Type [").append(this.k$1).append("] specified as pekko.actor.mailbox.requirement ").append(new StringBuilder(38).append("[").append(this.v$2).append("] in config can't be loaded due to [").append(e.getMessage()).append("]").toString()).toString(), e);
                        }
                    }).get();
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Class<RequiresMessageQueue> rmqClass = RequiresMessageQueue.class;
        this.mailboxSizeWarningIssued = false;
        this.mailboxNonZeroPushTimeoutWarningIssued = false;
        this.defaultMailboxConfig = settings.config().getConfig("pekko.actor.default-mailbox");
        this.stashCapacityCache = new AtomicReference<scala.collection.immutable.Map>(Predef$.MODULE$.Map().empty());
        this.defaultStashCapacity = this.stashCapacityFromConfig("pekko.actor.default-dispatcher", "pekko.actor.default-mailbox");
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public EventStream eventStream() {
        return this.eventStream;
    }

    public Mailbox deadLetterMailbox() {
        return this.deadLetterMailbox;
    }

    @InternalStableApi
    public void onDeadLetterMailboxEnqueue(ActorRef receiver, Envelope envelope) {
        Object object = envelope.message();
        if (object instanceof DeadLetter) {
            return;
        }
        Object msg = object;
        this.org$apache$pekko$dispatch$Mailboxes$$deadLetters.tell(DeadLetter$.MODULE$.apply(msg, envelope.sender(), receiver), envelope.sender());
    }

    public MailboxType lookup(String id) {
        return this.lookupConfigurator(id);
    }

    public MailboxType lookupByQueueType(Class<?> queueType) {
        return this.lookup(this.lookupId(queueType));
    }

    public Class<?> getRequiredType(Class<? extends Actor> actorClass) {
        Type type = Reflect$.MODULE$.findMarker(actorClass, RequiresMessageQueue.class);
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            Object object = Predef$.MODULE$.refArrayOps((Object[])t.getActualTypeArguments());
            Type type2 = (Type)ArrayOps$.MODULE$.head$extension(object);
            if (type2 instanceof Class) {
                Class c = (Class)type2;
                return c;
            }
            Type x = type2;
            throw new IllegalArgumentException(new StringBuilder(65).append("no wildcard type allowed in RequireMessageQueue argument (was [").append(x).append("])").toString());
        }
        Type unexpected = type;
        throw new IllegalArgumentException(new StringBuilder(31).append("Unexpected actor class marker: ").append(unexpected).toString());
    }

    public Class<? extends Object> getMailboxRequirement(Config config) {
        String string = config.getString("mailbox-requirement");
        if ("".equals(string)) {
            return MessageQueue.class;
        }
        String x = string;
        return (Class)this.dynamicAccess.getClassFor(x, ClassTag$.MODULE$.apply(Object.class)).get();
    }

    public Class<?> getProducedMessageQueueType(MailboxType mailboxType) {
        Class<ProducesMessageQueue> pmqClass = ProducesMessageQueue.class;
        if (!pmqClass.isAssignableFrom(mailboxType.getClass())) {
            return MessageQueue.class;
        }
        Type type = Reflect$.MODULE$.findMarker(mailboxType.getClass(), pmqClass);
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            Object object = Predef$.MODULE$.refArrayOps((Object[])t.getActualTypeArguments());
            Type type2 = (Type)ArrayOps$.MODULE$.head$extension(object);
            if (type2 instanceof Class) {
                Class c = (Class)type2;
                return c;
            }
            Type x = type2;
            throw new IllegalArgumentException(new StringBuilder(66).append("no wildcard type allowed in ProducesMessageQueue argument (was [").append(x).append("])").toString());
        }
        Type unexpected = type;
        throw new IllegalArgumentException(new StringBuilder(38).append("Unexpected message queue type marker: ").append(unexpected).toString());
    }

    /*
     * Unable to fully structure code
     */
    public MailboxType getMailboxType(Props props, Config dispatcherConfig) {
        var3_3 = new LazyRef();
        id = dispatcherConfig.getString("id");
        deploy = props.deploy();
        actorClass = props.actorClass();
        v0 = mailboxRequirement = this.getMailboxRequirement(dispatcherConfig);
        var9_8 = MessageQueue.class;
        v1 = (v0 == null ? var9_8 != null : v0.equals(var9_8) == false) ? true : (hasMailboxRequirement = false);
        if (!dispatcherConfig.hasPath("mailbox-type")) ** GOTO lbl-1000
        v2 = dispatcherConfig.getString("mailbox-type");
        var11_10 = "";
        if (v2 == null ? var11_10 != null : v2.equals(var11_10) == false) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = hasMailboxType = false;
        }
        if (!hasMailboxType && !this.mailboxSizeWarningIssued && dispatcherConfig.hasPath("mailbox-size")) {
            this.eventStream().publish(Logging$Warning$.MODULE$.apply("mailboxes", this.getClass(), new StringBuilder(93).append("ignoring setting 'mailbox-size' for dispatcher [").append(id).append("], you need to specify 'mailbox-type=bounded'").toString()));
            this.mailboxSizeWarningIssued = true;
        }
        v4 = deploy.mailbox();
        var12_12 = "";
        if (v4 == null ? var12_12 != null : v4.equals(var12_12) == false) {
            return this.verifyRequirements$1(hasMailboxRequirement, mailboxRequirement, id, actorClass, var3_3, this.lookup(deploy.mailbox()));
        }
        v5 = deploy.dispatcher();
        var13_13 = "";
        if (v5 == null ? var13_13 != null : v5.equals(var13_13) == false) {
            v6 = deploy.dispatcher();
            var14_14 = "..";
            if ((v6 == null ? var14_14 != null : v6.equals(var14_14) == false) && hasMailboxType) {
                return this.verifyRequirements$1(hasMailboxRequirement, mailboxRequirement, id, actorClass, var3_3, this.lookup(dispatcherConfig.getString("id")));
            }
        }
        if (this.hasRequiredType(actorClass)) {
            try {
                v7 = this.verifyRequirements$1(hasMailboxRequirement, mailboxRequirement, id, actorClass, var3_3, this.lookupByQueueType(this.getRequiredType(actorClass)));
            }
            catch (Throwable var15_15) {
                var16_16 = var15_15;
                if (var16_16 != null && !(var17_17 = NonFatal$.MODULE$.unapply(var16_16)).isEmpty()) {
                    var18_18 = (Throwable)var17_17.get();
                    if (hasMailboxRequirement) {
                        v7 = this.verifyRequirements$1(hasMailboxRequirement, mailboxRequirement, id, actorClass, var3_3, this.lookupByQueueType(mailboxRequirement));
                    }
                }
                throw var15_15;
            }
            return v7;
        }
        if (hasMailboxRequirement) {
            return this.verifyRequirements$1(hasMailboxRequirement, mailboxRequirement, id, actorClass, var3_3, this.lookupByQueueType(mailboxRequirement));
        }
        return this.verifyRequirements$1(hasMailboxRequirement, mailboxRequirement, id, actorClass, var3_3, this.lookup("pekko.actor.default-mailbox"));
    }

    public boolean hasRequiredType(Class<? extends Actor> actorClass) {
        return RequiresMessageQueue.class.isAssignableFrom(actorClass);
    }

    private String lookupId(Class<?> queueType) {
        Option option = this.mailboxBindings.get(queueType);
        if (None$.MODULE$.equals(option)) {
            throw new ConfigurationException(new StringBuilder(37).append("Mailbox Mapping for [").append(queueType).append("] not configured").toString());
        }
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            return s;
        }
        throw new MatchError((Object)option);
    }

    private MailboxType lookupConfigurator(String id) {
        MailboxType mailboxType = this.mailboxTypeConfigurators.get(id);
        if (mailboxType == null) {
            MailboxType mailboxType2;
            String string = id;
            if ("unbounded".equals(string)) {
                mailboxType2 = UnboundedMailbox$.MODULE$.apply();
            } else if ("bounded".equals(string)) {
                mailboxType2 = new BoundedMailbox(this.settings(), this.config(id));
            } else if (id.startsWith("bounded-capacity:")) {
                int capacity = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(id), ':')[1]));
                mailboxType2 = new BoundedMailbox(capacity, Duration$.MODULE$.Zero());
            } else {
                MailboxType m;
                MailboxType mailboxType3;
                if (!this.settings().config().hasPath(id)) {
                    throw new ConfigurationException(new StringBuilder(30).append("Mailbox Type [").append(id).append("] not configured").toString());
                }
                Config conf = this.config(id);
                String string2 = conf.getString("mailbox-type");
                if ("".equals(string2)) {
                    throw new ConfigurationException(new StringBuilder(48).append("The setting mailbox-type, defined in [").append(id).append("] is empty").toString());
                }
                String fqcn = string2;
                Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(ActorSystem.Settings.class);
                Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(Config.class);
                List args = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.settings()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)conf), (List)Nil$.MODULE$));
                MailboxType mailboxType4 = (MailboxType)this.dynamicAccess.createInstanceFor(fqcn, (Seq<Tuple2<Class<?>, Object>>)args, ClassTag$.MODULE$.apply(MailboxType.class)).recover((PartialFunction)new Serializable(fqcn, id){
                    private final String fqcn$1;
                    private final String id$2;
                    {
                        this.fqcn$1 = fqcn$2;
                        this.id$2 = id$3;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable;
                        Throwable exception = throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable;
                        Throwable exception = throwable = x;
                        throw new IllegalArgumentException(new StringBuilder(177).append("Cannot instantiate MailboxType [").append(this.fqcn$1).append("], defined in [").append(this.id$2).append("], make sure it has a public").append(" constructor with [org.apache.pekko.actor.ActorSystem.Settings, com.typesafe.config.Config] parameters").toString(), exception);
                    }
                }).get();
                if (!this.mailboxNonZeroPushTimeoutWarningIssued && (mailboxType3 = mailboxType4) instanceof ProducesPushTimeoutSemanticsMailbox && ((ProducesPushTimeoutSemanticsMailbox)((Object)(m = (MailboxType)((Object)((ProducesPushTimeoutSemanticsMailbox)((Object)mailboxType3)))))).pushTimeOut().toNanos() > 0L) {
                    this.warn(new StringBuilder(159).append("Configured potentially-blocking mailbox [").append(id).append("] configured with non-zero pushTimeOut (").append(((ProducesPushTimeoutSemanticsMailbox)((Object)m)).pushTimeOut()).append("), ").append("which can lead to blocking behavior when sending messages to this mailbox. ").append(new StringBuilder(58).append("Avoid this by setting `").append(id).append(".mailbox-push-timeout-time` to `0`.").toString()).toString());
                    this.mailboxNonZeroPushTimeoutWarningIssued = true;
                }
                mailboxType2 = mailboxType4;
            }
            UnboundedMailbox newConfigurator = mailboxType2;
            MailboxType mailboxType5 = this.mailboxTypeConfigurators.putIfAbsent(id, newConfigurator);
            if (mailboxType5 == null) {
                return newConfigurator;
            }
            MailboxType existing = mailboxType5;
            return existing;
        }
        MailboxType existing = mailboxType;
        return existing;
    }

    private final void warn(String msg) {
        this.eventStream().publish(Logging$Warning$.MODULE$.apply("mailboxes", this.getClass(), msg));
    }

    private Config config(String id) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id);
        return ConfigFactory.parseMap((java.util.Map)package$JavaConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava()).withFallback((ConfigMergeable)this.settings().config().getConfig(id)).withFallback((ConfigMergeable)this.defaultMailboxConfig);
    }

    public final int stashCapacity(String dispatcher, String mailbox) {
        String key;
        scala.collection.immutable.Map<String, Object> cache;
        Option option;
        String string = dispatcher;
        String string2 = "pekko.actor.default-dispatcher";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = mailbox;
            String string4 = "pekko.actor.default-mailbox";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                return this.defaultStashCapacity;
            }
        }
        if ((option = (cache = this.stashCapacityCache.get()).get((Object)(key = new StringBuilder(1).append(dispatcher).append("-").append(mailbox).toString()))) instanceof Some) {
            int value = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return value;
        }
        if (None$.MODULE$.equals(option)) {
            int value = this.stashCapacityFromConfig(dispatcher, mailbox);
            this.updateCache$1(cache, key, value);
            return value;
        }
        throw new MatchError((Object)option);
    }

    private int stashCapacityFromConfig(String dispatcher, String mailbox) {
        Config disp = Dispatchers$.MODULE$.getConfig(this.settings().config(), dispatcher, Dispatchers$.MODULE$.getConfig$default$3());
        Config fallback = disp.withFallback((ConfigMergeable)this.settings().config().getConfig("pekko.actor.default-mailbox"));
        String string = mailbox;
        String string2 = "pekko.actor.default-mailbox";
        Config config = !(string != null ? !string.equals(string2) : string2 != null) ? fallback : this.settings().config().getConfig(mailbox).withFallback((ConfigMergeable)fallback);
        return config.getInt("stash-capacity");
    }

    public final MessageQueue org$apache$pekko$dispatch$Mailboxes$$_$$anon$superArg$1$1() {
        return new MessageQueue(this){
            private final /* synthetic */ Mailboxes $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void enqueue(ActorRef receiver, Envelope envelope) {
                this.$outer.onDeadLetterMailboxEnqueue(receiver, envelope);
            }

            public Envelope dequeue() {
                return null;
            }

            public boolean hasMessages() {
                return false;
            }

            public int numberOfMessages() {
                return 0;
            }

            public void cleanUp(ActorRef owner, MessageQueue deadLetters) {
            }
        };
    }

    private final Class actorRequirement$lzyINIT1$1(LazyRef actorRequirement$lzy1$1, Class actorClass$1) {
        Class clazz;
        LazyRef lazyRef = actorRequirement$lzy1$1;
        synchronized (lazyRef) {
            clazz = (Class)(actorRequirement$lzy1$1.initialized() ? actorRequirement$lzy1$1.value() : actorRequirement$lzy1$1.initialize(this.getRequiredType(actorClass$1)));
        }
        return clazz;
    }

    private final Class actorRequirement$1(LazyRef actorRequirement$lzy1$2, Class actorClass$2) {
        return (Class)(actorRequirement$lzy1$2.initialized() ? actorRequirement$lzy1$2.value() : this.actorRequirement$lzyINIT1$1(actorRequirement$lzy1$2, actorClass$2));
    }

    private final Class mqType$lzyINIT1$1(LazyRef mqType$lzy1$1, MailboxType mailboxType$1) {
        Class clazz;
        LazyRef lazyRef = mqType$lzy1$1;
        synchronized (lazyRef) {
            clazz = (Class)(mqType$lzy1$1.initialized() ? mqType$lzy1$1.value() : mqType$lzy1$1.initialize(this.getProducedMessageQueueType(mailboxType$1)));
        }
        return clazz;
    }

    private final Class mqType$1(LazyRef mqType$lzy1$2, MailboxType mailboxType$2) {
        return (Class)(mqType$lzy1$2.initialized() ? mqType$lzy1$2.value() : this.mqType$lzyINIT1$1(mqType$lzy1$2, mailboxType$2));
    }

    private final MailboxType verifyRequirements$1(boolean hasMailboxRequirement$1, Class mailboxRequirement$1, String id$1, Class actorClass$3, LazyRef actorRequirement$lzy1$3, MailboxType mailboxType) {
        LazyRef lazyRef = new LazyRef();
        if (hasMailboxRequirement$1 && !mailboxRequirement$1.isAssignableFrom(this.mqType$1(lazyRef, mailboxType))) {
            throw new IllegalArgumentException(new StringBuilder(79).append("produced message queue type [").append(this.mqType$1(lazyRef, mailboxType)).append("] does not fulfill requirement for dispatcher [").append(id$1).append("]. ").append(new StringBuilder(25).append("Must be a subclass of [").append(mailboxRequirement$1).append("].").toString()).toString());
        }
        if (this.hasRequiredType(actorClass$3) && !this.actorRequirement$1(actorRequirement$lzy1$3, actorClass$3).isAssignableFrom(this.mqType$1(lazyRef, mailboxType))) {
            throw new IllegalArgumentException(new StringBuilder(80).append("produced message queue type [").append(this.mqType$1(lazyRef, mailboxType)).append("] does not fulfill requirement for actor class [").append(actorClass$3).append("]. ").append(new StringBuilder(25).append("Must be a subclass of [").append(this.actorRequirement$1(actorRequirement$lzy1$3, actorClass$3)).append("].").toString()).toString());
        }
        return mailboxType;
    }

    private final boolean updateCache$1(scala.collection.immutable.Map cache, String key, int value) {
        while (!this.stashCapacityCache.compareAndSet(cache, (scala.collection.immutable.Map<String, Object>)cache.updated((Object)key, (Object)BoxesRunTime.boxToInteger((int)value)))) {
            cache = this.stashCapacityCache.get();
        }
        return true;
    }
}

