/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import java.io.Serializable;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Cell;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.dispatch.AbstractMessageDispatcher;
import org.apache.pekko.dispatch.BatchingExecutor;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.Mailbox;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.Mailboxes;
import org.apache.pekko.dispatch.MessageDispatcher$;
import org.apache.pekko.dispatch.MessageDispatcherConfigurator;
import org.apache.pekko.dispatch.TaskInvocation;
import org.apache.pekko.dispatch.TaskInvocation$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$Error$;
import org.apache.pekko.util.Index;
import org.apache.pekko.util.Unsafe;
import scala.Function0;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

public abstract class MessageDispatcher
extends AbstractMessageDispatcher
implements BatchingExecutor,
ExecutionContext,
ExecutionContextExecutor {
    private ThreadLocal org$apache$pekko$dispatch$BatchingExecutor$$_tasksLocal;
    private ThreadLocal org$apache$pekko$dispatch$BatchingExecutor$$_blockContext;
    private final MessageDispatcherConfigurator configurator;
    private final Mailboxes mailboxes;
    private final EventStream eventStream;
    private volatile long _inhabitantsDoNotCallMeDirectly;
    private volatile int _shutdownScheduleDoNotCallMeDirectly;
    private final Function0<BoxedUnit> taskCleanup;
    private final Scheduler.TaskRunOnClose shutdownAction;
    private final boolean isThroughputDeadlineTimeDefined;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(MessageDispatcher$.class.getDeclaredField("actors$lzy1"));

    public static int RESCHEDULED() {
        return MessageDispatcher$.MODULE$.RESCHEDULED();
    }

    public static int SCHEDULED() {
        return MessageDispatcher$.MODULE$.SCHEDULED();
    }

    public static int UNSCHEDULED() {
        return MessageDispatcher$.MODULE$.UNSCHEDULED();
    }

    public static Index<MessageDispatcher, ActorRef> actors() {
        return MessageDispatcher$.MODULE$.actors();
    }

    public static boolean debug() {
        return MessageDispatcher$.MODULE$.debug();
    }

    public static void printActors() {
        MessageDispatcher$.MODULE$.printActors();
    }

    public MessageDispatcher(MessageDispatcherConfigurator configurator) {
        this.configurator = configurator;
        BatchingExecutor.$init$(this);
        ExecutionContext.$init$((ExecutionContext)this);
        this.mailboxes = configurator.prerequisites().mailboxes();
        this.eventStream = configurator.prerequisites().eventStream();
        this.taskCleanup = (JFunction0.mcV.sp & Serializable)() -> {
            if (this.addInhabitants(-1L) == 0L) {
                this.ifSensibleToDoSoThenScheduleShutdown();
                return;
            }
        };
        this.shutdownAction = new Scheduler.TaskRunOnClose(this){
            private final /* synthetic */ MessageDispatcher $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final void run() {
                int n;
                block9: {
                    do {
                        n = this.$outer.org$apache$pekko$dispatch$MessageDispatcher$$shutdownSchedule();
                        if (MessageDispatcher$.MODULE$.SCHEDULED() == n) {
                            try {
                                if (this.$outer.inhabitants() == 0L) {
                                    this.$outer.shutdown();
                                }
                            }
                            finally {
                                while (!this.$outer.org$apache$pekko$dispatch$MessageDispatcher$$updateShutdownSchedule(this.$outer.org$apache$pekko$dispatch$MessageDispatcher$$shutdownSchedule(), MessageDispatcher$.MODULE$.UNSCHEDULED())) {
                                }
                            }
                            return;
                        }
                        if (MessageDispatcher$.MODULE$.RESCHEDULED() != n) break block9;
                    } while (!this.$outer.org$apache$pekko$dispatch$MessageDispatcher$$updateShutdownSchedule(MessageDispatcher$.MODULE$.RESCHEDULED(), MessageDispatcher$.MODULE$.SCHEDULED()));
                    this.$outer.org$apache$pekko$dispatch$MessageDispatcher$$scheduleShutdownAction();
                    return;
                }
                if (MessageDispatcher$.MODULE$.UNSCHEDULED() == n) {
                    return;
                }
                int unexpected = n;
                throw new IllegalArgumentException(new StringBuilder(31).append("Unexpected actor class marker: ").append(unexpected).toString());
            }
        };
        this.isThroughputDeadlineTimeDefined = this.throughputDeadlineTime().toMillis() > 0L;
        Statics.releaseFence();
    }

    public ThreadLocal org$apache$pekko$dispatch$BatchingExecutor$$_tasksLocal() {
        return this.org$apache$pekko$dispatch$BatchingExecutor$$_tasksLocal;
    }

    public ThreadLocal org$apache$pekko$dispatch$BatchingExecutor$$_blockContext() {
        return this.org$apache$pekko$dispatch$BatchingExecutor$$_blockContext;
    }

    @Override
    public void org$apache$pekko$dispatch$BatchingExecutor$_setter_$org$apache$pekko$dispatch$BatchingExecutor$$_tasksLocal_$eq(ThreadLocal x$0) {
        this.org$apache$pekko$dispatch$BatchingExecutor$$_tasksLocal = x$0;
    }

    @Override
    public void org$apache$pekko$dispatch$BatchingExecutor$_setter_$org$apache$pekko$dispatch$BatchingExecutor$$_blockContext_$eq(ThreadLocal x$0) {
        this.org$apache$pekko$dispatch$BatchingExecutor$$_blockContext = x$0;
    }

    public MessageDispatcherConfigurator configurator() {
        return this.configurator;
    }

    public Mailboxes mailboxes() {
        return this.mailboxes;
    }

    public EventStream eventStream() {
        return this.eventStream;
    }

    private int _preventPrivateUnusedErasure() {
        return this._shutdownScheduleDoNotCallMeDirectly;
    }

    private final long addInhabitants(long add) {
        long old = Unsafe.instance.getAndAddLong(this, AbstractMessageDispatcher.inhabitantsOffset, add);
        long ret = old + add;
        if (ret < 0L) {
            IllegalStateException e = new IllegalStateException("ACTOR SYSTEM CORRUPTED!!! A dispatcher can't have less than 0 inhabitants!");
            this.reportFailure(e);
            throw e;
        }
        return ret;
    }

    public final long inhabitants() {
        return Unsafe.instance.getLongVolatile(this, AbstractMessageDispatcher.inhabitantsOffset);
    }

    public final int org$apache$pekko$dispatch$MessageDispatcher$$shutdownSchedule() {
        return Unsafe.instance.getIntVolatile(this, AbstractMessageDispatcher.shutdownScheduleOffset);
    }

    public final boolean org$apache$pekko$dispatch$MessageDispatcher$$updateShutdownSchedule(int expect, int update) {
        return Unsafe.instance.compareAndSwapInt(this, AbstractMessageDispatcher.shutdownScheduleOffset, expect, update);
    }

    public abstract Mailbox createMailbox(Cell var1, MailboxType var2);

    public abstract String id();

    public final void attach(ActorCell actor) {
        this.register(actor);
        this.registerForExecution(actor.mailbox(), false, true);
    }

    public final void detach(ActorCell actor) {
        try {
            this.unregister(actor);
        }
        finally {
            this.ifSensibleToDoSoThenScheduleShutdown();
        }
    }

    @Override
    public final boolean resubmitOnBlock() {
        return true;
    }

    @Override
    public final void unbatchedExecute(Runnable r) {
        TaskInvocation invocation = TaskInvocation$.MODULE$.apply(this.eventStream(), r, this.taskCleanup);
        this.addInhabitants(1L);
        try {
            this.executeTask(invocation);
        }
        catch (Throwable t) {
            this.addInhabitants(-1L);
            throw t;
        }
    }

    public void reportFailure(Throwable t) {
        Throwable throwable = t;
        if (throwable instanceof Logging.LogEventException) {
            Logging.LogEventException e = (Logging.LogEventException)throwable;
            this.eventStream().publish(e.event());
            return;
        }
        this.eventStream().publish(Logging$Error$.MODULE$.apply(t, this.getClass().getName(), this.getClass(), t.getMessage()));
    }

    private final void ifSensibleToDoSoThenScheduleShutdown() {
        while (this.inhabitants() <= 0L) {
            int n = this.org$apache$pekko$dispatch$MessageDispatcher$$shutdownSchedule();
            if (MessageDispatcher$.MODULE$.UNSCHEDULED() == n) {
                if (!this.org$apache$pekko$dispatch$MessageDispatcher$$updateShutdownSchedule(MessageDispatcher$.MODULE$.UNSCHEDULED(), MessageDispatcher$.MODULE$.SCHEDULED())) continue;
                this.org$apache$pekko$dispatch$MessageDispatcher$$scheduleShutdownAction();
                return;
            }
            if (MessageDispatcher$.MODULE$.SCHEDULED() == n) {
                if (!this.org$apache$pekko$dispatch$MessageDispatcher$$updateShutdownSchedule(MessageDispatcher$.MODULE$.SCHEDULED(), MessageDispatcher$.MODULE$.RESCHEDULED())) continue;
                return;
            }
            if (MessageDispatcher$.MODULE$.RESCHEDULED() == n) {
                return;
            }
            int unexpected = n;
            throw new IllegalArgumentException(new StringBuilder(31).append("Unexpected actor class marker: ").append(unexpected).toString());
        }
    }

    public void org$apache$pekko$dispatch$MessageDispatcher$$scheduleShutdownAction() {
        try {
            this.configurator().prerequisites().scheduler().scheduleOnce(this.shutdownTimeout(), (Runnable)this.shutdownAction, new ExecutionContext(this){
                private final /* synthetic */ MessageDispatcher $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    ExecutionContext.$init$((ExecutionContext)this);
                }

                public void execute(Runnable runnable) {
                    runnable.run();
                }

                public void reportFailure(Throwable t) {
                    this.$outer.reportFailure(t);
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            this.shutdown();
            this.org$apache$pekko$dispatch$MessageDispatcher$$updateShutdownSchedule(MessageDispatcher$.MODULE$.SCHEDULED(), MessageDispatcher$.MODULE$.UNSCHEDULED());
        }
    }

    public void register(ActorCell actor) {
        this.addInhabitants(1L);
    }

    public void unregister(ActorCell actor) {
        this.addInhabitants(-1L);
        Mailbox mailBox = actor.swapMailbox(this.mailboxes().deadLetterMailbox());
        mailBox.becomeClosed();
        mailBox.cleanUp();
    }

    public abstract FiniteDuration shutdownTimeout();

    public void suspend(ActorCell actor) {
        Mailbox mbox = actor.mailbox();
        if (mbox.actor() == actor && mbox.dispatcher() == this) {
            mbox.suspend();
            return;
        }
    }

    public void resume(ActorCell actor) {
        Mailbox mbox = actor.mailbox();
        if (mbox.actor() == actor && mbox.dispatcher() == this && mbox.resume()) {
            this.registerForExecution(mbox, false, false);
            return;
        }
    }

    public abstract void systemDispatch(ActorCell var1, SystemMessage var2);

    public abstract void dispatch(ActorCell var1, Envelope var2);

    public abstract boolean registerForExecution(Mailbox var1, boolean var2, boolean var3);

    public abstract int throughput();

    public abstract Duration throughputDeadlineTime();

    public final boolean isThroughputDeadlineTimeDefined() {
        return this.isThroughputDeadlineTimeDefined;
    }

    public abstract void executeTask(TaskInvocation var1);

    @InternalStableApi
    public abstract void shutdown();
}

