/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.dispatch.CachingConfig;
import org.apache.pekko.dispatch.DefaultExecutorServiceConfigurator;
import org.apache.pekko.dispatch.DispatcherPrerequisites;
import org.apache.pekko.dispatch.ExecutorServiceConfigurator;
import org.apache.pekko.dispatch.ForkJoinExecutorConfigurator;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.dispatch.ThreadPoolExecutorConfigurator;
import org.apache.pekko.dispatch.VirtualThreadExecutorConfigurator;
import org.apache.pekko.dispatch.VirtualThreadSupport$;
import org.apache.pekko.dispatch.affinity.AffinityPoolConfigurator;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public abstract class MessageDispatcherConfigurator {
    private final DispatcherPrerequisites prerequisites;
    private final Config config;

    public MessageDispatcherConfigurator(Config _config, DispatcherPrerequisites prerequisites) {
        this.prerequisites = prerequisites;
        this.config = new CachingConfig(_config);
    }

    public DispatcherPrerequisites prerequisites() {
        return this.prerequisites;
    }

    public Config config() {
        return this.config;
    }

    public abstract MessageDispatcher dispatcher();

    public ExecutorServiceConfigurator configureExecutor() {
        String string = this.config().getString("executor");
        if ("default-executor".equals(string)) {
            return new DefaultExecutorServiceConfigurator(this.config().getConfig("default-executor"), this.prerequisites(), this.configurator$1(this.config().getString("default-executor.fallback")));
        }
        String other = string;
        return this.configurator$1(other);
    }

    private final ExecutorServiceConfigurator configurator$1(String executor) {
        String string;
        block5: while (true) {
            if ((string = executor) == null || "".equals(string) || "fork-join-executor".equals(string)) {
                return new ForkJoinExecutorConfigurator(this.config().getConfig("fork-join-executor"), this.prerequisites());
            }
            switch (string == null ? 0 : string.hashCode()) {
                case -70555423: {
                    if (!"thread-pool-executor".equals(string)) break block5;
                    return new ThreadPoolExecutorConfigurator(this.config().getConfig("thread-pool-executor"), this.prerequisites());
                }
                case 867582580: {
                    if (!"virtual-thread-executor".equals(string)) break block5;
                    if (VirtualThreadSupport$.MODULE$.isSupported()) {
                        return new VirtualThreadExecutorConfigurator(this.config().getConfig("virtual-thread-executor"), this.prerequisites());
                    }
                    executor = this.config().getString("virtual-thread-executor.fallback");
                    continue block5;
                }
                case 1768732543: {
                    if (!"affinity-pool-executor".equals(string)) break block5;
                    return new AffinityPoolConfigurator(this.config().getConfig("affinity-pool-executor"), this.prerequisites());
                }
            }
            break;
        }
        String fqcn = string;
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(Config.class);
        Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(DispatcherPrerequisites.class);
        List args = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.config()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)this.prerequisites()), (List)Nil$.MODULE$));
        return (ExecutorServiceConfigurator)this.prerequisites().dynamicAccess().createInstanceFor(fqcn, (Seq<Tuple2<Class<?>, Object>>)args, ClassTag$.MODULE$.apply(ExecutorServiceConfigurator.class)).recover((PartialFunction)new Serializable(fqcn, this){
            private final String fqcn$1;
            private final /* synthetic */ MessageDispatcherConfigurator $outer;
            {
                this.fqcn$1 = fqcn$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable exception = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable exception = throwable = x;
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cannot instantiate ExecutorServiceConfigurator (\"executor = [%s]\"), defined in [%s],\n                make sure it has an accessible constructor with a [%s,%s] signature"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.fqcn$1, this.$outer.config().getString("id"), Config.class, DispatcherPrerequisites.class})), exception);
            }
        }).get();
    }
}

