/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.JavaVersion$;
import scala.Option;
import scala.Predef$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

@InternalApi
public final class VirtualThreadSupport$
implements Serializable {
    private static final MethodHandles.Lookup lookup;
    private static final boolean isSupported;
    public static final VirtualThreadSupport$ MODULE$;

    private VirtualThreadSupport$() {
    }

    static {
        MODULE$ = new VirtualThreadSupport$();
        lookup = MethodHandles.publicLookup();
        isSupported = JavaVersion$.MODULE$.majorVersion() >= 21;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(VirtualThreadSupport$.class);
    }

    public boolean isSupported() {
        return isSupported;
    }

    public ThreadFactory newVirtualThreadFactory(String prefix) {
        ThreadFactory threadFactory;
        Predef$.MODULE$.require(this.isSupported(), VirtualThreadSupport$::newVirtualThreadFactory$$anonfun$1);
        try {
            Class<?> builderClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.Thread$Builder");
            Class<?> ofVirtualClass = ClassLoader.getSystemClassLoader().loadClass("java.lang.Thread$Builder$OfVirtual");
            MethodHandle ofVirtualMethod = lookup.findStatic(Thread.class, "ofVirtual", MethodType.methodType(ofVirtualClass));
            Object builder = ofVirtualMethod.invoke();
            MethodHandle nameMethod = lookup.findVirtual(ofVirtualClass, "name", MethodType.methodType(ofVirtualClass, String.class, Long.TYPE));
            MethodHandle factoryMethod = lookup.findVirtual(builderClass, "factory", MethodType.methodType(ThreadFactory.class));
            builder = nameMethod.invoke(builder, new StringBuilder(16).append(prefix).append("-virtual-thread-").toString(), 0L);
            threadFactory = factoryMethod.invoke(builder);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw new UnsupportedOperationException("Failed to create virtual thread factory", e);
            }
            throw throwable;
        }
        return threadFactory;
    }

    public ExecutorService newThreadPerTaskExecutor(ThreadFactory threadFactory) {
        ExecutorService executorService;
        Predef$.MODULE$.require(threadFactory != null, VirtualThreadSupport$::newThreadPerTaskExecutor$$anonfun$1);
        try {
            Class<?> executorsClazz = ClassLoader.getSystemClassLoader().loadClass("java.util.concurrent.Executors");
            MethodHandle newThreadPerTaskExecutorMethod = lookup.findStatic(executorsClazz, "newThreadPerTaskExecutor", MethodType.methodType(ExecutorService.class, ThreadFactory.class));
            executorService = newThreadPerTaskExecutorMethod.invoke(threadFactory);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                throw new UnsupportedOperationException("Failed to create newThreadPerTaskExecutor.", e);
            }
            throw throwable;
        }
        return executorService;
    }

    private static final Object newVirtualThreadFactory$$anonfun$1() {
        return "Virtual thread is not supported.";
    }

    private static final Object newThreadPerTaskExecutor$$anonfun$1() {
        return "threadFactory should not be null.";
    }
}

