/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch.affinity;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.AbstractBoundedNodeQueue;
import org.apache.pekko.dispatch.affinity.AffinityPool$;
import org.apache.pekko.dispatch.affinity.OnSpinWait;
import org.apache.pekko.dispatch.affinity.QueueSelector;
import org.apache.pekko.dispatch.affinity.RejectionHandler;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.util.ReentrantGuard;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

@ApiMayChange
@InternalApi
public class AffinityPool
extends AbstractExecutorService {
    private final String id;
    private final int parallelism;
    private final int affinityGroupSize;
    public final ThreadFactory org$apache$pekko$dispatch$affinity$AffinityPool$$threadFactory;
    private final int idleCpuLevel;
    private final QueueSelector queueSelector;
    private final RejectionHandler rejectionHandler;
    private final ReentrantGuard bookKeepingLock;
    private final Condition terminationCondition;
    public volatile int org$apache$pekko$dispatch$affinity$AffinityPool$$poolState;
    private final BoundedAffinityTaskQueue[] workQueues;
    private final Set<AffinityPoolWorker> workers;

    public static int Initial() {
        return AffinityPool$.MODULE$.Initial();
    }

    public static int Initializing() {
        return AffinityPool$.MODULE$.Initializing();
    }

    public static int Parking() {
        return AffinityPool$.MODULE$.Parking();
    }

    public static int Running() {
        return AffinityPool$.MODULE$.Running();
    }

    public static int ShutDown() {
        return AffinityPool$.MODULE$.ShutDown();
    }

    public static int ShuttingDown() {
        return AffinityPool$.MODULE$.ShuttingDown();
    }

    public static int Spinning() {
        return AffinityPool$.MODULE$.Spinning();
    }

    public static int Terminated() {
        return AffinityPool$.MODULE$.Terminated();
    }

    public static int Uninitialized() {
        return AffinityPool$.MODULE$.Uninitialized();
    }

    public static int Yielding() {
        return AffinityPool$.MODULE$.Yielding();
    }

    public AffinityPool(String id, int parallelism, int affinityGroupSize, ThreadFactory threadFactory, int idleCpuLevel, QueueSelector queueSelector, RejectionHandler rejectionHandler) {
        this.id = id;
        this.parallelism = parallelism;
        this.affinityGroupSize = affinityGroupSize;
        this.org$apache$pekko$dispatch$affinity$AffinityPool$$threadFactory = threadFactory;
        this.idleCpuLevel = idleCpuLevel;
        this.queueSelector = queueSelector;
        this.rejectionHandler = rejectionHandler;
        if (parallelism <= 0) {
            throw new IllegalArgumentException("Size of pool cannot be less or equal to 0");
        }
        this.bookKeepingLock = new ReentrantGuard();
        this.terminationCondition = this.bookKeepingLock.newCondition();
        this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState = 0;
        this.workQueues = (BoundedAffinityTaskQueue[])Array$.MODULE$.fill(parallelism, () -> AffinityPool.$init$$$anonfun$1(affinityGroupSize), ClassTag$.MODULE$.apply(BoundedAffinityTaskQueue.class));
        this.workers = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AffinityPoolWorker[0]));
    }

    public final QueueSelector queueSelector() {
        return this.queueSelector;
    }

    public AffinityPool start() {
        return (AffinityPool)this.bookKeepingLock.withGuard(this::start$$anonfun$1);
    }

    private void addWorker(Set<AffinityPoolWorker> workers, BoundedAffinityTaskQueue q) {
        AffinityPoolWorker worker = new AffinityPoolWorker(this, q, new IdleStrategy(this.idleCpuLevel));
        workers.add((Object)worker);
        worker.start();
    }

    public void org$apache$pekko$dispatch$affinity$AffinityPool$$onWorkerExit(AffinityPoolWorker w, boolean abruptTermination) {
        this.bookKeepingLock.withGuard((Function0 & Serializable)() -> {
            this.onWorkerExit$$anonfun$1(w, abruptTermination);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void execute(Runnable command) {
        BoundedAffinityTaskQueue queue = this.workQueues[this.queueSelector().getQueue(command, this.parallelism)];
        if (this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState >= 3 || !queue.add(command)) {
            this.rejectionHandler.reject(command, this);
            return;
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return BoxesRunTime.unboxToBoolean(this.bookKeepingLock.withGuard(() -> this.awaitTermination$$anonfun$1(unit, timeout)));
    }

    private void attemptPoolTermination() {
        if (this.workers.isEmpty() && this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState == 4) {
            this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState = 5;
            this.terminationCondition.signalAll();
            return;
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        return (List)this.bookKeepingLock.withGuard(this::shutdownNow$$anonfun$1);
    }

    @Override
    public void shutdown() {
        this.bookKeepingLock.withGuard((Function0 & Serializable)() -> {
            this.shutdown$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isShutdown() {
        return this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState >= 4;
    }

    @Override
    public boolean isTerminated() {
        return this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState == 5;
    }

    public String toString() {
        return new StringBuilder(119).append(Logging$.MODULE$.simpleName(this)).append("(id = ").append(this.id).append(", parallelism = ").append(this.parallelism).append(", affinityGroupSize = ").append(this.affinityGroupSize).append(", threadFactory = ").append(this.org$apache$pekko$dispatch$affinity$AffinityPool$$threadFactory).append(", idleCpuLevel = ").append(this.idleCpuLevel).append(", queueSelector = ").append(this.queueSelector()).append(", rejectionHandler = ").append(this.rejectionHandler).append(")").toString();
    }

    private static final BoundedAffinityTaskQueue $init$$$anonfun$1(int affinityGroupSize$1) {
        return new BoundedAffinityTaskQueue(affinityGroupSize$1);
    }

    private final AffinityPool start$$anonfun$1() {
        if (this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState == 0) {
            this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState = 1;
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.workQueues);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)q -> this.addWorker(this.workers, (BoundedAffinityTaskQueue)q));
            this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState = 2;
        }
        return this;
    }

    private final void onWorkerExit$$anonfun$1(AffinityPoolWorker w$1, boolean abruptTermination$1) {
        this.workers.remove((Object)w$1);
        if (abruptTermination$1 && this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState == 2) {
            this.addWorker(this.workers, w$1.q());
            return;
        }
        if (this.workers.isEmpty() && !abruptTermination$1 && this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState >= 3) {
            this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState = 4;
            this.attemptPoolTermination();
            return;
        }
    }

    private final boolean awaitTermination$1(long nanos) {
        while (this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState != 5) {
            if (nanos <= 0L) {
                return false;
            }
            nanos = this.terminationCondition.awaitNanos(nanos);
        }
        return true;
    }

    private final boolean awaitTermination$$anonfun$1(TimeUnit unit$1, long timeout$1) {
        return this.awaitTermination$1(unit$1.toNanos(timeout$1));
    }

    private final List shutdownNow$$anonfun$1() {
        this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState = 4;
        this.workers.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.stop());
        this.attemptPoolTermination();
        return Collections.emptyList();
    }

    private final void shutdown$$anonfun$1() {
        this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState = 3;
        this.workers.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.stopIfIdle());
        this.attemptPoolTermination();
    }

    public final class AffinityPoolWorker
    implements Runnable {
        private final BoundedAffinityTaskQueue q;
        private final IdleStrategy idleStrategy;
        private final Thread thread;
        private final /* synthetic */ AffinityPool $outer;

        public AffinityPoolWorker(AffinityPool $outer, BoundedAffinityTaskQueue q, IdleStrategy idleStrategy) {
            this.q = q;
            this.idleStrategy = idleStrategy;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.thread = $outer.org$apache$pekko$dispatch$affinity$AffinityPool$$threadFactory.newThread(this);
        }

        public BoundedAffinityTaskQueue q() {
            return this.q;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Thread thread() {
            return this.thread;
        }

        public void start() {
            if (this.thread() == null) {
                throw new IllegalStateException(new StringBuilder(43).append("Was not able to allocate worker thread for ").append(this.$outer).toString());
            }
            this.thread().start();
        }

        @Override
        public void run() {
            boolean abruptTermination = true;
            try {
                this.runLoop$1();
                abruptTermination = false;
            }
            finally {
                this.$outer.org$apache$pekko$dispatch$affinity$AffinityPool$$onWorkerExit(this, abruptTermination);
            }
        }

        public void stop() {
            if (!this.thread().isInterrupted()) {
                this.thread().interrupt();
                return;
            }
        }

        public void stopIfIdle() {
            if (this.idleStrategy().isIdling()) {
                this.stop();
                return;
            }
        }

        public final /* synthetic */ AffinityPool org$apache$pekko$dispatch$affinity$AffinityPool$AffinityPoolWorker$$$outer() {
            return this.$outer;
        }

        private final boolean executeNext$1() {
            boolean next;
            Runnable c = (Runnable)this.q().poll();
            boolean bl = next = c != null;
            if (next) {
                c.run();
                this.idleStrategy().reset();
            } else {
                this.idleStrategy().idle();
            }
            return next;
        }

        private final void runLoop$1() {
            block6: while (!Thread.interrupted()) {
                int n = this.$outer.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState;
                switch (n) {
                    case 0: {
                        return;
                    }
                    case 1: 
                    case 2: {
                        this.executeNext$1();
                        continue block6;
                    }
                    case 3: {
                        if (this.executeNext$1()) continue block6;
                        return;
                    }
                    case 4: 
                    case 5: {
                        return;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
    }

    public static final class BoundedAffinityTaskQueue
    extends AbstractBoundedNodeQueue<Runnable> {
        public BoundedAffinityTaskQueue(int capacity) {
            super(capacity);
        }
    }

    public static final class IdleStrategy {
        private final int maxSpins;
        private final int maxYields;
        private final int minParkPeriodNs;
        private final long maxParkPeriodNs;
        private int state;
        private long turns;
        private long parkPeriodNs;
        private volatile boolean idling;

        public IdleStrategy(int idleCpuLevel) {
            this.maxSpins = 1100 * idleCpuLevel - 1000;
            this.maxYields = 5 * idleCpuLevel;
            this.minParkPeriodNs = 1;
            this.maxParkPeriodNs = TimeUnit.MICROSECONDS.toNanos(Int$.MODULE$.int2long(250 - 80 * (idleCpuLevel - 1) / 3));
            this.state = 0;
            this.turns = 0L;
            this.parkPeriodNs = 0L;
            this.idling = false;
        }

        private void transitionTo(int newState) {
            this.state = newState;
            this.turns = 0L;
        }

        public boolean isIdling() {
            return this.idling;
        }

        public void idle() {
            int n = this.state;
            switch (n) {
                case 0: {
                    this.idling = true;
                    this.transitionTo(1);
                    return;
                }
                case 1: {
                    OnSpinWait.spinWait();
                    ++this.turns;
                    if (this.turns > (long)this.maxSpins) {
                        this.transitionTo(2);
                        return;
                    }
                    return;
                }
                case 2: {
                    ++this.turns;
                    if (this.turns > (long)this.maxYields) {
                        this.parkPeriodNs = Int$.MODULE$.int2long(this.minParkPeriodNs);
                        this.transitionTo(3);
                        return;
                    }
                    Thread.yield();
                    return;
                }
                case 3: {
                    LockSupport.parkNanos(this.parkPeriodNs);
                    this.parkPeriodNs = Math.min(this.parkPeriodNs << 1, this.maxParkPeriodNs);
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }

        public void reset() {
            this.idling = false;
            this.transitionTo(0);
        }
    }
}

