/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.ActorEventBus;
import org.apache.pekko.event.EventStreamUnsubscriber;
import org.apache.pekko.event.EventStreamUnsubscriber$;
import org.apache.pekko.event.EventStreamUnsubscriber$Register$;
import org.apache.pekko.event.EventStreamUnsubscriber$UnregisterIfNoMoreSubscribedChannels$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Debug$;
import org.apache.pekko.event.LoggingBus;
import org.apache.pekko.event.SubchannelClassification;
import org.apache.pekko.util.ReentrantGuard;
import org.apache.pekko.util.Subclassification;
import org.apache.pekko.util.SubclassifiedIndex;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class EventStream
implements ActorEventBus,
LoggingBus,
SubchannelClassification {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(EventStream.class.getDeclaredField("org$apache$pekko$event$SubchannelClassification$$subscriptions$lzy1"));
    private ReentrantGuard org$apache$pekko$event$LoggingBus$$guard;
    private Seq org$apache$pekko$event$LoggingBus$$loggers;
    private volatile int org$apache$pekko$event$LoggingBus$$_logLevel;
    private volatile Object org$apache$pekko$event$SubchannelClassification$$subscriptions$lzy1;
    private volatile Map org$apache$pekko$event$SubchannelClassification$$cache;
    private final ActorSystem sys;
    private final boolean debug;
    private final AtomicReference<Either<Set<ActorRef>, ActorRef>> initiallySubscribedOrUnsubscriber;
    private final Subclassification subclassification;

    public EventStream(ActorSystem sys, boolean debug) {
        this.sys = sys;
        this.debug = debug;
        LoggingBus.$init$(this);
        SubchannelClassification.$init$(this);
        this.initiallySubscribedOrUnsubscriber = new AtomicReference<Left>(package$.MODULE$.Left().apply((Object)Predef$.MODULE$.Set().empty()));
        this.subclassification = new Subclassification<Class<?>>(){

            public boolean isEqual(Class x, Class y) {
                Class clazz = x;
                Class clazz2 = y;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }

            public boolean isSubclass(Class x, Class y) {
                return y.isAssignableFrom(x);
            }
        };
        Statics.releaseFence();
    }

    @Override
    public ReentrantGuard org$apache$pekko$event$LoggingBus$$guard() {
        return this.org$apache$pekko$event$LoggingBus$$guard;
    }

    public Seq org$apache$pekko$event$LoggingBus$$loggers() {
        return this.org$apache$pekko$event$LoggingBus$$loggers;
    }

    @Override
    public int org$apache$pekko$event$LoggingBus$$_logLevel() {
        return this.org$apache$pekko$event$LoggingBus$$_logLevel;
    }

    public void org$apache$pekko$event$LoggingBus$$loggers_$eq(Seq x$1) {
        this.org$apache$pekko$event$LoggingBus$$loggers = x$1;
    }

    @Override
    public void org$apache$pekko$event$LoggingBus$$_logLevel_$eq(int x$1) {
        this.org$apache$pekko$event$LoggingBus$$_logLevel = x$1;
    }

    @Override
    public void org$apache$pekko$event$LoggingBus$_setter_$org$apache$pekko$event$LoggingBus$$guard_$eq(ReentrantGuard x$0) {
        this.org$apache$pekko$event$LoggingBus$$guard = x$0;
    }

    public SubclassifiedIndex org$apache$pekko$event$SubchannelClassification$$subscriptions() {
        Object object = this.org$apache$pekko$event$SubchannelClassification$$subscriptions$lzy1;
        if (object instanceof SubclassifiedIndex) {
            return (SubclassifiedIndex)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SubclassifiedIndex)this.org$apache$pekko$event$SubchannelClassification$$subscriptions$lzyINIT1();
    }

    private Object org$apache$pekko$event$SubchannelClassification$$subscriptions$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.org$apache$pekko$event$SubchannelClassification$$subscriptions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SubclassifiedIndex subclassifiedIndex = null;
                    try {
                        subclassifiedIndex = SubchannelClassification.org$apache$pekko$event$SubchannelClassification$$subscriptions$(this);
                        object2 = subclassifiedIndex == null ? LazyVals.NullValue$.MODULE$ : subclassifiedIndex;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.org$apache$pekko$event$SubchannelClassification$$subscriptions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return subclassifiedIndex;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Map org$apache$pekko$event$SubchannelClassification$$cache() {
        return this.org$apache$pekko$event$SubchannelClassification$$cache;
    }

    public void org$apache$pekko$event$SubchannelClassification$$cache_$eq(Map x$1) {
        this.org$apache$pekko$event$SubchannelClassification$$cache = x$1;
    }

    private boolean debug() {
        return this.debug;
    }

    public EventStream(ActorSystem sys) {
        this(sys, false);
    }

    public Subclassification<Class<?>> subclassification() {
        return this.subclassification;
    }

    @Override
    public Class<?> classify(Object event) {
        return event.getClass();
    }

    public void publish(Object event, ActorRef subscriber) {
        if (this.sys == null && subscriber.isTerminated()) {
            this.unsubscribe(subscriber);
            return;
        }
        subscriber.$bang(event, subscriber.$bang$default$2(event));
    }

    public boolean subscribe(ActorRef subscriber, Class<?> channel) {
        if (subscriber == null) {
            throw new IllegalArgumentException("subscriber is null");
        }
        if (this.debug()) {
            this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), new StringBuilder(24).append("subscribing ").append(subscriber).append(" to channel ").append(channel).toString()));
        }
        this.registerWithUnsubscriber(subscriber);
        return SubchannelClassification.subscribe$(this, subscriber, channel);
    }

    public boolean unsubscribe(ActorRef subscriber, Class<?> channel) {
        if (subscriber == null) {
            throw new IllegalArgumentException("subscriber is null");
        }
        boolean ret = SubchannelClassification.unsubscribe$(this, subscriber, channel);
        this.unregisterIfNoMoreSubscribedChannels(subscriber);
        if (this.debug()) {
            this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), new StringBuilder(28).append("unsubscribing ").append(subscriber).append(" from channel ").append(channel).toString()));
        }
        return ret;
    }

    public void unsubscribe(ActorRef subscriber) {
        if (subscriber == null) {
            throw new IllegalArgumentException("subscriber is null");
        }
        SubchannelClassification.unsubscribe$(this, subscriber);
        this.unregisterIfNoMoreSubscribedChannels(subscriber);
        if (this.debug()) {
            this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), new StringBuilder(32).append("unsubscribing ").append(subscriber).append(" from all channels").toString()));
            return;
        }
    }

    public void startUnsubscriber() {
        if (this.sys != null) {
            EventStreamUnsubscriber$.MODULE$.start(this.sys, this);
            return;
        }
    }

    public final boolean initUnsubscriber(ActorRef unsubscriber) {
        Either<Set<ActorRef>, ActorRef> either;
        block5: {
            Set subscribers;
            Left left;
            Left value;
            do {
                if (this.sys == null) {
                    return false;
                }
                either = this.initiallySubscribedOrUnsubscriber.get();
                if (!(either instanceof Left)) break block5;
                left = (Left)either;
                subscribers = (Set)left.value();
            } while (!this.initiallySubscribedOrUnsubscriber.compareAndSet((Either<Set<ActorRef>, ActorRef>)(value = left), (Either<Set<ActorRef>, ActorRef>)package$.MODULE$.Right().apply((Object)unsubscriber)));
            if (this.debug()) {
                this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), new StringBuilder(71).append("initialized unsubscriber to: ").append(unsubscriber).append(", registering ").append(subscribers.size()).append(" initial subscribers with it").toString()));
            }
            subscribers.foreach((Function1)(JProcedure1 & Serializable)subscriber -> this.registerWithUnsubscriber((ActorRef)subscriber));
            return true;
        }
        if (either instanceof Right) {
            ActorRef presentUnsubscriber = (ActorRef)((Right)either).value();
            if (this.debug()) {
                this.publish(Logging$Debug$.MODULE$.apply(Logging$.MODULE$.simpleName(this), this.getClass(), new StringBuilder(58).append("not using unsubscriber ").append(unsubscriber).append(", because already initialized with ").append(presentUnsubscriber).toString()));
            }
            return false;
        }
        throw new MatchError(either);
    }

    private void registerWithUnsubscriber(ActorRef subscriber) {
        while (this.sys != null) {
            Either<Set<ActorRef>, ActorRef> either = this.initiallySubscribedOrUnsubscriber.get();
            if (either instanceof Left) {
                Left left = (Left)either;
                Set subscribers = (Set)left.value();
                Left value = left;
                if (!this.initiallySubscribedOrUnsubscriber.compareAndSet((Either<Set<ActorRef>, ActorRef>)value, (Either<Set<ActorRef>, ActorRef>)package$.MODULE$.Left().apply((Object)subscribers.$plus((Object)subscriber)))) continue;
                return;
            }
            if (either instanceof Right) {
                ActorRef unsubscriber = (ActorRef)((Right)either).value();
                EventStreamUnsubscriber.Register register = EventStreamUnsubscriber$Register$.MODULE$.apply(subscriber);
                unsubscriber.$bang(register, unsubscriber.$bang$default$2(register));
                return;
            }
            throw new MatchError(either);
        }
    }

    private void unregisterIfNoMoreSubscribedChannels(ActorRef subscriber) {
        while (this.sys != null) {
            Either<Set<ActorRef>, ActorRef> either = this.initiallySubscribedOrUnsubscriber.get();
            if (either instanceof Left) {
                Left left = (Left)either;
                Set subscribers = (Set)left.value();
                Left value = left;
                if (!this.initiallySubscribedOrUnsubscriber.compareAndSet((Either<Set<ActorRef>, ActorRef>)value, (Either<Set<ActorRef>, ActorRef>)package$.MODULE$.Left().apply((Object)subscribers.$minus((Object)subscriber)))) continue;
                return;
            }
            if (either instanceof Right) {
                ActorRef unsubscriber = (ActorRef)((Right)either).value();
                EventStreamUnsubscriber.UnregisterIfNoMoreSubscribedChannels unregisterIfNoMoreSubscribedChannels = EventStreamUnsubscriber$UnregisterIfNoMoreSubscribedChannels$.MODULE$.apply(subscriber);
                unsubscriber.$bang(unregisterIfNoMoreSubscribedChannels, unsubscriber.$bang$default$2(unregisterIfNoMoreSubscribedChannels));
                return;
            }
            throw new MatchError(either);
        }
    }
}

