/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event;

import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.DiagnosticActorLogging;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$LogEvent$;
import org.apache.pekko.event.Logging$LogLevel$;
import org.apache.pekko.event.LoggingReceive$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;

public class LoggingReceive
implements PartialFunction<Object, BoxedUnit> {
    private final Option<Object> source;
    private final PartialFunction<Object, BoxedUnit> r;
    private final Option<String> label;
    private final int logLevel;
    private final ActorContext context;

    public static AbstractActor.Receive create(AbstractActor.Receive receive, AbstractActor.ActorContext actorContext) {
        return LoggingReceive$.MODULE$.create(receive, actorContext);
    }

    public static PartialFunction<Object, BoxedUnit> withLabel(String string, int n, PartialFunction<Object, BoxedUnit> partialFunction, ActorContext actorContext) {
        return LoggingReceive$.MODULE$.withLabel(string, n, partialFunction, actorContext);
    }

    public static PartialFunction<Object, BoxedUnit> withLabel(String string, PartialFunction<Object, BoxedUnit> partialFunction, ActorContext actorContext) {
        return LoggingReceive$.MODULE$.withLabel(string, partialFunction, actorContext);
    }

    public LoggingReceive(Option<Object> source, PartialFunction<Object, BoxedUnit> r, Option<String> label, int logLevel, ActorContext context) {
        this.source = source;
        this.r = r;
        this.label = label;
        this.logLevel = logLevel;
        this.context = context;
        PartialFunction.$init$((PartialFunction)this);
    }

    public LoggingReceive(Option<Object> source, PartialFunction<Object, BoxedUnit> r, Option<String> label, ActorContext context) {
        this(source, r, label, Logging$.MODULE$.DebugLevel(), context);
    }

    public LoggingReceive(Option<Object> source, PartialFunction<Object, BoxedUnit> r, ActorContext context) {
        this(source, r, (Option<String>)None$.MODULE$, Logging$.MODULE$.DebugLevel(), context);
    }

    public boolean isDefinedAt(Object o) {
        boolean handled = this.r.isDefinedAt(o);
        if (Logging$LogLevel$.MODULE$.$greater$eq$extension(this.context.system().eventStream().logLevel(), this.logLevel)) {
            Logging.LogEvent logEvent;
            String string;
            Object src = this.source.getOrElse(this::$anonfun$1);
            Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(src);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String str = (String)tuple2._1();
            Class clazz = (Class)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)str, (Object)clazz);
            String str2 = (String)tuple22._1();
            Class clazz2 = (Class)tuple22._2();
            StringBuilder stringBuilder = new StringBuilder(24).append("received ").append(handled ? "handled" : "unhandled").append(" message ").append(o).append(" from ").append(this.context.sender());
            Option<String> option = this.label;
            if (option instanceof Some) {
                String l = (String)((Some)option).value();
                string = new StringBuilder(10).append(" in state ").append(l).toString();
            } else {
                string = "";
            }
            String message = stringBuilder.append(string).toString();
            Object object = src;
            if (object instanceof DiagnosticActorLogging) {
                DiagnosticActorLogging a = (DiagnosticActorLogging)object;
                logEvent = Logging$LogEvent$.MODULE$.apply(this.logLevel, str2, clazz2, message, a.log().mdc());
            } else {
                logEvent = Logging$LogEvent$.MODULE$.apply(this.logLevel, str2, clazz2, message);
            }
            Logging.LogEvent event = logEvent;
            this.context.system().eventStream().publish(event);
        }
        return handled;
    }

    public void apply(Object o) {
        this.r.apply(o);
    }

    private final Object $anonfun$1() {
        return ((ActorCell)this.context).actor();
    }
}

