/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.io.Inet;
import org.apache.pekko.io.SelectionHandler;
import org.apache.pekko.io.SelectionHandlerSettings;
import org.apache.pekko.io.Udp$;
import org.apache.pekko.io.Udp$Bind$;
import org.apache.pekko.io.Udp$Bound$;
import org.apache.pekko.io.Udp$CommandFailed$;
import org.apache.pekko.io.Udp$NoAck$;
import org.apache.pekko.io.Udp$Received$;
import org.apache.pekko.io.Udp$Send$;
import org.apache.pekko.io.Udp$SimpleSender$;
import org.apache.pekko.io.Udp$SimpleSenderReady$;
import org.apache.pekko.io.Udp$Unbound$;
import org.apache.pekko.io.UdpExt;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$Requiring$;
import scala.Function0;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.deriving.Mirror;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Udp {
    public static Extension apply(ActorSystem actorSystem) {
        return Udp$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Udp$.MODULE$.apply(classicActorSystemProvider);
    }

    public static UdpExt createExtension(ExtendedActorSystem extendedActorSystem) {
        return Udp$.MODULE$.createExtension(extendedActorSystem);
    }

    public static boolean equals(Object object) {
        return Udp$.MODULE$.equals(object);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return Udp$.MODULE$.get(actorSystem);
    }

    public static UdpExt get(ActorSystem actorSystem) {
        return Udp$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Udp$.MODULE$.get(classicActorSystemProvider);
    }

    public static UdpExt get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Udp$.MODULE$.get(classicActorSystemProvider);
    }

    public static int hashCode() {
        return Udp$.MODULE$.hashCode();
    }

    public static ExtensionId<? extends Extension> lookup() {
        return Udp$.MODULE$.lookup();
    }

    public static final class Bind
    implements Command,
    Product,
    Serializable {
        private final ActorRef handler;
        private final InetSocketAddress localAddress;
        private final Iterable options;

        public static Bind apply(ActorRef actorRef, InetSocketAddress inetSocketAddress, Iterable<Inet.SocketOption> iterable) {
            return Udp$Bind$.MODULE$.apply(actorRef, inetSocketAddress, iterable);
        }

        public static Bind fromProduct(Product product) {
            return Udp$Bind$.MODULE$.fromProduct(product);
        }

        public static Bind unapply(Bind bind) {
            return Udp$Bind$.MODULE$.unapply(bind);
        }

        public static Iterable<Inet.SocketOption> $lessinit$greater$default$3() {
            return Udp$Bind$.MODULE$.$lessinit$greater$default$3();
        }

        public Bind(ActorRef handler, InetSocketAddress localAddress, Iterable<Inet.SocketOption> options) {
            this.handler = handler;
            this.localAddress = localAddress;
            this.options = options;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Bind)) return false;
            Bind bind = (Bind)object;
            ActorRef actorRef = this.handler();
            ActorRef actorRef2 = bind.handler();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!((Object)actorRef).equals(actorRef2)) return false;
            InetSocketAddress inetSocketAddress = this.localAddress();
            InetSocketAddress inetSocketAddress2 = bind.localAddress();
            if (inetSocketAddress == null) {
                if (inetSocketAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
            Iterable<Inet.SocketOption> iterable = this.options();
            Iterable<Inet.SocketOption> iterable2 = bind.options();
            if (iterable == null) {
                if (iterable2 == null) return true;
                return false;
            } else {
                if (!iterable.equals(iterable2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Bind;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Bind";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "handler";
                }
                case 1: {
                    return "localAddress";
                }
                case 2: {
                    return "options";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef handler() {
            return this.handler;
        }

        public InetSocketAddress localAddress() {
            return this.localAddress;
        }

        public Iterable<Inet.SocketOption> options() {
            return this.options;
        }

        public Bind copy(ActorRef handler, InetSocketAddress localAddress, Iterable<Inet.SocketOption> options) {
            return new Bind(handler, localAddress, options);
        }

        public ActorRef copy$default$1() {
            return this.handler();
        }

        public InetSocketAddress copy$default$2() {
            return this.localAddress();
        }

        public Iterable<Inet.SocketOption> copy$default$3() {
            return this.options();
        }

        public ActorRef _1() {
            return this.handler();
        }

        public InetSocketAddress _2() {
            return this.localAddress();
        }

        public Iterable<Inet.SocketOption> _3() {
            return this.options();
        }
    }

    public static final class Bound
    implements Event,
    Product,
    Serializable {
        private final InetSocketAddress localAddress;

        public static Bound apply(InetSocketAddress inetSocketAddress) {
            return Udp$Bound$.MODULE$.apply(inetSocketAddress);
        }

        public static Bound fromProduct(Product product) {
            return Udp$Bound$.MODULE$.fromProduct(product);
        }

        public static Bound unapply(Bound bound) {
            return Udp$Bound$.MODULE$.unapply(bound);
        }

        public Bound(InetSocketAddress localAddress) {
            this.localAddress = localAddress;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Bound)) return false;
            Bound bound = (Bound)object;
            InetSocketAddress inetSocketAddress = this.localAddress();
            InetSocketAddress inetSocketAddress2 = bound.localAddress();
            if (inetSocketAddress != null) {
                if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
                return true;
            }
            if (inetSocketAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Bound;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Bound";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "localAddress";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InetSocketAddress localAddress() {
            return this.localAddress;
        }

        public Bound copy(InetSocketAddress localAddress) {
            return new Bound(localAddress);
        }

        public InetSocketAddress copy$default$1() {
            return this.localAddress();
        }

        public InetSocketAddress _1() {
            return this.localAddress();
        }
    }

    public static interface Command
    extends SelectionHandler.HasFailureMessage,
    Message {
        public static Object failureMessage$(Command $this) {
            return $this.failureMessage();
        }

        @Override
        default public Object failureMessage() {
            return Udp$CommandFailed$.MODULE$.apply(this);
        }
    }

    public static final class CommandFailed
    implements Event,
    Product,
    Serializable {
        private final Command cmd;

        public static CommandFailed apply(Command command) {
            return Udp$CommandFailed$.MODULE$.apply(command);
        }

        public static CommandFailed fromProduct(Product product) {
            return Udp$CommandFailed$.MODULE$.fromProduct(product);
        }

        public static CommandFailed unapply(CommandFailed commandFailed) {
            return Udp$CommandFailed$.MODULE$.unapply(commandFailed);
        }

        public CommandFailed(Command cmd) {
            this.cmd = cmd;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CommandFailed)) return false;
            CommandFailed commandFailed = (CommandFailed)object;
            Command command = this.cmd();
            Command command2 = commandFailed.cmd();
            if (command != null) {
                if (!command.equals(command2)) return false;
                return true;
            }
            if (command2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CommandFailed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CommandFailed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cmd";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Command cmd() {
            return this.cmd;
        }

        public CommandFailed copy(Command cmd) {
            return new CommandFailed(cmd);
        }

        public Command copy$default$1() {
            return this.cmd();
        }

        public Command _1() {
            return this.cmd();
        }
    }

    public static interface Event
    extends Message {
    }

    public static interface Message {
    }

    public static class NoAck
    implements Event,
    Product,
    Serializable {
        private final Object token;

        public static NoAck apply(Object object) {
            return Udp$NoAck$.MODULE$.apply(object);
        }

        public static NoAck fromProduct(Product product) {
            return Udp$NoAck$.MODULE$.fromProduct(product);
        }

        public static NoAck unapply(NoAck noAck) {
            return Udp$NoAck$.MODULE$.unapply(noAck);
        }

        public NoAck(Object token) {
            this.token = token;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NoAck)) return false;
            NoAck noAck = (NoAck)object;
            if (!BoxesRunTime.equals((Object)this.token(), (Object)noAck.token())) return false;
            if (!noAck.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NoAck;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NoAck";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "token";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object token() {
            return this.token;
        }

        public NoAck copy(Object token) {
            return new NoAck(token);
        }

        public Object copy$default$1() {
            return this.token();
        }

        public Object _1() {
            return this.token();
        }
    }

    public static final class Received
    implements Event,
    Product,
    Serializable {
        private final ByteString data;
        private final InetSocketAddress sender;

        public static Received apply(ByteString byteString, InetSocketAddress inetSocketAddress) {
            return Udp$Received$.MODULE$.apply(byteString, inetSocketAddress);
        }

        public static Received fromProduct(Product product) {
            return Udp$Received$.MODULE$.fromProduct(product);
        }

        public static Received unapply(Received received) {
            return Udp$Received$.MODULE$.unapply(received);
        }

        public Received(ByteString data, InetSocketAddress sender) {
            this.data = data;
            this.sender = sender;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Received)) return false;
            Received received = (Received)object;
            ByteString byteString = this.data();
            ByteString byteString2 = received.data();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            InetSocketAddress inetSocketAddress = this.sender();
            InetSocketAddress inetSocketAddress2 = received.sender();
            if (inetSocketAddress == null) {
                if (inetSocketAddress2 == null) return true;
                return false;
            } else {
                if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Received;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Received";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            if (1 == n2) {
                return "sender";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString data() {
            return this.data;
        }

        public InetSocketAddress sender() {
            return this.sender;
        }

        public Received copy(ByteString data, InetSocketAddress sender) {
            return new Received(data, sender);
        }

        public ByteString copy$default$1() {
            return this.data();
        }

        public InetSocketAddress copy$default$2() {
            return this.sender();
        }

        public ByteString _1() {
            return this.data();
        }

        public InetSocketAddress _2() {
            return this.sender();
        }
    }

    public static final class Send
    implements Command,
    Product,
    Serializable {
        private final ByteString payload;
        private final InetSocketAddress target;
        private final Event ack;

        public static Send apply(ByteString byteString, InetSocketAddress inetSocketAddress) {
            return Udp$Send$.MODULE$.apply(byteString, inetSocketAddress);
        }

        public static Send apply(ByteString byteString, InetSocketAddress inetSocketAddress, Event event) {
            return Udp$Send$.MODULE$.apply(byteString, inetSocketAddress, event);
        }

        public static Send fromProduct(Product product) {
            return Udp$Send$.MODULE$.fromProduct(product);
        }

        public static Send unapply(Send send) {
            return Udp$Send$.MODULE$.unapply(send);
        }

        public Send(ByteString payload, InetSocketAddress target, Event ack) {
            this.payload = payload;
            this.target = target;
            this.ack = ack;
            Predef$.MODULE$.require(ack != null, this::$init$$$anonfun$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Send)) return false;
            Send send = (Send)object;
            ByteString byteString = this.payload();
            ByteString byteString2 = send.payload();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            InetSocketAddress inetSocketAddress = this.target();
            InetSocketAddress inetSocketAddress2 = send.target();
            if (inetSocketAddress == null) {
                if (inetSocketAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetSocketAddress).equals(inetSocketAddress2)) return false;
            Event event = this.ack();
            Event event2 = send.ack();
            if (event == null) {
                if (event2 == null) return true;
                return false;
            } else {
                if (!event.equals(event2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Send;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Send";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "payload";
                }
                case 1: {
                    return "target";
                }
                case 2: {
                    return "ack";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString payload() {
            return this.payload;
        }

        public InetSocketAddress target() {
            return this.target;
        }

        public Event ack() {
            return this.ack;
        }

        public boolean wantsAck() {
            return !(this.ack() instanceof NoAck);
        }

        public Send copy(ByteString payload, InetSocketAddress target, Event ack) {
            return new Send(payload, target, ack);
        }

        public ByteString copy$default$1() {
            return this.payload();
        }

        public InetSocketAddress copy$default$2() {
            return this.target();
        }

        public Event copy$default$3() {
            return this.ack();
        }

        public ByteString _1() {
            return this.payload();
        }

        public InetSocketAddress _2() {
            return this.target();
        }

        public Event _3() {
            return this.ack();
        }

        private final Object $init$$$anonfun$1() {
            return "ack must be non-null. Use NoAck if you don't want acks.";
        }
    }

    public static class SimpleSender
    implements Command,
    Product,
    Serializable {
        private final Iterable options;

        public static SimpleSender apply(Iterable<Inet.SocketOption> iterable) {
            return Udp$SimpleSender$.MODULE$.apply(iterable);
        }

        public static SimpleSender fromProduct(Product product) {
            return Udp$SimpleSender$.MODULE$.fromProduct(product);
        }

        public static SimpleSender unapply(SimpleSender simpleSender) {
            return Udp$SimpleSender$.MODULE$.unapply(simpleSender);
        }

        public static Iterable<Inet.SocketOption> $lessinit$greater$default$1() {
            return Udp$SimpleSender$.MODULE$.$lessinit$greater$default$1();
        }

        public SimpleSender(Iterable<Inet.SocketOption> options) {
            this.options = options;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SimpleSender)) return false;
            SimpleSender simpleSender = (SimpleSender)object;
            Iterable<Inet.SocketOption> iterable = this.options();
            Iterable<Inet.SocketOption> iterable2 = simpleSender.options();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            if (!simpleSender.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SimpleSender;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SimpleSender";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "options";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Iterable<Inet.SocketOption> options() {
            return this.options;
        }

        public SimpleSender copy(Iterable<Inet.SocketOption> options) {
            return new SimpleSender(options);
        }

        public Iterable<Inet.SocketOption> copy$default$1() {
            return this.options();
        }

        public Iterable<Inet.SocketOption> _1() {
            return this.options();
        }
    }

    public static interface SimpleSenderReady
    extends Event {
        public static boolean canEqual(Object object) {
            return Udp$SimpleSenderReady$.MODULE$.canEqual(object);
        }

        public static Mirror.Singleton fromProduct(Product product) {
            return Udp$SimpleSenderReady$.MODULE$.fromProduct(product);
        }

        public static int productArity() {
            return Udp$SimpleSenderReady$.MODULE$.productArity();
        }

        public static Object productElement(int n) {
            return Udp$SimpleSenderReady$.MODULE$.productElement(n);
        }

        public static String productElementName(int n) {
            return Udp$SimpleSenderReady$.MODULE$.productElementName(n);
        }

        public static Iterator<String> productElementNames() {
            return Udp$SimpleSenderReady$.MODULE$.productElementNames();
        }

        public static Iterator<Object> productIterator() {
            return Udp$SimpleSenderReady$.MODULE$.productIterator();
        }

        public static String productPrefix() {
            return Udp$SimpleSenderReady$.MODULE$.productPrefix();
        }
    }

    public static class UdpSettings
    extends SelectionHandlerSettings {
        private final Config _config;
        private final int NrOfSelectors;
        private final int DirectBufferSize;
        private final int MaxDirectBufferPoolSize;
        private final int BatchReceiveLimit;
        private final String ManagementDispatcher;
        private final int MaxChannelsPerSelector;

        public UdpSettings(Config _config) {
            this._config = _config;
            super(_config);
            Integer n = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger((int)_config.getInt("nr-of-selectors")));
            this.NrOfSelectors = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n, (JFunction1.mcZI.sp & Serializable)_$1 -> _$1 > 0, (Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$3)));
            this.DirectBufferSize = this.getIntBytes("direct-buffer-size");
            this.MaxDirectBufferPoolSize = _config.getInt("direct-buffer-pool-limit");
            this.BatchReceiveLimit = _config.getInt("receive-throughput");
            this.ManagementDispatcher = _config.getString("management-dispatcher");
            this.MaxChannelsPerSelector = this.MaxChannels() == -1 ? -1 : package$.MODULE$.max(this.MaxChannels() / this.NrOfSelectors(), 1);
        }

        public int NrOfSelectors() {
            return this.NrOfSelectors;
        }

        public int DirectBufferSize() {
            return this.DirectBufferSize;
        }

        public int MaxDirectBufferPoolSize() {
            return this.MaxDirectBufferPoolSize;
        }

        public int BatchReceiveLimit() {
            return this.BatchReceiveLimit;
        }

        public String ManagementDispatcher() {
            return this.ManagementDispatcher;
        }

        @Override
        public int MaxChannelsPerSelector() {
            return this.MaxChannelsPerSelector;
        }

        private int getIntBytes(String path) {
            Long size = this._config.getBytes(path);
            Predef$.MODULE$.require(Predef$.MODULE$.Long2long(size) < Integer.MAX_VALUE, () -> Udp$.org$apache$pekko$io$Udp$UdpSettings$$_$getIntBytes$$anonfun$1(path));
            return (int)Predef$.MODULE$.Long2long(size);
        }

        private final Object $init$$$anonfun$3() {
            return "nr-of-selectors must be > 0";
        }
    }

    public static interface Unbound {
        public static boolean canEqual(Object object) {
            return Udp$Unbound$.MODULE$.canEqual(object);
        }

        public static Mirror.Singleton fromProduct(Product product) {
            return Udp$Unbound$.MODULE$.fromProduct(product);
        }

        public static int productArity() {
            return Udp$Unbound$.MODULE$.productArity();
        }

        public static Object productElement(int n) {
            return Udp$Unbound$.MODULE$.productElement(n);
        }

        public static String productElementName(int n) {
            return Udp$Unbound$.MODULE$.productElementName(n);
        }

        public static Iterator<String> productElementNames() {
            return Udp$Unbound$.MODULE$.productElementNames();
        }

        public static Iterator<Object> productIterator() {
            return Udp$Unbound$.MODULE$.productIterator();
        }

        public static String productPrefix() {
            return Udp$Unbound$.MODULE$.productPrefix();
        }
    }
}

