/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io.dns.internal;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.actor.UnrestrictedStash;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.Tcp;
import org.apache.pekko.io.Tcp$CommandFailed$;
import org.apache.pekko.io.Tcp$Connect$;
import org.apache.pekko.io.Tcp$PeerClosed$;
import org.apache.pekko.io.Tcp$Received$;
import org.apache.pekko.io.Tcp$Register$;
import org.apache.pekko.io.Tcp$Write$;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.io.dns.internal.DnsClient;
import org.apache.pekko.io.dns.internal.DnsClient$Answer$;
import org.apache.pekko.io.dns.internal.Message;
import org.apache.pekko.io.dns.internal.Message$;
import org.apache.pekko.io.dns.internal.MessageFlags$;
import org.apache.pekko.io.dns.internal.ResponseCode$;
import org.apache.pekko.io.dns.internal.TcpDnsClient$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@InternalApi
public class TcpDnsClient
implements Actor,
ActorLogging,
StashSupport,
UnrestrictedStash,
Stash {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private Vector org$apache$pekko$actor$StashSupport$$theStash;
    private int org$apache$pekko$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    public final ActorRef org$apache$pekko$io$dns$internal$TcpDnsClient$$tcp;
    public final InetSocketAddress org$apache$pekko$io$dns$internal$TcpDnsClient$$ns;
    public final ActorRef org$apache$pekko$io$dns$internal$TcpDnsClient$$answerRecipient;
    private final PartialFunction idle;
    private final PartialFunction connecting;

    public static int decodeLength(ByteString byteString) {
        return TcpDnsClient$.MODULE$.decodeLength(byteString);
    }

    public static ByteString encodeLength(int n) {
        return TcpDnsClient$.MODULE$.encodeLength(n);
    }

    public static void throwFailure(String string, Option<Throwable> option) {
        TcpDnsClient$.MODULE$.throwFailure(string, option);
    }

    public TcpDnsClient(ActorRef tcp, InetSocketAddress ns, ActorRef answerRecipient) {
        this.org$apache$pekko$io$dns$internal$TcpDnsClient$$tcp = tcp;
        this.org$apache$pekko$io$dns$internal$TcpDnsClient$$ns = ns;
        this.org$apache$pekko$io$dns$internal$TcpDnsClient$$answerRecipient = answerRecipient;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        StashSupport.$init$(this);
        this.idle = new Serializable(this){
            private final /* synthetic */ TcpDnsClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return object instanceof Message;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Message) {
                    this.$outer.stash();
                    this.$outer.log().debug("Connecting to [{}]", this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$ns);
                    this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$tcp.$bang(Tcp$Connect$.MODULE$.apply(this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$ns, Tcp$Connect$.MODULE$.$lessinit$greater$default$2(), Tcp$Connect$.MODULE$.$lessinit$greater$default$3(), Tcp$Connect$.MODULE$.$lessinit$greater$default$4(), Tcp$Connect$.MODULE$.$lessinit$greater$default$5()), this.$outer.self());
                    this.$outer.context().become(this.$outer.connecting());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
        this.connecting = new Serializable(this){
            private final /* synthetic */ TcpDnsClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Tcp.CommandFailed commandFailed;
                Tcp.CommandFailed commandFailed2;
                Tcp.Command command;
                Object object = x;
                if (object instanceof Tcp.CommandFailed && (command = (commandFailed2 = Tcp$CommandFailed$.MODULE$.unapply(commandFailed = (Tcp.CommandFailed)object))._1()) instanceof Tcp.Connect) {
                    Tcp.CommandFailed failure = commandFailed;
                    return true;
                }
                if (object instanceof Tcp.Connected) {
                    return true;
                }
                return object instanceof Message;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Tcp.CommandFailed commandFailed;
                Tcp.CommandFailed commandFailed2;
                Tcp.Command command;
                Object object = x;
                if (object instanceof Tcp.CommandFailed && (command = (commandFailed2 = Tcp$CommandFailed$.MODULE$.unapply(commandFailed = (Tcp.CommandFailed)object))._1()) instanceof Tcp.Connect) {
                    Tcp.CommandFailed failure = commandFailed;
                    TcpDnsClient$.MODULE$.throwFailure(new StringBuilder(41).append("Failed to connect to TCP DNS server at [").append(this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$ns).append("]").toString(), failure.cause());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Tcp.Connected) {
                    this.$outer.log().debug("Connected to TCP address [{}]", this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$ns);
                    ActorRef connection = this.$outer.sender();
                    this.$outer.context().become(this.$outer.ready(connection, this.$outer.ready$default$2()));
                    this.$outer.context().watch(connection);
                    connection.$bang(Tcp$Register$.MODULE$.apply(this.$outer.self(), Tcp$Register$.MODULE$.$lessinit$greater$default$2(), Tcp$Register$.MODULE$.$lessinit$greater$default$3()), this.$outer.self());
                    this.$outer.unstashAll();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Message) {
                    this.$outer.stash();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Vector org$apache$pekko$actor$StashSupport$$theStash() {
        return this.org$apache$pekko$actor$StashSupport$$theStash;
    }

    @Override
    public int org$apache$pekko$actor$StashSupport$$capacity() {
        return this.org$apache$pekko$actor$StashSupport$$capacity;
    }

    @Override
    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector x$1) {
        this.org$apache$pekko$actor$StashSupport$$theStash = x$1;
    }

    @Override
    public void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int x$0) {
        this.org$apache$pekko$actor$StashSupport$$capacity = x$0;
    }

    @Override
    public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$0) {
        this.mailbox = x$0;
    }

    @Override
    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$(this);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return this.idle();
    }

    public PartialFunction<Object, BoxedUnit> idle() {
        return this.idle;
    }

    public PartialFunction<Object, BoxedUnit> connecting() {
        return this.connecting;
    }

    public PartialFunction<Object, BoxedUnit> ready(ActorRef connection, ByteString buffer) {
        return new Serializable(connection, buffer, this){
            private final ActorRef connection$1;
            private final ByteString buffer$1;
            private final /* synthetic */ TcpDnsClient $outer;
            {
                this.connection$1 = connection$2;
                this.buffer$1 = buffer$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Tcp.CommandFailed commandFailed;
                Tcp.CommandFailed commandFailed2;
                Tcp.Command command;
                Object object = x;
                if (object instanceof Message) {
                    Message msg = (Message)object;
                    return true;
                }
                if (object instanceof Tcp.CommandFailed && (command = (commandFailed2 = Tcp$CommandFailed$.MODULE$.unapply(commandFailed = (Tcp.CommandFailed)object))._1()) instanceof Tcp.Write) {
                    Tcp.CommandFailed failure = commandFailed;
                    return true;
                }
                if (object instanceof Tcp.Received) {
                    ByteString byteString;
                    Tcp.Received received = Tcp$Received$.MODULE$.unapply((Tcp.Received)object);
                    ByteString newData = byteString = received._1();
                    return true;
                }
                if (Tcp$PeerClosed$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    ActorRef actorRef2 = this.connection$1;
                    ActorRef actorRef3 = actorRef;
                    if (!(actorRef2 != null ? !((Object)actorRef2).equals(actorRef3) : actorRef3 != null)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Tcp.CommandFailed commandFailed;
                Tcp.CommandFailed commandFailed2;
                Tcp.Command command;
                Object object = x;
                if (object instanceof Message) {
                    Message msg = (Message)object;
                    ByteString bytes = msg.write();
                    this.connection$1.$bang(Tcp$Write$.MODULE$.apply(TcpDnsClient$.MODULE$.encodeLength(bytes.length()).$plus$plus(bytes)), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Tcp.CommandFailed && (command = (commandFailed2 = Tcp$CommandFailed$.MODULE$.unapply(commandFailed = (Tcp.CommandFailed)object))._1()) instanceof Tcp.Write) {
                    Tcp.CommandFailed failure = commandFailed;
                    TcpDnsClient$.MODULE$.throwFailure("Write failed", failure.cause());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Tcp.Received) {
                    ByteString byteString;
                    Tcp.Received received = Tcp$Received$.MODULE$.unapply((Tcp.Received)object);
                    ByteString newData = byteString = received._1();
                    ByteString data = this.buffer$1.$plus$plus(newData);
                    int prefixSize = 2;
                    if (data.length() < prefixSize) {
                        this.$outer.context().become(this.$outer.ready(this.connection$1, data));
                        return BoxedUnit.UNIT;
                    }
                    int expectedPayloadLength = TcpDnsClient$.MODULE$.decodeLength(data);
                    if (data.drop(prefixSize).length() < expectedPayloadLength) {
                        this.$outer.context().become(this.$outer.ready(this.connection$1, data));
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$answerRecipient.$bang(this.$outer.org$apache$pekko$io$dns$internal$TcpDnsClient$$parseResponse(data.drop(prefixSize)), this.$outer.self());
                    this.$outer.context().become(this.$outer.ready(this.connection$1, ByteString$.MODULE$.empty()));
                    if (data.length() > prefixSize + expectedPayloadLength) {
                        this.$outer.self().$bang(Tcp$Received$.MODULE$.apply(data.drop(prefixSize + expectedPayloadLength)), this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (Tcp$PeerClosed$.MODULE$.equals(object)) {
                    this.$outer.context().unwatch(this.connection$1);
                    this.$outer.context().become(this.$outer.idle());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    ActorRef actorRef2 = this.connection$1;
                    ActorRef actorRef3 = actorRef;
                    if (!(actorRef2 != null ? !((Object)actorRef2).equals(actorRef3) : actorRef3 != null)) {
                        TcpDnsClient$.MODULE$.throwFailure("TCP connection terminated without closing (register timeout?)", (Option<Throwable>)None$.MODULE$);
                        return BoxedUnit.UNIT;
                    }
                }
                return function1.apply(x);
            }
        };
    }

    public ByteString ready$default$2() {
        return ByteString$.MODULE$.empty();
    }

    public DnsClient.Answer org$apache$pekko$io$dns$internal$TcpDnsClient$$parseResponse(ByteString data) {
        Message msg = Message$.MODULE$.parse(data);
        this.log().debug("Decoded TCP DNS response [{}]", msg);
        if (MessageFlags$.MODULE$.isTruncated$extension(msg.flags())) {
            this.log().warning("TCP DNS response truncated");
        }
        Enumeration.Value value = MessageFlags$.MODULE$.responseCode$extension(msg.flags());
        Enumeration.Value value2 = ResponseCode$.MODULE$.SUCCESS();
        Tuple2 tuple2 = !(value != null ? !value.equals(value2) : value2 != null) ? Tuple2$.MODULE$.apply(msg.answerRecs(), msg.additionalRecs()) : Tuple2$.MODULE$.apply((Object)package$.MODULE$.Nil(), (Object)package$.MODULE$.Nil());
        Seq recs = (Seq)tuple2._1();
        Seq additionalRecs = (Seq)tuple2._2();
        return DnsClient$Answer$.MODULE$.apply(msg.id(), (Seq<ResourceRecord>)recs, (Seq<ResourceRecord>)additionalRecs);
    }
}

