/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.pattern.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.OneForOneStrategy;
import org.apache.pekko.actor.OneForOneStrategy$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.SupervisorStrategy$Escalate$;
import org.apache.pekko.actor.SupervisorStrategy$Restart$;
import org.apache.pekko.actor.SupervisorStrategy$Stop$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.BackoffReset;
import org.apache.pekko.pattern.BackoffSupervisor$;
import org.apache.pekko.pattern.BackoffSupervisor$ResetRestartCount$;
import org.apache.pekko.pattern.BackoffSupervisor$StartChild$;
import org.apache.pekko.pattern.ForwardDeathLetters$;
import org.apache.pekko.pattern.ForwardTo;
import org.apache.pekko.pattern.ForwardTo$;
import org.apache.pekko.pattern.HandleBackoff;
import org.apache.pekko.pattern.HandlingWhileStopped;
import org.apache.pekko.pattern.ReplyWith;
import org.apache.pekko.pattern.ReplyWith$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;

@InternalApi
public class BackoffOnRestartSupervisor
implements Actor,
HandleBackoff,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private Option child;
    private int restartCount;
    private boolean finalStopMessageReceived;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final Props childProps;
    private final String childName;
    public final FiniteDuration org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$minBackoff;
    public final FiniteDuration org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$maxBackoff;
    private final BackoffReset reset;
    public final double org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$randomFactor;
    public final OneForOneStrategy org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$strategy;
    private final HandlingWhileStopped handlingWhileStopped;
    private final OneForOneStrategy supervisorStrategy;

    public BackoffOnRestartSupervisor(Props childProps, String childName, FiniteDuration minBackoff, FiniteDuration maxBackoff, BackoffReset reset, double randomFactor, OneForOneStrategy strategy, HandlingWhileStopped handlingWhileStopped) {
        this.childProps = childProps;
        this.childName = childName;
        this.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$minBackoff = minBackoff;
        this.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$maxBackoff = maxBackoff;
        this.reset = reset;
        this.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$randomFactor = randomFactor;
        this.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$strategy = strategy;
        this.handlingWhileStopped = handlingWhileStopped;
        Actor.$init$(this);
        HandleBackoff.$init$(this);
        ActorLogging.$init$(this);
        PartialFunction<Throwable, SupervisorStrategy.Directive> decider = Actor.supervisorStrategy$(this).decider();
        this.supervisorStrategy = OneForOneStrategy$.MODULE$.apply(strategy.maxNrOfRetries(), strategy.withinTimeRange(), strategy.loggingEnabled(), (PartialFunction<Throwable, SupervisorStrategy.Directive>)new Serializable(decider, this){
            private final PartialFunction decider$1;
            private final /* synthetic */ BackoffOnRestartSupervisor $outer;
            {
                this.decider$1 = decider$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                SupervisorStrategy.Directive defaultDirective = (SupervisorStrategy.Directive)this.decider$1.applyOrElse((Object)ex, BackoffOnRestartSupervisor::org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$_$$anonfun$1);
                SupervisorStrategy.Directive directive = (SupervisorStrategy.Directive)this.$outer.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$strategy.decider().applyOrElse((Object)ex, arg_0 -> BackoffOnRestartSupervisor.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$applyOrElse$$anonfun$1(defaultDirective, arg_0));
                if (SupervisorStrategy$Restart$.MODULE$.equals(directive)) {
                    int nextRestartCount = this.$outer.restartCount() + 1;
                    if (this.$outer.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$strategy.withinTimeRange().isFinite() && this.$outer.restartCount() == 0) {
                        FiniteDuration finiteWithinTimeRange = (FiniteDuration)this.$outer.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$strategy.withinTimeRange();
                        this.$outer.context().system().scheduler().scheduleOnce(finiteWithinTimeRange, this.$outer.self(), (Object)BackoffSupervisor$ResetRestartCount$.MODULE$.apply(nextRestartCount), (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self());
                    }
                    ActorRef childRef = this.$outer.sender();
                    if (this.$outer.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$strategy.maxNrOfRetries() >= 0 && nextRestartCount > this.$outer.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$strategy.maxNrOfRetries()) {
                        this.$outer.log().debug("Terminating on restart #{} which exceeds max allowed restarts ({})", BoxesRunTime.boxToInteger((int)nextRestartCount), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$strategy.maxNrOfRetries()));
                        this.$outer.context().become(this.$outer.receive());
                        this.$outer.context().stop(this.$outer.self());
                    } else {
                        this.$outer.context().become((PartialFunction<Object, BoxedUnit>)this.$outer.waitChildTerminatedBeforeBackoff(childRef).orElse(this.$outer.handleBackoff()));
                    }
                    return SupervisorStrategy$Stop$.MODULE$;
                }
                SupervisorStrategy.Directive other = directive;
                return other;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$_$$anonfun$1(java.lang.Object ), org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$applyOrElse$$anonfun$1(org.apache.pekko.actor.SupervisorStrategy$Directive java.lang.Object )}, serializedLambda);
            }
        });
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Option child() {
        return this.child;
    }

    @Override
    public int restartCount() {
        return this.restartCount;
    }

    @Override
    public boolean finalStopMessageReceived() {
        return this.finalStopMessageReceived;
    }

    public void child_$eq(Option x$1) {
        this.child = x$1;
    }

    @Override
    public void restartCount_$eq(int x$1) {
        this.restartCount = x$1;
    }

    @Override
    public void finalStopMessageReceived_$eq(boolean x$1) {
        this.finalStopMessageReceived = x$1;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public Props childProps() {
        return this.childProps;
    }

    @Override
    public String childName() {
        return this.childName;
    }

    @Override
    public BackoffReset reset() {
        return this.reset;
    }

    @Override
    public OneForOneStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    public PartialFunction<Object, BoxedUnit> waitChildTerminatedBeforeBackoff(ActorRef childRef) {
        return new Serializable(childRef, this){
            private final ActorRef childRef$1;
            private final /* synthetic */ BackoffOnRestartSupervisor $outer;
            {
                this.childRef$1 = childRef$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    ActorRef actorRef2 = this.childRef$1;
                    ActorRef actorRef3 = actorRef;
                    if (!(actorRef2 != null ? !((Object)actorRef2).equals(actorRef3) : actorRef3 != null)) {
                        return true;
                    }
                }
                return BackoffSupervisor$StartChild$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Terminated) {
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef actorRef = terminated._1();
                    ActorRef actorRef2 = this.childRef$1;
                    ActorRef actorRef3 = actorRef;
                    if (!(actorRef2 != null ? !((Object)actorRef2).equals(actorRef3) : actorRef3 != null)) {
                        this.$outer.context().become(this.$outer.receive());
                        this.$outer.child_$eq((Option)None$.MODULE$);
                        FiniteDuration restartDelay = BackoffSupervisor$.MODULE$.calculateDelay(this.$outer.restartCount(), this.$outer.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$minBackoff, this.$outer.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$maxBackoff, this.$outer.org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$randomFactor);
                        this.$outer.context().system().scheduler().scheduleOnce(restartDelay, this.$outer.self(), (Object)BackoffSupervisor$StartChild$.MODULE$, (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self());
                        this.$outer.restartCount_$eq(this.$outer.restartCount() + 1);
                        return BoxedUnit.UNIT;
                    }
                }
                if (BackoffSupervisor$StartChild$.MODULE$.equals(object)) {
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> onTerminated() {
        return new Serializable(this){
            private final /* synthetic */ BackoffOnRestartSupervisor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef c = actorRef = terminated._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef c = actorRef = terminated._1();
                    this.$outer.log().debug(new StringBuilder(47).append("Terminating, because child [").append(c).append("] terminated itself").toString());
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return this.onTerminated().orElse(this.handleBackoff());
    }

    @Override
    public void handleMessageToChild(Object msg) {
        Option option = this.child();
        if (option instanceof Some) {
            ActorRef c = (ActorRef)((Some)option).value();
            c.forward(msg, this.context());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            HandlingWhileStopped handlingWhileStopped = this.handlingWhileStopped;
            if (ForwardDeathLetters$.MODULE$.equals(handlingWhileStopped)) {
                this.context().system().deadLetters().forward(msg, this.context());
                return;
            }
            if (handlingWhileStopped instanceof ForwardTo) {
                ActorRef actorRef;
                ForwardTo forwardTo = ForwardTo$.MODULE$.unapply((ForwardTo)handlingWhileStopped);
                ActorRef h = actorRef = forwardTo._1();
                h.forward(msg, this.context());
                return;
            }
            if (handlingWhileStopped instanceof ReplyWith) {
                Object object;
                ReplyWith replyWith = ReplyWith$.MODULE$.unapply((ReplyWith)handlingWhileStopped);
                Object r = object = replyWith._1();
                this.sender().$bang(r, this.self());
                return;
            }
            throw new MatchError((Object)handlingWhileStopped);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ SupervisorStrategy.Directive org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$_$$anonfun$1(Object _$1) {
        return SupervisorStrategy$Escalate$.MODULE$;
    }

    public static final /* synthetic */ SupervisorStrategy.Directive org$apache$pekko$pattern$internal$BackoffOnRestartSupervisor$$anon$1$$_$applyOrElse$$anonfun$1(SupervisorStrategy.Directive defaultDirective$1, Object _$2) {
        return defaultDirective$1;
    }
}

