/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.routing.BroadcastPool$;
import org.apache.pekko.routing.BroadcastRoutingLogic$;
import org.apache.pekko.routing.PoolOverrideUnsetConfig;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.Resizer$;
import org.apache.pekko.routing.Router;
import org.apache.pekko.routing.RouterConfig;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BroadcastPool
implements PoolOverrideUnsetConfig<BroadcastPool>,
Product {
    private static final long serialVersionUID = 1L;
    private final int nrOfInstances;
    private final Option resizer;
    private final SupervisorStrategy supervisorStrategy;
    private final String routerDispatcher;
    private final boolean usePoolDispatcher;

    public static BroadcastPool apply(int n, Option<Resizer> option, SupervisorStrategy supervisorStrategy, String string, boolean bl) {
        return BroadcastPool$.MODULE$.apply(n, option, supervisorStrategy, string, bl);
    }

    public static BroadcastPool fromProduct(Product product) {
        return BroadcastPool$.MODULE$.fromProduct(product);
    }

    public static BroadcastPool unapply(BroadcastPool broadcastPool) {
        return BroadcastPool$.MODULE$.unapply(broadcastPool);
    }

    public static Option<Resizer> $lessinit$greater$default$2() {
        return BroadcastPool$.MODULE$.$lessinit$greater$default$2();
    }

    public static SupervisorStrategy $lessinit$greater$default$3() {
        return BroadcastPool$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$4() {
        return BroadcastPool$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$5() {
        return BroadcastPool$.MODULE$.$lessinit$greater$default$5();
    }

    public BroadcastPool(int nrOfInstances, Option<Resizer> resizer, SupervisorStrategy supervisorStrategy, String routerDispatcher, boolean usePoolDispatcher) {
        this.nrOfInstances = nrOfInstances;
        this.resizer = resizer;
        this.supervisorStrategy = supervisorStrategy;
        this.routerDispatcher = routerDispatcher;
        this.usePoolDispatcher = usePoolDispatcher;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.nrOfInstances());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.resizer()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.supervisorStrategy()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.routerDispatcher()));
        n = Statics.mix((int)n, (int)(this.usePoolDispatcher() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BroadcastPool)) return false;
        BroadcastPool broadcastPool = (BroadcastPool)object;
        if (this.nrOfInstances() != broadcastPool.nrOfInstances()) return false;
        if (this.usePoolDispatcher() != broadcastPool.usePoolDispatcher()) return false;
        Option<Resizer> option = this.resizer();
        Option<Resizer> option2 = broadcastPool.resizer();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        SupervisorStrategy supervisorStrategy = this.supervisorStrategy();
        SupervisorStrategy supervisorStrategy2 = broadcastPool.supervisorStrategy();
        if (supervisorStrategy == null) {
            if (supervisorStrategy2 != null) {
                return false;
            }
        } else if (!supervisorStrategy.equals(supervisorStrategy2)) return false;
        String string = this.routerDispatcher();
        String string2 = broadcastPool.routerDispatcher();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BroadcastPool;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "BroadcastPool";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this._5());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "nrOfInstances";
            }
            case 1: {
                return "resizer";
            }
            case 2: {
                return "supervisorStrategy";
            }
            case 3: {
                return "routerDispatcher";
            }
            case 4: {
                return "usePoolDispatcher";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int nrOfInstances() {
        return this.nrOfInstances;
    }

    @Override
    public Option<Resizer> resizer() {
        return this.resizer;
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    @Override
    public String routerDispatcher() {
        return this.routerDispatcher;
    }

    @Override
    public boolean usePoolDispatcher() {
        return this.usePoolDispatcher;
    }

    public BroadcastPool(Config config) {
        int n = config.getInt("nr-of-instances");
        Option<Resizer> option = Resizer$.MODULE$.fromConfig(config);
        boolean bl = config.hasPath("pool-dispatcher");
        SupervisorStrategy supervisorStrategy = BroadcastPool$.MODULE$.$lessinit$greater$default$3();
        String string = BroadcastPool$.MODULE$.$lessinit$greater$default$4();
        this(n, option, supervisorStrategy, string, bl);
    }

    public BroadcastPool(int nr) {
        this(nr, BroadcastPool$.MODULE$.$lessinit$greater$default$2(), BroadcastPool$.MODULE$.$lessinit$greater$default$3(), BroadcastPool$.MODULE$.$lessinit$greater$default$4(), BroadcastPool$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public Router createRouter(ActorSystem system) {
        return new Router(BroadcastRoutingLogic$.MODULE$.apply());
    }

    @Override
    public int nrOfInstances(ActorSystem sys) {
        return this.nrOfInstances();
    }

    @Override
    public BroadcastPool withSupervisorStrategy(SupervisorStrategy strategy) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), strategy, this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public BroadcastPool withResizer(Resizer resizer) {
        Some some = Some$.MODULE$.apply((Object)resizer);
        int n = this.copy$default$1();
        SupervisorStrategy supervisorStrategy = this.copy$default$3();
        String string = this.copy$default$4();
        boolean bl = this.copy$default$5();
        return this.copy(n, (Option<Resizer>)some, supervisorStrategy, string, bl);
    }

    public BroadcastPool withDispatcher(String dispatcherId) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), dispatcherId, this.copy$default$5());
    }

    @Override
    public RouterConfig withFallback(RouterConfig other) {
        return this.overrideUnsetConfig(other);
    }

    public BroadcastPool copy(int nrOfInstances, Option<Resizer> resizer, SupervisorStrategy supervisorStrategy, String routerDispatcher, boolean usePoolDispatcher) {
        return new BroadcastPool(nrOfInstances, resizer, supervisorStrategy, routerDispatcher, usePoolDispatcher);
    }

    public int copy$default$1() {
        return this.nrOfInstances();
    }

    public Option<Resizer> copy$default$2() {
        return this.resizer();
    }

    public SupervisorStrategy copy$default$3() {
        return this.supervisorStrategy();
    }

    public String copy$default$4() {
        return this.routerDispatcher();
    }

    public boolean copy$default$5() {
        return this.usePoolDispatcher();
    }

    public int _1() {
        return this.nrOfInstances();
    }

    public Option<Resizer> _2() {
        return this.resizer();
    }

    public SupervisorStrategy _3() {
        return this.supervisorStrategy();
    }

    public String _4() {
        return this.routerDispatcher();
    }

    public boolean _5() {
        return this.usePoolDispatcher();
    }
}

