/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.routing.ConsistentHashingPool$;
import org.apache.pekko.routing.ConsistentHashingRouter;
import org.apache.pekko.routing.ConsistentHashingRouter$;
import org.apache.pekko.routing.ConsistentHashingRoutingLogic$;
import org.apache.pekko.routing.FromConfig;
import org.apache.pekko.routing.NoRouter;
import org.apache.pekko.routing.PoolOverrideUnsetConfig;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.Resizer$;
import org.apache.pekko.routing.Router;
import org.apache.pekko.routing.RouterConfig;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ConsistentHashingPool
implements PoolOverrideUnsetConfig<ConsistentHashingPool>,
Product {
    private static final long serialVersionUID = 1L;
    private final int nrOfInstances;
    private final Option resizer;
    private final int virtualNodesFactor;
    private final PartialFunction hashMapping;
    private final SupervisorStrategy supervisorStrategy;
    private final String routerDispatcher;
    private final boolean usePoolDispatcher;

    public static ConsistentHashingPool apply(int n, Option<Resizer> option, int n2, PartialFunction<Object, Object> partialFunction, SupervisorStrategy supervisorStrategy, String string, boolean bl) {
        return ConsistentHashingPool$.MODULE$.apply(n, option, n2, partialFunction, supervisorStrategy, string, bl);
    }

    public static ConsistentHashingPool fromProduct(Product product) {
        return ConsistentHashingPool$.MODULE$.fromProduct(product);
    }

    public static ConsistentHashingPool unapply(ConsistentHashingPool consistentHashingPool) {
        return ConsistentHashingPool$.MODULE$.unapply(consistentHashingPool);
    }

    public static Option<Resizer> $lessinit$greater$default$2() {
        return ConsistentHashingPool$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$3() {
        return ConsistentHashingPool$.MODULE$.$lessinit$greater$default$3();
    }

    public static PartialFunction<Object, Object> $lessinit$greater$default$4() {
        return ConsistentHashingPool$.MODULE$.$lessinit$greater$default$4();
    }

    public static SupervisorStrategy $lessinit$greater$default$5() {
        return ConsistentHashingPool$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$6() {
        return ConsistentHashingPool$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$7() {
        return ConsistentHashingPool$.MODULE$.$lessinit$greater$default$7();
    }

    public ConsistentHashingPool(int nrOfInstances, Option<Resizer> resizer, int virtualNodesFactor, PartialFunction<Object, Object> hashMapping, SupervisorStrategy supervisorStrategy, String routerDispatcher, boolean usePoolDispatcher) {
        this.nrOfInstances = nrOfInstances;
        this.resizer = resizer;
        this.virtualNodesFactor = virtualNodesFactor;
        this.hashMapping = hashMapping;
        this.supervisorStrategy = supervisorStrategy;
        this.routerDispatcher = routerDispatcher;
        this.usePoolDispatcher = usePoolDispatcher;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.nrOfInstances());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.resizer()));
        n = Statics.mix((int)n, (int)this.virtualNodesFactor());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.hashMapping()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.supervisorStrategy()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.routerDispatcher()));
        n = Statics.mix((int)n, (int)(this.usePoolDispatcher() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ConsistentHashingPool)) return false;
        ConsistentHashingPool consistentHashingPool = (ConsistentHashingPool)object;
        if (this.nrOfInstances() != consistentHashingPool.nrOfInstances()) return false;
        if (this.virtualNodesFactor() != consistentHashingPool.virtualNodesFactor()) return false;
        if (this.usePoolDispatcher() != consistentHashingPool.usePoolDispatcher()) return false;
        Option<Resizer> option = this.resizer();
        Option<Resizer> option2 = consistentHashingPool.resizer();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        PartialFunction<Object, Object> partialFunction = this.hashMapping();
        PartialFunction<Object, Object> partialFunction2 = consistentHashingPool.hashMapping();
        if (partialFunction == null) {
            if (partialFunction2 != null) {
                return false;
            }
        } else if (!partialFunction.equals(partialFunction2)) return false;
        SupervisorStrategy supervisorStrategy = this.supervisorStrategy();
        SupervisorStrategy supervisorStrategy2 = consistentHashingPool.supervisorStrategy();
        if (supervisorStrategy == null) {
            if (supervisorStrategy2 != null) {
                return false;
            }
        } else if (!supervisorStrategy.equals(supervisorStrategy2)) return false;
        String string = this.routerDispatcher();
        String string2 = consistentHashingPool.routerDispatcher();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ConsistentHashingPool;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "ConsistentHashingPool";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return BoxesRunTime.boxToBoolean((boolean)this._7());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "nrOfInstances";
            }
            case 1: {
                return "resizer";
            }
            case 2: {
                return "virtualNodesFactor";
            }
            case 3: {
                return "hashMapping";
            }
            case 4: {
                return "supervisorStrategy";
            }
            case 5: {
                return "routerDispatcher";
            }
            case 6: {
                return "usePoolDispatcher";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int nrOfInstances() {
        return this.nrOfInstances;
    }

    @Override
    public Option<Resizer> resizer() {
        return this.resizer;
    }

    public int virtualNodesFactor() {
        return this.virtualNodesFactor;
    }

    public PartialFunction<Object, Object> hashMapping() {
        return this.hashMapping;
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    @Override
    public String routerDispatcher() {
        return this.routerDispatcher;
    }

    @Override
    public boolean usePoolDispatcher() {
        return this.usePoolDispatcher;
    }

    public ConsistentHashingPool(Config config) {
        int n = config.getInt("nr-of-instances");
        Option<Resizer> option = Resizer$.MODULE$.fromConfig(config);
        boolean bl = config.hasPath("pool-dispatcher");
        int n2 = ConsistentHashingPool$.MODULE$.$lessinit$greater$default$3();
        PartialFunction<Object, Object> partialFunction = ConsistentHashingPool$.MODULE$.$lessinit$greater$default$4();
        SupervisorStrategy supervisorStrategy = ConsistentHashingPool$.MODULE$.$lessinit$greater$default$5();
        String string = ConsistentHashingPool$.MODULE$.$lessinit$greater$default$6();
        this(n, option, n2, partialFunction, supervisorStrategy, string, bl);
    }

    public ConsistentHashingPool(int nr) {
        this(nr, ConsistentHashingPool$.MODULE$.$lessinit$greater$default$2(), ConsistentHashingPool$.MODULE$.$lessinit$greater$default$3(), ConsistentHashingPool$.MODULE$.$lessinit$greater$default$4(), ConsistentHashingPool$.MODULE$.$lessinit$greater$default$5(), ConsistentHashingPool$.MODULE$.$lessinit$greater$default$6(), ConsistentHashingPool$.MODULE$.$lessinit$greater$default$7());
    }

    @Override
    public Router createRouter(ActorSystem system) {
        return new Router(ConsistentHashingRoutingLogic$.MODULE$.apply(system, this.virtualNodesFactor(), this.hashMapping()));
    }

    @Override
    public int nrOfInstances(ActorSystem sys) {
        return this.nrOfInstances();
    }

    @Override
    public ConsistentHashingPool withSupervisorStrategy(SupervisorStrategy strategy) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), strategy, this.copy$default$6(), this.copy$default$7());
    }

    @Override
    public ConsistentHashingPool withResizer(Resizer resizer) {
        Some some = Some$.MODULE$.apply((Object)resizer);
        int n = this.copy$default$1();
        int n2 = this.copy$default$3();
        PartialFunction<Object, Object> partialFunction = this.copy$default$4();
        SupervisorStrategy supervisorStrategy = this.copy$default$5();
        String string = this.copy$default$6();
        boolean bl = this.copy$default$7();
        return this.copy(n, (Option<Resizer>)some, n2, partialFunction, supervisorStrategy, string, bl);
    }

    public ConsistentHashingPool withDispatcher(String dispatcherId) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), dispatcherId, this.copy$default$7());
    }

    public ConsistentHashingPool withVirtualNodesFactor(int vnodes) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), vnodes, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public ConsistentHashingPool withHashMapper(ConsistentHashingRouter.ConsistentHashMapper mapper) {
        PartialFunction<Object, Object> partialFunction = ConsistentHashingRouter$.MODULE$.hashMappingAdapter(mapper);
        int n = this.copy$default$1();
        Option<Resizer> option = this.copy$default$2();
        int n2 = this.copy$default$3();
        SupervisorStrategy supervisorStrategy = this.copy$default$5();
        String string = this.copy$default$6();
        boolean bl = this.copy$default$7();
        return this.copy(n, option, n2, partialFunction, supervisorStrategy, string, bl);
    }

    @Override
    public RouterConfig withFallback(RouterConfig other) {
        RouterConfig routerConfig = other;
        if (routerConfig instanceof FromConfig || routerConfig instanceof NoRouter) {
            return this.overrideUnsetConfig(other);
        }
        if (routerConfig instanceof ConsistentHashingPool) {
            ConsistentHashingPool otherRouter = (ConsistentHashingPool)routerConfig;
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), otherRouter.hashMapping(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7()).overrideUnsetConfig(other);
        }
        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected ConsistentHashingPool, got [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{other})));
    }

    public ConsistentHashingPool copy(int nrOfInstances, Option<Resizer> resizer, int virtualNodesFactor, PartialFunction<Object, Object> hashMapping, SupervisorStrategy supervisorStrategy, String routerDispatcher, boolean usePoolDispatcher) {
        return new ConsistentHashingPool(nrOfInstances, resizer, virtualNodesFactor, hashMapping, supervisorStrategy, routerDispatcher, usePoolDispatcher);
    }

    public int copy$default$1() {
        return this.nrOfInstances();
    }

    public Option<Resizer> copy$default$2() {
        return this.resizer();
    }

    public int copy$default$3() {
        return this.virtualNodesFactor();
    }

    public PartialFunction<Object, Object> copy$default$4() {
        return this.hashMapping();
    }

    public SupervisorStrategy copy$default$5() {
        return this.supervisorStrategy();
    }

    public String copy$default$6() {
        return this.routerDispatcher();
    }

    public boolean copy$default$7() {
        return this.usePoolDispatcher();
    }

    public int _1() {
        return this.nrOfInstances();
    }

    public Option<Resizer> _2() {
        return this.resizer();
    }

    public int _3() {
        return this.virtualNodesFactor();
    }

    public PartialFunction<Object, Object> _4() {
        return this.hashMapping();
    }

    public SupervisorStrategy _5() {
        return this.supervisorStrategy();
    }

    public String _6() {
        return this.routerDispatcher();
    }

    public boolean _7() {
        return this.usePoolDispatcher();
    }
}

