/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.routing.ConsistentHash;
import org.apache.pekko.routing.ConsistentHash$;
import org.apache.pekko.routing.ConsistentHashingRouter;
import org.apache.pekko.routing.ConsistentHashingRouter$;
import org.apache.pekko.routing.ConsistentHashingRouter$emptyConsistentHashMapping$;
import org.apache.pekko.routing.ConsistentHashingRoutingLogic$;
import org.apache.pekko.routing.ConsistentRoutee;
import org.apache.pekko.routing.ConsistentRoutee$;
import org.apache.pekko.routing.NoRoutee$;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.RoutingLogic;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public final class ConsistentHashingRoutingLogic
implements RoutingLogic,
Product,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ConsistentHashingRoutingLogic.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConsistentHashingRoutingLogic.class.getDeclaredField("selfAddress$lzy1"));
    private final ActorSystem system;
    private final int virtualNodesFactor;
    private final PartialFunction hashMapping;
    private volatile Object selfAddress$lzy1;
    private final int vnodes;
    private volatile Object log$lzy1;
    private final AtomicReference<Tuple2<IndexedSeq<Routee>, ConsistentHash<ConsistentRoutee>>> consistentHashRef;

    public static ConsistentHashingRoutingLogic apply(ActorSystem actorSystem, int n, PartialFunction<Object, Object> partialFunction) {
        return ConsistentHashingRoutingLogic$.MODULE$.apply(actorSystem, n, partialFunction);
    }

    public static Address defaultAddress(ActorSystem actorSystem) {
        return ConsistentHashingRoutingLogic$.MODULE$.defaultAddress(actorSystem);
    }

    public static ConsistentHashingRoutingLogic fromProduct(Product product) {
        return ConsistentHashingRoutingLogic$.MODULE$.fromProduct(product);
    }

    public static ConsistentHashingRoutingLogic unapply(ConsistentHashingRoutingLogic consistentHashingRoutingLogic) {
        return ConsistentHashingRoutingLogic$.MODULE$.unapply(consistentHashingRoutingLogic);
    }

    public static int $lessinit$greater$default$2() {
        return ConsistentHashingRoutingLogic$.MODULE$.$lessinit$greater$default$2();
    }

    public static PartialFunction<Object, Object> $lessinit$greater$default$3() {
        return ConsistentHashingRoutingLogic$.MODULE$.$lessinit$greater$default$3();
    }

    public ConsistentHashingRoutingLogic(ActorSystem system, int virtualNodesFactor, PartialFunction<Object, Object> hashMapping) {
        this.system = system;
        this.virtualNodesFactor = virtualNodesFactor;
        this.hashMapping = hashMapping;
        this.vnodes = virtualNodesFactor == 0 ? system.settings().DefaultVirtualNodesFactor() : virtualNodesFactor;
        this.consistentHashRef = new AtomicReference<Tuple2>(Tuple2$.MODULE$.apply(null, null));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.system()));
        n = Statics.mix((int)n, (int)this.virtualNodesFactor());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.hashMapping()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ConsistentHashingRoutingLogic)) return false;
        ConsistentHashingRoutingLogic consistentHashingRoutingLogic = (ConsistentHashingRoutingLogic)object;
        if (this.virtualNodesFactor() != consistentHashingRoutingLogic.virtualNodesFactor()) return false;
        ActorSystem actorSystem = this.system();
        ActorSystem actorSystem2 = consistentHashingRoutingLogic.system();
        if (actorSystem == null) {
            if (actorSystem2 != null) {
                return false;
            }
        } else if (!actorSystem.equals(actorSystem2)) return false;
        PartialFunction<Object, Object> partialFunction = this.hashMapping();
        PartialFunction<Object, Object> partialFunction2 = consistentHashingRoutingLogic.hashMapping();
        if (partialFunction == null) {
            if (partialFunction2 == null) return true;
            return false;
        } else {
            if (!partialFunction.equals(partialFunction2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ConsistentHashingRoutingLogic;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "ConsistentHashingRoutingLogic";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "system";
            }
            case 1: {
                return "virtualNodesFactor";
            }
            case 2: {
                return "hashMapping";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ActorSystem system() {
        return this.system;
    }

    public int virtualNodesFactor() {
        return this.virtualNodesFactor;
    }

    public PartialFunction<Object, Object> hashMapping() {
        return this.hashMapping;
    }

    public ConsistentHashingRoutingLogic(ActorSystem system) {
        this(system, 0, ConsistentHashingRouter$emptyConsistentHashMapping$.MODULE$);
    }

    private Address selfAddress() {
        Object object = this.selfAddress$lzy1;
        if (object instanceof Address) {
            return (Address)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Address)this.selfAddress$lzyINIT1();
    }

    private Object selfAddress$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.selfAddress$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Address address = null;
                    try {
                        Address a = ConsistentHashingRoutingLogic$.MODULE$.defaultAddress(this.system());
                        if (a == null) {
                            throw new IllegalStateException("defaultAddress not available yet");
                        }
                        address = a;
                        object2 = address == null ? LazyVals.NullValue$.MODULE$ : address;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.selfAddress$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return address;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int vnodes() {
        return this.vnodes;
    }

    private LoggingAdapter log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingAdapter) {
            return (LoggingAdapter)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingAdapter)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingAdapter loggingAdapter = null;
                    try {
                        loggingAdapter = Logging$.MODULE$.apply(this.system(), ConsistentHashingRoutingLogic.class, LogSource$.MODULE$.fromAnyClass());
                        object2 = loggingAdapter == null ? LazyVals.NullValue$.MODULE$ : loggingAdapter;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingAdapter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ConsistentHashingRoutingLogic withVirtualNodesFactor(int vnodes) {
        return this.copy(this.copy$default$1(), vnodes, this.copy$default$3());
    }

    public ConsistentHashingRoutingLogic withHashMapper(ConsistentHashingRouter.ConsistentHashMapper mapper) {
        PartialFunction<Object, Object> partialFunction = ConsistentHashingRouter$.MODULE$.hashMappingAdapter(mapper);
        ActorSystem actorSystem = this.copy$default$1();
        int n = this.copy$default$2();
        return this.copy(actorSystem, n, partialFunction);
    }

    @Override
    public Routee select(Object message, IndexedSeq<Routee> routees) {
        if (routees.isEmpty()) {
            return NoRoutee$.MODULE$;
        }
        Object object = message;
        if (this.hashMapping().isDefinedAt(message)) {
            return this.target$1(routees, this.hashMapping().apply(message));
        }
        if (object instanceof ConsistentHashingRouter.ConsistentHashable) {
            ConsistentHashingRouter.ConsistentHashable hashable = (ConsistentHashingRouter.ConsistentHashable)object;
            return this.target$1(routees, hashable.consistentHashKey());
        }
        this.log().warning("Message [{}] must be handled by hashMapping, or implement [{}] or be wrapped in [{}]", (Object)message.getClass().getName(), (Object)ConsistentHashingRouter.ConsistentHashable.class.getName(), (Object)ConsistentHashingRouter.ConsistentHashableEnvelope.class.getName());
        return NoRoutee$.MODULE$;
    }

    public ConsistentHashingRoutingLogic copy(ActorSystem system, int virtualNodesFactor, PartialFunction<Object, Object> hashMapping) {
        return new ConsistentHashingRoutingLogic(system, virtualNodesFactor, hashMapping);
    }

    public ActorSystem copy$default$1() {
        return this.system();
    }

    public int copy$default$2() {
        return this.virtualNodesFactor();
    }

    public PartialFunction<Object, Object> copy$default$3() {
        return this.hashMapping();
    }

    public ActorSystem _1() {
        return this.system();
    }

    public int _2() {
        return this.virtualNodesFactor();
    }

    public PartialFunction<Object, Object> _3() {
        return this.hashMapping();
    }

    private final ConsistentHash updateConsistentHash$1(IndexedSeq routees$1) {
        Tuple2<IndexedSeq<Routee>, ConsistentHash<ConsistentRoutee>> oldConsistentHashTuple = this.consistentHashRef.get();
        Tuple2<IndexedSeq<Routee>, ConsistentHash<ConsistentRoutee>> tuple2 = oldConsistentHashTuple;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        IndexedSeq oldRoutees = (IndexedSeq)tuple2._1();
        ConsistentHash oldConsistentHash = (ConsistentHash)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)oldRoutees, (Object)oldConsistentHash);
        IndexedSeq oldRoutees2 = (IndexedSeq)tuple22._1();
        ConsistentHash oldConsistentHash2 = (ConsistentHash)tuple22._2();
        if (routees$1 != oldRoutees2) {
            IndexedSeq indexedSeq = routees$1;
            IndexedSeq indexedSeq2 = oldRoutees2;
            ConsistentHash consistentHash = !(indexedSeq != null ? !indexedSeq.equals(indexedSeq2) : indexedSeq2 != null) ? oldConsistentHash2 : ConsistentHash$.MODULE$.apply((Iterable)routees$1.map((Function1 & Serializable)_$1 -> ConsistentRoutee$.MODULE$.apply((Routee)_$1, this.selfAddress())), this.vnodes(), ClassTag$.MODULE$.apply(ConsistentRoutee.class));
            this.consistentHashRef.compareAndSet(oldConsistentHashTuple, (Tuple2<IndexedSeq<Routee>, ConsistentHash<ConsistentRoutee>>)Tuple2$.MODULE$.apply((Object)routees$1, (Object)consistentHash));
            return consistentHash;
        }
        return oldConsistentHash2;
    }

    private final Routee target$1(IndexedSeq routees$2, Object hashData) {
        Routee routee;
        block7: {
            try {
                ConsistentHash currentConsistenHash = this.updateConsistentHash$1(routees$2);
                if (currentConsistenHash.isEmpty()) {
                    routee = NoRoutee$.MODULE$;
                    break block7;
                }
                Object object = hashData;
                if (object instanceof byte[]) {
                    byte[] bytes = (byte[])object;
                    routee = ((ConsistentRoutee)currentConsistenHash.nodeFor(bytes)).routee();
                    break block7;
                }
                if (object instanceof String) {
                    String str = (String)object;
                    routee = ((ConsistentRoutee)currentConsistenHash.nodeFor(str)).routee();
                    break block7;
                }
                if (object instanceof Object) {
                    Object x = object;
                    routee = ((ConsistentRoutee)currentConsistenHash.nodeFor((byte[])((Serialization)SerializationExtension$.MODULE$.apply(this.system())).serialize(x).get())).routee();
                    break block7;
                }
                Object unexpected = object;
                throw new IllegalArgumentException(new StringBuilder(21).append("Unexpected hashdata: ").append(unexpected).toString());
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.log().warning("Couldn't route message with consistent hash key [{}] due to [{}]", hashData, (Object)e.getMessage());
                    routee = NoRoutee$.MODULE$;
                }
                throw throwable;
            }
        }
        return routee;
    }
}

