/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.apache.pekko.util.ByteIterator$;
import org.apache.pekko.util.ByteIterator$ByteArrayIterator$;
import org.apache.pekko.util.ByteIterator$MultiByteArrayIterator$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteString$ByteString1$;
import org.apache.pekko.util.ByteString$ByteString1C$;
import org.apache.pekko.util.Collections$EmptyImmutableSeq$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BufferedIterator;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public abstract class ByteIterator
implements BufferedIterator<Object> {
    public ByteIterator() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        BufferedIterator.$init$((BufferedIterator)this);
    }

    public abstract int len();

    public abstract byte head();

    public abstract byte next();

    public abstract void clear();

    public ByteIterator $plus$plus(IterableOnce<Object> that) {
        Iterator it = that.iterator();
        if (it.isEmpty()) {
            return this;
        }
        return ByteIterator$ByteArrayIterator$.MODULE$.apply((byte[])it.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public ByteIterator clone() {
        throw new UnsupportedOperationException("Method clone is not implemented in ByteIterator");
    }

    public Tuple2<ByteIterator, ByteIterator> duplicate() {
        return Tuple2$.MODULE$.apply((Object)this, (Object)this.clone());
    }

    public ByteIterator take(int n) {
        throw new UnsupportedOperationException("Method take is not implemented in ByteIterator");
    }

    public ByteIterator drop(int n) {
        throw new UnsupportedOperationException("Method drop is not implemented in ByteIterator");
    }

    public ByteIterator slice(int from, int until) {
        if (from > 0) {
            return this.drop(from).take(until - from);
        }
        return this.take(until);
    }

    public ByteIterator takeWhile(Function1<Object, Object> p) {
        throw new UnsupportedOperationException("Method takeWhile is not implemented in ByteIterator");
    }

    public ByteIterator dropWhile(Function1<Object, Object> p) {
        throw new UnsupportedOperationException("Method dropWhile is not implemented in ByteIterator");
    }

    public Tuple2<ByteIterator, ByteIterator> span(Function1<Object, Object> p) {
        ByteIterator that = this.clone();
        this.takeWhile((Function1)p);
        that.drop(this.len());
        return Tuple2$.MODULE$.apply((Object)this, (Object)that);
    }

    public int indexWhere(Function1<Object, Object> p, int from) {
        int index;
        for (index = 0; index < from && this.hasNext(); ++index) {
            this.next();
        }
        boolean found = false;
        while (!found && this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean((Object)p.apply((Object)BoxesRunTime.boxToByte((byte)this.next())))) {
                found = true;
                continue;
            }
            ++index;
        }
        if (found) {
            return index;
        }
        return -1;
    }

    public int indexWhere$default$2() {
        return 0;
    }

    public int indexOf(byte elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(byte elem, int from) {
        return this.indexWhere((Function1<Object, Object>)(Function1 & Serializable)_$27 -> ByteIterator.indexOf$$anonfun$1(elem, BoxesRunTime.unboxToByte((Object)_$27)), from);
    }

    public <B> int indexOf(B elem) {
        return this.indexOf(elem, 0);
    }

    public <B> int indexOf(B elem, int from) {
        return this.indexWhere((Function1<Object, Object>)(Function1 & Serializable)_$28 -> ByteIterator.indexOf$$anonfun$2(elem, BoxesRunTime.unboxToByte((Object)_$28)), from);
    }

    public abstract ByteString toByteString();

    public ByteString toSeq() {
        return this.toByteString();
    }

    public <U> void foreach(Function1<Object, U> f) {
        while (this.hasNext()) {
            f.apply((Object)BoxesRunTime.boxToByte((byte)this.next()));
        }
    }

    public <B> B foldLeft(B z, Function2<B, Object, B> op) {
        ObjectRef acc = ObjectRef.create(z);
        this.foreach((Function1 & Serializable)v1 -> {
            acc.elem = op.apply(acc.elem, (Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)v1)));
            return BoxedUnit.UNIT;
        });
        return (B)acc.elem;
    }

    public <B> Object toArray(ClassTag<B> arg0) {
        Object target = Arrays$.MODULE$.newGenericArray(this.len(), arg0);
        this.copyToArray(target);
        return target;
    }

    public byte getByte() {
        return this.next();
    }

    public short getShort(ByteOrder byteOrder) {
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            return (short)((this.next() & 0xFF) << 8 | (this.next() & 0xFF) << 0);
        }
        ByteOrder byteOrder4 = byteOrder;
        ByteOrder byteOrder5 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder4 != null ? !byteOrder4.equals(byteOrder5) : byteOrder5 != null)) {
            return (short)((this.next() & 0xFF) << 0 | (this.next() & 0xFF) << 8);
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unknown byte order ").append(byteOrder).toString());
    }

    public int getInt(ByteOrder byteOrder) {
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            return (this.next() & 0xFF) << 24 | (this.next() & 0xFF) << 16 | (this.next() & 0xFF) << 8 | (this.next() & 0xFF) << 0;
        }
        ByteOrder byteOrder4 = byteOrder;
        ByteOrder byteOrder5 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder4 != null ? !byteOrder4.equals(byteOrder5) : byteOrder5 != null)) {
            return (this.next() & 0xFF) << 0 | (this.next() & 0xFF) << 8 | (this.next() & 0xFF) << 16 | (this.next() & 0xFF) << 24;
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unknown byte order ").append(byteOrder).toString());
    }

    public long getLong(ByteOrder byteOrder) {
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            return ((long)this.next() & 0xFFL) << 56 | ((long)this.next() & 0xFFL) << 48 | ((long)this.next() & 0xFFL) << 40 | ((long)this.next() & 0xFFL) << 32 | ((long)this.next() & 0xFFL) << 24 | ((long)this.next() & 0xFFL) << 16 | ((long)this.next() & 0xFFL) << 8 | ((long)this.next() & 0xFFL) << 0;
        }
        ByteOrder byteOrder4 = byteOrder;
        ByteOrder byteOrder5 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder4 != null ? !byteOrder4.equals(byteOrder5) : byteOrder5 != null)) {
            return ((long)this.next() & 0xFFL) << 0 | ((long)this.next() & 0xFFL) << 8 | ((long)this.next() & 0xFFL) << 16 | ((long)this.next() & 0xFFL) << 24 | ((long)this.next() & 0xFFL) << 32 | ((long)this.next() & 0xFFL) << 40 | ((long)this.next() & 0xFFL) << 48 | ((long)this.next() & 0xFFL) << 56;
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unknown byte order ").append(byteOrder).toString());
    }

    public long getLongPart(int n, ByteOrder byteOrder) {
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            LongRef x = LongRef.create((long)0L);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), n).foreach((Function1)(JFunction1.mcVI.sp & Serializable)_$29 -> {
                x$1.elem = x$1.elem << 8 | (long)(this.next() & 0xFF);
            });
            return x.elem;
        }
        ByteOrder byteOrder4 = byteOrder;
        ByteOrder byteOrder5 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder4 != null ? !byteOrder4.equals(byteOrder5) : byteOrder5 != null)) {
            LongRef x = LongRef.create((long)0L);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> x$2.elem |= (long)((this.next() & 0xFF) << 8 * i));
            return x.elem;
        }
        throw new IllegalArgumentException(new StringBuilder(19).append("Unknown byte order ").append(byteOrder).toString());
    }

    public float getFloat(ByteOrder byteOrder) {
        return Float.intBitsToFloat(this.getInt(byteOrder));
    }

    public double getDouble(ByteOrder byteOrder) {
        return Double.longBitsToDouble(this.getLong(byteOrder));
    }

    public ByteIterator getBytes(byte[] xs) {
        return this.getBytes(xs, 0, xs.length);
    }

    public abstract ByteIterator getBytes(byte[] var1, int var2, int var3);

    public byte[] getBytes(int n) {
        byte[] bytes = new byte[n];
        this.getBytes(bytes, 0, n);
        return bytes;
    }

    public ByteString getByteString(int n) {
        ByteString bs = this.clone().take(n).toByteString();
        this.drop(n);
        return bs;
    }

    public ByteIterator getShorts(short[] xs, ByteOrder byteOrder) {
        return this.getShorts(xs, 0, xs.length, byteOrder);
    }

    public abstract ByteIterator getShorts(short[] var1, int var2, int var3, ByteOrder var4);

    public ByteIterator getInts(int[] xs, ByteOrder byteOrder) {
        return this.getInts(xs, 0, xs.length, byteOrder);
    }

    public abstract ByteIterator getInts(int[] var1, int var2, int var3, ByteOrder var4);

    public ByteIterator getLongs(long[] xs, ByteOrder byteOrder) {
        return this.getLongs(xs, 0, xs.length, byteOrder);
    }

    public abstract ByteIterator getLongs(long[] var1, int var2, int var3, ByteOrder var4);

    public ByteIterator getFloats(float[] xs, ByteOrder byteOrder) {
        return this.getFloats(xs, 0, xs.length, byteOrder);
    }

    public abstract ByteIterator getFloats(float[] var1, int var2, int var3, ByteOrder var4);

    public ByteIterator getDoubles(double[] xs, ByteOrder byteOrder) {
        return this.getDoubles(xs, 0, xs.length, byteOrder);
    }

    public abstract ByteIterator getDoubles(double[] var1, int var2, int var3, ByteOrder var4);

    public abstract int copyToBuffer(ByteBuffer var1);

    public abstract InputStream asInputStream();

    private static final /* synthetic */ boolean indexOf$$anonfun$1(byte elem$1, byte _$27) {
        return _$27 == elem$1;
    }

    private static final /* synthetic */ boolean indexOf$$anonfun$2(Object elem$2, byte _$28) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)_$28), (Object)elem$2);
    }

    public static class ByteArrayIterator
    extends ByteIterator {
        private byte[] array;
        private int from;
        private int until;

        public static ByteArrayIterator empty() {
            return ByteIterator$ByteArrayIterator$.MODULE$.empty();
        }

        public ByteArrayIterator(byte[] array, int from, int until) {
            this.array = array;
            this.from = from;
            this.until = until;
        }

        private byte[] array() {
            return this.array;
        }

        private void array_$eq(byte[] x$0) {
            this.array = x$0;
        }

        private int from() {
            return this.from;
        }

        private void from_$eq(int x$0) {
            this.from = x$0;
        }

        private int until() {
            return this.until;
        }

        private void until_$eq(int x$0) {
            this.until = x$0;
        }

        @Override
        public final int len() {
            return this.until() - this.from();
        }

        public final boolean hasNext() {
            return this.from() < this.until();
        }

        @Override
        public final byte head() {
            return this.array()[this.from()];
        }

        @Override
        public final byte next() {
            if (!this.hasNext()) {
                return BoxesRunTime.unboxToByte((Object)Collections$EmptyImmutableSeq$.MODULE$.iterator().next());
            }
            int i = this.from();
            this.from_$eq(this.from() + 1);
            return this.array()[i];
        }

        @Override
        public void clear() {
            this.array_$eq(Array$.MODULE$.emptyByteArray());
            this.from_$eq(0);
            this.until_$eq(this.from());
        }

        @Override
        public final int size() {
            int l = this.len();
            this.clear();
            return l;
        }

        @Override
        public final ByteIterator $plus$plus(IterableOnce<Object> that) {
            IterableOnce<Object> iterableOnce = that;
            if (iterableOnce instanceof ByteIterator) {
                ByteIterator that2 = (ByteIterator)iterableOnce;
                if (that2.isEmpty()) {
                    return this;
                }
                if (this.isEmpty()) {
                    return that2;
                }
                ByteIterator byteIterator = that2;
                if (byteIterator instanceof ByteArrayIterator) {
                    ByteArrayIterator that3 = (ByteArrayIterator)byteIterator;
                    if (this.array() == that3.array() && this.until() == that3.from()) {
                        this.until_$eq(that3.until());
                        that3.clear();
                        return this;
                    }
                    MultiByteArrayIterator result = ByteIterator$MultiByteArrayIterator$.MODULE$.apply((LinearSeq<ByteArrayIterator>)((LinearSeq)new .colon.colon((Object)this, (List)new .colon.colon((Object)that3, (List)Nil$.MODULE$))));
                    this.clear();
                    return result;
                }
                if (byteIterator instanceof MultiByteArrayIterator) {
                    MultiByteArrayIterator that4 = (MultiByteArrayIterator)byteIterator;
                    return that4.$plus$plus$colon(this);
                }
                throw new MatchError((Object)byteIterator);
            }
            return super.$plus$plus(that);
        }

        @Override
        public final ByteArrayIterator clone() {
            return new ByteArrayIterator(this.array(), this.from(), this.until());
        }

        @Override
        public final ByteArrayIterator take(int n) {
            if (n < this.len()) {
                this.until_$eq(n > 0 ? this.from() + n : this.from());
            }
            return this;
        }

        @Override
        public final ByteArrayIterator drop(int n) {
            if (n > 0) {
                this.from_$eq(n < this.len() ? this.from() + n : this.until());
            }
            return this;
        }

        @Override
        public final ByteArrayIterator takeWhile(Function1<Object, Object> p) {
            int prev = this.from();
            this.dropWhile((Function1)p);
            this.until_$eq(this.from());
            this.from_$eq(prev);
            return this;
        }

        @Override
        public final ByteArrayIterator dropWhile(Function1<Object, Object> p) {
            boolean stop = false;
            while (!stop && this.hasNext()) {
                if (BoxesRunTime.unboxToBoolean((Object)p.apply((Object)BoxesRunTime.boxToByte((byte)this.array()[this.from()])))) {
                    this.from_$eq(this.from() + 1);
                    continue;
                }
                stop = true;
            }
            return this;
        }

        @Override
        public <B> int copyToArray(Object xs, int start) {
            return this.copyToArray(xs, start, ScalaRunTime$.MODULE$.array_length(xs));
        }

        @Override
        public <B> int copyToArray(Object xs) {
            return this.copyToArray(xs, 0, ScalaRunTime$.MODULE$.array_length(xs));
        }

        @Override
        public final <B> int copyToArray(Object xs, int start, int len) {
            int n = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(xs) - start), this.len())), len));
            Array$.MODULE$.copy((Object)this.array(), this.from(), xs, start, n);
            this.drop(n);
            return n;
        }

        @Override
        public final ByteString toByteString() {
            ByteString result = this.from() == 0 && this.until() == this.array().length ? ByteString$ByteString1C$.MODULE$.apply(this.array()) : ByteString$ByteString1$.MODULE$.apply(this.array(), this.from(), this.len());
            this.clear();
            return result;
        }

        @Override
        public ByteArrayIterator getBytes(byte[] xs, int offset, int n) throws NoSuchElementException {
            if (n <= this.len()) {
                System.arraycopy(this.array(), this.from(), xs, offset, n);
                return this.drop(n);
            }
            throw new NoSuchElementException("next on empty iterator");
        }

        private ByteBuffer wrappedByteBuffer() {
            return ByteBuffer.wrap(this.array(), this.from(), this.len()).asReadOnlyBuffer();
        }

        @Override
        public ByteArrayIterator getShorts(short[] xs, int offset, int n, ByteOrder byteOrder) {
            this.wrappedByteBuffer().order(byteOrder).asShortBuffer().get(xs, offset, n);
            return this.drop(2 * n);
        }

        @Override
        public ByteArrayIterator getInts(int[] xs, int offset, int n, ByteOrder byteOrder) {
            this.wrappedByteBuffer().order(byteOrder).asIntBuffer().get(xs, offset, n);
            return this.drop(4 * n);
        }

        @Override
        public ByteArrayIterator getLongs(long[] xs, int offset, int n, ByteOrder byteOrder) {
            this.wrappedByteBuffer().order(byteOrder).asLongBuffer().get(xs, offset, n);
            return this.drop(8 * n);
        }

        @Override
        public ByteArrayIterator getFloats(float[] xs, int offset, int n, ByteOrder byteOrder) {
            this.wrappedByteBuffer().order(byteOrder).asFloatBuffer().get(xs, offset, n);
            return this.drop(4 * n);
        }

        @Override
        public ByteArrayIterator getDoubles(double[] xs, int offset, int n, ByteOrder byteOrder) {
            this.wrappedByteBuffer().order(byteOrder).asDoubleBuffer().get(xs, offset, n);
            return this.drop(8 * n);
        }

        @Override
        public int copyToBuffer(ByteBuffer buffer) {
            int copyLength = scala.math.package$.MODULE$.min(buffer.remaining(), this.len());
            if (copyLength > 0) {
                buffer.put(this.array(), this.from(), copyLength);
                this.drop(copyLength);
            }
            return copyLength;
        }

        @Override
        public InputStream asInputStream() {
            return new InputStream(this){
                private final /* synthetic */ ByteArrayIterator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public int available() {
                    return this.$outer.len();
                }

                public int read() {
                    if (this.$outer.hasNext()) {
                        return this.$outer.next() & 0xFF;
                    }
                    return -1;
                }

                public int read(byte[] b, int off, int len) {
                    if (off < 0 || len < 0 || off + len > b.length) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (len == 0) {
                        return 0;
                    }
                    if (!this.$outer.isEmpty()) {
                        int nRead = scala.math.package$.MODULE$.min(this.available(), len);
                        this.$outer.copyToArray(b, off, nRead);
                        return nRead;
                    }
                    return -1;
                }

                public long skip(long n) {
                    int nSkip = scala.math.package$.MODULE$.min(this.$outer.len(), (int)n);
                    this.$outer.drop(nSkip);
                    return Int$.MODULE$.int2long(nSkip);
                }
            };
        }
    }

    public static class MultiByteArrayIterator
    extends ByteIterator {
        private LinearSeq iterators;

        public static MultiByteArrayIterator empty() {
            return ByteIterator$MultiByteArrayIterator$.MODULE$.empty();
        }

        public MultiByteArrayIterator(LinearSeq<ByteArrayIterator> iterators) {
            this.iterators = iterators;
            this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
        }

        private LinearSeq<ByteArrayIterator> iterators() {
            return this.iterators;
        }

        private void iterators_$eq(LinearSeq<ByteArrayIterator> x$0) {
            this.iterators = x$0;
        }

        public MultiByteArrayIterator org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize() {
            this.iterators_$eq((LinearSeq<ByteArrayIterator>)this.norm$1(this.iterators()));
            return this;
        }

        public ByteArrayIterator org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current() {
            return (ByteArrayIterator)this.iterators().head();
        }

        private void dropCurrent() {
            this.iterators_$eq((LinearSeq<ByteArrayIterator>)((LinearSeq)this.iterators().tail()));
        }

        @Override
        public void clear() {
            this.iterators_$eq(ByteIterator$MultiByteArrayIterator$.MODULE$.empty().iterators());
        }

        public final boolean hasNext() {
            return this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().hasNext();
        }

        @Override
        public final byte head() {
            return this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().head();
        }

        @Override
        public final byte next() {
            byte result = this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().next();
            this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
            return result;
        }

        @Override
        public final int len() {
            return BoxesRunTime.unboxToInt((Object)this.iterators().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), ByteIterator$::org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$_$len$$anonfun$adapted$1));
        }

        @Override
        public final int size() {
            int result = this.len();
            this.clear();
            return result;
        }

        public MultiByteArrayIterator $plus$plus$colon(ByteArrayIterator that) {
            this.iterators_$eq((LinearSeq<ByteArrayIterator>)((LinearSeq)this.iterators().$plus$colon((Object)that)));
            return this;
        }

        @Override
        public final ByteIterator $plus$plus(IterableOnce<Object> that) {
            IterableOnce<Object> iterableOnce = that;
            if (iterableOnce instanceof ByteIterator) {
                ByteIterator that2 = (ByteIterator)iterableOnce;
                if (that2.isEmpty()) {
                    return this;
                }
                if (this.isEmpty()) {
                    return that2;
                }
                ByteIterator byteIterator = that2;
                if (byteIterator instanceof ByteArrayIterator) {
                    ByteArrayIterator that3 = (ByteArrayIterator)byteIterator;
                    this.iterators_$eq((LinearSeq<ByteArrayIterator>)((LinearSeq)this.iterators().$colon$plus((Object)that3)));
                    that3.clear();
                    return this;
                }
                if (byteIterator instanceof MultiByteArrayIterator) {
                    MultiByteArrayIterator that4 = (MultiByteArrayIterator)byteIterator;
                    this.iterators_$eq((LinearSeq<ByteArrayIterator>)((LinearSeq)this.iterators().$plus$plus(that4.iterators())));
                    that4.clear();
                    return this;
                }
                throw new MatchError((Object)byteIterator);
            }
            return super.$plus$plus(that);
        }

        @Override
        public final MultiByteArrayIterator clone() {
            List clonedIterators = (List)this.iterators().iterator().map(ByteIterator$::org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$_$_$$anonfun$1).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.List()));
            return new MultiByteArrayIterator((LinearSeq<ByteArrayIterator>)clonedIterators);
        }

        @Override
        public final MultiByteArrayIterator take(int n) {
            int rest = n;
            ListBuffer builder = new ListBuffer();
            while (rest > 0 && !this.iterators().isEmpty()) {
                this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().take(rest);
                if (this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().hasNext()) {
                    rest -= this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().len();
                    builder.$plus$eq((Object)this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current());
                }
                this.iterators_$eq((LinearSeq<ByteArrayIterator>)((LinearSeq)this.iterators().tail()));
            }
            this.iterators_$eq((LinearSeq<ByteArrayIterator>)builder.result());
            return this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
        }

        @Override
        public final MultiByteArrayIterator drop(int n) {
            while (n > 0 && !this.isEmpty()) {
                int nCurrent = scala.math.package$.MODULE$.min(n, this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().len());
                this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().drop(n);
                int rest = n - nCurrent;
                if (!this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().isEmpty() && rest != 0) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
                n = rest;
            }
            return this;
        }

        @Override
        public final MultiByteArrayIterator takeWhile(Function1<Object, Object> p) {
            boolean stop = false;
            ListBuffer builder = new ListBuffer();
            while (!stop && !this.iterators().isEmpty()) {
                int lastLen = this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().len();
                this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().takeWhile((Function1)p);
                if (this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().hasNext()) {
                    builder.$plus$eq((Object)this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current());
                }
                if (this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().len() < lastLen) {
                    stop = true;
                }
                this.dropCurrent();
            }
            this.iterators_$eq((LinearSeq<ByteArrayIterator>)builder.result());
            return this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
        }

        @Override
        public final MultiByteArrayIterator dropWhile(Function1<Object, Object> p) {
            while (!this.isEmpty()) {
                this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().dropWhile((Function1)p);
                boolean dropMore = this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().isEmpty();
                this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
                if (dropMore) continue;
                return this;
            }
            return this;
        }

        @Override
        public final <B> int copyToArray(Object xs, int start, int len) {
            int rest;
            int n;
            int pos = start;
            for (rest = len; rest > 0 && !this.iterators().isEmpty() && pos < ScalaRunTime$.MODULE$.array_length(xs); pos += n, rest -= n) {
                n = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(xs) - pos), this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().len())), rest));
                this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().copyToArray(xs, pos, n);
                if (!this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().isEmpty()) continue;
                this.dropCurrent();
            }
            this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
            return len - rest;
        }

        @Override
        public <U> void foreach(Function1<Object, U> f) {
            this.iterators().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> ByteIterator$.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$_$foreach$$anonfun$1(f, arg_0)));
            this.clear();
        }

        @Override
        public final ByteString toByteString() {
            if (((SeqOps)this.iterators().tail()).isEmpty()) {
                return ((ByteArrayIterator)this.iterators().head()).toByteString();
            }
            ByteString result = (ByteString)this.iterators().foldLeft((Object)ByteString$.MODULE$.empty(), ByteIterator$::org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$_$_$$anonfun$2);
            this.clear();
            return result;
        }

        public final <A> MultiByteArrayIterator getToArray(Object xs, int offset, int n, int elemSize, Function0<A> getSingle, Function3<Object, Object, Object, BoxedUnit> getMult) {
            while (n > 0) {
                int n2;
                if (this.isEmpty()) {
                    Collections$EmptyImmutableSeq$.MODULE$.iterator().next();
                }
                if (this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().len() >= elemSize) {
                    int nCurrent = scala.math.package$.MODULE$.min(n, this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().len() / elemSize);
                    getMult.apply(xs, (Object)BoxesRunTime.boxToInteger((int)offset), (Object)BoxesRunTime.boxToInteger((int)nCurrent));
                    n2 = nCurrent;
                } else {
                    ScalaRunTime$.MODULE$.array_update(xs, offset, getSingle.apply());
                    n2 = 1;
                }
                int nDone = n2;
                this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
                int n3 = offset + nDone;
                int n4 = n - nDone;
                offset = n3;
                n = n4;
            }
            return this;
        }

        @Override
        public MultiByteArrayIterator getBytes(byte[] xs, int offset, int n) {
            return this.getToArray(xs, offset, n, 1, this::getBytes$$anonfun$1, (Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(v1, v2, v3) -> {
                this.getBytes$$anonfun$2((byte[])v1, BoxesRunTime.unboxToInt((Object)v2), BoxesRunTime.unboxToInt((Object)v3));
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public MultiByteArrayIterator getShorts(short[] xs, int offset, int n, ByteOrder byteOrder) {
            return this.getToArray(xs, offset, n, 2, () -> this.getShorts$$anonfun$1(byteOrder), (Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(v1, v2, v3) -> {
                this.getShorts$$anonfun$2(byteOrder, (short[])v1, BoxesRunTime.unboxToInt((Object)v2), BoxesRunTime.unboxToInt((Object)v3));
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public MultiByteArrayIterator getInts(int[] xs, int offset, int n, ByteOrder byteOrder) {
            return this.getToArray(xs, offset, n, 4, () -> this.getInts$$anonfun$1(byteOrder), (Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(v1, v2, v3) -> {
                this.getInts$$anonfun$2(byteOrder, (int[])v1, BoxesRunTime.unboxToInt((Object)v2), BoxesRunTime.unboxToInt((Object)v3));
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public MultiByteArrayIterator getLongs(long[] xs, int offset, int n, ByteOrder byteOrder) {
            return this.getToArray(xs, offset, n, 8, () -> this.getLongs$$anonfun$1(byteOrder), (Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(v1, v2, v3) -> {
                this.getLongs$$anonfun$2(byteOrder, (long[])v1, BoxesRunTime.unboxToInt((Object)v2), BoxesRunTime.unboxToInt((Object)v3));
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public MultiByteArrayIterator getFloats(float[] xs, int offset, int n, ByteOrder byteOrder) {
            return this.getToArray(xs, offset, n, 8, () -> this.getFloats$$anonfun$1(byteOrder), (Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(v1, v2, v3) -> {
                this.getFloats$$anonfun$2(byteOrder, (float[])v1, BoxesRunTime.unboxToInt((Object)v2), BoxesRunTime.unboxToInt((Object)v3));
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public MultiByteArrayIterator getDoubles(double[] xs, int offset, int n, ByteOrder byteOrder) {
            return this.getToArray(xs, offset, n, 8, () -> this.getDoubles$$anonfun$1(byteOrder), (Function3<Object, Object, Object, BoxedUnit>)(Function3 & Serializable)(v1, v2, v3) -> {
                this.getDoubles$$anonfun$2(byteOrder, (double[])v1, BoxesRunTime.unboxToInt((Object)v2), BoxesRunTime.unboxToInt((Object)v3));
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public int copyToBuffer(ByteBuffer buffer) {
            int n = BoxesRunTime.unboxToInt((Object)this.iterators().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (arg_0, arg_1) -> ByteIterator$.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$_$_$$anonfun$adapted$1(buffer, arg_0, arg_1)));
            this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
            return n;
        }

        @Override
        public InputStream asInputStream() {
            return new InputStream(this){
                private final /* synthetic */ MultiByteArrayIterator $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public int available() {
                    return this.$outer.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().len();
                }

                public int read() {
                    if (this.$outer.hasNext()) {
                        return this.$outer.next() & 0xFF;
                    }
                    return -1;
                }

                public int read(byte[] b, int off, int len) {
                    int nRead = this.$outer.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().asInputStream().read(b, off, len);
                    this.$outer.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
                    return nRead;
                }

                public long skip(long n) {
                    return this.skipImpl$1(n, 0L);
                }

                private final long skipImpl$1(long n, long skipped) {
                    while (n > 0L) {
                        if (!this.$outer.isEmpty()) {
                            long m = this.$outer.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().asInputStream().skip(n);
                            this.$outer.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$normalize();
                            long newN = n - m;
                            long newSkipped = skipped + m;
                            if (newN > 0L) {
                                long l = newN;
                                long l2 = newSkipped;
                                n = l;
                                skipped = l2;
                                continue;
                            }
                            return newSkipped;
                        }
                        return 0L;
                    }
                    return 0L;
                }
            };
        }

        private final LinearSeq norm$1(LinearSeq xs) {
            while (true) {
                if (xs.isEmpty()) {
                    return ByteIterator$MultiByteArrayIterator$.MODULE$.clearedList();
                }
                if (!((Iterator)xs.head()).isEmpty()) break;
                xs = (LinearSeq)xs.tail();
            }
            return xs;
        }

        private final byte getBytes$$anonfun$1() {
            return this.getByte();
        }

        private final /* synthetic */ void getBytes$$anonfun$2(byte[] _$7, int _$8, int _$9) {
            this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().getBytes(_$7, _$8, _$9);
        }

        private final short getShorts$$anonfun$1(ByteOrder byteOrder$1) {
            return this.getShort(byteOrder$1);
        }

        private final /* synthetic */ void getShorts$$anonfun$2(ByteOrder byteOrder$2, short[] _$10, int _$11, int _$12) {
            this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().getShorts(_$10, _$11, _$12, byteOrder$2);
        }

        private final int getInts$$anonfun$1(ByteOrder byteOrder$3) {
            return this.getInt(byteOrder$3);
        }

        private final /* synthetic */ void getInts$$anonfun$2(ByteOrder byteOrder$4, int[] _$13, int _$14, int _$15) {
            this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().getInts(_$13, _$14, _$15, byteOrder$4);
        }

        private final long getLongs$$anonfun$1(ByteOrder byteOrder$5) {
            return this.getLong(byteOrder$5);
        }

        private final /* synthetic */ void getLongs$$anonfun$2(ByteOrder byteOrder$6, long[] _$16, int _$17, int _$18) {
            this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().getLongs(_$16, _$17, _$18, byteOrder$6);
        }

        private final float getFloats$$anonfun$1(ByteOrder byteOrder$7) {
            return this.getFloat(byteOrder$7);
        }

        private final /* synthetic */ void getFloats$$anonfun$2(ByteOrder byteOrder$8, float[] _$19, int _$20, int _$21) {
            this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().getFloats(_$19, _$20, _$21, byteOrder$8);
        }

        private final double getDoubles$$anonfun$1(ByteOrder byteOrder$9) {
            return this.getDouble(byteOrder$9);
        }

        private final /* synthetic */ void getDoubles$$anonfun$2(ByteOrder byteOrder$10, double[] _$22, int _$23, int _$24) {
            this.org$apache$pekko$util$ByteIterator$MultiByteArrayIterator$$current().getDoubles(_$22, _$23, _$24, byteOrder$10);
        }
    }
}

