/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.pekko.util.ByteIterator;
import org.apache.pekko.util.ByteIterator$ByteArrayIterator$;
import org.apache.pekko.util.ByteIterator$MultiByteArrayIterator$;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteString$ByteString1$;
import org.apache.pekko.util.ByteString$ByteString1C$;
import org.apache.pekko.util.ByteString$ByteStrings$;
import org.apache.pekko.util.ByteString$Companion$;
import org.apache.pekko.util.ByteStringBuilder;
import org.apache.pekko.util.CompactByteString;
import org.apache.pekko.util.CompactByteString$;
import scala.Array$;
import scala.Byte$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LinearSeq;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeqOps;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public abstract class ByteString
implements scala.collection.immutable.IndexedSeq<Object>,
scala.collection.immutable.StrictOptimizedSeqOps<Object, scala.collection.immutable.IndexedSeq, ByteString> {
    public static String UTF_8() {
        return ByteString$.MODULE$.UTF_8();
    }

    public static ByteStringBuilder createBuilder() {
        return ByteString$.MODULE$.createBuilder();
    }

    public static ByteString emptyByteString() {
        return ByteString$.MODULE$.emptyByteString();
    }

    public static ByteString fromArray(byte[] byArray) {
        return ByteString$.MODULE$.fromArray(byArray);
    }

    public static ByteString fromArray(byte[] byArray, int n, int n2) {
        return ByteString$.MODULE$.fromArray(byArray, n, n2);
    }

    public static ByteString fromArrayUnsafe(byte[] byArray) {
        return ByteString$.MODULE$.fromArrayUnsafe(byArray);
    }

    public static ByteString fromArrayUnsafe(byte[] byArray, int n, int n2) {
        return ByteString$.MODULE$.fromArrayUnsafe(byArray, n, n2);
    }

    public static ByteString fromByteBuffer(ByteBuffer byteBuffer) {
        return ByteString$.MODULE$.fromByteBuffer(byteBuffer);
    }

    public static ByteString fromInts(int ... nArray) {
        return ByteString$.MODULE$.fromInts(nArray);
    }

    public static ByteString fromInts(scala.collection.immutable.Seq<Object> seq) {
        return ByteString$.MODULE$.fromInts(seq);
    }

    public static ByteString fromString(String string) {
        return ByteString$.MODULE$.fromString(string);
    }

    public static ByteString fromString(String string, Charset charset) {
        return ByteString$.MODULE$.fromString(string, charset);
    }

    public static ByteString fromString(String string, String string2) {
        return ByteString$.MODULE$.fromString(string, string2);
    }

    public static ByteStringBuilder newBuilder() {
        return ByteString$.MODULE$.newBuilder();
    }

    public ByteString() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        scala.collection.immutable.Iterable.$init$((scala.collection.immutable.Iterable)this);
        PartialFunction.$init$((PartialFunction)this);
        SeqOps.$init$((SeqOps)this);
        Seq.$init$((Seq)this);
        scala.collection.immutable.Seq.$init$((scala.collection.immutable.Seq)this);
        scala.collection.IndexedSeqOps.$init$((scala.collection.IndexedSeqOps)this);
        IndexedSeq.$init$((IndexedSeq)this);
        IndexedSeqOps.$init$((IndexedSeqOps)this);
        scala.collection.immutable.IndexedSeq.$init$((scala.collection.immutable.IndexedSeq)this);
        StrictOptimizedIterableOps.$init$((StrictOptimizedIterableOps)this);
        StrictOptimizedSeqOps.$init$((StrictOptimizedSeqOps)this);
        scala.collection.immutable.StrictOptimizedSeqOps.$init$((scala.collection.immutable.StrictOptimizedSeqOps)this);
    }

    public <B> scala.collection.immutable.IndexedSeq<B> scala$collection$SeqOps$$super$concat(IterableOnce<B> suffix) {
        return (scala.collection.immutable.IndexedSeq)IterableOps.concat$((IterableOps)this, suffix);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(Iterable<?> that) {
        return IterableOps.sizeCompare$((IterableOps)this, that);
    }

    public ByteString scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        return (ByteString)scala.collection.IndexedSeqOps.slice$((scala.collection.IndexedSeqOps)this, (int)from, (int)until);
    }

    public boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        return Seq.canEqual$((Seq)this, (Object)that);
    }

    public <B> boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce<B> that) {
        return SeqOps.sameElements$((SeqOps)this, that);
    }

    public <B> ByteString scala$collection$immutable$StrictOptimizedSeqOps$$super$sorted(Ordering<B> ord) {
        return (ByteString)SeqOps.sorted$((SeqOps)this, ord);
    }

    public ByteString fromSpecific(IterableOnce<Object> coll) {
        return ByteString$.MODULE$.apply(coll);
    }

    public Builder<Object, ByteString> newSpecificBuilder() {
        return ByteString$.MODULE$.newBuilder();
    }

    public ByteString empty() {
        return ByteString$.MODULE$.empty();
    }

    public abstract byte apply(int var1);

    public abstract Companion byteStringCompanion();

    public final String className() {
        return "ByteString";
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public ByteIterator iterator() {
        throw new UnsupportedOperationException("Method iterator is not implemented in ByteString");
    }

    public byte head() {
        return this.apply(0);
    }

    public ByteString tail() {
        return this.drop(1);
    }

    public byte last() {
        return this.apply(this.length() - 1);
    }

    public ByteString init() {
        return this.dropRight(1);
    }

    public ByteString take(int n) {
        throw new UnsupportedOperationException("Method take is not implemented in ByteString");
    }

    public ByteString takeRight(int n) {
        return this.slice(this.length() - n, this.length());
    }

    public ByteString slice(int from, int until) {
        throw new UnsupportedOperationException("Method slice is not implemented in ByteString");
    }

    public ByteString drop(int n) {
        throw new UnsupportedOperationException("Method drop is not implemented in ByteString");
    }

    public ByteString dropRight(int n) {
        throw new UnsupportedOperationException("Method dropRight is not implemented in ByteString");
    }

    public ByteString takeWhile(Function1<Object, Object> p) {
        return ((ByteIterator)this.iterator().takeWhile((Function1)p)).toByteString();
    }

    public ByteString dropWhile(Function1<Object, Object> p) {
        return ((ByteIterator)this.iterator().dropWhile((Function1)p)).toByteString();
    }

    public Tuple2<ByteString, ByteString> span(Function1<Object, Object> p) {
        Tuple2<ByteIterator, ByteIterator> tuple2 = this.iterator().span(p);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ByteIterator a = (ByteIterator)tuple2._1();
        ByteIterator b = (ByteIterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)a, (Object)b);
        ByteIterator a2 = (ByteIterator)tuple22._1();
        ByteIterator b2 = (ByteIterator)tuple22._2();
        return Tuple2$.MODULE$.apply((Object)a2.toByteString(), (Object)b2.toByteString());
    }

    public Tuple2<ByteString, ByteString> splitAt(int n) {
        return Tuple2$.MODULE$.apply((Object)this.take(n), (Object)this.drop(n));
    }

    public int indexWhere(Function1<Object, Object> p, int from) {
        return this.iterator().indexWhere(p, from);
    }

    public <B> int indexOf(B elem, int from) {
        return SeqOps.indexOf$((SeqOps)this, elem, (int)from);
    }

    public int indexOf(byte elem, int from) {
        return this.indexOf((Object)BoxesRunTime.boxToByte((byte)elem), from);
    }

    public int indexOf(byte elem) {
        return this.indexOf(elem, 0);
    }

    public Iterator<ByteString> grouped(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(new StringBuilder(22).append("size=").append(size).append(" must be positive").toString());
        }
        return package$.MODULE$.Iterator().iterate((Object)this, (Function1 & Serializable)_$7 -> _$7.drop(size)).takeWhile((Function1 & Serializable)_$8 -> _$8.nonEmpty()).map((Function1 & Serializable)_$9 -> _$9.take(size));
    }

    public String toString() {
        int maxSize = 100;
        if (this.size() > maxSize) {
            return new StringBuilder(0).append(this.take(maxSize).toString()).append(new StringBuilder(15).append("... and [").append(this.size() - maxSize).append("] more").toString()).toString();
        }
        return Seq.toString$((Seq)this);
    }

    public byte[] toArray() {
        return (byte[])this.toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    public final <B> Object toArray(ClassTag<B> arg0) {
        Object array = Arrays$.MODULE$.newGenericArray(this.size(), arg0);
        this.copyToArray(array, 0, this.size());
        return array;
    }

    public final <B> int copyToArray(Object xs, int start) {
        Object object = Predef$.MODULE$.genericArrayOps(xs);
        return this.copyToArray(xs, start, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.size()), ArrayOps$.MODULE$.size$extension(object)));
    }

    public <B> int copyToArray(Object xs, int start, int len) {
        throw new UnsupportedOperationException("Method copyToArray is not implemented in ByteString");
    }

    public byte[] toArrayUnsafe() {
        return this.toArray();
    }

    public abstract InputStream asInputStream();

    public <U> void foreach(Function1<Object, U> f) {
        this.iterator().foreach(f);
    }

    public abstract void writeToOutputStream(ObjectOutputStream var1);

    public abstract ByteString $plus$plus(ByteString var1);

    public ByteString concat(ByteString that) {
        return this.$plus$plus(that);
    }

    public abstract int copyToBuffer(ByteBuffer var1);

    public abstract CompactByteString compact();

    public abstract boolean isCompact();

    public abstract ByteBuffer asByteBuffer();

    public abstract scala.collection.immutable.Iterable<ByteBuffer> asByteBuffers();

    public java.lang.Iterable<ByteBuffer> getByteBuffers() {
        return CollectionConverters$.MODULE$.IterableHasAsJava(this.asByteBuffers()).asJava();
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toArray());
    }

    public final String utf8String() {
        return this.decodeString(StandardCharsets.UTF_8);
    }

    public abstract String decodeString(String var1);

    public abstract String decodeString(Charset var1);

    public abstract ByteString decodeBase64();

    public abstract ByteString encodeBase64();

    public final ByteString mapI(Function1<Object, Object> f) {
        return this.map(f.andThen((Function1 & Serializable)_$10 -> ByteString.mapI$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$10))));
    }

    public <A> ByteString map(Function1<Object, Object> f) {
        return this.fromSpecific((IterableOnce)StrictOptimizedIterableOps.map$((StrictOptimizedIterableOps)this, f));
    }

    private static final /* synthetic */ byte mapI$$anonfun$1(int _$10) {
        return (byte)_$10;
    }

    public static final class ByteString1
    extends ByteString
    implements Serializable {
        private final byte[] bytes;
        private final int startIndex;
        private final int length;

        public static byte SerializationIdentity() {
            return ByteString$ByteString1$.MODULE$.SerializationIdentity();
        }

        public static ByteString1 fromString(String string) {
            return ByteString$ByteString1$.MODULE$.fromString(string);
        }

        public static ByteString1 readFromInputStream(ObjectInputStream objectInputStream) {
            return ByteString$ByteString1$.MODULE$.readFromInputStream(objectInputStream);
        }

        public ByteString1(byte[] bytes, int startIndex, int length) {
            this.bytes = bytes;
            this.startIndex = startIndex;
            this.length = length;
        }

        private byte[] bytes() {
            return this.bytes;
        }

        private int startIndex() {
            return this.startIndex;
        }

        public int length() {
            return this.length;
        }

        @Override
        public byte apply(int idx) {
            return this.bytes()[this.checkRangeConvert(idx)];
        }

        @Override
        public ByteIterator.ByteArrayIterator iterator() {
            return ByteIterator$ByteArrayIterator$.MODULE$.apply(this.bytes(), this.startIndex(), this.startIndex() + this.length());
        }

        private int checkRangeConvert(int index) {
            if (0 <= index && this.length() > index) {
                return index + this.startIndex();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)index).toString());
        }

        @Override
        public void writeToOutputStream(ObjectOutputStream os) {
            os.writeInt(this.length());
            os.write(this.bytes(), this.startIndex(), this.length());
        }

        @Override
        public boolean isCompact() {
            return this.length() == this.bytes().length;
        }

        @Override
        public Companion byteStringCompanion() {
            return ByteString$ByteString1$.MODULE$;
        }

        @Override
        public ByteString dropRight(int n) {
            return this.dropRight1(n);
        }

        public ByteString1 dropRight1(int n) {
            if (n <= 0) {
                return this;
            }
            if (this.length() - n <= 0) {
                return ByteString$ByteString1$.MODULE$.empty();
            }
            return new ByteString1(this.bytes(), this.startIndex(), this.length() - n);
        }

        @Override
        public ByteString drop(int n) {
            if (n <= 0) {
                return this;
            }
            return this.drop1(n);
        }

        public ByteString1 drop1(int n) {
            int nextStartIndex = this.startIndex() + n;
            if (nextStartIndex >= this.bytes().length) {
                return ByteString$ByteString1$.MODULE$.empty();
            }
            return ByteString$ByteString1$.MODULE$.apply(this.bytes(), nextStartIndex, this.length() - n);
        }

        @Override
        public ByteString take(int n) {
            if (n <= 0) {
                return ByteString$.MODULE$.empty();
            }
            return this.take1(n);
        }

        public ByteString1 take1(int n) {
            if (n >= this.length()) {
                return this;
            }
            return ByteString$ByteString1$.MODULE$.apply(this.bytes(), this.startIndex(), n);
        }

        @Override
        public ByteString slice(int from, int until) {
            return this.drop(from).take(until - Math.max(0, from));
        }

        @Override
        public int copyToBuffer(ByteBuffer buffer) {
            return this.writeToBuffer(buffer);
        }

        public int writeToBuffer(ByteBuffer buffer) {
            int copyLength = Math.min(buffer.remaining(), this.length());
            if (copyLength > 0) {
                buffer.put(this.bytes(), this.startIndex(), copyLength);
            }
            return copyLength;
        }

        @Override
        public CompactByteString compact() {
            if (this.isCompact()) {
                return ByteString$ByteString1C$.MODULE$.apply(this.bytes());
            }
            return ByteString$ByteString1C$.MODULE$.apply(this.toArray());
        }

        @Override
        public ByteBuffer asByteBuffer() {
            ByteBuffer buffer = ByteBuffer.wrap(this.bytes(), this.startIndex(), this.length()).asReadOnlyBuffer();
            if (buffer.remaining() < this.bytes().length) {
                return buffer.slice();
            }
            return buffer;
        }

        @Override
        public scala.collection.immutable.Iterable<ByteBuffer> asByteBuffers() {
            return (scala.collection.immutable.Iterable)new .colon.colon((Object)this.asByteBuffer(), (List)Nil$.MODULE$);
        }

        @Override
        public String decodeString(String charset) {
            if (this.isEmpty()) {
                return "";
            }
            return new String(this.bytes(), this.startIndex(), this.length(), charset);
        }

        @Override
        public String decodeString(Charset charset) {
            if (this.isEmpty()) {
                return "";
            }
            return new String(this.bytes(), this.startIndex(), this.length(), charset);
        }

        @Override
        public ByteString decodeBase64() {
            if (this.isEmpty()) {
                return this;
            }
            if (this.isCompact()) {
                return ByteString$ByteString1C$.MODULE$.apply(Base64.getDecoder().decode(this.bytes()));
            }
            ByteBuffer dst = Base64.getDecoder().decode(ByteBuffer.wrap(this.bytes(), this.startIndex(), this.length()));
            if (dst.hasArray()) {
                return dst.array().length == dst.remaining() ? ByteString$ByteString1C$.MODULE$.apply(dst.array()) : ByteString$ByteString1$.MODULE$.apply(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining());
            }
            return CompactByteString$.MODULE$.apply(dst);
        }

        @Override
        public ByteString encodeBase64() {
            if (this.isEmpty()) {
                return this;
            }
            if (this.isCompact()) {
                return ByteString$ByteString1C$.MODULE$.apply(Base64.getEncoder().encode(this.bytes()));
            }
            ByteBuffer dst = Base64.getEncoder().encode(ByteBuffer.wrap(this.bytes(), this.startIndex(), this.length()));
            if (dst.hasArray()) {
                return dst.array().length == dst.remaining() ? ByteString$ByteString1C$.MODULE$.apply(dst.array()) : ByteString$ByteString1$.MODULE$.apply(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining());
            }
            return CompactByteString$.MODULE$.apply(dst);
        }

        @Override
        public ByteString $plus$plus(ByteString that) {
            if (that.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return that;
            }
            ByteString byteString = that;
            if (byteString instanceof ByteString1C) {
                ByteString1C b = (ByteString1C)byteString;
                return ByteString$ByteStrings$.MODULE$.apply(this, b.toByteString1());
            }
            if (byteString instanceof ByteString1) {
                ByteString1 b = (ByteString1)byteString;
                if (this.bytes() == b.bytes() && this.startIndex() + this.length() == b.startIndex()) {
                    return new ByteString1(this.bytes(), this.startIndex(), this.length() + b.length());
                }
                return ByteString$ByteStrings$.MODULE$.apply(this, b);
            }
            if (byteString instanceof ByteStrings) {
                ByteStrings bs = (ByteStrings)byteString;
                return ByteString$ByteStrings$.MODULE$.apply(this, bs);
            }
            throw new MatchError((Object)byteString);
        }

        @Override
        public <B> int indexOf(B elem, int from) {
            if (from >= this.length()) {
                return -1;
            }
            int found = -1;
            for (int i = scala.math.package$.MODULE$.max(from, 0); i < this.length() && found == -1; ++i) {
                if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)this.bytes()[this.startIndex() + i]), elem)) continue;
                found = i;
            }
            return found;
        }

        @Override
        public int indexOf(byte elem, int from) {
            if (from >= this.length()) {
                return -1;
            }
            int found = -1;
            for (int i = scala.math.package$.MODULE$.max(from, 0); i < this.length() && found == -1; ++i) {
                if (this.bytes()[this.startIndex() + i] != elem) continue;
                found = i;
            }
            return found;
        }

        @Override
        public <B> int copyToArray(Object dest, int start, int len) {
            int toCopy = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.min(len, this.length()), ScalaRunTime$.MODULE$.array_length(dest) - start);
            if (toCopy > 0) {
                Array$.MODULE$.copy((Object)this.bytes(), this.startIndex(), dest, start, toCopy);
            }
            return toCopy;
        }

        public Object writeReplace() {
            return new SerializationProxy(this);
        }

        @Override
        public byte[] toArrayUnsafe() {
            if (this.startIndex() == 0 && this.length() == this.bytes().length) {
                return this.bytes();
            }
            return this.toArray();
        }

        @Override
        public InputStream asInputStream() {
            return new ByteArrayInputStream(this.bytes(), this.startIndex(), this.length());
        }
    }

    public static final class ByteString1C
    extends CompactByteString {
        private static final long serialVersionUID = 3956956327691936932L;
        private final byte[] bytes;

        public static byte SerializationIdentity() {
            return ByteString$ByteString1C$.MODULE$.SerializationIdentity();
        }

        public static ByteString1C fromString(String string) {
            return ByteString$ByteString1C$.MODULE$.fromString(string);
        }

        public static ByteString1C readFromInputStream(ObjectInputStream objectInputStream) {
            return ByteString$ByteString1C$.MODULE$.readFromInputStream(objectInputStream);
        }

        public ByteString1C(byte[] bytes) {
            this.bytes = bytes;
        }

        private byte[] bytes() {
            return this.bytes;
        }

        @Override
        public byte apply(int idx) {
            return this.bytes()[idx];
        }

        public int length() {
            return this.bytes().length;
        }

        @Override
        public ByteIterator.ByteArrayIterator iterator() {
            return ByteIterator$ByteArrayIterator$.MODULE$.apply(this.bytes(), 0, this.bytes().length);
        }

        public ByteString1 toByteString1() {
            return ByteString$ByteString1$.MODULE$.apply(this.bytes(), 0, this.bytes().length);
        }

        @Override
        public Companion byteStringCompanion() {
            return ByteString$ByteString1C$.MODULE$;
        }

        @Override
        public ByteBuffer asByteBuffer() {
            return this.toByteString1().asByteBuffer();
        }

        @Override
        public scala.collection.immutable.Iterable<ByteBuffer> asByteBuffers() {
            return (scala.collection.immutable.Iterable)new .colon.colon((Object)this.asByteBuffer(), (List)Nil$.MODULE$);
        }

        @Override
        public String decodeString(String charset) {
            if (this.isEmpty()) {
                return "";
            }
            return new String(this.bytes(), charset);
        }

        @Override
        public String decodeString(Charset charset) {
            if (this.isEmpty()) {
                return "";
            }
            return new String(this.bytes(), charset);
        }

        @Override
        public ByteString decodeBase64() {
            if (this.isEmpty()) {
                return this;
            }
            return ByteString$ByteString1C$.MODULE$.apply(Base64.getDecoder().decode(this.bytes()));
        }

        @Override
        public ByteString encodeBase64() {
            if (this.isEmpty()) {
                return this;
            }
            return ByteString$ByteString1C$.MODULE$.apply(Base64.getEncoder().encode(this.bytes()));
        }

        @Override
        public ByteString $plus$plus(ByteString that) {
            if (that.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return that;
            }
            return this.toByteString1().$plus$plus(that);
        }

        @Override
        public ByteString take(int n) {
            if (n <= 0) {
                return ByteString$.MODULE$.empty();
            }
            if (n >= this.length()) {
                return this;
            }
            return this.toByteString1().take(n);
        }

        @Override
        public ByteString dropRight(int n) {
            if (n <= 0) {
                return this;
            }
            return this.toByteString1().dropRight(n);
        }

        @Override
        public ByteString drop(int n) {
            if (n <= 0) {
                return this;
            }
            return this.toByteString1().drop(n);
        }

        @Override
        public <B> int indexOf(B elem, int from) {
            if (from >= this.length()) {
                return -1;
            }
            int found = -1;
            for (int i = scala.math.package$.MODULE$.max(from, 0); i < this.length() && found == -1; ++i) {
                if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)this.bytes()[i]), elem)) continue;
                found = i;
            }
            return found;
        }

        @Override
        public int indexOf(byte elem, int from) {
            if (from >= this.length()) {
                return -1;
            }
            int found = -1;
            for (int i = scala.math.package$.MODULE$.max(from, 0); i < this.length() && found == -1; ++i) {
                if (this.bytes()[i] != elem) continue;
                found = i;
            }
            return found;
        }

        @Override
        public ByteString slice(int from, int until) {
            if (from <= 0 && until >= this.length()) {
                return this;
            }
            if (from >= this.length() || until <= 0 || from >= until) {
                return ByteString$.MODULE$.empty();
            }
            return this.toByteString1().slice(from, until);
        }

        @Override
        public void writeToOutputStream(ObjectOutputStream os) {
            this.toByteString1().writeToOutputStream(os);
        }

        @Override
        public int copyToBuffer(ByteBuffer buffer) {
            return this.writeToBuffer(buffer, 0);
        }

        public int writeToBuffer(ByteBuffer buffer, int offset) {
            int copyLength = Math.min(buffer.remaining(), offset + this.length());
            if (copyLength > 0) {
                buffer.put(this.bytes(), offset, copyLength);
            }
            return copyLength;
        }

        public ByteStringBuilder appendToBuilder(ByteStringBuilder buffer) {
            return buffer.putByteArrayUnsafe(this.bytes());
        }

        @Override
        public <B> int copyToArray(Object dest, int start, int len) {
            int toCopy = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.min(len, this.bytes().length), ScalaRunTime$.MODULE$.array_length(dest) - start);
            if (toCopy > 0) {
                Array$.MODULE$.copy((Object)this.bytes(), 0, dest, start, toCopy);
            }
            return toCopy;
        }

        @Override
        public byte[] toArrayUnsafe() {
            return this.bytes();
        }

        @Override
        public InputStream asInputStream() {
            return new ByteArrayInputStream(this.bytes());
        }
    }

    public static final class ByteStrings
    extends ByteString
    implements Serializable {
        private final Vector bytestrings;
        private final int length;

        public static byte SerializationIdentity() {
            return ByteString$ByteStrings$.MODULE$.SerializationIdentity();
        }

        public static int compare(ByteString byteString, ByteString byteString2) {
            return ByteString$ByteStrings$.MODULE$.compare(byteString, byteString2);
        }

        public static ByteStrings readFromInputStream(ObjectInputStream objectInputStream) {
            return ByteString$ByteStrings$.MODULE$.readFromInputStream(objectInputStream);
        }

        public ByteStrings(Vector<ByteString1> bytestrings, int length) {
            this.bytestrings = bytestrings;
            this.length = length;
            if (bytestrings.isEmpty()) {
                throw new IllegalArgumentException("bytestrings must not be empty");
            }
            if (((ByteString)bytestrings.head()).isEmpty()) {
                throw new IllegalArgumentException("bytestrings.head must not be empty");
            }
        }

        public Vector<ByteString1> bytestrings() {
            return this.bytestrings;
        }

        public int length() {
            return this.length;
        }

        @Override
        public byte apply(int idx) {
            if (0 <= idx && idx < this.length()) {
                int pos = 0;
                int seen = 0;
                ByteString1 frag = (ByteString1)this.bytestrings().apply(pos);
                while (idx >= seen + frag.length()) {
                    seen += frag.length();
                    frag = (ByteString1)this.bytestrings().apply(++pos);
                }
                return frag.apply(idx - seen);
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)idx).toString());
        }

        @Override
        public ByteIterator.MultiByteArrayIterator iterator() {
            return ByteIterator$MultiByteArrayIterator$.MODULE$.apply((LinearSeq<ByteIterator.ByteArrayIterator>)((LazyList)this.bytestrings().to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.LazyList()))).map(ByteString$::org$apache$pekko$util$ByteString$ByteStrings$$_$iterator$$anonfun$1));
        }

        @Override
        public ByteString $plus$plus(ByteString that) {
            if (that.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return that;
            }
            ByteString byteString = that;
            if (byteString instanceof ByteString1C) {
                ByteString1C b = (ByteString1C)byteString;
                return ByteString$ByteStrings$.MODULE$.apply(this, b.toByteString1());
            }
            if (byteString instanceof ByteString1) {
                ByteString1 b = (ByteString1)byteString;
                return ByteString$ByteStrings$.MODULE$.apply(this, b);
            }
            if (byteString instanceof ByteStrings) {
                ByteStrings bs = (ByteStrings)byteString;
                return ByteString$ByteStrings$.MODULE$.apply(this, bs);
            }
            throw new MatchError((Object)byteString);
        }

        @Override
        public Companion byteStringCompanion() {
            return ByteString$ByteStrings$.MODULE$;
        }

        @Override
        public boolean isCompact() {
            if (this.bytestrings().length() == 1) {
                return ((ByteString1)this.bytestrings().head()).isCompact();
            }
            return false;
        }

        @Override
        public int copyToBuffer(ByteBuffer buffer) {
            return this.copyItToTheBuffer$1(buffer, 0, 0);
        }

        @Override
        public CompactByteString compact() {
            if (this.isCompact()) {
                return ((ByteString1)this.bytestrings().head()).compact();
            }
            byte[] ar = new byte[this.length()];
            IntRef pos = IntRef.create((int)0);
            this.bytestrings().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> ByteString$.org$apache$pekko$util$ByteString$ByteStrings$$_$compact$$anonfun$1(ar, pos, arg_0)));
            return ByteString$ByteString1C$.MODULE$.apply(ar);
        }

        @Override
        public ByteBuffer asByteBuffer() {
            return this.compact().asByteBuffer();
        }

        @Override
        public scala.collection.immutable.Iterable<ByteBuffer> asByteBuffers() {
            return (scala.collection.immutable.Iterable)this.bytestrings().map(ByteString$::org$apache$pekko$util$ByteString$ByteStrings$$_$asByteBuffers$$anonfun$1);
        }

        @Override
        public InputStream asInputStream() {
            return new SequenceInputStream(CollectionConverters$.MODULE$.IteratorHasAsJava(this.bytestrings().iterator().map(ByteString$::org$apache$pekko$util$ByteString$ByteStrings$$_$asInputStream$$anonfun$1)).asJavaEnumeration());
        }

        @Override
        public String decodeString(String charset) {
            return this.compact().decodeString(charset);
        }

        @Override
        public String decodeString(Charset charset) {
            return this.compact().decodeString(charset);
        }

        @Override
        public ByteString decodeBase64() {
            return this.compact().decodeBase64();
        }

        @Override
        public ByteString encodeBase64() {
            return this.compact().encodeBase64();
        }

        @Override
        public void writeToOutputStream(ObjectOutputStream os) {
            os.writeInt(this.bytestrings().length());
            this.bytestrings().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> ByteString$.org$apache$pekko$util$ByteString$ByteStrings$$_$writeToOutputStream$$anonfun$1(os, arg_0)));
        }

        @Override
        public ByteString take(int n) {
            if (n <= 0) {
                return ByteString$.MODULE$.empty();
            }
            if (n >= this.length()) {
                return this;
            }
            return this.take0(n);
        }

        public ByteString take0(int n) {
            Tuple2 tuple2 = this.go$1(0, n);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int last = tuple2._1$mcI$sp();
            int restToTake = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(last, restToTake);
            int last2 = sp2._1$mcI$sp();
            int restToTake2 = sp2._2$mcI$sp();
            if (last2 == 0) {
                return ((ByteString1)this.bytestrings().apply(last2)).take(restToTake2);
            }
            if (restToTake2 == 0) {
                return new ByteStrings((Vector<ByteString1>)this.bytestrings().take(last2), n);
            }
            return new ByteStrings((Vector<ByteString1>)((Vector)this.bytestrings().take(last2).$colon$plus((Object)((ByteString1)this.bytestrings().apply(last2)).take1(restToTake2))), n);
        }

        @Override
        public ByteString dropRight(int n) {
            if (0 < n && n < this.length()) {
                return this.dropRight0(n);
            }
            if (n >= this.length()) {
                return ByteString$.MODULE$.empty();
            }
            return this;
        }

        private ByteString dropRight0(int n) {
            int byteStringsSize = this.bytestrings().length();
            return this.dropRightWithFullDropsAndRemainig$1(byteStringsSize, n, 0, n);
        }

        @Override
        public ByteString slice(int from, int until) {
            if (from <= 0 && until >= this.length()) {
                return this;
            }
            if (from > this.length() || until <= from) {
                return ByteString$.MODULE$.empty();
            }
            return this.drop(from).dropRight(this.length() - until);
        }

        @Override
        public ByteString drop(int n) {
            if (n <= 0) {
                return this;
            }
            if (n >= this.length()) {
                return ByteString$.MODULE$.empty();
            }
            return this.drop0(n);
        }

        private ByteString drop0(int n) {
            Tuple2 tuple2 = this.findSplit$1(0, n);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int fullDrops = tuple2._1$mcI$sp();
            int remainingToDrop = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(fullDrops, remainingToDrop);
            int fullDrops2 = sp2._1$mcI$sp();
            int remainingToDrop2 = sp2._2$mcI$sp();
            if (remainingToDrop2 == 0) {
                return new ByteStrings((Vector<ByteString1>)this.bytestrings().drop(fullDrops2), this.length() - n);
            }
            if (fullDrops2 == this.bytestrings().length() - 1) {
                return ((ByteString1)this.bytestrings().apply(fullDrops2)).drop(remainingToDrop2);
            }
            ByteString1 byteString1 = ((ByteString1)this.bytestrings().apply(fullDrops2)).drop1(remainingToDrop2);
            return new ByteStrings((Vector<ByteString1>)((Vector)this.bytestrings().drop(fullDrops2 + 1).$plus$colon((Object)byteString1)), this.length() - n);
        }

        @Override
        public <B> int indexOf(B elem, int from) {
            if (from >= this.length()) {
                return -1;
            }
            int byteStringsSize = this.bytestrings().size();
            return this.find$1(byteStringsSize, elem, 0, scala.math.package$.MODULE$.max(from, 0), 0);
        }

        @Override
        public int indexOf(byte elem, int from) {
            if (from >= this.length()) {
                return -1;
            }
            int byteStringsSize = this.bytestrings().size();
            return this.find$2(byteStringsSize, elem, 0, scala.math.package$.MODULE$.max(from, 0), 0);
        }

        @Override
        public <B> int copyToArray(Object dest, int start, int len) {
            if (this.bytestrings().size() == 1) {
                return ((ByteString1)this.bytestrings().head()).copyToArray(dest, start, len);
            }
            int totalToCopy = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.min(len, this.length()), ScalaRunTime$.MODULE$.array_length(dest) - start);
            if (totalToCopy > 0) {
                ByteString1 current;
                Iterator bsIterator = this.bytestrings().iterator();
                for (int copied = 0; copied < totalToCopy; copied += current.copyToArray(dest, start + copied, totalToCopy - copied)) {
                    current = (ByteString1)bsIterator.next();
                }
            }
            return totalToCopy;
        }

        public Object writeReplace() {
            return new SerializationProxy(this);
        }

        private final int copyItToTheBuffer$1(ByteBuffer buffer, int i, int written) {
            while (i < this.bytestrings().length()) {
                int n = i + 1;
                int n2 = written + ((ByteString1)this.bytestrings().apply(i)).writeToBuffer(buffer);
                i = n;
                written = n2;
            }
            return written;
        }

        private final Tuple2 go$1(int last, int restToTake) {
            ByteString1 bs;
            while ((bs = (ByteString1)this.bytestrings().apply(last)).length() <= restToTake) {
                int n = last + 1;
                int n2 = restToTake - bs.length();
                last = n;
                restToTake = n2;
            }
            return new Tuple2.mcII.sp(last, restToTake);
        }

        private final ByteString dropRightWithFullDropsAndRemainig$1(int byteStringsSize$1, int n$1, int fullDrops, int remainingToDrop) {
            while (true) {
                ByteString1 bs;
                if ((bs = (ByteString1)this.bytestrings().apply(byteStringsSize$1 - fullDrops - 1)).length() > remainingToDrop) {
                    if (fullDrops == byteStringsSize$1 - 1) {
                        return ((ByteString1)this.bytestrings().apply(0)).dropRight(remainingToDrop);
                    }
                    if (remainingToDrop == 0) {
                        return new ByteStrings((Vector<ByteString1>)this.bytestrings().dropRight(fullDrops), this.length() - n$1);
                    }
                    return new ByteStrings((Vector<ByteString1>)((Vector)this.bytestrings().dropRight(fullDrops + 1).$colon$plus((Object)((ByteString1)this.bytestrings().apply(byteStringsSize$1 - fullDrops - 1)).dropRight1(remainingToDrop))), this.length() - n$1);
                }
                int n = fullDrops + 1;
                int n2 = remainingToDrop - bs.length();
                fullDrops = n;
                remainingToDrop = n2;
            }
        }

        private final Tuple2 findSplit$1(int fullDrops, int remainingToDrop) {
            ByteString1 bs;
            while ((bs = (ByteString1)this.bytestrings().apply(fullDrops)).length() <= remainingToDrop) {
                int n = fullDrops + 1;
                int n2 = remainingToDrop - bs.length();
                fullDrops = n;
                remainingToDrop = n2;
            }
            return new Tuple2.mcII.sp(fullDrops, remainingToDrop);
        }

        private final int find$1(int byteStringsSize$2, Object elem$2, int bsIdx, int relativeIndex, int bytesPassed) {
            int subIndexOf;
            while (true) {
                if (bsIdx >= byteStringsSize$2) {
                    return -1;
                }
                ByteString1 bs = (ByteString1)this.bytestrings().apply(bsIdx);
                if (bs.length() <= relativeIndex) {
                    int n = bsIdx + 1;
                    int n2 = relativeIndex - bs.length();
                    int n3 = bytesPassed + bs.length();
                    bsIdx = n;
                    relativeIndex = n2;
                    bytesPassed = n3;
                    continue;
                }
                subIndexOf = bs.indexOf(elem$2, relativeIndex);
                if (subIndexOf >= 0) break;
                int n = bsIdx + 1;
                int n4 = relativeIndex - bs.length();
                int n5 = bytesPassed + bs.length();
                bsIdx = n;
                relativeIndex = n4;
                bytesPassed = n5;
            }
            return subIndexOf + bytesPassed;
        }

        private final int find$2(int byteStringsSize$3, byte elem$3, int bsIdx, int relativeIndex, int bytesPassed) {
            int subIndexOf;
            while (true) {
                if (bsIdx >= byteStringsSize$3) {
                    return -1;
                }
                ByteString1 bs = (ByteString1)this.bytestrings().apply(bsIdx);
                if (bs.length() <= relativeIndex) {
                    int n = bsIdx + 1;
                    int n2 = relativeIndex - bs.length();
                    int n3 = bytesPassed + bs.length();
                    bsIdx = n;
                    relativeIndex = n2;
                    bytesPassed = n3;
                    continue;
                }
                subIndexOf = bs.indexOf(elem$3, relativeIndex);
                if (subIndexOf >= 0) break;
                int n = bsIdx + 1;
                int n4 = relativeIndex - bs.length();
                int n5 = bytesPassed + bs.length();
                bsIdx = n;
                relativeIndex = n4;
                bytesPassed = n5;
            }
            return subIndexOf + bytesPassed;
        }
    }

    public static interface Companion {
        public static Companion apply(byte by) {
            return ByteString$Companion$.MODULE$.apply(by);
        }

        public static int ordinal(Companion companion) {
            return ByteString$Companion$.MODULE$.ordinal(companion);
        }

        public byte SerializationIdentity();

        public ByteString readFromInputStream(ObjectInputStream var1);
    }

    public static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient ByteString orig;

        public SerializationProxy(ByteString orig) {
            this.orig = orig;
        }

        private ByteString orig() {
            return this.orig;
        }

        private void orig_$eq(ByteString x$0) {
            this.orig = x$0;
        }

        private void writeObject(ObjectOutputStream out) {
            out.writeByte(Byte$.MODULE$.byte2int(this.orig().byteStringCompanion().SerializationIdentity()));
            this.orig().writeToOutputStream(out);
        }

        private void readObject(ObjectInputStream in) {
            byte serializationId = in.readByte();
            this.orig_$eq(ByteString$Companion$.MODULE$.apply(serializationId).readFromInputStream(in));
        }

        private Object readResolve() {
            return this.orig();
        }
    }
}

