/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.pekko.util.Helpers$ConfigOps$;
import org.apache.pekko.util.Helpers$Requiring$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Helpers$
implements Serializable {
    private static final boolean isWindows;
    private static final DateTimeFormatter formatter;
    private static final ZoneId timeZone;
    public static final Helpers$Requiring$ Requiring;
    public static final Helpers$ConfigOps$ ConfigOps;
    public static final Helpers$ MODULE$;

    private Helpers$() {
    }

    static {
        MODULE$ = new Helpers$();
        isWindows = MODULE$.toRootLowerCase(System.getProperty("os.name", "")).indexOf("win") >= 0;
        formatter = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss.SSS");
        timeZone = ZoneId.systemDefault();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Helpers$.class);
    }

    public String toRootLowerCase(String s) {
        return s.toLowerCase(Locale.ROOT);
    }

    public boolean isWindows() {
        return isWindows;
    }

    public Pattern makePattern(String s) {
        return Pattern.compile(new StringBuilder(6).append("^\\Q").append(s.replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q")).append("\\E$").toString());
    }

    public int compareIdentityHash(Object a, Object b) {
        long diff = ((long)System.identityHashCode(a) & 0xFFFFFFFFL) - ((long)System.identityHashCode(b) & 0xFFFFFFFFL);
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 0;
    }

    public <T> Comparator<T> identityHashComparator(Comparator<T> comp) {
        return new Comparator<T>(comp){
            private final Comparator comp$1;
            {
                this.comp$1 = comp$2;
            }

            public int compare(Object a, Object b) {
                int n = Helpers$.MODULE$.compareIdentityHash(a, b);
                if (0 == n && !BoxesRunTime.equals((Object)a, (Object)b)) {
                    return this.comp$1.compare(a, b);
                }
                int x = n;
                return x;
            }
        };
    }

    public String currentTimeMillisToUTCString(long timestamp) {
        long timeOfDay = timestamp % 86400000L;
        long hours = timeOfDay / 3600000L;
        long minutes = timeOfDay / 60000L % 60L;
        long seconds = timeOfDay / 1000L % 60L;
        long ms = timeOfDay % 1000L;
        StringBuilder sb = new StringBuilder(15);
        if (hours < 10L) {
            sb.append(0);
        }
        sb.append(hours);
        sb.append(':');
        if (minutes < 10L) {
            sb.append(0);
        }
        sb.append(minutes);
        sb.append(':');
        if (seconds < 10L) {
            sb.append(0);
        }
        sb.append(seconds);
        sb.append('.');
        if (ms < 100L) {
            sb.append(0);
        }
        if (ms < 10L) {
            sb.append(0);
        }
        sb.append(ms);
        sb.append("UTC");
        return sb.toString();
    }

    public String timestamp(long time) {
        return formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(time), timeZone));
    }

    public final String base64chars() {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+~";
    }

    public String base64(long l, StringBuilder sb) {
        while (true) {
            sb.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+~".charAt((int)l & 0x3F));
            long next = l >>> 6;
            if (next == 0L) {
                return sb.toString();
            }
            l = next;
        }
    }

    public StringBuilder base64$default$2() {
        return new StringBuilder("$");
    }

    public final <A> Object Requiring(A value) {
        return value;
    }

    public final Config ConfigOps(Config config) {
        return config;
    }
}

