/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class Index<K, V> {
    private final int mapSize;
    private final Comparator valueComparator;
    private final ConcurrentHashMap<K, ConcurrentSkipListSet<V>> container;
    private final ConcurrentSkipListSet<V> emptySet;

    public Index(int mapSize, Comparator<V> valueComparator) {
        this.mapSize = mapSize;
        this.valueComparator = valueComparator;
        this.container = new ConcurrentHashMap(mapSize);
        this.emptySet = new ConcurrentSkipListSet();
    }

    public int mapSize() {
        return this.mapSize;
    }

    public Comparator<V> valueComparator() {
        return this.valueComparator;
    }

    public Index(int mapSize, Function2<V, V, Object> cmp) {
        this(mapSize, Index.Index$superArg$1(mapSize, cmp));
    }

    public boolean put(K key, V value) {
        return this.spinPut$1(key, value);
    }

    public Option<V> findValue(K key, Function1<V, Object> f) {
        ConcurrentSkipListSet<V> concurrentSkipListSet = this.container.get(key);
        if (concurrentSkipListSet == null) {
            return None$.MODULE$;
        }
        ConcurrentSkipListSet<V> set = concurrentSkipListSet;
        return package$JavaConverters$.MODULE$.IteratorHasAsScala(set.iterator()).asScala().find(f);
    }

    public Iterator<V> valueIterator(K key) {
        ConcurrentSkipListSet<V> concurrentSkipListSet = this.container.get(key);
        if (concurrentSkipListSet == null) {
            return package$.MODULE$.Iterator().empty();
        }
        ConcurrentSkipListSet<V> some = concurrentSkipListSet;
        return package$JavaConverters$.MODULE$.IteratorHasAsScala(some.iterator()).asScala();
    }

    public void foreach(Function2<K, V, BoxedUnit> fun) {
        package$JavaConverters$.MODULE$.IteratorHasAsScala(this.container.entrySet().iterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)e -> package$JavaConverters$.MODULE$.IteratorHasAsScala(((ConcurrentSkipListSet)e.getValue()).iterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)_$1 -> fun.apply(e.getKey(), _$1)));
    }

    public scala.collection.immutable.Set<V> values() {
        Builder builder = Predef$.MODULE$.Set().newBuilder();
        package$JavaConverters$.MODULE$.IteratorHasAsScala(this.container.values().iterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)values -> package$JavaConverters$.MODULE$.IteratorHasAsScala(values.iterator()).asScala().foreach((Function1 & Serializable)v -> (Builder)builder.$plus$eq(v)));
        return (scala.collection.immutable.Set)builder.result();
    }

    public Iterable<K> keys() {
        return package$JavaConverters$.MODULE$.SetHasAsScala(this.container.keySet()).asScala();
    }

    public boolean remove(K key, V value) {
        ConcurrentSkipListSet<V> set = this.container.get(key);
        if (set != null) {
            boolean bl;
            ConcurrentSkipListSet<V> concurrentSkipListSet = set;
            synchronized (concurrentSkipListSet) {
                boolean bl2;
                if (set.remove(value)) {
                    if (set.isEmpty()) {
                        this.container.remove(key, this.emptySet);
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                bl = bl2;
            }
            return bl;
        }
        return false;
    }

    public Option<Iterable<V>> remove(K key) {
        ConcurrentSkipListSet<V> set = this.container.get(key);
        if (set != null) {
            Some some;
            ConcurrentSkipListSet<V> concurrentSkipListSet = set;
            synchronized (concurrentSkipListSet) {
                this.container.remove(key, set);
                scala.collection.mutable.Set ret = package$JavaConverters$.MODULE$.SetHasAsScala((Set)set.clone()).asScala();
                set.clear();
                some = Some$.MODULE$.apply((Object)ret);
            }
            return some;
        }
        return None$.MODULE$;
    }

    public void removeValue(V value) {
        for (Map.Entry<K, ConcurrentSkipListSet<V>> e : this.container.entrySet()) {
            ConcurrentSkipListSet<V> set = e.getValue();
            if (set == null) continue;
            ConcurrentSkipListSet<V> concurrentSkipListSet = set;
            synchronized (concurrentSkipListSet) {
                BoxedUnit boxedUnit;
                if (set.remove(value)) {
                    if (set.isEmpty()) {
                        this.container.remove(e.getKey(), this.emptySet);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    public void clear() {
        for (Map.Entry<K, ConcurrentSkipListSet<V>> e : this.container.entrySet()) {
            ConcurrentSkipListSet<V> set = e.getValue();
            if (set == null) continue;
            ConcurrentSkipListSet<V> concurrentSkipListSet = set;
            synchronized (concurrentSkipListSet) {
                set.clear();
                this.container.remove(e.getKey(), this.emptySet);
            }
        }
    }

    private static <K, V> Comparator<V> Index$superArg$1(int mapSize, Function2<V, V, Object> cmp) {
        return (a, b) -> BoxesRunTime.unboxToInt((Object)cmp.apply(a, b));
    }

    private final boolean spinPut$1(Object k, Object v) {
        boolean added;
        boolean retry;
        do {
            retry = false;
            added = false;
            ConcurrentSkipListSet<V> set = this.container.get(k);
            if (set != null) {
                ConcurrentSkipListSet<V> concurrentSkipListSet = set;
                synchronized (concurrentSkipListSet) {
                    BoxedUnit boxedUnit;
                    if (set.isEmpty()) {
                        retry = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        added = set.add(v);
                        retry = false;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            } else {
                ConcurrentSkipListSet<V> newSet = new ConcurrentSkipListSet<V>(this.valueComparator());
                newSet.add(v);
                ConcurrentSkipListSet<V> oldSet = this.container.putIfAbsent(k, newSet);
                if (oldSet != null) {
                    ConcurrentSkipListSet<V> concurrentSkipListSet = oldSet;
                    synchronized (concurrentSkipListSet) {
                        BoxedUnit boxedUnit;
                        if (oldSet.isEmpty()) {
                            retry = true;
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            added = oldSet.add(v);
                            retry = false;
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                } else {
                    added = true;
                }
            }
        } while (retry);
        return added;
    }
}

