/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.DoubleLinkedList;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.apache.pekko.util.RecencyList$;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class RecencyList<A> {
    private final Clock clock;
    private final DoubleLinkedList<Node<A>> recency;
    private final Map<A, Node<A>> lookupNode;

    public static <A> RecencyList<A> empty() {
        return RecencyList$.MODULE$.empty();
    }

    public RecencyList(Clock clock) {
        this.clock = clock;
        this.recency = new DoubleLinkedList((Function1 & Serializable)_$1 -> new OptionVal<Node>(_$1.lessRecent()), (Function1 & Serializable)_$2 -> new OptionVal<Node>(_$2.moreRecent()), (Function2 & Serializable)(v1, v2) -> {
            ((Node)v1).lessRecent_$eq(v2 == null ? null : ((OptionVal)v2).x());
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable)(v1, v2) -> {
            ((Node)v1).moreRecent_$eq(v2 == null ? null : ((OptionVal)v2).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = (Map)Map$.MODULE$.empty();
    }

    public int size() {
        return this.lookupNode.size();
    }

    public RecencyList<A> update(A value) {
        Node node;
        if (this.lookupNode.contains(value)) {
            Node node2 = (Node)this.lookupNode.apply(value);
            node2.timestamp_$eq(this.clock.currentTime());
            node = this.recency.moveToBack(node2);
        } else {
            Node<A> node3 = new Node<A>(value);
            node3.timestamp_$eq(this.clock.currentTime());
            this.recency.append(node3);
            Object object = Predef$.MODULE$.ArrowAssoc(value);
            node = this.lookupNode.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, node3));
        }
        return this;
    }

    public RecencyList<A> remove(A value) {
        if (this.lookupNode.contains(value)) {
            this.removeNode((Node)this.lookupNode.apply(value));
        }
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode.contains(value);
    }

    public Object leastRecent() {
        Node node = (Node)this.recency.getFirst();
        Node node2 = (Node)OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node node3;
            Node first = node3 = (Node)OptionVal$.MODULE$.get$extension(node2);
            return OptionVal$Some$.MODULE$.apply(first.value());
        }
        return OptionVal$.MODULE$.none();
    }

    public Object mostRecent() {
        Node node = (Node)this.recency.getLast();
        Node node2 = (Node)OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node node3;
            Node last = node3 = (Node)OptionVal$.MODULE$.get$extension(node2);
            return OptionVal$Some$.MODULE$.apply(last.value());
        }
        return OptionVal$.MODULE$.none();
    }

    public Iterator<A> leastToMostRecent() {
        return this.recency.forwardIterator().map((Function1 & Serializable)_$3 -> _$3.value());
    }

    public Iterator<A> mostToLeastRecent() {
        return this.recency.backwardIterator().map((Function1 & Serializable)_$4 -> _$4.value());
    }

    public Seq<A> removeLeastRecent(int n) {
        if (n == 1) {
            return this.removeLeastRecent();
        }
        return this.recency.forwardIterator().take(n).map((Function1 & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public Seq<A> removeLeastRecent(int n, int skip) {
        return this.recency.forwardIterator().slice(skip, skip + n).map((Function1 & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public Seq<A> removeLeastRecent() {
        Node node = (Node)this.recency.getFirst();
        Node node2 = (Node)OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node node3;
            Node first = node3 = (Node)OptionVal$.MODULE$.get$extension(node2);
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.removeNode(first)}));
        }
        return package$.MODULE$.Nil();
    }

    public Seq<A> removeMostRecent(int n) {
        if (n == 1) {
            return this.removeMostRecent();
        }
        return this.recency.backwardIterator().take(n).map((Function1 & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public Seq<A> removeMostRecent(int n, int skip) {
        return this.recency.backwardIterator().slice(skip, skip + n).map((Function1 & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public Seq<A> removeMostRecent() {
        Node node = (Node)this.recency.getLast();
        Node node2 = (Node)OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node node3;
            Node last = node3 = (Node)OptionVal$.MODULE$.get$extension(node2);
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.removeNode(last)}));
        }
        return package$.MODULE$.Nil();
    }

    public Seq<A> removeLeastRecentOutside(FiniteDuration duration) {
        long min = this.clock.earlierTime(duration);
        return this.recency.forwardIterator().takeWhile((Function1 & Serializable)_$5 -> _$5.timestamp() < min).map((Function1 & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public Seq<A> removeMostRecentWithin(FiniteDuration duration) {
        long max = this.clock.earlierTime(duration);
        return this.recency.backwardIterator().takeWhile((Function1 & Serializable)_$6 -> _$6.timestamp() > max).map((Function1 & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    private A removeNode(Node<A> node) {
        A value = node.value();
        this.recency.remove(node);
        this.lookupNode.$minus$eq(value);
        return value;
    }

    public static interface Clock {
        public long currentTime();

        public long earlierTime(FiniteDuration var1);
    }

    public static final class NanoClock
    implements Clock {
        @Override
        public long currentTime() {
            return System.nanoTime();
        }

        @Override
        public long earlierTime(FiniteDuration duration) {
            return this.currentTime() - duration.toNanos();
        }
    }

    public static final class Node<A> {
        private final Object value;
        private Node lessRecent;
        private Node moreRecent;
        private long timestamp;

        public Node(A value) {
            this.value = value;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            this.timestamp = 0L;
        }

        public A value() {
            return (A)this.value;
        }

        public Node lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node x$1) {
            this.lessRecent = x$1;
        }

        public Node moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node x$1) {
            this.moreRecent = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }
    }
}

