/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import org.apache.pekko.util.Subclassification;
import org.apache.pekko.util.SubclassifiedIndex$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.ScalaRunTime$;

public class SubclassifiedIndex<K, V> {
    private Set values;
    private final Subclassification<K> sc;
    private Vector subkeys;
    private final SubclassifiedIndex root;

    public static <K, V> Map<K, Set<V>> emptyMergeMap() {
        return SubclassifiedIndex$.MODULE$.emptyMergeMap();
    }

    public SubclassifiedIndex(Set<V> values, Subclassification<K> sc) {
        this.values = values;
        this.sc = sc;
        this.subkeys = package$.MODULE$.Vector().empty();
        this.root = this;
    }

    public Set<V> values() {
        return this.values;
    }

    public void values_$eq(Set<V> x$1) {
        this.values = x$1;
    }

    public Vector<Nonroot<K, V>> subkeys() {
        return this.subkeys;
    }

    public void subkeys_$eq(Vector<Nonroot<K, V>> x$1) {
        this.subkeys = x$1;
    }

    public SubclassifiedIndex(Subclassification<K> sc) {
        this(Predef$.MODULE$.Set().empty(), sc);
    }

    public SubclassifiedIndex<K, V> root() {
        return this.root;
    }

    public Seq<Tuple2<K, Set<V>>> addKey(K key) {
        return this.mergeChangesByKey(this.innerAddKey(key));
    }

    public Seq<Tuple2<K, Set<V>>> innerAddKey(K key) {
        BooleanRef found = BooleanRef.create((boolean)false);
        Vector ch = (Vector)this.subkeys().flatMap((Function1 & Serializable)n -> {
            if (this.sc.isEqual(key, n.key())) {
                found$1.elem = true;
                return package$.MODULE$.Nil();
            }
            if (this.sc.isSubclass(key, n.key())) {
                found$1.elem = true;
                return n.innerAddKey(key);
            }
            return package$.MODULE$.Nil();
        });
        if (!found.elem) {
            return (Seq)this.integrate(new Nonroot<K, V>(this.root(), key, this.values(), this.sc)).$colon$plus((Object)Tuple2$.MODULE$.apply(key, this.values()));
        }
        return ch;
    }

    public Seq<Tuple2<K, Set<V>>> addValue(K key, V value) {
        return this.mergeChangesByKey(this.innerAddValue(key, value));
    }

    public Seq<Tuple2<K, Set<V>>> innerAddValue(K key, V value) {
        BooleanRef found = BooleanRef.create((boolean)false);
        Vector ch = (Vector)this.subkeys().flatMap((Function1 & Serializable)n -> {
            if (this.sc.isSubclass(key, n.key())) {
                found$2.elem = true;
                return n.innerAddValue(key, value);
            }
            return package$.MODULE$.Nil();
        });
        if (!found.elem) {
            Set v = (Set)this.values().$plus(value);
            Nonroot<K, V> n2 = new Nonroot<K, V>(this.root(), key, v, this.sc);
            Object object = Predef$.MODULE$.ArrowAssoc(key);
            return (Seq)((SeqOps)this.integrate(n2).$plus$plus(n2.innerAddValue(key, value))).$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)v));
        }
        return ch;
    }

    public Seq<Tuple2<K, Set<V>>> removeValue(K key, V value) {
        return (Seq)this.mergeChangesByKey(this.innerRemoveValue(key, value)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                return Tuple2$.MODULE$.apply(k, this.findValues(k));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Seq<Tuple2<K, Set<V>>> innerRemoveValue(K key, V value) {
        BooleanRef found = BooleanRef.create((boolean)false);
        Vector ch = (Vector)this.subkeys().flatMap((Function1 & Serializable)n -> {
            if (this.sc.isSubclass(key, n.key())) {
                found$3.elem = true;
                return n.innerRemoveValue(key, value);
            }
            return package$.MODULE$.Nil();
        });
        if (!found.elem) {
            Nonroot<K, V> n2 = new Nonroot<K, V>(this.root(), key, this.values(), this.sc);
            return (Seq)this.integrate(n2).$plus$plus(n2.removeValue(value));
        }
        return ch;
    }

    public Seq<Tuple2<K, Set<V>>> removeValue(V value) {
        return this.mergeChangesByKey((Seq)this.subkeys().flatMap((Function1 & Serializable)_$3 -> _$3.removeValue(value)));
    }

    public final Set<V> findValues(K key) {
        return this.root().innerFindValues(key);
    }

    public Set<V> innerFindValues(K key) {
        return (Set)this.subkeys().foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(s, n) -> {
            if (this.sc.isSubclass(key, n.key())) {
                return (Set)s.$plus$plus(n.innerFindValues(key));
            }
            return s;
        });
    }

    public final Set<K> findSubKeysExcept(K key, Vector<Nonroot<K, V>> except) {
        return this.root().innerFindSubKeys(key, except);
    }

    public Set<K> innerFindSubKeys(K key, Vector<Nonroot<K, V>> except) {
        return (Set)this.subkeys().foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(s, n) -> {
            if (this.sc.isEqual(key, n.key())) {
                return s;
            }
            return (Set)n.innerFindSubKeys(key, except).$plus$plus((IterableOnce)(this.sc.isSubclass(n.key(), key) && !except.exists((Function1 & Serializable)e -> this.sc.isEqual(key, e.key())) ? s.$plus(n.key()) : s));
        });
    }

    public String toString() {
        return this.subkeys().mkString(new StringBuilder(21).append("SubclassifiedIndex(").append(this.values()).append(",\n").toString(), ",\n", ")");
    }

    private Seq<Tuple2<K, Set<V>>> integrate(Nonroot<K, V> n2) {
        Tuple2 tuple2 = this.subkeys().partition((Function1 & Serializable)k -> this.sc.isSubclass(k.key(), n2.key()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector subsub = (Vector)tuple2._1();
        Vector sub = (Vector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)subsub, (Object)sub);
        Vector<Nonroot<K, V>> subsub2 = (Vector<Nonroot<K, V>>)tuple22._1();
        Vector sub2 = (Vector)tuple22._2();
        this.subkeys_$eq((Vector)sub2.$colon$plus(n2));
        n2.subkeys_$eq(subsub2.nonEmpty() ? subsub2 : n2.subkeys());
        n2.subkeys_$eq((Vector)n2.subkeys().$plus$plus((IterableOnce)this.findSubKeysExcept(n2.key(), n2.subkeys()).map((Function1 & Serializable)k -> new Nonroot<Object, V>(this.root(), k, this.values(), this.sc))));
        return (Seq)n2.subkeys().map((Function1 & Serializable)n -> Tuple2$.MODULE$.apply(n.key(), (Object)n.values().toSet()));
    }

    private Seq<Tuple2<K, Set<V>>> mergeChangesByKey(Seq<Tuple2<K, Set<V>>> changes) {
        return (Seq)((IterableOnceOps)changes.foldLeft(SubclassifiedIndex$.MODULE$.emptyMergeMap(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Map m = (Map)tuple2._1();
                if (tuple22 != null) {
                    Object k = tuple22._1();
                    Set s = (Set)tuple22._2();
                    return (Map)m.updated(k, (Object)((SetOps)m.apply(k)).$plus$plus((IterableOnce)s));
                }
            }
            throw new MatchError((Object)tuple2);
        })).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
    }

    public static class Nonroot<K, V>
    extends SubclassifiedIndex<K, V> {
        private final SubclassifiedIndex root;
        private final Object key;
        private final Subclassification<K> sc;

        public Nonroot(SubclassifiedIndex<K, V> root, K key, Set<V> _values, Subclassification<K> sc) {
            this.root = root;
            this.key = key;
            this.sc = sc;
            super(_values, sc);
        }

        @Override
        public SubclassifiedIndex<K, V> root() {
            return this.root;
        }

        public K key() {
            return (K)this.key;
        }

        @Override
        public Seq<Tuple2<K, Set<V>>> innerAddValue(K key, V value) {
            if (this.sc.isEqual(key, this.key())) {
                return this.org$apache$pekko$util$SubclassifiedIndex$Nonroot$$addValue(value);
            }
            return super.innerAddValue(key, value);
        }

        public Seq<Tuple2<K, Set<V>>> org$apache$pekko$util$SubclassifiedIndex$Nonroot$$addValue(V value) {
            Vector kids = (Vector)this.subkeys().flatMap(arg_0 -> SubclassifiedIndex$.org$apache$pekko$util$SubclassifiedIndex$Nonroot$$_$_$$anonfun$5(value, arg_0));
            if (!this.values().contains(value)) {
                this.values_$eq((Set)this.values().$plus(value));
                return (Seq)kids.$colon$plus((Object)Tuple2$.MODULE$.apply(this.key(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value}))));
            }
            return kids;
        }

        @Override
        public Seq<Tuple2<K, Set<V>>> innerRemoveValue(K key, V value) {
            if (this.sc.isEqual(key, this.key())) {
                return this.removeValue(value);
            }
            return super.innerRemoveValue(key, value);
        }

        @Override
        public Seq<Tuple2<K, Set<V>>> removeValue(V value) {
            Vector kids = (Vector)this.subkeys().flatMap(arg_0 -> SubclassifiedIndex$.org$apache$pekko$util$SubclassifiedIndex$Nonroot$$_$_$$anonfun$6(value, arg_0));
            if (this.values().contains(value)) {
                this.values_$eq((Set)this.values().$minus(value));
                return (Seq)kids.$colon$plus((Object)Tuple2$.MODULE$.apply(this.key(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value}))));
            }
            return kids;
        }

        @Override
        public Set<V> innerFindValues(K key) {
            if (this.sc.isEqual(key, this.key())) {
                return this.values();
            }
            return super.innerFindValues(key);
        }

        @Override
        public String toString() {
            return this.subkeys().mkString(new StringBuilder(12).append("Nonroot(").append(this.key()).append(", ").append(this.values()).append(",\n").toString(), ",\n", ")");
        }
    }
}

