/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.util.ArrayDeque;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.GenericOutlet;
import org.apache.pekko.stream.stage.OutHandler;
import scala.Predef$;

@InternalApi
public class BufferedOutlet<T>
implements OutHandler {
    private final GenericOutlet<T> outlet;
    private final ArrayDeque buffer;
    private boolean completed;

    public BufferedOutlet(GenericOutlet<T> outlet) {
        this.outlet = outlet;
        this.buffer = new ArrayDeque();
        this.completed = false;
        outlet.setHandler(this);
    }

    public ArrayDeque<T> buffer() {
        return this.buffer;
    }

    public boolean completed() {
        return this.completed;
    }

    public void completed_$eq(boolean x$1) {
        this.completed = x$1;
    }

    public void doPush(T elem) {
        this.outlet.push(elem);
    }

    public void onPull() {
        this.tryFlush();
    }

    public void push(T elem) {
        if (this.outlet.canBePushed() && this.buffer().isEmpty()) {
            this.doPush(elem);
            return;
        }
        this.buffer().addLast(elem);
    }

    public void complete() {
        Predef$.MODULE$.require(!this.completed(), BufferedOutlet::complete$$anonfun$1);
        this.completed_$eq(true);
        if (this.buffer().isEmpty()) {
            this.outlet.complete();
            return;
        }
    }

    public void fail(Throwable cause) {
        this.buffer().clear();
        this.outlet.fail(cause);
    }

    public void tryFlush() {
        if (this.outlet.canBePushed() && !this.buffer().isEmpty()) {
            this.doPush(this.buffer().pop());
        }
        if (this.buffer().isEmpty() && this.completed()) {
            this.outlet.complete();
            return;
        }
    }

    private static final Object complete$$anonfun$1() {
        return "Can only complete once.";
    }
}

