/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import java.util.ArrayDeque;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.BufferedOutletExtended$ElementAndTrigger$;
import org.apache.pekko.http.impl.engine.http2.GenericOutlet;
import org.apache.pekko.stream.stage.OutHandler;
import scala.Function0;
import scala.Product;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@InternalApi
public class BufferedOutletExtended<T>
implements OutHandler {
    private final GenericOutlet<T> outlet;
    public final BufferedOutletExtended$ElementAndTrigger$ ElementAndTrigger$lzy1;
    private final ArrayDeque buffer;

    public BufferedOutletExtended(GenericOutlet<T> outlet) {
        this.outlet = outlet;
        this.ElementAndTrigger$lzy1 = new BufferedOutletExtended$ElementAndTrigger$(this);
        this.buffer = new ArrayDeque();
        outlet.setHandler(this);
    }

    public final BufferedOutletExtended$ElementAndTrigger$ ElementAndTrigger() {
        return this.ElementAndTrigger$lzy1;
    }

    public final ArrayDeque<ElementAndTrigger> buffer() {
        return this.buffer;
    }

    public void doPush(ElementAndTrigger elem) {
        this.outlet.push(elem.element());
        elem.trigger().apply$mcV$sp();
    }

    public void onPull() {
        if (!this.buffer().isEmpty()) {
            this.doPush(this.buffer().pop());
            return;
        }
    }

    public final void push(T element) {
        this.pushWithTrigger(element, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {});
    }

    public final void pushWithTrigger(T elem, Function0<BoxedUnit> trigger) {
        if (this.outlet.canBePushed() && this.buffer().isEmpty()) {
            this.doPush(this.ElementAndTrigger().apply(elem, trigger));
            return;
        }
        this.buffer().addLast(this.ElementAndTrigger().apply(elem, trigger));
    }

    public void tryFlush() {
        if (this.outlet.canBePushed() && !this.buffer().isEmpty()) {
            this.doPush(this.buffer().pop());
            return;
        }
    }

    public class ElementAndTrigger
    implements Product,
    Serializable {
        private final Object element;
        private final Function0 trigger;
        private final /* synthetic */ BufferedOutletExtended $outer;

        public ElementAndTrigger(BufferedOutletExtended $outer, T element, Function0<BoxedUnit> trigger) {
            this.element = element;
            this.trigger = trigger;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ElementAndTrigger)) return false;
            if (((ElementAndTrigger)object).org$apache$pekko$http$impl$engine$http2$BufferedOutletExtended$ElementAndTrigger$$$outer() != this.$outer) return false;
            ElementAndTrigger elementAndTrigger = (ElementAndTrigger)object;
            if (!BoxesRunTime.equals(this.element(), elementAndTrigger.element())) return false;
            Function0<BoxedUnit> function0 = this.trigger();
            Function0<BoxedUnit> function02 = elementAndTrigger.trigger();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            if (!elementAndTrigger.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ElementAndTrigger;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ElementAndTrigger";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "element";
            }
            if (1 == n2) {
                return "trigger";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public T element() {
            return this.element;
        }

        public Function0<BoxedUnit> trigger() {
            return this.trigger;
        }

        public ElementAndTrigger copy(T element, Function0<BoxedUnit> trigger) {
            return new ElementAndTrigger(this.$outer, element, trigger);
        }

        public T copy$default$1() {
            return this.element();
        }

        public Function0<BoxedUnit> copy$default$2() {
            return this.trigger();
        }

        public T _1() {
            return this.element();
        }

        public Function0<BoxedUnit> _2() {
            return this.trigger();
        }

        public final /* synthetic */ BufferedOutletExtended org$apache$pekko$http$impl$engine$http2$BufferedOutletExtended$ElementAndTrigger$$$outer() {
            return this.$outer;
        }
    }
}

