/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$ContinuationFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$DataFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$GoAwayFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$HeadersFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$ParsedHeadersFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PingFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$PriorityFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$RstStreamFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$Setting$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$SettingsAckFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$SettingsFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent$WindowUpdateFrame$;
import org.apache.pekko.http.impl.engine.http2.FrameLogger;
import org.apache.pekko.http.impl.engine.http2.FrameLogger$LogEntry$3$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public final class FrameLogger$
implements Serializable {
    public static final FrameLogger$ MODULE$ = new FrameLogger$();

    private FrameLogger$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FrameLogger$.class);
    }

    public final int maxBytes() {
        return 16;
    }

    public BidiFlow<FrameEvent, FrameEvent, FrameEvent, FrameEvent, NotUsed> logFramesIfEnabled(boolean shouldLog) {
        if (shouldLog) {
            return this.bidi();
        }
        return BidiFlow$.MODULE$.identity();
    }

    public BidiFlow<FrameEvent, FrameEvent, FrameEvent, FrameEvent, NotUsed> bidi() {
        Flow flow = Flow$.MODULE$.apply();
        String string = new StringBuilder(13).append("\u001b[31m").append("DOWN").append("\u001b[0m").toString();
        Function1 & Serializable intersect = (Function1 & Serializable)frameEvent -> MODULE$.logEvent((FrameEvent)frameEvent);
        Flow flow2 = Flow$.MODULE$.apply();
        String string2 = new StringBuilder(13).append("\u001b[32m").append(" UP ").append("\u001b[0m").toString();
        Function1 & Serializable intersect2 = (Function1 & Serializable)frameEvent -> MODULE$.logEvent((FrameEvent)frameEvent);
        return BidiFlow$.MODULE$.fromFlows((Graph)flow.log(string, (Function1)intersect, flow.log$default$3(string, (Function1)intersect)), (Graph)flow2.log(string2, (Function1)intersect2, flow2.log$default$3(string2, (Function1)intersect2))).addAttributes(Attributes$.MODULE$.apply((Attributes.Attribute)Attributes.LogLevels$.MODULE$.apply(Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel())));
    }

    public String logEvent(FrameEvent frameEvent) {
        LazyRef lazyRef = new LazyRef();
        public class Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1
        implements Product,
        Serializable {
            private final int streamId;
            private final String shortFrameType;
            private final String extraInfo;
            private final Seq flags;

            public Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(int streamId, String shortFrameType, String extraInfo, Seq flags) {
                this.streamId = streamId;
                this.shortFrameType = shortFrameType;
                this.extraInfo = extraInfo;
                this.flags = flags;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)this.streamId());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shortFrameType()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.extraInfo()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.flags()));
                return Statics.finalizeHash((int)n, (int)4);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1)) return false;
                Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1 var3_3 = (Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1)object;
                if (this.streamId() != var3_3.streamId()) return false;
                String string = this.shortFrameType();
                String string2 = var3_3.shortFrameType();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = this.extraInfo();
                String string4 = var3_3.extraInfo();
                if (string3 == null) {
                    if (string4 != null) {
                        return false;
                    }
                } else if (!string3.equals(string4)) return false;
                Seq seq = this.flags();
                Seq seq2 = var3_3.flags();
                if (seq == null) {
                    if (seq2 != null) {
                        return false;
                    }
                } else if (!seq.equals(seq2)) return false;
                if (!var3_3.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1;
            }

            public int productArity() {
                return 4;
            }

            public String productPrefix() {
                return "LogEntry";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return BoxesRunTime.boxToInteger((int)this._1());
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return this._3();
                    }
                    case 3: {
                        return this._4();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "streamId";
                    }
                    case 1: {
                        return "shortFrameType";
                    }
                    case 2: {
                        return "extraInfo";
                    }
                    case 3: {
                        return "flags";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public int streamId() {
                return this.streamId;
            }

            public String shortFrameType() {
                return this.shortFrameType;
            }

            public String extraInfo() {
                return this.extraInfo;
            }

            public Seq flags() {
                return this.flags;
            }

            public int _1() {
                return this.streamId();
            }

            public String _2() {
                return this.shortFrameType();
            }

            public String _3() {
                return this.extraInfo();
            }

            public Seq _4() {
                return this.flags();
            }
        }
        return this.display$1(this.entryForFrame$1(lazyRef, frameEvent));
    }

    private String formatSettings(Seq<FrameEvent.Setting> s2) {
        return ((IterableOnceOps)s2.map((Function1 & Serializable)x$1 -> {
            FrameEvent.Setting setting = x$1;
            if (setting != null) {
                FrameEvent.Setting setting2 = FrameEvent$Setting$.MODULE$.unapply(setting);
                Http2Protocol.SettingIdentifier settingIdentifier = setting2._1();
                int n = setting2._2();
                Http2Protocol.SettingIdentifier id = settingIdentifier;
                int value = n;
                return new StringBuilder(4).append(id).append(" -> ").append(value).toString();
            }
            throw new MatchError((Object)setting);
        })).mkString(", ");
    }

    private final FrameLogger$LogEntry$3$ LogEntry$lzyINIT1$1(LazyRef LogEntry$lzy1$1) {
        FrameLogger$LogEntry$3$ frameLogger$LogEntry$3$;
        LazyRef lazyRef = LogEntry$lzy1$1;
        synchronized (lazyRef) {
            frameLogger$LogEntry$3$ = (FrameLogger$LogEntry$3$)(LogEntry$lzy1$1.initialized() ? LogEntry$lzy1$1.value() : LogEntry$lzy1$1.initialize((Object)new FrameLogger$LogEntry$3$()));
        }
        return frameLogger$LogEntry$3$;
    }

    private final FrameLogger$LogEntry$3$ LogEntry$2(LazyRef LogEntry$lzy1$2) {
        return (FrameLogger$LogEntry$3$)(LogEntry$lzy1$2.initialized() ? LogEntry$lzy1$2.value() : this.LogEntry$lzyINIT1$1(LogEntry$lzy1$2));
    }

    private final Option flag$1(boolean value, String name) {
        if (value) {
            return Some$.MODULE$.apply((Object)name);
        }
        return None$.MODULE$;
    }

    private final String hex$1(ByteString bytes) {
        int num = package$.MODULE$.min(16, bytes.size());
        String ellipsis = num < bytes.size() ? new StringBuilder(18).append(" [... ").append(bytes.size() - num).append(" more bytes]").toString() : "";
        return new StringBuilder(0).append(((IterableOnceOps)bytes.take(num).map((Function1 & Serializable)_$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)_$1))})))).mkString(" ")).append(ellipsis).toString();
    }

    private final FrameLogger.LogEntry.1 entryForFrame$1(LazyRef LogEntry$lzy1$3, FrameEvent frameEvent) {
        FrameEvent frameEvent2 = frameEvent;
        if (frameEvent2 instanceof FrameEvent.PingFrame) {
            FrameEvent.PingFrame pingFrame = FrameEvent$PingFrame$.MODULE$.unapply((FrameEvent.PingFrame)frameEvent2);
            boolean bl = pingFrame._1();
            ByteString byteString = pingFrame._2();
            if (!bl) {
                ByteString data = byteString;
                return this.LogEntry$2(LogEntry$lzy1$3).apply(0, "PING", this.hex$1(data), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[0]));
            }
            if (bl) {
                ByteString data = byteString;
                return this.LogEntry$2(LogEntry$lzy1$3).apply(0, "PONG", this.hex$1(data), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[0]));
            }
        }
        if (frameEvent2 instanceof FrameEvent.HeadersFrame) {
            FrameEvent.HeadersFrame headersFrame = FrameEvent$HeadersFrame$.MODULE$.unapply((FrameEvent.HeadersFrame)frameEvent2);
            int n = headersFrame._1();
            boolean bl = headersFrame._2();
            boolean bl2 = headersFrame._3();
            ByteString byteString = headersFrame._4();
            Option<FrameEvent.PriorityFrame> option = headersFrame._5();
            int streamId = n;
            boolean endStream = bl;
            boolean endHeaders = bl2;
            ByteString payload = byteString;
            Option<FrameEvent.PriorityFrame> prio = option;
            String prioInfo = prio.isDefined() ? new StringBuilder(1).append(this.display$1(this.entryForFrame$1(LogEntry$lzy1$3, (FrameEvent)prio.get()))).append(" ").toString() : "";
            return this.LogEntry$2(LogEntry$lzy1$3).apply(streamId, "HEAD", new StringBuilder(0).append(prioInfo).append(this.hex$1(payload)).toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.flag$1(endStream, "ES"), this.flag$1(endHeaders, "EH")}));
        }
        if (frameEvent2 instanceof FrameEvent.ContinuationFrame) {
            FrameEvent.ContinuationFrame continuationFrame = FrameEvent$ContinuationFrame$.MODULE$.unapply((FrameEvent.ContinuationFrame)frameEvent2);
            int n = continuationFrame._1();
            boolean bl = continuationFrame._2();
            ByteString byteString = continuationFrame._3();
            int streamId = n;
            boolean endHeaders = bl;
            ByteString payload = byteString;
            return this.LogEntry$2(LogEntry$lzy1$3).apply(streamId, "CONT", this.hex$1(payload), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.flag$1(endHeaders, "EH")}));
        }
        if (frameEvent2 instanceof FrameEvent.DataFrame) {
            FrameEvent.DataFrame dataFrame = FrameEvent$DataFrame$.MODULE$.unapply((FrameEvent.DataFrame)frameEvent2);
            int n = dataFrame._1();
            boolean bl = dataFrame._2();
            ByteString byteString = dataFrame._3();
            int streamId = n;
            boolean endStream = bl;
            ByteString payload = byteString;
            return this.LogEntry$2(LogEntry$lzy1$3).apply(streamId, "DATA", this.hex$1(payload), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.flag$1(endStream, "ES")}));
        }
        if (frameEvent2 instanceof FrameEvent.GoAwayFrame) {
            FrameEvent.GoAwayFrame goAwayFrame = FrameEvent$GoAwayFrame$.MODULE$.unapply((FrameEvent.GoAwayFrame)frameEvent2);
            int n = goAwayFrame._1();
            Http2Protocol.ErrorCode errorCode = goAwayFrame._2();
            ByteString byteString = goAwayFrame._3();
            int lastStreamId = n;
            Http2Protocol.ErrorCode errorCode2 = errorCode;
            ByteString debug = byteString;
            return this.LogEntry$2(LogEntry$lzy1$3).apply(0, "GOAY", new StringBuilder(39).append("lastStreamId = ").append(lastStreamId).append(", errorCode = ").append(errorCode2).append(", debug = ").append(debug.utf8String()).toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[0]));
        }
        if (frameEvent2 instanceof FrameEvent.ParsedHeadersFrame) {
            FrameEvent.ParsedHeadersFrame parsedHeadersFrame = FrameEvent$ParsedHeadersFrame$.MODULE$.unapply((FrameEvent.ParsedHeadersFrame)frameEvent2);
            int n = parsedHeadersFrame._1();
            boolean bl = parsedHeadersFrame._2();
            Seq<Tuple2<String, Object>> seq = parsedHeadersFrame._3();
            Option<FrameEvent.PriorityFrame> option = parsedHeadersFrame._4();
            int streamId = n;
            boolean endStream = bl;
            Seq<Tuple2<String, Object>> kvPairs = seq;
            Option<FrameEvent.PriorityFrame> prio = option;
            String prioInfo = prio.isDefined() ? new StringBuilder(1).append(this.display$1(this.entryForFrame$1(LogEntry$lzy1$3, (FrameEvent)prio.get()))).append(" ").toString() : "";
            String kvInfo = ((IterableOnceOps)kvPairs.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    return new StringBuilder(4).append(key).append(" -> ").append(value).toString();
                }
                throw new MatchError((Object)tuple2);
            })).mkString(", ");
            return this.LogEntry$2(LogEntry$lzy1$3).apply(streamId, "HEAD", new StringBuilder(0).append(prioInfo).append(kvInfo).toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.flag$1(endStream, "ES")}));
        }
        if (frameEvent2 instanceof FrameEvent.PriorityFrame) {
            FrameEvent.PriorityFrame priorityFrame = FrameEvent$PriorityFrame$.MODULE$.unapply((FrameEvent.PriorityFrame)frameEvent2);
            int n = priorityFrame._1();
            boolean bl = priorityFrame._2();
            int n2 = priorityFrame._3();
            int n3 = priorityFrame._4();
            int streamId = n;
            boolean exclusive = bl;
            int streamDependency = n2;
            int weight = n3;
            return this.LogEntry$2(LogEntry$lzy1$3).apply(streamId, "PRIO", new StringBuilder(29).append("streamDependency = ").append(streamDependency).append(", weight: ").append(weight).toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.flag$1(exclusive, "EX")}));
        }
        if (frameEvent2 instanceof FrameEvent.RstStreamFrame) {
            FrameEvent.RstStreamFrame rstStreamFrame = FrameEvent$RstStreamFrame$.MODULE$.unapply((FrameEvent.RstStreamFrame)frameEvent2);
            int n = rstStreamFrame._1();
            Http2Protocol.ErrorCode errorCode = rstStreamFrame._2();
            int streamId = n;
            Http2Protocol.ErrorCode errorCode3 = errorCode;
            return this.LogEntry$2(LogEntry$lzy1$3).apply(streamId, "RSET", errorCode3.toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[0]));
        }
        if (frameEvent2 instanceof FrameEvent.SettingsFrame) {
            Seq<FrameEvent.Setting> seq;
            FrameEvent.SettingsFrame settingsFrame = FrameEvent$SettingsFrame$.MODULE$.unapply((FrameEvent.SettingsFrame)frameEvent2);
            Seq<FrameEvent.Setting> settings = seq = settingsFrame._1();
            String settingsInfo = ((IterableOnceOps)settings.map((Function1 & Serializable)x$1 -> {
                FrameEvent.Setting setting = x$1;
                if (setting != null) {
                    FrameEvent.Setting setting2 = FrameEvent$Setting$.MODULE$.unapply(setting);
                    Http2Protocol.SettingIdentifier settingIdentifier = setting2._1();
                    int n = setting2._2();
                    Http2Protocol.SettingIdentifier id = settingIdentifier;
                    int value = n;
                    return new StringBuilder(4).append(id).append(" -> ").append(value).toString();
                }
                throw new MatchError((Object)setting);
            })).mkString(", ");
            return this.LogEntry$2(LogEntry$lzy1$3).apply(0, "SETT", settingsInfo, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[0]));
        }
        if (frameEvent2 instanceof FrameEvent.SettingsAckFrame) {
            Seq<FrameEvent.Setting> seq;
            FrameEvent.SettingsAckFrame settingsAckFrame = FrameEvent$SettingsAckFrame$.MODULE$.unapply((FrameEvent.SettingsAckFrame)frameEvent2);
            Seq<FrameEvent.Setting> s2 = seq = settingsAckFrame._1();
            String acksInfo = this.formatSettings(s2);
            return this.LogEntry$2(LogEntry$lzy1$3).apply(0, "SETA", acksInfo, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[0]));
        }
        if (frameEvent2 instanceof FrameEvent.WindowUpdateFrame) {
            FrameEvent.WindowUpdateFrame windowUpdateFrame = FrameEvent$WindowUpdateFrame$.MODULE$.unapply((FrameEvent.WindowUpdateFrame)frameEvent2);
            int n = windowUpdateFrame._1();
            int n4 = windowUpdateFrame._2();
            int streamId = n;
            int windowSizeIncrement = n4;
            return this.LogEntry$2(LogEntry$lzy1$3).apply(streamId, "WIND", new StringBuilder(2).append("+ ").append(windowSizeIncrement).toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[0]));
        }
        if (frameEvent2 instanceof FrameEvent.StreamFrameEvent) {
            FrameEvent.StreamFrameEvent other = (FrameEvent.StreamFrameEvent)frameEvent2;
            return this.LogEntry$2(LogEntry$lzy1$3).apply(other.streamId(), "UNKN", other.toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[0]));
        }
        FrameEvent other = frameEvent2;
        return this.LogEntry$2(LogEntry$lzy1$3).apply(0, "UNKN", other.toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[0]));
    }

    private final String display$1(FrameLogger.LogEntry.1 entry) {
        return StringOps$.MODULE$.format$extension("%s%4d %s%s %s%s %s%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"\u001b[32m", BoxesRunTime.boxToInteger((int)entry.streamId()), "\u001b[33m", entry.shortFrameType(), "\u001b[31m", ((IterableOnceOps)entry.flags().flatMap((Function1 & Serializable)x -> x)).mkString(" "), "\u001b[0m", entry.extraInfo()}));
    }
}

