/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.Http2Compliance$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$ErrorCode$FRAME_SIZE_ERROR$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$ErrorCode$PROTOCOL_ERROR$;
import scala.runtime.Nothing$;

@InternalApi
public final class Http2Compliance {
    public static boolean isClientInitiatedStreamId(int n) {
        return Http2Compliance$.MODULE$.isClientInitiatedStreamId(n);
    }

    public static Nothing$ missingHttpIdHeaderException() {
        return Http2Compliance$.MODULE$.missingHttpIdHeaderException();
    }

    public static void requireFrameSize(int n, int n2) {
        Http2Compliance$.MODULE$.requireFrameSize(n, n2);
    }

    public static void requireNoSelfDependency(int n, int n2) {
        Http2Compliance$.MODULE$.requireNoSelfDependency(n, n2);
    }

    public static void requireNonZeroStreamId(int n) {
        Http2Compliance$.MODULE$.requireNonZeroStreamId(n);
    }

    public static void requirePositiveWindowUpdateIncrement(int n, int n2) {
        Http2Compliance$.MODULE$.requirePositiveWindowUpdateIncrement(n, n2);
    }

    public static void requireZeroStreamId(int n) {
        Http2Compliance$.MODULE$.requireZeroStreamId(n);
    }

    public static void validateMaxFrameSize(int n) {
        Http2Compliance$.MODULE$.validateMaxFrameSize(n);
    }

    public static class Http2ProtocolException
    extends IllegalStateException {
        private final Http2Protocol.ErrorCode errorCode;

        public Http2ProtocolException(Http2Protocol.ErrorCode errorCode, String message) {
            this.errorCode = errorCode;
            super(message);
        }

        public Http2Protocol.ErrorCode errorCode() {
            return this.errorCode;
        }

        public Http2ProtocolException(String message) {
            this(Http2Protocol$ErrorCode$PROTOCOL_ERROR$.MODULE$, message);
        }
    }

    public static class Http2ProtocolStreamException
    extends IllegalStateException {
        private final int streamId;
        private final Http2Protocol.ErrorCode errorCode;

        public Http2ProtocolStreamException(int streamId, Http2Protocol.ErrorCode errorCode, String message) {
            this.streamId = streamId;
            this.errorCode = errorCode;
            super(message);
        }

        public int streamId() {
            return this.streamId;
        }

        public Http2Protocol.ErrorCode errorCode() {
            return this.errorCode;
        }
    }

    public static class IllegalHttp2FrameSize
    extends Http2ProtocolException {
        public IllegalHttp2FrameSize(int size, String expected) {
            super(Http2Protocol$ErrorCode$FRAME_SIZE_ERROR$.MODULE$, new StringBuilder(32).append("Illegal HTTP/2 frame size: [").append(size).append("]. ").append(expected).append("!").toString());
        }
    }

    public static final class IllegalHttp2StreamDependency
    extends Http2ProtocolException {
        public IllegalHttp2StreamDependency(int id) {
            super(new StringBuilder(45).append("Illegal self dependency of stream for id: [").append(id).append("]!").toString());
        }
    }

    public static final class IllegalHttp2StreamIdException
    extends Http2ProtocolException {
        public IllegalHttp2StreamIdException(int id, String expected) {
            super(new StringBuilder(31).append("Illegal HTTP/2 stream id: [").append(id).append("]. ").append(expected).append("!").toString());
        }
    }

    public static final class IllegalPayloadInSettingsAckFrame
    extends IllegalHttp2FrameSize {
        public IllegalPayloadInSettingsAckFrame(int size, String expected) {
            super(size, expected);
        }
    }

    public static final class IllegalPayloadLengthInSettingsFrame
    extends IllegalHttp2FrameSize {
        public IllegalPayloadLengthInSettingsFrame(int size, String expected) {
            super(size, expected);
        }
    }

    public static final class MissingHttpIdHeaderException
    extends Http2ProtocolException {
        public MissingHttpIdHeaderException() {
            super("Expected `Http2StreamIdHeader` header to be present but was missing!");
        }
    }
}

