/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.PriorityNode;
import org.apache.pekko.http.impl.engine.http2.PriorityTree$;
import org.apache.pekko.http.impl.engine.http2.PriorityTree$PriorityInfo$;
import org.apache.pekko.http.impl.engine.http2.util.AsciiTreeLayout$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedMapOps;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public interface PriorityTree {
    public static PriorityTree apply() {
        return PriorityTree$.MODULE$.apply();
    }

    public PriorityTree insertOrUpdate(int var1, int var2, int var3, boolean var4);

    public PriorityNode rootNode();

    public String print();

    public static class PriorityInfo
    implements Product,
    Serializable {
        private final int streamId;
        private final int streamDependency;
        private final int weight;
        private final TreeSet childrenIds;

        public static PriorityInfo apply(int n, int n2, int n3, TreeSet<Object> treeSet) {
            return PriorityTree$PriorityInfo$.MODULE$.apply(n, n2, n3, treeSet);
        }

        public static PriorityInfo fromProduct(Product product) {
            return PriorityTree$PriorityInfo$.MODULE$.fromProduct(product);
        }

        public static PriorityInfo unapply(PriorityInfo priorityInfo) {
            return PriorityTree$PriorityInfo$.MODULE$.unapply(priorityInfo);
        }

        public PriorityInfo(int streamId, int streamDependency, int weight, TreeSet<Object> childrenIds) {
            this.streamId = streamId;
            this.streamDependency = streamDependency;
            this.weight = weight;
            this.childrenIds = childrenIds;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)this.streamDependency());
            n = Statics.mix((int)n, (int)this.weight());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.childrenIds()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PriorityInfo)) return false;
            PriorityInfo priorityInfo = (PriorityInfo)object;
            if (this.streamId() != priorityInfo.streamId()) return false;
            if (this.streamDependency() != priorityInfo.streamDependency()) return false;
            if (this.weight() != priorityInfo.weight()) return false;
            TreeSet<Object> treeSet = this.childrenIds();
            TreeSet<Object> treeSet2 = priorityInfo.childrenIds();
            if (treeSet == null) {
                if (treeSet2 != null) {
                    return false;
                }
            } else if (!treeSet.equals(treeSet2)) return false;
            if (!priorityInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PriorityInfo;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PriorityInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "streamId";
                }
                case 1: {
                    return "streamDependency";
                }
                case 2: {
                    return "weight";
                }
                case 3: {
                    return "childrenIds";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int streamId() {
            return this.streamId;
        }

        public int streamDependency() {
            return this.streamDependency;
        }

        public int weight() {
            return this.weight;
        }

        public TreeSet<Object> childrenIds() {
            return this.childrenIds;
        }

        public PriorityInfo copy(int streamId, int streamDependency, int weight, TreeSet<Object> childrenIds) {
            return new PriorityInfo(streamId, streamDependency, weight, childrenIds);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public int copy$default$2() {
            return this.streamDependency();
        }

        public int copy$default$3() {
            return this.weight();
        }

        public TreeSet<Object> copy$default$4() {
            return this.childrenIds();
        }

        public int _1() {
            return this.streamId();
        }

        public int _2() {
            return this.streamDependency();
        }

        public int _3() {
            return this.weight();
        }

        public TreeSet<Object> _4() {
            return this.childrenIds();
        }
    }

    public static class PriorityTreeImpl
    implements PriorityTree {
        public final TreeMap<Object, PriorityInfo> org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes;

        public PriorityTreeImpl(TreeMap<Object, PriorityInfo> nodes) {
            this.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes = nodes;
        }

        @Override
        public PriorityNode rootNode() {
            return this.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$node(0);
        }

        @Override
        public PriorityTree insertOrUpdate(int streamId, int streamDependency, int weight, boolean exclusive) {
            if (this.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.isDefinedAt((Object)BoxesRunTime.boxToInteger((int)streamId))) {
                return this.update(streamId, streamDependency, weight, exclusive);
            }
            return this.insert(streamId, streamDependency, weight, exclusive);
        }

        private PriorityTreeImpl insert(int streamId, int streamDependency, int weight, boolean exclusive) {
            while (true) {
                Predef$.MODULE$.require(!this_.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.isDefinedAt((Object)BoxesRunTime.boxToInteger((int)streamId)), () -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$insert$$anonfun$1(streamId));
                Predef$.MODULE$.require(streamId != streamDependency, () -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$insert$$anonfun$2(streamId));
                if (this_.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.isDefinedAt((Object)BoxesRunTime.boxToInteger((int)streamDependency))) {
                    PriorityInfo dependencyInfo = (PriorityInfo)this_.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.apply((Object)BoxesRunTime.boxToInteger((int)streamDependency));
                    if (!exclusive) {
                        return this_.insertNode(PriorityTree$PriorityInfo$.MODULE$.apply(streamId, streamDependency, weight, (TreeSet<Object>)TreeSet$.MODULE$.empty((Ordering)Ordering.Int$.MODULE$))).updateNode(streamDependency, this_.updateChildren((Function1<TreeSet<Object>, TreeSet<Object>>)((Function1 & Serializable)arg_0 -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$insert$$anonfun$3(streamId, arg_0))));
                    }
                    return this_.insertNode(PriorityTree$PriorityInfo$.MODULE$.apply(streamId, streamDependency, weight, dependencyInfo.childrenIds())).updateNode(streamDependency, this_.updateChildren((Function1<TreeSet<Object>, TreeSet<Object>>)((Function1 & Serializable)arg_0 -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$insert$$anonfun$4(streamId, arg_0))));
                }
                PriorityTreeImpl this_ = this_.insertNode(PriorityTree$PriorityInfo$.MODULE$.apply(streamDependency, 0, 16, (TreeSet<Object>)TreeSet$.MODULE$.empty((Ordering)Ordering.Int$.MODULE$)));
            }
        }

        private PriorityTree update(int streamId, int newStreamDependency, int newWeight, boolean newlyExclusive) {
            while (true) {
                Predef$.MODULE$.require(this_.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.isDefinedAt((Object)BoxesRunTime.boxToInteger((int)streamId)), () -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$update$$anonfun$1(streamId));
                Predef$.MODULE$.require(streamId != newStreamDependency, () -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$update$$anonfun$2(streamId));
                if (this_.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.isDefinedAt((Object)BoxesRunTime.boxToInteger((int)newStreamDependency))) {
                    PriorityInfo oldInfo = (PriorityInfo)this_.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.apply((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!newlyExclusive && newStreamDependency == this_.dependencyOf(streamId)) {
                        return this_.updateNode(streamId, (Function1<PriorityInfo, PriorityInfo>)((Function1 & Serializable)arg_0 -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$update$$anonfun$3(newWeight, arg_0)));
                    }
                    if (!this_.dependsTransitivelyOn(newStreamDependency, streamId)) {
                        return this_.remove(streamId).insert(streamId, newStreamDependency, newWeight, newlyExclusive).updateNode(streamId, this_.updateChildren((Function1<TreeSet<Object>, TreeSet<Object>>)((Function1 & Serializable)arg_0 -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$update$$anonfun$4(oldInfo, arg_0))));
                    }
                    return this_;
                }
                PriorityTreeImpl this_ = this_.insert(newStreamDependency, 0, 16, false);
            }
        }

        private PriorityTreeImpl remove(int streamId) {
            Predef$.MODULE$.require(this.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.isDefinedAt((Object)BoxesRunTime.boxToInteger((int)streamId)), PriorityTree$::org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$remove$$anonfun$1);
            Predef$.MODULE$.require(streamId != 0, PriorityTree$::org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$remove$$anonfun$2);
            PriorityInfo info = (PriorityInfo)this.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.apply((Object)BoxesRunTime.boxToInteger((int)streamId));
            PriorityInfo dependencyInfo = (PriorityInfo)this.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.apply((Object)BoxesRunTime.boxToInteger((int)info.streamDependency()));
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.streamDependency()));
            TreeSet treeSet = (TreeSet)dependencyInfo.childrenIds().$minus((Object)BoxesRunTime.boxToInteger((int)streamId));
            int n2 = dependencyInfo.copy$default$1();
            int n3 = dependencyInfo.copy$default$2();
            int n4 = dependencyInfo.copy$default$3();
            return PriorityTree$.MODULE$.org$apache$pekko$http$impl$engine$http2$PriorityTree$$$create((TreeMap<Object, PriorityInfo>)((TreeMap)((scala.collection.SortedMapOps)((SortedMapOps)this.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.$minus((Object)BoxesRunTime.boxToInteger((int)streamId))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)dependencyInfo.copy(n2, n3, n4, (TreeSet<Object>)treeSet)))).$plus$plus((IterableOnce)info.childrenIds().unsorted().map((Function1 & Serializable)id -> this.remove$$anonfun$3(info, BoxesRunTime.unboxToInt((Object)id))))));
        }

        private boolean dependsTransitivelyOn(int child, int parent) {
            boolean bl;
            block2: {
                block1: {
                    while (true) {
                        int realParent = this.dependencyOf(child);
                        if (child == 0) break block1;
                        if (realParent == parent) break;
                        child = realParent;
                    }
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }

        private int dependencyOf(int streamId) {
            return ((PriorityInfo)this.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.apply((Object)BoxesRunTime.boxToInteger((int)streamId))).streamDependency();
        }

        private PriorityTreeImpl updateNodes(Function1<TreeMap<Object, PriorityInfo>, TreeMap<Object, PriorityInfo>> updater) {
            return PriorityTree$.MODULE$.org$apache$pekko$http$impl$engine$http2$PriorityTree$$$create((TreeMap<Object, PriorityInfo>)((TreeMap)updater.apply(this.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes)));
        }

        private PriorityTreeImpl updateNode(int streamId, Function1<PriorityInfo, PriorityInfo> updater) {
            return this.updateNodes((Function1<TreeMap<Object, PriorityInfo>, TreeMap<Object, PriorityInfo>>)((Function1 & Serializable)arg_0 -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$updateNode$$anonfun$1(streamId, updater, arg_0)));
        }

        private Function1<PriorityInfo, PriorityInfo> updateChildren(Function1<TreeSet<Object>, TreeSet<Object>> updater) {
            return arg_0 -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$updateChildren$$anonfun$1(updater, arg_0);
        }

        private PriorityTreeImpl insertNode(PriorityInfo newNode) {
            return this.updateNodes((Function1<TreeMap<Object, PriorityInfo>, TreeMap<Object, PriorityInfo>>)((Function1 & Serializable)arg_0 -> PriorityTree$.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$insertNode$$anonfun$1(newNode, arg_0)));
        }

        @Override
        public String print() {
            return AsciiTreeLayout$.MODULE$.toAscii(this.rootNode(), PriorityTree$::org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$_$print$$anonfun$1, (Function1 & Serializable)node -> this.printNode$1((PriorityNode)node), AsciiTreeLayout$.MODULE$.toAscii$default$4());
        }

        public PriorityNode org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$node(int _streamId) {
            return new PriorityNode(_streamId, this){
                private final int _streamId$1;
                private final /* synthetic */ PriorityTreeImpl $outer;
                {
                    this._streamId$1 = _streamId$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public int streamId() {
                    return this._streamId$1;
                }

                public int weight() {
                    return ((PriorityInfo)this.$outer.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.apply((Object)BoxesRunTime.boxToInteger((int)this.streamId()))).weight();
                }

                public PriorityNode dependency() {
                    return this.$outer.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$node(((PriorityInfo)this.$outer.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.apply((Object)BoxesRunTime.boxToInteger((int)this.streamId()))).streamDependency());
                }

                public Seq children() {
                    return (Seq)((PriorityInfo)this.$outer.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.apply((Object)BoxesRunTime.boxToInteger((int)this.streamId()))).childrenIds().toVector().map((Function1 & Serializable)_streamId -> this.children$$anonfun$1(BoxesRunTime.unboxToInt((Object)_streamId)));
                }

                private final /* synthetic */ PriorityNode children$$anonfun$1(int _streamId) {
                    return this.$outer.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$node(_streamId);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{children$$anonfun$adapted$1(java.lang.Object )}, serializedLambda);
                }
            };
        }

        private final /* synthetic */ Tuple2 remove$$anonfun$3(PriorityInfo info$1, int id) {
            Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id));
            PriorityInfo priorityInfo = (PriorityInfo)this.org$apache$pekko$http$impl$engine$http2$PriorityTree$PriorityTreeImpl$$nodes.apply((Object)BoxesRunTime.boxToInteger((int)id));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)priorityInfo.copy(priorityInfo.copy$default$1(), info$1.streamDependency(), priorityInfo.copy$default$3(), priorityInfo.copy$default$4()));
        }

        private final String printNode$1(PriorityNode node) {
            return new StringBuilder(11).append(node.streamId()).append(" [weight: ").append(node.weight()).append("]").toString();
        }
    }
}

