/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2.framing;

import java.nio.ByteOrder;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.http.impl.engine.http2.framing.FrameRenderer$;
import org.apache.pekko.http.impl.engine.http2.framing.FrameRenderer$Frame$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

@InternalApi
public final class FrameRenderer {
    public static ByteOrder byteOrder() {
        return FrameRenderer$.MODULE$.byteOrder();
    }

    public static ByteString render(FrameEvent frameEvent) {
        return FrameRenderer$.MODULE$.render(frameEvent);
    }

    public static ByteString renderFrame(Http2Protocol.FrameType frameType, int n, int n2, ByteString byteString) {
        return FrameRenderer$.MODULE$.renderFrame(frameType, n, n2, byteString);
    }

    public static class Frame {
        private final int targetSize;
        private final byte[] buffer;
        private int pos;

        public static Frame apply(int n, Http2Protocol.FrameType frameType, int n2, int n3) {
            return FrameRenderer$Frame$.MODULE$.apply(n, frameType, n2, n3);
        }

        public Frame(int payloadSize, Http2Protocol.FrameType tpe, int flags, int streamId) {
            this.targetSize = 9 + payloadSize;
            this.buffer = new byte[this.targetSize];
            this.pos = 0;
            this.putInt24(payloadSize);
            this.putByte((byte)tpe.id());
            this.putByte((byte)flags);
            this.putInt32(streamId);
        }

        public Frame putPriorityInfo(FrameEvent.PriorityFrame priorityFrame) {
            int exclusiveBit = priorityFrame.exclusiveFlag() ? Integer.MIN_VALUE : 0;
            this.putInt32(exclusiveBit | priorityFrame.streamDependency());
            return this.putByte((byte)priorityFrame.weight());
        }

        public Frame putPriorityInfo(Option<FrameEvent.PriorityFrame> priorityFrame) {
            Option<FrameEvent.PriorityFrame> option = priorityFrame;
            if (option instanceof Some) {
                FrameEvent.PriorityFrame p = (FrameEvent.PriorityFrame)((Some)option).value();
                return this.putPriorityInfo(p);
            }
            if (None$.MODULE$.equals(option)) {
                return this;
            }
            throw new MatchError(option);
        }

        public Frame putByte(byte by) {
            this.buffer[this.pos] = by;
            ++this.pos;
            return this;
        }

        public Frame putInt32(int value) {
            this.buffer[this.pos + 0] = (byte)(value >> 24);
            this.buffer[this.pos + 1] = (byte)(value >> 16);
            this.buffer[this.pos + 2] = (byte)(value >> 8);
            this.buffer[this.pos + 3] = (byte)(value >> 0);
            this.pos += 4;
            return this;
        }

        public Frame putInt24(int value) {
            this.buffer[this.pos + 0] = (byte)(value >> 16);
            this.buffer[this.pos + 1] = (byte)(value >> 8);
            this.buffer[this.pos + 2] = (byte)(value >> 0);
            this.pos += 3;
            return this;
        }

        public Frame putInt16(int value) {
            this.buffer[this.pos + 0] = (byte)(value >> 8);
            this.buffer[this.pos + 1] = (byte)(value >> 0);
            this.pos += 2;
            return this;
        }

        public Frame put(ByteString bytes) {
            if (bytes.isEmpty()) {
                return this;
            }
            bytes.copyToArray((Object)this.buffer, this.pos);
            this.pos += bytes.length();
            return this;
        }

        public ByteString build() {
            if (this.pos != this.targetSize) {
                throw new IllegalStateException(new StringBuilder(33).append("Did not write exactly ").append(this.targetSize).append(" bytes but ").append(this.pos).toString());
            }
            return ByteString$.MODULE$.fromArrayUnsafe(this.buffer);
        }
    }
}

