/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.BodyPartParser$;
import org.apache.pekko.http.impl.engine.parsing.BodyPartParser$BodyPartStart$;
import org.apache.pekko.http.impl.engine.parsing.BodyPartParser$BoundaryHeader$;
import org.apache.pekko.http.impl.engine.parsing.BodyPartParser$DefinedEndOfLineConfiguration$;
import org.apache.pekko.http.impl.engine.parsing.BodyPartParser$EntityPart$;
import org.apache.pekko.http.impl.engine.parsing.BodyPartParser$ParseError$;
import org.apache.pekko.http.impl.engine.parsing.BodyPartParser$UndefinedEndOfLineConfiguration$;
import org.apache.pekko.http.impl.engine.parsing.BoyerMoore;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser$;
import org.apache.pekko.http.impl.engine.parsing.NotEnoughDataException$;
import org.apache.pekko.http.impl.engine.parsing.package$;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.scaladsl.model.BodyPartEntity;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.ErrorInfo$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$IndefiniteLength$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Strict$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.ParsingException;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.EmptyHeader$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.parboiled2.CharPredicate;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure3;

@InternalApi
public final class BodyPartParser
extends GraphStage<FlowShape<ByteString, Output>> {
    public final ContentType org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$defaultContentType;
    public final String org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$boundary;
    public final Settings org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$settings;
    public final HttpHeaderParser org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$headerParser;
    private final Inlet in;
    private final Outlet out;
    private final FlowShape shape;

    public static CharPredicate boundaryChar() {
        return BodyPartParser$.MODULE$.boundaryChar();
    }

    public BodyPartParser(ContentType defaultContentType, String boundary, LoggingAdapter log, Settings settings) {
        this.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$defaultContentType = defaultContentType;
        this.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$boundary = boundary;
        this.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$settings = settings;
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(boundary)), BodyPartParser::$init$$$anonfun$1);
        Predef$.MODULE$.require(boundary.charAt(boundary.length() - 1) != ' ', BodyPartParser::$init$$$anonfun$2);
        Predef$.MODULE$.require(BodyPartParser$.MODULE$.boundaryChar().matchesAll(boundary), () -> BodyPartParser.$init$$$anonfun$3(boundary));
        this.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$headerParser = HttpHeaderParser$.MODULE$.apply(settings, log);
        this.in = Inlet$.MODULE$.apply("BodyPartParser.in");
        this.out = Outlet$.MODULE$.apply("BodyPartParser.out");
        this.shape = FlowShape$.MODULE$.apply(this.in(), this.out());
    }

    public Inlet<ByteString> in() {
        return this.in;
    }

    public Outlet<Output> out() {
        return this.out;
    }

    public FlowShape<ByteString, Output> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes attributes) {
        return new InHandler(this){
            private Queue output;
            private Function1 state;
            private boolean shouldTerminate;
            private EndOfLineConfiguration eolConfiguration;
            private Function0 trampoline;
            private final /* synthetic */ BodyPartParser $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.output = Queue$.MODULE$.empty();
                this.state = (Function1 & Serializable)input -> this.tryParseInitialBoundary((ByteString)input);
                this.shouldTerminate = false;
                this.eolConfiguration = BodyPartParser$UndefinedEndOfLineConfiguration$.MODULE$.apply($outer.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$boundary);
                this.trampoline = null;
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public void onPush() {
                if (!this.shouldTerminate) {
                    Object object;
                    ByteString elem = (ByteString)this.grab(this.$outer.in());
                    try {
                        this.run(elem);
                        object = BoxedUnit.UNIT;
                    }
                    catch (ParsingException e) {
                        object = this.fail(e.info());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NotEnoughDataException$.MODULE$.equals(throwable2)) {
                            throw new IllegalStateException("unexpected NotEnoughDataException", NotEnoughDataException$.MODULE$);
                        }
                        throw throwable;
                    }
                    if (this.output.nonEmpty()) {
                        this.push(this.$outer.out(), this.dequeue());
                        return;
                    }
                    if (!this.shouldTerminate) {
                        this.pull(this.$outer.in());
                        return;
                    }
                    this.completeStage();
                    return;
                }
                this.completeStage();
            }

            public void onPull() {
                if (this.output.nonEmpty()) {
                    this.push(this.$outer.out(), this.dequeue());
                    return;
                }
                if (this.isClosed(this.$outer.in())) {
                    if (!this.shouldTerminate) {
                        this.push(this.$outer.out(), BodyPartParser$ParseError$.MODULE$.apply(ErrorInfo$.MODULE$.apply("Unexpected end of multipart entity", ErrorInfo$.MODULE$.apply$default$2())));
                    }
                    this.completeStage();
                    return;
                }
                this.pull(this.$outer.in());
            }

            public void onUpstreamFinish() {
                if (this.isAvailable(this.$outer.out())) {
                    this.onPull();
                    return;
                }
            }

            public void run(ByteString data) {
                this.state.apply((Object)data);
                this.loop$1();
            }

            public StateResult trampoline(Function0 function0) {
                Predef$.MODULE$.require(this.trampoline == null);
                this.trampoline = function0;
                return this.done();
            }

            public StateResult tryParseInitialBoundary(ByteString input) {
                StateResult stateResult;
                try {
                    int ix;
                    EndOfLineConfiguration endOfLineConfiguration = this.eolConfiguration = this.eolConfiguration.defineOnce(input);
                    stateResult = endOfLineConfiguration.isBoundary(input, 0, endOfLineConfiguration.isBoundary$default$3()) ? (this.eolConfiguration.isEndOfLine(input, ix = this.eolConfiguration.boundaryLength()) ? this.parseHeaderLines(input, ix + this.eolConfiguration.eolLength(), this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5()) : (this.doubleDash(input, ix) ? this.setShouldTerminate() : this.parsePreamble(input))) : this.parsePreamble(input);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (NotEnoughDataException$.MODULE$.equals(throwable2)) {
                        stateResult = this.continue(input, 0, (Function2 & Serializable)(newInput, _$1) -> this.tryParseInitialBoundary$$anonfun$1((ByteString)newInput, BoxesRunTime.unboxToInt((Object)_$1)));
                    }
                    throw throwable;
                }
                return stateResult;
            }

            public StateResult parsePreamble(ByteString input) {
                StateResult stateResult;
                try {
                    this.eolConfiguration = this.eolConfiguration.defineOnce(input);
                    stateResult = this.rec$1(input, 0);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (NotEnoughDataException$.MODULE$.equals(throwable2)) {
                        stateResult = this.continue(input, 0, (Function2 & Serializable)(newInput, _$2) -> this.parsePreamble$$anonfun$1((ByteString)newInput, BoxesRunTime.unboxToInt((Object)_$2)));
                    }
                    throw throwable;
                }
                return stateResult;
            }

            public StateResult parseHeaderLines(ByteString input2, int lineStart2, ListBuffer headers, int headerCount, Option cth) {
                while (true) {
                    BodyPartParser$BoundaryHeader$ resultHeader;
                    HttpHeader httpHeader;
                    int lineEnd = 0;
                    try {
                        EndOfLineConfiguration endOfLineConfiguration = this.eolConfiguration;
                        if (!endOfLineConfiguration.isBoundary(input2, lineStart2, endOfLineConfiguration.isBoundary$default$3())) {
                            lineEnd = this.$outer.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$headerParser.parseHeaderLine(input2, lineStart2, this.$outer.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$headerParser.parseHeaderLine$default$3(input2, lineStart2), this.$outer.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$headerParser.parseHeaderLine$default$4(input2, lineStart2));
                            httpHeader = this.$outer.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$headerParser.resultHeader();
                        } else {
                            httpHeader = BodyPartParser$BoundaryHeader$.MODULE$;
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!NotEnoughDataException$.MODULE$.equals(throwable2)) {
                            throw throwable;
                        }
                        httpHeader = null;
                    }
                    BodyPartParser$BoundaryHeader$ bodyPartParser$BoundaryHeader$ = resultHeader = httpHeader;
                    if (bodyPartParser$BoundaryHeader$ == null) {
                        return this.continue(input2, lineStart2, (Function2 & Serializable)(input, lineStart) -> this.parseHeaderLines$$anonfun$1(headers, headerCount, cth, (ByteString)input, BoxesRunTime.unboxToInt((Object)lineStart)));
                    }
                    if (BodyPartParser$BoundaryHeader$.MODULE$.equals(bodyPartParser$BoundaryHeader$)) {
                        this.emit(BodyPartParser$BodyPartStart$.MODULE$.apply((List<HttpHeader>)headers.toList(), (Function1<Source<Output, NotUsed>, BodyPartEntity>)(Function1 & Serializable)_$3 -> HttpEntity$.MODULE$.empty(this.contentType$5(cth))));
                        int ix = lineStart2 + this.eolConfiguration.boundaryLength();
                        if (this.eolConfiguration.isEndOfLine(input2, ix)) {
                            int n = ix + this.eolConfiguration.eolLength();
                            None$ none$ = None$.MODULE$;
                            lineStart2 = n;
                            cth = none$;
                            continue;
                        }
                        if (this.doubleDash(input2, ix)) {
                            return this.setShouldTerminate();
                        }
                        return this.fail("Illegal multipart boundary in message content");
                    }
                    if (EmptyHeader$.MODULE$.equals(bodyPartParser$BoundaryHeader$)) {
                        return this.parseEntity(headers.toList(), this.contentType$5(cth), this.parseEntity$default$3(), this.parseEntity$default$4(), input2, lineEnd);
                    }
                    if (bodyPartParser$BoundaryHeader$ instanceof Content$minusType) {
                        Content$minusType h = (Content$minusType)((Object)bodyPartParser$BoundaryHeader$);
                        if (cth.isEmpty()) {
                            int n = lineEnd;
                            int n2 = headerCount + 1;
                            Some some = Some$.MODULE$.apply((Object)h);
                            lineStart2 = n;
                            headerCount = n2;
                            cth = some;
                            continue;
                        }
                        Object object = cth.get();
                        Content$minusType content$minusType = h;
                        if (!(object != null ? !object.equals(content$minusType) : content$minusType != null)) {
                            lineStart2 = lineEnd;
                            continue;
                        }
                        return this.fail("multipart part must not contain more than one Content-Type header");
                    }
                    BodyPartParser$BoundaryHeader$ h = bodyPartParser$BoundaryHeader$;
                    if (headerCount >= this.$outer.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$settings.maxHeaderCount()) break;
                    int n = lineEnd;
                    ListBuffer listBuffer = (ListBuffer)headers.$plus$eq((Object)h);
                    int n3 = headerCount + 1;
                    lineStart2 = n;
                    headers = listBuffer;
                    headerCount = n3;
                }
                return this.fail(new StringBuilder(66).append("multipart part contains more than the configured limit of ").append(this.$outer.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$settings.maxHeaderCount()).append(" headers").toString());
            }

            public ListBuffer parseHeaderLines$default$3() {
                return (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpHeader[0]));
            }

            public int parseHeaderLines$default$4() {
                return 0;
            }

            public Option parseHeaderLines$default$5() {
                return None$.MODULE$;
            }

            public StateResult parseHeaderLinesAux(ListBuffer headers, int headerCount, Option cth, ByteString input, int lineStart) {
                return this.parseHeaderLines(input, lineStart, headers, headerCount, cth);
            }

            public StateResult parseEntity(List headers, ContentType contentType, Function3 emitPartChunk, Function3 emitFinalPartChunk, ByteString input2, int offset2) {
                StateResult stateResult;
                try {
                    stateResult = this.rec$2(input2, emitFinalPartChunk, headers, contentType, offset2, offset2);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (NotEnoughDataException$.MODULE$.equals(throwable2)) {
                        int emitEnd = input2.length() - this.eolConfiguration.needle().length - this.eolConfiguration.eolLength();
                        if (emitEnd > offset2) {
                            emitPartChunk.apply((Object)headers, (Object)contentType, (Object)input2.slice(offset2, emitEnd));
                            JProcedure3 & Serializable simpleEmit = (JProcedure3 & Serializable)(_$4, _$5, bytes) -> this.emit((ByteString)bytes);
                            stateResult = this.continue(input2.drop(emitEnd), 0, (arg_0, arg_1) -> this.parseEntity$$anonfun$adapted$1((Function3)simpleEmit, arg_0, arg_1));
                        } else {
                            stateResult = this.continue(input2, offset2, (Function2 & Serializable)(input, offset) -> this.parseEntity$$anonfun$2(headers, contentType, emitPartChunk, emitFinalPartChunk, (ByteString)input, BoxesRunTime.unboxToInt((Object)offset)));
                        }
                    }
                    throw throwable;
                }
                return stateResult;
            }

            public Function3 parseEntity$default$3() {
                return (JProcedure3 & Serializable)(headers, ct, bytes) -> {
                    this.emit(BodyPartParser$BodyPartStart$.MODULE$.apply((List<HttpHeader>)headers, (Function1<Source<Output, NotUsed>, BodyPartEntity>)((Function1 & Serializable)arg_0 -> BodyPartParser.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$parseEntity$default$3$$anonfun$1$$anonfun$1(ct, arg_0))));
                    this.emit((ByteString)bytes);
                };
            }

            public Function3 parseEntity$default$4() {
                return (JProcedure3 & Serializable)(headers, ct, bytes) -> this.emit(BodyPartParser$BodyPartStart$.MODULE$.apply((List<HttpHeader>)headers, (Function1<Source<Output, NotUsed>, BodyPartEntity>)(Function1 & Serializable)rest -> {
                    StreamUtils$.MODULE$.cancelSource((Source<?, ?>)rest, this.materializer());
                    return HttpEntity$Strict$.MODULE$.apply((ContentType)ct, (ByteString)bytes);
                }));
            }

            public void emit(ByteString bytes) {
                if (bytes.nonEmpty()) {
                    this.emit(BodyPartParser$EntityPart$.MODULE$.apply(bytes));
                    return;
                }
            }

            public void emit(Output element) {
                this.output = this.output.enqueue((Object)element);
            }

            public Output dequeue() {
                Output head = (Output)this.output.head();
                this.output = this.output.tail();
                return head;
            }

            public StateResult continue(ByteString input, int offset, Function2 next) {
                Function1 & Serializable intersect;
                int n = scala.math.package$.MODULE$.signum(offset - input.length());
                switch (n) {
                    case -1: {
                        intersect = arg_0 -> BodyPartParser.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$continue$$anonfun$1(next, input, offset, arg_0);
                        break;
                    }
                    case 0: {
                        intersect = arg_0 -> BodyPartParser.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$continue$$anonfun$2(next, arg_0);
                        break;
                    }
                    case 1: {
                        throw new IllegalStateException();
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                this.state = intersect;
                return this.done();
            }

            public StateResult fail(String summary) {
                return this.fail(ErrorInfo$.MODULE$.apply(summary, ErrorInfo$.MODULE$.apply$default$2()));
            }

            public StateResult fail(ErrorInfo info) {
                this.emit(BodyPartParser$ParseError$.MODULE$.apply(info));
                return this.setShouldTerminate();
            }

            public StateResult setShouldTerminate() {
                this.shouldTerminate = true;
                return this.done();
            }

            public StateResult done() {
                return null;
            }

            public boolean doubleDash(ByteString input, int offset) {
                return package$.MODULE$.byteChar(input, offset) == '-' && package$.MODULE$.byteChar(input, offset + 1) == '-';
            }

            private final void loop$1() {
                Function0 function0;
                while ((function0 = this.trampoline) != null) {
                    Function0 f = function0;
                    this.trampoline = null;
                    f.apply();
                }
                return;
            }

            private final /* synthetic */ StateResult tryParseInitialBoundary$$anonfun$1(ByteString newInput, int _$1) {
                return this.tryParseInitialBoundary(newInput);
            }

            private final StateResult rec$1(ByteString input$1, int index) {
                int needleEnd;
                while (!this.eolConfiguration.isEndOfLine(input$1, needleEnd = this.eolConfiguration.boyerMoore().nextIndex(input$1, index) + this.eolConfiguration.needle().length)) {
                    if (this.doubleDash(input$1, needleEnd)) {
                        return this.setShouldTerminate();
                    }
                    index = needleEnd;
                }
                return this.parseHeaderLines(input$1, needleEnd + this.eolConfiguration.eolLength(), this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5());
            }

            private final /* synthetic */ StateResult parsePreamble$$anonfun$1(ByteString newInput, int _$2) {
                return this.parsePreamble(newInput);
            }

            private final ContentType contentType$5(Option cth$tailLocal1$1) {
                Option option = cth$tailLocal1$1;
                if (option instanceof Some) {
                    Content$minusType x = (Content$minusType)((Some)option).value();
                    return x.contentType();
                }
                if (None$.MODULE$.equals(option)) {
                    return this.$outer.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$defaultContentType;
                }
                throw new MatchError((Object)option);
            }

            private final /* synthetic */ StateResult parseHeaderLines$$anonfun$1(ListBuffer headers$tailLocal1$1, int headerCount$tailLocal1$1, Option cth$tailLocal1$2, ByteString input, int lineStart) {
                return this.parseHeaderLinesAux(headers$tailLocal1$1, headerCount$tailLocal1$1, cth$tailLocal1$2, input, lineStart);
            }

            private final StateResult rec$2$$anonfun$1(ByteString input$4, int needleEnd$1) {
                return this.parseHeaderLines(input$4, needleEnd$1 + this.eolConfiguration.eolLength(), this.parseHeaderLines$default$3(), this.parseHeaderLines$default$4(), this.parseHeaderLines$default$5());
            }

            private final StateResult rec$2(ByteString input$2, Function3 emitFinalPartChunk$1, List headers$1, ContentType contentType$1, int offset$1, int index) {
                while (true) {
                    int currentPartEnd;
                    int needleEnd;
                    if (this.eolConfiguration.isEndOfLine(input$2, needleEnd = (currentPartEnd = this.eolConfiguration.boyerMoore().nextIndex(input$2, index)) + this.eolConfiguration.needle().length)) {
                        BodyPartParser.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$emitFinalChunk$1(emitFinalPartChunk$1, headers$1, contentType$1, input$2, offset$1, currentPartEnd);
                        return this.trampoline(() -> this.rec$2$$anonfun$1(input$2, needleEnd));
                    }
                    if (this.doubleDash(input$2, needleEnd)) {
                        BodyPartParser.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$emitFinalChunk$1(emitFinalPartChunk$1, headers$1, contentType$1, input$2, offset$1, currentPartEnd);
                        return this.setShouldTerminate();
                    }
                    index = needleEnd;
                }
            }

            private final /* synthetic */ StateResult parseEntity$$anonfun$1(Function3 simpleEmit$1, ByteString input, int offset) {
                return this.parseEntity(null, null, simpleEmit$1, simpleEmit$1, input, offset);
            }

            private final /* synthetic */ StateResult parseEntity$$anonfun$2(List headers$3, ContentType contentType$3, Function3 emitPartChunk$1, Function3 emitFinalPartChunk$3, ByteString input, int offset) {
                return this.parseEntity(headers$3, contentType$3, emitPartChunk$1, emitFinalPartChunk$3, input, offset);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$4(org.apache.pekko.util.ByteString ), tryParseInitialBoundary$$anonfun$adapted$1(java.lang.Object java.lang.Object ), parsePreamble$$anonfun$adapted$1(java.lang.Object java.lang.Object ), parseHeaderLines$$anonfun$adapted$1(scala.collection.mutable.ListBuffer int scala.Option java.lang.Object java.lang.Object ), parseHeaderLines$$anonfun$2(scala.Option org.apache.pekko.stream.scaladsl.Source ), $anonfun$1(scala.collection.immutable.List org.apache.pekko.http.scaladsl.model.ContentType org.apache.pekko.util.ByteString ), parseEntity$$anonfun$adapted$1(scala.Function3 java.lang.Object java.lang.Object ), parseEntity$$anonfun$adapted$2(scala.collection.immutable.List org.apache.pekko.http.scaladsl.model.ContentType scala.Function3 scala.Function3 java.lang.Object java.lang.Object ), parseEntity$default$3$$anonfun$1(scala.collection.immutable.List org.apache.pekko.http.scaladsl.model.ContentType org.apache.pekko.util.ByteString ), parseEntity$default$4$$anonfun$1(scala.collection.immutable.List org.apache.pekko.http.scaladsl.model.ContentType org.apache.pekko.util.ByteString ), org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$continue$$anonfun$1(scala.Function2 org.apache.pekko.util.ByteString int org.apache.pekko.util.ByteString ), org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$continue$$anonfun$2(scala.Function2 org.apache.pekko.util.ByteString ), rec$2$$anonfun$1(org.apache.pekko.util.ByteString int ), org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$parseEntity$default$3$$anonfun$1$$anonfun$1(org.apache.pekko.http.scaladsl.model.ContentType org.apache.pekko.stream.scaladsl.Source ), parseEntity$default$4$$anonfun$1$$anonfun$1(org.apache.pekko.http.scaladsl.model.ContentType org.apache.pekko.util.ByteString org.apache.pekko.stream.scaladsl.Source )}, serializedLambda);
            }
        };
    }

    private static final Object $init$$$anonfun$1() {
        return "'boundary' parameter of multipart Content-Type must be non-empty";
    }

    private static final Object $init$$$anonfun$2() {
        return "'boundary' parameter of multipart Content-Type must not end with a space char";
    }

    private static final Object $init$$$anonfun$3(String boundary$1) {
        return new StringBuilder(76).append("'boundary' parameter of multipart Content-Type contains illegal character '").append(BodyPartParser$.MODULE$.boundaryChar().firstMismatch(boundary$1).get()).append("'").toString();
    }

    public static final void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$emitFinalChunk$1(Function3 emitFinalPartChunk$2, List headers$2, ContentType contentType$2, ByteString input$3, int offset$2, int currentPartEnd$1) {
        emitFinalPartChunk$2.apply((Object)headers$2, (Object)contentType$2, (Object)input$3.slice(offset$2, currentPartEnd$1));
    }

    public static final /* synthetic */ BodyPartEntity org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$parseEntity$default$3$$anonfun$1$$anonfun$1(ContentType ct$1, Source entityParts) {
        return HttpEntity$IndefiniteLength$.MODULE$.apply(ct$1, (Source<ByteString, Object>)((Source)entityParts.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Output x) {
                Output output = x;
                if (output instanceof EntityPart) {
                    ByteString byteString;
                    EntityPart entityPart = BodyPartParser$EntityPart$.MODULE$.unapply((EntityPart)output);
                    ByteString data = byteString = entityPart._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Output x, Function1 function1) {
                Output output = x;
                if (output instanceof EntityPart) {
                    ByteString byteString;
                    EntityPart entityPart = BodyPartParser$EntityPart$.MODULE$.unapply((EntityPart)output);
                    ByteString data = byteString = entityPart._1();
                    return data;
                }
                return function1.apply((Object)x);
            }
        })));
    }

    public static final /* synthetic */ StateResult org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$continue$$anonfun$1(Function2 next$1, ByteString input$5, int offset$3, ByteString more) {
        return (StateResult)next$1.apply((Object)input$5.$plus$plus(more), (Object)BoxesRunTime.boxToInteger((int)offset$3));
    }

    public static final /* synthetic */ StateResult org$apache$pekko$http$impl$engine$parsing$BodyPartParser$$anon$1$$_$continue$$anonfun$2(Function2 next$2, ByteString _$6) {
        return (StateResult)next$2.apply((Object)_$6, (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static final class BodyPartStart
    implements PartStart,
    Product,
    Serializable {
        private final List headers;
        private final Function1 createEntity;

        public static BodyPartStart apply(List<HttpHeader> list, Function1<Source<Output, NotUsed>, BodyPartEntity> function1) {
            return BodyPartParser$BodyPartStart$.MODULE$.apply(list, function1);
        }

        public static BodyPartStart fromProduct(Product product) {
            return BodyPartParser$BodyPartStart$.MODULE$.fromProduct(product);
        }

        public static BodyPartStart unapply(BodyPartStart bodyPartStart) {
            return BodyPartParser$BodyPartStart$.MODULE$.unapply(bodyPartStart);
        }

        public BodyPartStart(List<HttpHeader> headers, Function1<Source<Output, NotUsed>, BodyPartEntity> createEntity) {
            this.headers = headers;
            this.createEntity = createEntity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BodyPartStart)) return false;
            BodyPartStart bodyPartStart = (BodyPartStart)object;
            List<HttpHeader> list = this.headers();
            List<HttpHeader> list2 = bodyPartStart.headers();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            Function1<Source<Output, NotUsed>, BodyPartEntity> function1 = this.createEntity();
            Function1<Source<Output, NotUsed>, BodyPartEntity> function12 = bodyPartStart.createEntity();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BodyPartStart;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "BodyPartStart";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "headers";
            }
            if (1 == n2) {
                return "createEntity";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<HttpHeader> headers() {
            return this.headers;
        }

        public Function1<Source<Output, NotUsed>, BodyPartEntity> createEntity() {
            return this.createEntity;
        }

        public BodyPartStart copy(List<HttpHeader> headers, Function1<Source<Output, NotUsed>, BodyPartEntity> createEntity) {
            return new BodyPartStart(headers, createEntity);
        }

        public List<HttpHeader> copy$default$1() {
            return this.headers();
        }

        public Function1<Source<Output, NotUsed>, BodyPartEntity> copy$default$2() {
            return this.createEntity();
        }

        public List<HttpHeader> _1() {
            return this.headers();
        }

        public Function1<Source<Output, NotUsed>, BodyPartEntity> _2() {
            return this.createEntity();
        }
    }

    public static class DefinedEndOfLineConfiguration
    implements EndOfLineConfiguration,
    Product,
    Serializable {
        private int eolLength;
        private byte[] needle;
        private int boundaryLength;
        private BoyerMoore boyerMoore;
        private final String eol;
        private final String boundary;

        public static DefinedEndOfLineConfiguration apply(String string, String string2) {
            return BodyPartParser$DefinedEndOfLineConfiguration$.MODULE$.apply(string, string2);
        }

        public static DefinedEndOfLineConfiguration fromProduct(Product product) {
            return BodyPartParser$DefinedEndOfLineConfiguration$.MODULE$.fromProduct(product);
        }

        public static DefinedEndOfLineConfiguration unapply(DefinedEndOfLineConfiguration definedEndOfLineConfiguration) {
            return BodyPartParser$DefinedEndOfLineConfiguration$.MODULE$.unapply(definedEndOfLineConfiguration);
        }

        public DefinedEndOfLineConfiguration(String eol, String boundary) {
            this.eol = eol;
            this.boundary = boundary;
            EndOfLineConfiguration.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public int eolLength() {
            return this.eolLength;
        }

        @Override
        public byte[] needle() {
            return this.needle;
        }

        @Override
        public int boundaryLength() {
            return this.boundaryLength;
        }

        @Override
        public BoyerMoore boyerMoore() {
            return this.boyerMoore;
        }

        @Override
        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$eolLength_$eq(int x$0) {
            this.eolLength = x$0;
        }

        @Override
        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$needle_$eq(byte[] x$0) {
            this.needle = x$0;
        }

        @Override
        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$boundaryLength_$eq(int x$0) {
            this.boundaryLength = x$0;
        }

        @Override
        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$boyerMoore_$eq(BoyerMoore x$0) {
            this.boyerMoore = x$0;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DefinedEndOfLineConfiguration)) return false;
            DefinedEndOfLineConfiguration definedEndOfLineConfiguration = (DefinedEndOfLineConfiguration)object;
            String string = this.eol();
            String string2 = definedEndOfLineConfiguration.eol();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.boundary();
            String string4 = definedEndOfLineConfiguration.boundary();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!definedEndOfLineConfiguration.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DefinedEndOfLineConfiguration;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DefinedEndOfLineConfiguration";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "eol";
            }
            if (1 == n2) {
                return "boundary";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String eol() {
            return this.eol;
        }

        @Override
        public String boundary() {
            return this.boundary;
        }

        @Override
        public EndOfLineConfiguration defineOnce(ByteString input) {
            return this;
        }

        public DefinedEndOfLineConfiguration copy(String eol, String boundary) {
            return new DefinedEndOfLineConfiguration(eol, boundary);
        }

        public String copy$default$1() {
            return this.eol();
        }

        public String copy$default$2() {
            return this.boundary();
        }

        public String _1() {
            return this.eol();
        }

        public String _2() {
            return this.boundary();
        }
    }

    public static interface EndOfLineConfiguration {
        public static void $init$(EndOfLineConfiguration $this) {
            $this.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$eolLength_$eq($this.eol().length());
            $this.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$needle_$eq(EnhancedString$.MODULE$.asciiBytes$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_(new StringBuilder(2).append($this.eol()).append("--").append($this.boundary()).toString())));
            $this.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$boundaryLength_$eq($this.needle().length - $this.eolLength());
            $this.org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$boyerMoore_$eq(new BoyerMoore($this.needle()));
        }

        public String eol();

        public String boundary();

        public EndOfLineConfiguration defineOnce(ByteString var1);

        public int eolLength();

        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$eolLength_$eq(int var1);

        public byte[] needle();

        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$needle_$eq(byte[] var1);

        public int boundaryLength();

        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$boundaryLength_$eq(int var1);

        public BoyerMoore boyerMoore();

        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$boyerMoore_$eq(BoyerMoore var1);

        public static boolean isBoundary$(EndOfLineConfiguration $this, ByteString input, int offset, int ix) {
            return $this.isBoundary(input, offset, ix);
        }

        default public boolean isBoundary(ByteString input, int offset, int ix) {
            return this.process$1(input, offset, ix);
        }

        public static int isBoundary$default$3$(EndOfLineConfiguration $this) {
            return $this.isBoundary$default$3();
        }

        default public int isBoundary$default$3() {
            return this.eolLength();
        }

        public static boolean isEndOfLine$(EndOfLineConfiguration $this, ByteString input, int offset) {
            return $this.isEndOfLine(input, offset);
        }

        default public boolean isEndOfLine(ByteString input, int offset) {
            return this.process$2(input, offset, 0);
        }

        private boolean process$1(ByteString input, int offset, int ix) {
            boolean bl;
            block3: {
                block2: {
                    while (ix != this.needle().length) {
                        if (package$.MODULE$.byteAt(input, offset + ix - this.eol().length()) == this.needle()[ix]) {
                            ++ix;
                            continue;
                        }
                        break block2;
                    }
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            return bl;
        }

        private boolean process$2(ByteString input, int offset, int ix) {
            boolean bl;
            block3: {
                block2: {
                    while (ix != this.eolLength()) {
                        if (package$.MODULE$.byteAt(input, offset + ix) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.eol()), ix)) {
                            ++ix;
                            continue;
                        }
                        break block2;
                    }
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            return bl;
        }
    }

    public static final class EntityPart
    implements Output,
    Product,
    Serializable {
        private final ByteString data;

        public static EntityPart apply(ByteString byteString) {
            return BodyPartParser$EntityPart$.MODULE$.apply(byteString);
        }

        public static EntityPart fromProduct(Product product) {
            return BodyPartParser$EntityPart$.MODULE$.fromProduct(product);
        }

        public static EntityPart unapply(EntityPart entityPart) {
            return BodyPartParser$EntityPart$.MODULE$.unapply(entityPart);
        }

        public EntityPart(ByteString data) {
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EntityPart)) return false;
            EntityPart entityPart = (EntityPart)object;
            ByteString byteString = this.data();
            ByteString byteString2 = entityPart.data();
            if (byteString != null) {
                if (!byteString.equals(byteString2)) return false;
                return true;
            }
            if (byteString2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EntityPart;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "EntityPart";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString data() {
            return this.data;
        }

        public EntityPart copy(ByteString data) {
            return new EntityPart(data);
        }

        public ByteString copy$default$1() {
            return this.data();
        }

        public ByteString _1() {
            return this.data();
        }
    }

    public static interface Output {
    }

    public static final class ParseError
    implements PartStart,
    Product,
    Serializable {
        private final ErrorInfo info;

        public static ParseError apply(ErrorInfo errorInfo) {
            return BodyPartParser$ParseError$.MODULE$.apply(errorInfo);
        }

        public static ParseError fromProduct(Product product) {
            return BodyPartParser$ParseError$.MODULE$.fromProduct(product);
        }

        public static ParseError unapply(ParseError parseError) {
            return BodyPartParser$ParseError$.MODULE$.unapply(parseError);
        }

        public ParseError(ErrorInfo info) {
            this.info = info;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParseError)) return false;
            ParseError parseError = (ParseError)object;
            ErrorInfo errorInfo = this.info();
            ErrorInfo errorInfo2 = parseError.info();
            if (errorInfo != null) {
                if (!((Object)errorInfo).equals(errorInfo2)) return false;
                return true;
            }
            if (errorInfo2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ParseError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ParseError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "info";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ErrorInfo info() {
            return this.info;
        }

        public ParseError copy(ErrorInfo info) {
            return new ParseError(info);
        }

        public ErrorInfo copy$default$1() {
            return this.info();
        }

        public ErrorInfo _1() {
            return this.info();
        }
    }

    public static interface PartStart
    extends Output {
    }

    public static abstract class Settings
    extends HttpHeaderParser.Settings {
        public abstract int maxHeaderCount();

        @Override
        public abstract boolean illegalHeaderWarnings();

        public abstract int defaultHeaderValueCacheLimit();
    }

    public interface StateResult {
    }

    public static class UndefinedEndOfLineConfiguration
    implements EndOfLineConfiguration,
    Product,
    Serializable {
        private int eolLength;
        private byte[] needle;
        private int boundaryLength;
        private BoyerMoore boyerMoore;
        private final String boundary;

        public static UndefinedEndOfLineConfiguration apply(String string) {
            return BodyPartParser$UndefinedEndOfLineConfiguration$.MODULE$.apply(string);
        }

        public static UndefinedEndOfLineConfiguration fromProduct(Product product) {
            return BodyPartParser$UndefinedEndOfLineConfiguration$.MODULE$.fromProduct(product);
        }

        public static UndefinedEndOfLineConfiguration unapply(UndefinedEndOfLineConfiguration undefinedEndOfLineConfiguration) {
            return BodyPartParser$UndefinedEndOfLineConfiguration$.MODULE$.unapply(undefinedEndOfLineConfiguration);
        }

        public UndefinedEndOfLineConfiguration(String boundary) {
            this.boundary = boundary;
            EndOfLineConfiguration.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public int eolLength() {
            return this.eolLength;
        }

        @Override
        public byte[] needle() {
            return this.needle;
        }

        @Override
        public int boundaryLength() {
            return this.boundaryLength;
        }

        @Override
        public BoyerMoore boyerMoore() {
            return this.boyerMoore;
        }

        @Override
        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$eolLength_$eq(int x$0) {
            this.eolLength = x$0;
        }

        @Override
        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$needle_$eq(byte[] x$0) {
            this.needle = x$0;
        }

        @Override
        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$boundaryLength_$eq(int x$0) {
            this.boundaryLength = x$0;
        }

        @Override
        public void org$apache$pekko$http$impl$engine$parsing$BodyPartParser$EndOfLineConfiguration$_setter_$boyerMoore_$eq(BoyerMoore x$0) {
            this.boyerMoore = x$0;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UndefinedEndOfLineConfiguration)) return false;
            UndefinedEndOfLineConfiguration undefinedEndOfLineConfiguration = (UndefinedEndOfLineConfiguration)object;
            String string = this.boundary();
            String string2 = undefinedEndOfLineConfiguration.boundary();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!undefinedEndOfLineConfiguration.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UndefinedEndOfLineConfiguration;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UndefinedEndOfLineConfiguration";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "boundary";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String boundary() {
            return this.boundary;
        }

        @Override
        public String eol() {
            return "\r\n";
        }

        @Override
        public EndOfLineConfiguration defineOnce(ByteString byteString) {
            ByteString crLfNeedle = ByteString$.MODULE$.apply(new StringBuilder(2).append(this.boundary()).append("\r\n").toString());
            ByteString lfNeedle = ByteString$.MODULE$.apply(new StringBuilder(1).append(this.boundary()).append("\n").toString());
            if (byteString.containsSlice((Seq)crLfNeedle)) {
                return BodyPartParser$DefinedEndOfLineConfiguration$.MODULE$.apply("\r\n", this.boundary());
            }
            return (EndOfLineConfiguration)(byteString.containsSlice((Seq)lfNeedle) ? BodyPartParser$DefinedEndOfLineConfiguration$.MODULE$.apply("\n", this.boundary()) : this);
        }

        public UndefinedEndOfLineConfiguration copy(String boundary) {
            return new UndefinedEndOfLineConfiguration(boundary);
        }

        public String copy$default$1() {
            return this.boundary();
        }

        public String _1() {
            return this.boundary();
        }
    }
}

