/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser$;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser$OutOfTrieSpaceException$;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser$ValueBranch$;
import org.apache.pekko.http.impl.engine.parsing.package$;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.model.parser.HeaderParser;
import org.apache.pekko.http.impl.model.parser.HeaderParser$;
import org.apache.pekko.http.impl.model.parser.HeaderParser$Failure$;
import org.apache.pekko.http.impl.model.parser.HeaderParser$RuleNotFound$;
import org.apache.pekko.http.impl.model.parser.HeaderParser$Success$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.headers.EmptyHeader$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderNameProcessingMode$Error$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderNameProcessingMode$Ignore$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$IllegalResponseHeaderNameProcessingMode$Warn$;
import org.apache.pekko.util.ByteString;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Short$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public final class HttpHeaderParser {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(HttpHeaderParser.class.getDeclaredField("decoder$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(HttpHeaderParser.class.getDeclaredField("charBuffer$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HttpHeaderParser.class.getDeclaredField("byteBuffer$lzy1"));
    private final Settings settings;
    private final LoggingAdapter log;
    private final Function1<ErrorInfo, BoxedUnit> onIllegalHeader;
    private char[] nodes;
    private int nodeCount;
    private short[] branchData;
    private int branchDataCount;
    private Object[] values;
    private int valueCount;
    private boolean trieIsPrivate;
    private HttpHeader resultHeader;
    private volatile Object byteBuffer$lzy1;
    private volatile Object charBuffer$lzy1;
    private volatile Object decoder$lzy1;

    public static HttpHeaderParser apply(Settings settings, LoggingAdapter loggingAdapter) {
        return HttpHeaderParser$.MODULE$.apply(settings, loggingAdapter);
    }

    public static Function1<ErrorInfo, BoxedUnit> defaultIllegalHeaderHandler(Settings settings, LoggingAdapter loggingAdapter) {
        return HttpHeaderParser$.MODULE$.defaultIllegalHeaderHandler(settings, loggingAdapter);
    }

    public static Nothing$ fail(String string, StatusCode statusCode) {
        return HttpHeaderParser$.MODULE$.fail(string, statusCode);
    }

    public static void insert(HttpHeaderParser httpHeaderParser, ByteString byteString, Object object) {
        HttpHeaderParser$.MODULE$.insert(httpHeaderParser, byteString, object);
    }

    public static void insertRemainingCharsAsNewNodes(HttpHeaderParser httpHeaderParser, ByteString byteString, Object object) {
        HttpHeaderParser$.MODULE$.insertRemainingCharsAsNewNodes(httpHeaderParser, byteString, object);
    }

    public static HttpHeaderParser prime(HttpHeaderParser httpHeaderParser) {
        return HttpHeaderParser$.MODULE$.prime(httpHeaderParser);
    }

    public static char toLowerCase(char c) {
        return HttpHeaderParser$.MODULE$.toLowerCase(c);
    }

    public static HttpHeaderParser unprimed(Settings settings, LoggingAdapter loggingAdapter, Function1<ErrorInfo, BoxedUnit> function1) {
        return HttpHeaderParser$.MODULE$.unprimed(settings, loggingAdapter, function1);
    }

    public static StatusCode fail$default$2() {
        return HttpHeaderParser$.MODULE$.fail$default$2();
    }

    public HttpHeaderParser(Settings settings, LoggingAdapter log, Function1<ErrorInfo, BoxedUnit> onIllegalHeader, char[] nodes, int nodeCount, short[] branchData, int branchDataCount, Object[] values, int valueCount, boolean trieIsPrivate) {
        this.settings = settings;
        this.log = log;
        this.onIllegalHeader = onIllegalHeader;
        this.nodes = nodes;
        this.nodeCount = nodeCount;
        this.branchData = branchData;
        this.branchDataCount = branchDataCount;
        this.values = values;
        this.valueCount = valueCount;
        this.trieIsPrivate = trieIsPrivate;
        this.resultHeader = EmptyHeader$.MODULE$;
    }

    public Settings settings() {
        return this.settings;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public HttpHeader resultHeader() {
        return this.resultHeader;
    }

    public void resultHeader_$eq(HttpHeader x$1) {
        this.resultHeader = x$1;
    }

    public boolean isEmpty() {
        return this.nodeCount == 0;
    }

    public HttpHeaderParser createShallowCopy() {
        return new HttpHeaderParser(this.settings(), this.log(), this.onIllegalHeader, this.nodes, this.nodeCount, this.branchData, this.branchDataCount, this.values, this.valueCount, HttpHeaderParser$.MODULE$.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$$lessinit$greater$default$10());
    }

    public int parseHeaderLine(ByteString input, int lineStart, int cursor, int nodeIx) {
        while (true) {
            char node;
            int n;
            if (0 == (n = (node = this.nodes[nodeIx]) & 0xFF)) {
                int valueIx = (node >>> 8) - 1;
                Object object = this.values[valueIx];
                if (object instanceof ValueBranch) {
                    ValueBranch branch = (ValueBranch)object;
                    return this.parseHeaderValue(input, cursor, branch, this.parseHeaderValue$default$4(input, cursor, branch), this.parseHeaderValue$default$5(input, cursor, branch));
                }
                if (object instanceof HeaderValueParser) {
                    HeaderValueParser valueParser = (HeaderValueParser)object;
                    return this.startValueBranch$1(input, cursor, valueIx, valueParser);
                }
                if (EmptyHeader$.MODULE$.equals(object)) {
                    this.resultHeader_$eq(EmptyHeader$.MODULE$);
                    return cursor;
                }
                throw new MatchError(object);
            }
            int nodeChar = n;
            char c = HttpHeaderParser$.MODULE$.toLowerCase(package$.MODULE$.byteChar(input, cursor));
            if (c == node) {
                int n2 = cursor + 1;
                int n3 = nodeIx + 1;
                cursor = n2;
                nodeIx = n3;
                continue;
            }
            int n4 = node >>> 8;
            if (0 == n4) {
                return this.parseRawHeader(input, lineStart, cursor, nodeIx);
            }
            int msb = n4;
            int signum = scala.math.package$.MODULE$.signum(c - nodeChar);
            short s2 = this.branchData[this.rowIx(msb) + 1 + signum];
            if (0 == s2) {
                return this.parseRawHeader(input, lineStart, cursor, nodeIx);
            }
            short subNodeIx = s2;
            int n5 = cursor + 1 - scala.math.package$.MODULE$.abs(signum);
            int n6 = Short$.MODULE$.short2int(subNodeIx);
            cursor = n5;
            nodeIx = n6;
        }
    }

    public int parseHeaderLine$default$2() {
        return 0;
    }

    public int parseHeaderLine$default$3(ByteString input, int lineStart) {
        return lineStart;
    }

    public int parseHeaderLine$default$4(ByteString input, int lineStart) {
        return 0;
    }

    private int parseRawHeader(ByteString input, int lineStart, int cursor, int nodeIx) {
        int n;
        int colonIx = this.scanHeaderNameAndReturnIndexOfColon(input, lineStart, lineStart + 1 + this.settings().maxHeaderNameLength(), cursor);
        String headerName = package$.MODULE$.asciiString(input, lineStart, colonIx);
        try {
            RawHeaderValueParser valueParser = new RawHeaderValueParser(headerName, this.settings().maxHeaderValueLength(), this.settings().headerValueCacheLimit(headerName), this.log(), this.settings().illegalResponseHeaderValueProcessingMode());
            this.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(input, valueParser, cursor, colonIx + 1, nodeIx, colonIx);
            n = this.parseHeaderLine(input, lineStart, cursor, nodeIx);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (HttpHeaderParser$OutOfTrieSpaceException$.MODULE$.equals(throwable2)) {
                int n2 = colonIx + 1;
                int n3 = colonIx + this.settings().maxHeaderValueLength() + 3;
                ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValueProcessingMode = this.settings().illegalResponseHeaderValueProcessingMode();
                Tuple2<String, Object> tuple2 = HttpHeaderParser$.MODULE$.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue(this, input, n2, n3, this.log(), illegalResponseHeaderValueProcessingMode, HttpHeaderParser$.MODULE$.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue$default$7(this, input, n2, n3, this.log(), illegalResponseHeaderValueProcessingMode), HttpHeaderParser$.MODULE$.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue$default$8(this, input, n2, n3, this.log(), illegalResponseHeaderValueProcessingMode));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String headerValue = (String)tuple2._1();
                int endIx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)headerValue, (Object)BoxesRunTime.boxToInteger((int)endIx));
                String headerValue2 = (String)tuple22._1();
                int endIx2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
                this.resultHeader_$eq(RawHeader$.MODULE$.apply(headerName, headerValue2.trim()));
                n = endIx2;
            }
            throw throwable;
        }
        return n;
    }

    private int scanHeaderNameAndReturnIndexOfColon(ByteString input, int start, int limit, int ix) {
        while (ix < limit) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)package$.MODULE$.byteChar(input, ix)), (Object)this.settings().illegalResponseHeaderNameProcessingMode());
            if (tuple2 != null) {
                char c = BoxesRunTime.unboxToChar((Object)tuple2._1());
                ParserSettings.IllegalResponseHeaderNameProcessingMode illegalResponseHeaderNameProcessingMode = (ParserSettings.IllegalResponseHeaderNameProcessingMode)tuple2._2();
                if (':' == c) {
                    return ix;
                }
                char c2 = c;
                if (CharacterClasses$.MODULE$.tchar().apply(c2)) {
                    ++ix;
                    continue;
                }
                char c3 = c;
                if (ParserSettings$IllegalResponseHeaderNameProcessingMode$Error$.MODULE$.equals(illegalResponseHeaderNameProcessingMode)) {
                    throw HttpHeaderParser$.MODULE$.fail(new StringBuilder(35).append("Illegal character '").append(package$.MODULE$.escape(c3)).append("' in header name").toString(), HttpHeaderParser$.MODULE$.fail$default$2());
                }
                char c4 = c;
                if (ParserSettings$IllegalResponseHeaderNameProcessingMode$Warn$.MODULE$.equals(illegalResponseHeaderNameProcessingMode)) {
                    this.log().warning(new StringBuilder(40).append("Header key contains illegal character '").append(package$.MODULE$.escape(c4)).append("'").toString());
                    ++ix;
                    continue;
                }
                char c5 = c;
                if (ParserSettings$IllegalResponseHeaderNameProcessingMode$Ignore$.MODULE$.equals(illegalResponseHeaderNameProcessingMode)) {
                    ++ix;
                    continue;
                }
            }
            throw new MatchError((Object)tuple2);
        }
        throw HttpHeaderParser$.MODULE$.fail(new StringBuilder(60).append("HTTP header name exceeds the configured limit of ").append(limit - start - 1).append(" characters").toString(), StatusCodes$.MODULE$.RequestHeaderFieldsTooLarge());
    }

    private int parseHeaderValue(ByteString input, int valueStart, ValueBranch branch, int cursor, int nodeIx) {
        while (true) {
            char node;
            char c;
            if ((c = package$.MODULE$.byteChar(input, cursor)) == (node = this.nodes[nodeIx])) {
                int n = cursor + 1;
                int n2 = nodeIx + 1;
                cursor = n;
                nodeIx = n2;
                continue;
            }
            int n = node >>> 8;
            if (0 == n) {
                return this.parseAndInsertHeader$1(branch, input, valueStart, cursor, nodeIx);
            }
            int msb = n;
            int n3 = node & 0xFF;
            if (0 == n3) {
                this.resultHeader_$eq((HttpHeader)this.values[msb - 1]);
                return cursor;
            }
            int nodeChar = n3;
            int signum = scala.math.package$.MODULE$.signum(c - nodeChar);
            short s2 = this.branchData[this.rowIx(msb) + 1 + signum];
            if (0 == s2) {
                return this.parseAndInsertHeader$1(branch, input, valueStart, cursor, nodeIx);
            }
            short subNodeIx = s2;
            int n4 = cursor + 1 - scala.math.package$.MODULE$.abs(signum);
            int n5 = Short$.MODULE$.short2int(subNodeIx);
            cursor = n4;
            nodeIx = n5;
        }
    }

    private int parseHeaderValue$default$4(ByteString input, int valueStart, ValueBranch branch) {
        return valueStart;
    }

    private int parseHeaderValue$default$5(ByteString input, int valueStart, ValueBranch branch) {
        return branch.branchRootNodeIx();
    }

    public void org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(ByteString input, Object value, int cursor, int endIx, int nodeIx, int colonIx) {
        while (true) {
            char node;
            char c;
            if ((c = cursor < colonIx ? HttpHeaderParser$.MODULE$.toLowerCase((char)(input.apply(cursor) & 0xFF)) : (cursor < endIx ? (char)(input.apply(cursor) & 0xFF) : (char)'\u0000')) == (node = this.nodes[nodeIx])) {
                int n = cursor + 1;
                int n2 = nodeIx + 1;
                cursor = n;
                nodeIx = n2;
                continue;
            }
            int nodeChar = node & 0xFF;
            int signum = scala.math.package$.MODULE$.signum(c - nodeChar);
            int n = node >>> 8;
            if (0 == n) {
                int valueIx = this.newValueIndex();
                int rowIx = this.newBranchDataRowIndex();
                this.unshareIfRequired();
                short newNodeIx = (short)this.nodeCount;
                this.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(input, value, cursor, endIx, valueIx, colonIx);
                this.nodes[nodeIx] = this.nodeBits(rowIx, nodeChar);
                this.branchData[rowIx + 1] = (short)(nodeIx + 1);
                this.branchData[rowIx + 1 + signum] = newNodeIx;
                return;
            }
            int msb = n;
            if (nodeChar == 0) {
                Predef$.MODULE$.require(cursor == endIx, HttpHeaderParser::insert$$anonfun$1);
                this.values[msb - 1] = value;
                return;
            }
            int branchIndex = this.rowIx(msb) + 1 + signum;
            short s2 = this.branchData[branchIndex];
            if (0 == s2) {
                int valueIx = this.newValueIndex();
                this.unshareIfRequired();
                short newNodeIx = (short)this.nodeCount;
                this.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(input, value, cursor, endIx, valueIx, colonIx);
                this.branchData[branchIndex] = newNodeIx;
                return;
            }
            short subNodeIx = s2;
            int n3 = cursor + 1 - scala.math.package$.MODULE$.abs(signum);
            int n4 = Short$.MODULE$.short2int(subNodeIx);
            cursor = n3;
            nodeIx = n4;
        }
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$3(ByteString input, Object value) {
        return 0;
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$4(ByteString input, Object value) {
        return input.length();
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$5(ByteString input, Object value) {
        return 0;
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert$default$6(ByteString input, Object value) {
        return 0;
    }

    public void org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(ByteString input, Object value, int cursor, int endIx, int valueIx, int colonIx) {
        while (true) {
            char c;
            int newNodeIx = this.newNodeIndex();
            if (cursor >= endIx) break;
            char c2 = (char)(input.apply(cursor) & 0xFF);
            this.nodes[newNodeIx] = c = cursor < colonIx ? HttpHeaderParser$.MODULE$.toLowerCase(c2) : c2;
            ++cursor;
        }
        this.values[valueIx] = value;
        this.nodes[newNodeIx] = (char)(valueIx + 1 << 8);
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$3(ByteString input, Object value) {
        return 0;
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$4(ByteString input, Object value) {
        return input.length();
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$5(ByteString input, Object value) {
        return this.newValueIndex();
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$6(ByteString input, Object value) {
        return 0;
    }

    private void unshareIfRequired() {
        if (!this.trieIsPrivate) {
            this.nodes = Arrays.copyOf(this.nodes, this.nodes.length);
            this.branchData = Arrays.copyOf(this.branchData, this.branchData.length);
            this.values = Arrays.copyOf(this.values, this.values.length);
            this.trieIsPrivate = true;
            return;
        }
    }

    private int newNodeIndex() {
        int index = this.nodeCount;
        if (index < Short.MAX_VALUE) {
            if (index == this.nodes.length) {
                this.nodes = Arrays.copyOf(this.nodes, scala.math.package$.MODULE$.min(index * 3 / 2, Short.MAX_VALUE));
            }
            this.nodeCount = index + 1;
            return index;
        }
        throw HttpHeaderParser$OutOfTrieSpaceException$.MODULE$;
    }

    private int newBranchDataRowIndex() {
        int index = this.branchDataCount;
        this.branchDataCount = index + 3;
        return index;
    }

    private int newValueIndex() {
        int index = this.valueCount;
        if (index < this.values.length) {
            this.valueCount = index + 1;
            return index;
        }
        throw HttpHeaderParser$OutOfTrieSpaceException$.MODULE$;
    }

    private int rowIx(int msb) {
        return (msb - 1) * 3;
    }

    private char nodeBits(int rowIx, int n) {
        return (char)(rowIx / 3 + 1 << 8 | n);
    }

    public String formatTrie() {
        StringBuilder sb = new StringBuilder();
        Tuple2 tuple2 = this.recurse$1(HttpHeaderParser.recurse$default$1$1());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq lines = (Seq)tuple2._1();
        int mainLineIx = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)lines, (Object)BoxesRunTime.boxToInteger((int)mainLineIx));
        Seq lines2 = (Seq)tuple22._1();
        int mainLineIx2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        ((IterableOnceOps)lines2.zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                List line = (List)tuple2._1();
                int ix = BoxesRunTime.unboxToInt((Object)tuple2._2());
                sb.append(ix == mainLineIx2 ? (char)'-' : (char)' ');
                line.foreach((Function1 & Serializable)s2 -> sb.append((String)s2));
                return sb.append('\n');
            }
            throw new MatchError((Object)tuple2);
        });
        return sb.toString();
    }

    public Map<String, Object> contentHistogram() {
        return this.build$1(HttpHeaderParser.build$default$1$1());
    }

    public String formatRawTrie() {
        Object object = Predef$.MODULE$.charArrayOps(this.nodes);
        Object object2 = Predef$.MODULE$.charArrayOps((char[])ArrayOps$.MODULE$.take$extension(object, this.nodeCount));
        Object object3 = Predef$.MODULE$.shortArrayOps(this.branchData);
        Object object4 = Predef$.MODULE$.shortArrayOps((short[])ArrayOps$.MODULE$.take$extension(object3, this.branchDataCount));
        Object object5 = Predef$.MODULE$.refArrayOps(this.values);
        return new StringBuilder(8).append("nodes: ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)c -> HttpHeaderParser.char$1(BoxesRunTime.unboxToChar((Object)c)), ClassTag$.MODULE$.apply(String.class))).mkString(", ")).append("\n").append(new StringBuilder(13).append("branchData: ").append(ArrayOps$.MODULE$.grouped$extension(object4, 3).map((Function1 & Serializable)x$1 -> {
            Object object;
            short[] sArray = x$1;
            if (sArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)sArray), 3) == 0) {
                short s2 = BoxesRunTime.unboxToShort((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
                short s3 = BoxesRunTime.unboxToShort((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1));
                short s4 = BoxesRunTime.unboxToShort((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2));
                short a = s2;
                short b = s3;
                short c = s4;
                return new StringBuilder(2).append(a).append("/").append(b).append("/").append(c).toString();
            }
            throw new MatchError((Object)sArray);
        }).mkString(", ")).append("\n").toString()).append(new StringBuilder(8).append("values: ").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(object5, this.valueCount)).mkString(", ")).toString()).toString();
    }

    public String formatSizes() {
        return new StringBuilder(33).append(this.nodeCount).append(" nodes, ").append(this.branchDataCount / 3).append(" branchData rows, ").append(this.valueCount).append(" values").toString();
    }

    public ByteBuffer org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer() {
        Object object = this.byteBuffer$lzy1;
        if (object instanceof ByteBuffer) {
            return (ByteBuffer)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ByteBuffer)this.byteBuffer$lzyINIT1();
    }

    private Object byteBuffer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.byteBuffer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ByteBuffer byteBuffer = null;
                    try {
                        byteBuffer = ByteBuffer.allocate(4);
                        object2 = byteBuffer == null ? LazyVals.NullValue$.MODULE$ : byteBuffer;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.byteBuffer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return byteBuffer;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private CharBuffer charBuffer() {
        Object object = this.charBuffer$lzy1;
        if (object instanceof CharBuffer) {
            return (CharBuffer)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CharBuffer)this.charBuffer$lzyINIT1();
    }

    private Object charBuffer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.charBuffer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CharBuffer charBuffer = null;
                    try {
                        charBuffer = CharBuffer.allocate(2);
                        object2 = charBuffer == null ? LazyVals.NullValue$.MODULE$ : charBuffer;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.charBuffer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return charBuffer;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private CharsetDecoder decoder() {
        Object object = this.decoder$lzy1;
        if (object instanceof CharsetDecoder) {
            return (CharsetDecoder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CharsetDecoder)this.decoder$lzyINIT1();
    }

    private Object decoder$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.decoder$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CharsetDecoder charsetDecoder = null;
                    try {
                        charsetDecoder = org.apache.pekko.http.impl.util.package$.MODULE$.UTF8().newDecoder();
                        object2 = charsetDecoder == null ? LazyVals.NullValue$.MODULE$ : charsetDecoder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.decoder$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return charsetDecoder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$decodeByteBuffer() {
        int n;
        this.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().flip();
        CoderResult coderResult = this.decoder().decode(this.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer(), this.charBuffer(), false);
        this.charBuffer().flip();
        if (coderResult.isUnderflow() & this.charBuffer().hasRemaining()) {
            char c = this.charBuffer().get();
            n = this.charBuffer().hasRemaining() ? this.charBuffer().get() << 16 | c : (int)c;
        } else {
            n = -1;
        }
        int result = n;
        this.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$byteBuffer().clear();
        this.charBuffer().clear();
        return result;
    }

    private final int startValueBranch$1(ByteString input$6, int cursor$tailLocal1$1, int rootValueIx, HeaderValueParser valueParser) {
        int endIx;
        HttpHeader header;
        block4: {
            Tuple2<HttpHeader, Object> tuple2 = valueParser.apply(this, input$6, cursor$tailLocal1$1, this.onIllegalHeader);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            HttpHeader header2 = (HttpHeader)tuple2._1();
            int endIx2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)header2, (Object)BoxesRunTime.boxToInteger((int)endIx2));
            header = (HttpHeader)tuple22._1();
            endIx = BoxesRunTime.unboxToInt((Object)tuple22._2());
            if (valueParser.cachingEnabled()) {
                try {
                    int valueIx = this.newValueIndex();
                    this.unshareIfRequired();
                    int nodeIx = this.nodeCount;
                    this.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes(input$6, header, cursor$tailLocal1$1, endIx, valueIx, this.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insertRemainingCharsAsNewNodes$default$6(input$6, header));
                    this.values[rootValueIx] = HttpHeaderParser$ValueBranch$.MODULE$.apply(rootValueIx, valueParser, nodeIx, 1);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (HttpHeaderParser$OutOfTrieSpaceException$.MODULE$.equals(throwable2)) break block4;
                    throw throwable;
                }
            }
        }
        this.resultHeader_$eq(header);
        return endIx;
    }

    private final int parseAndInsertHeader$1(ValueBranch branch$1, ByteString input$7, int valueStart$1, int cursor$tailLocal2$1, int nodeIx$tailLocal2$1) {
        int endIx;
        HttpHeader header;
        block4: {
            Tuple2<HttpHeader, Object> tuple2 = branch$1.parser().apply(this, input$7, valueStart$1, this.onIllegalHeader);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            HttpHeader header2 = (HttpHeader)tuple2._1();
            int endIx2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)header2, (Object)BoxesRunTime.boxToInteger((int)endIx2));
            header = (HttpHeader)tuple22._1();
            endIx = BoxesRunTime.unboxToInt((Object)tuple22._2());
            if (branch$1.spaceLeft()) {
                try {
                    this.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$insert(input$7, header, cursor$tailLocal2$1, endIx, nodeIx$tailLocal2$1, 0);
                    this.values[branch$1.valueIx()] = branch$1.withValueCountIncreased();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (HttpHeaderParser$OutOfTrieSpaceException$.MODULE$.equals(throwable2)) break block4;
                    throw throwable;
                }
            }
        }
        this.resultHeader_$eq(header);
        return endIx;
    }

    private static final Object insert$$anonfun$1() {
        return "Cannot insert key of which a prefix already has a value";
    }

    private final Tuple2 recurseAndPrefixLines$1(int subNodeIx, String p1, String p2, String p3) {
        Tuple2 tuple2 = this.recurse$1(subNodeIx);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq lines = (Seq)tuple2._1();
        int mainIx = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)lines, (Object)BoxesRunTime.boxToInteger((int)mainIx));
        Seq lines2 = (Seq)tuple22._1();
        int mainIx2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        Seq prefixedLines = (Seq)((IterableOps)lines2.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                List line = (List)tuple2._1();
                int ix = BoxesRunTime.unboxToInt((Object)tuple2._2());
                String string = ix < mainIx2 ? p1 : (ix > mainIx2 ? p3 : p2);
                return line.$colon$colon((Object)string);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq seq = (Seq)Predef$.MODULE$.ArrowAssoc((Object)prefixedLines);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq, (Object)BoxesRunTime.boxToInteger((int)mainIx2));
    }

    private final Seq branchLines$1(int dataIx, String p1, String p2, String p3) {
        short s2 = this.branchData[dataIx];
        if (0 == s2) {
            return (Seq)scala.package$.MODULE$.Seq().empty();
        }
        short subNodeIx = s2;
        return (Seq)this.recurseAndPrefixLines$1(Short$.MODULE$.short2int(subNodeIx), p1, p2, p3)._1();
    }

    private final Tuple2 recurse$1(int nodeIx) {
        char node = this.nodes[nodeIx];
        String string = package$.MODULE$.escape((char)(node & 0xFF));
        int n = node >>> 8;
        if (0 == n) {
            return this.recurseAndPrefixLines$1(nodeIx + 1, "  ", new StringBuilder(1).append(string).append("-").toString(), "  ");
        }
        int msb = n;
        int n2 = node & 0xFF;
        if (0 == n2) {
            Object object = this.values[msb - 1];
            if (object instanceof ValueBranch) {
                ValueBranch valueBranch = HttpHeaderParser$ValueBranch$.MODULE$.unapply((ValueBranch)object);
                int n3 = valueBranch._1();
                HeaderValueParser headerValueParser = valueBranch._2();
                int n4 = valueBranch._3();
                int n5 = valueBranch._4();
                HeaderValueParser valueParser = headerValueParser;
                int branchRootNodeIx = n4;
                String pad = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), valueParser.headerName().length() + 3);
                return this.recurseAndPrefixLines$1(branchRootNodeIx, pad, new StringBuilder(3).append("(").append(valueParser.headerName()).append(")-").toString(), pad);
            }
            if (object instanceof HeaderValueParser) {
                HeaderValueParser vp = (HeaderValueParser)object;
                Seq seq = (Seq)Predef$.MODULE$.ArrowAssoc((Object)((SeqOps)new .colon.colon((Object)scala.package$.MODULE$.Nil().$colon$colon((Object)")").$colon$colon((Object)vp.headerName()).$colon$colon((Object)" ("), (List)Nil$.MODULE$)));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq, (Object)BoxesRunTime.boxToInteger((int)0));
            }
            if (object instanceof RawHeader) {
                RawHeader value = (RawHeader)object;
                String string2 = value.toString();
                Seq seq = (Seq)Predef$.MODULE$.ArrowAssoc((Object)((SeqOps)new .colon.colon((Object)scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)" *"), (List)Nil$.MODULE$)));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq, (Object)BoxesRunTime.boxToInteger((int)0));
            }
            Object value = object;
            String string3 = value.toString();
            Seq seq = (Seq)Predef$.MODULE$.ArrowAssoc((Object)((SeqOps)new .colon.colon((Object)scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)" "), (List)Nil$.MODULE$)));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq, (Object)BoxesRunTime.boxToInteger((int)0));
        }
        int nodeChar = n2;
        int rix = this.rowIx(msb);
        Seq preLines = this.branchLines$1(rix, "  ", "\u250c\u2500", "| ");
        Seq postLines = this.branchLines$1(rix + 2, "| ", "\u2514\u2500", "  ");
        String p1 = preLines.nonEmpty() ? "| " : "  ";
        String p3 = postLines.nonEmpty() ? "| " : "  ";
        Tuple2 tuple2 = this.recurseAndPrefixLines$1(Short$.MODULE$.short2int(this.branchData[rix + 1]), p1, new StringBuilder(11).append(string).append('-').toString(), p3);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq matchLines = (Seq)tuple2._1();
        int mainLineIx = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)matchLines, (Object)BoxesRunTime.boxToInteger((int)mainLineIx));
        Seq matchLines2 = (Seq)tuple22._1();
        int mainLineIx2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        return Tuple2$.MODULE$.apply(((IterableOps)preLines.$plus$plus((IterableOnce)matchLines2)).$plus$plus((IterableOnce)postLines), (Object)BoxesRunTime.boxToInteger((int)(mainLineIx2 + preLines.size())));
    }

    private static final int recurse$default$1$1() {
        return 0;
    }

    private final Map branch$2(int ix) {
        if (ix > 0) {
            return this.build$1(ix);
        }
        return Predef$.MODULE$.Map().empty();
    }

    private final Map build$1(int nodeIx) {
        char node;
        int n;
        while (0 == (n = (node = this.nodes[nodeIx]) >>> 8)) {
            ++nodeIx;
        }
        int msb = n;
        if ((node & 0xFF) == 0) {
            Object object = this.values[msb - 1];
            if (object instanceof ValueBranch) {
                ValueBranch valueBranch = HttpHeaderParser$ValueBranch$.MODULE$.unapply((ValueBranch)object);
                int n2 = valueBranch._1();
                HeaderValueParser headerValueParser = valueBranch._2();
                int n3 = valueBranch._3();
                int n4 = valueBranch._4();
                HeaderValueParser parser = headerValueParser;
                int count = n4;
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)parser.headerName());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)count));
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }
            return Predef$.MODULE$.Map().empty();
        }
        int msb2 = n;
        int rix = this.rowIx(msb2);
        return (Map)((MapOps)this.branch$2(Short$.MODULE$.short2int(this.branchData[rix + 0])).$plus$plus((IterableOnce)this.branch$2(Short$.MODULE$.short2int(this.branchData[rix + 1])))).$plus$plus((IterableOnce)this.branch$2(Short$.MODULE$.short2int(this.branchData[rix + 2])));
    }

    private static final int build$default$1$1() {
        return 0;
    }

    private static final String char$1(char c) {
        return new StringBuilder(0).append(BoxesRunTime.boxToInteger((int)(c >> 8)).toString()).append((c & 0xFF) > 0 ? new StringBuilder(1).append("/").append((char)(c & 0xFF)).toString() : "/\u03a9").toString();
    }

    public static abstract class HeaderValueParser {
        private final String headerName;
        private final int maxValueCount;

        public HeaderValueParser(String headerName, int maxValueCount) {
            this.headerName = headerName;
            this.maxValueCount = maxValueCount;
        }

        public String headerName() {
            return this.headerName;
        }

        public int maxValueCount() {
            return this.maxValueCount;
        }

        public abstract Tuple2<HttpHeader, Object> apply(HttpHeaderParser var1, ByteString var2, int var3, Function1<ErrorInfo, BoxedUnit> var4);

        public String toString() {
            return new StringBuilder(19).append("HeaderValueParser[").append(this.headerName()).append("]").toString();
        }

        public boolean cachingEnabled() {
            return this.maxValueCount() > 0;
        }
    }

    public static class ModeledHeaderValueParser
    extends HeaderValueParser {
        private final int maxHeaderValueLength;
        private final LoggingAdapter log;
        private final HeaderParser.Settings settings;
        private final Function1 parser;

        public ModeledHeaderValueParser(String headerName, int maxHeaderValueLength, int maxValueCount, LoggingAdapter log, HeaderParser.Settings settings) {
            this.maxHeaderValueLength = maxHeaderValueLength;
            this.log = log;
            this.settings = settings;
            super(headerName, maxValueCount);
            this.parser = (Function1)HeaderParser$.MODULE$.lookupParser(headerName, settings).getOrElse(() -> this.$init$$$anonfun$1(headerName));
        }

        private String headerName$accessor() {
            return super.headerName();
        }

        private int maxValueCount$accessor() {
            return super.maxValueCount();
        }

        public Function1<String, HeaderParser.Result> parser() {
            return this.parser;
        }

        @Override
        public Tuple2<HttpHeader, Object> apply(HttpHeaderParser hhp, ByteString input, int valueStart, Function1<ErrorInfo, BoxedUnit> onIllegalHeader) {
            HttpHeader httpHeader;
            int n = valueStart + this.maxHeaderValueLength + 2;
            ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValueProcessingMode = this.settings.illegalResponseHeaderValueProcessingMode();
            Tuple2<String, Object> tuple2 = HttpHeaderParser$.MODULE$.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue(hhp, input, valueStart, n, this.log, illegalResponseHeaderValueProcessingMode, HttpHeaderParser$.MODULE$.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue$default$7(hhp, input, valueStart, n, this.log, illegalResponseHeaderValueProcessingMode), HttpHeaderParser$.MODULE$.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue$default$8(hhp, input, valueStart, n, this.log, illegalResponseHeaderValueProcessingMode));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String headerValue = (String)tuple2._1();
            int endIx = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)headerValue, (Object)BoxesRunTime.boxToInteger((int)endIx));
            String headerValue2 = (String)tuple22._1();
            int endIx2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
            String trimmedHeaderValue = headerValue2.trim();
            HeaderParser.Result result = (HeaderParser.Result)this.parser().apply((Object)trimmedHeaderValue);
            if (result instanceof HeaderParser.Success) {
                HttpHeader httpHeader2;
                HttpHeader h;
                HeaderParser.Success success = HeaderParser$Success$.MODULE$.unapply((HeaderParser.Success)result);
                httpHeader = h = (httpHeader2 = success._1());
            } else if (result instanceof HeaderParser.Failure) {
                ErrorInfo errorInfo;
                HeaderParser.Failure failure = HeaderParser$Failure$.MODULE$.unapply((HeaderParser.Failure)result);
                ErrorInfo error = errorInfo = failure._1();
                onIllegalHeader.apply((Object)error.withSummaryPrepended(new StringBuilder(17).append("Illegal '").append(this.headerName$accessor()).append("' header").toString()).withErrorHeaderName(this.headerName$accessor()));
                httpHeader = RawHeader$.MODULE$.apply(this.headerName$accessor(), trimmedHeaderValue);
            } else {
                if (HeaderParser$RuleNotFound$.MODULE$.equals(result)) {
                    throw new IllegalStateException(new StringBuilder(55).append("Unexpected RuleNotFound exception for modeled header [").append(this.headerName$accessor()).append("]").toString());
                }
                throw new MatchError((Object)result);
            }
            HttpHeader header = httpHeader;
            HttpHeader httpHeader3 = (HttpHeader)Predef$.MODULE$.ArrowAssoc((Object)header);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)httpHeader3, (Object)BoxesRunTime.boxToInteger((int)endIx2));
        }

        private final Function1 $init$$$anonfun$1(String headerName$1) {
            throw new IllegalStateException(new StringBuilder(30).append("Missing parser for modeled [").append(headerName$1).append("].").toString());
        }
    }

    public static class RawHeaderValueParser
    extends HeaderValueParser {
        private final int maxHeaderValueLength;
        private final LoggingAdapter log;
        private final ParserSettings.IllegalResponseHeaderValueProcessingMode mode;

        public RawHeaderValueParser(String headerName, int maxHeaderValueLength, int maxValueCount, LoggingAdapter log, ParserSettings.IllegalResponseHeaderValueProcessingMode mode) {
            this.maxHeaderValueLength = maxHeaderValueLength;
            this.log = log;
            this.mode = mode;
            super(headerName, maxValueCount);
        }

        private String headerName$accessor() {
            return super.headerName();
        }

        private int maxValueCount$accessor() {
            return super.maxValueCount();
        }

        @Override
        public Tuple2<HttpHeader, Object> apply(HttpHeaderParser hhp, ByteString input, int valueStart, Function1<ErrorInfo, BoxedUnit> onIllegalHeader) {
            int n = valueStart + this.maxHeaderValueLength + 2;
            Tuple2<String, Object> tuple2 = HttpHeaderParser$.MODULE$.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue(hhp, input, valueStart, n, this.log, this.mode, HttpHeaderParser$.MODULE$.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue$default$7(hhp, input, valueStart, n, this.log, this.mode), HttpHeaderParser$.MODULE$.org$apache$pekko$http$impl$engine$parsing$HttpHeaderParser$$$scanHeaderValue$default$8(hhp, input, valueStart, n, this.log, this.mode));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String headerValue = (String)tuple2._1();
            int endIx = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)headerValue, (Object)BoxesRunTime.boxToInteger((int)endIx));
            String headerValue2 = (String)tuple22._1();
            int endIx2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
            RawHeader rawHeader = (RawHeader)Predef$.MODULE$.ArrowAssoc((Object)RawHeader$.MODULE$.apply(this.headerName$accessor(), headerValue2.trim()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)rawHeader, (Object)BoxesRunTime.boxToInteger((int)endIx2));
        }
    }

    public static abstract class Settings
    extends HeaderParser.Settings {
        public abstract int maxHeaderNameLength();

        public abstract int maxHeaderValueLength();

        public abstract int headerValueCacheLimit(String var1);

        @Override
        public abstract Function2<String, String, Option<MediaType>> customMediaTypes();

        public abstract boolean illegalHeaderWarnings();

        public abstract Set<String> ignoreIllegalHeaderFor();

        @Override
        public abstract ParserSettings.IllegalResponseHeaderNameProcessingMode illegalResponseHeaderNameProcessingMode();

        @Override
        public abstract ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValueProcessingMode();

        public abstract ParserSettings.ErrorLoggingVerbosity errorLoggingVerbosity();

        public abstract boolean modeledHeaderParsing();
    }

    public static final class ValueBranch
    implements Product,
    Serializable {
        private final int valueIx;
        private final HeaderValueParser parser;
        private final int branchRootNodeIx;
        private final int valueCount;

        public static ValueBranch apply(int n, HeaderValueParser headerValueParser, int n2, int n3) {
            return HttpHeaderParser$ValueBranch$.MODULE$.apply(n, headerValueParser, n2, n3);
        }

        public static ValueBranch fromProduct(Product product) {
            return HttpHeaderParser$ValueBranch$.MODULE$.fromProduct(product);
        }

        public static ValueBranch unapply(ValueBranch valueBranch) {
            return HttpHeaderParser$ValueBranch$.MODULE$.unapply(valueBranch);
        }

        public ValueBranch(int valueIx, HeaderValueParser parser, int branchRootNodeIx, int valueCount) {
            this.valueIx = valueIx;
            this.parser = parser;
            this.branchRootNodeIx = branchRootNodeIx;
            this.valueCount = valueCount;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.valueIx());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parser()));
            n = Statics.mix((int)n, (int)this.branchRootNodeIx());
            n = Statics.mix((int)n, (int)this.valueCount());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ValueBranch)) return false;
            ValueBranch valueBranch = (ValueBranch)object;
            if (this.valueIx() != valueBranch.valueIx()) return false;
            if (this.branchRootNodeIx() != valueBranch.branchRootNodeIx()) return false;
            if (this.valueCount() != valueBranch.valueCount()) return false;
            HeaderValueParser headerValueParser = this.parser();
            HeaderValueParser headerValueParser2 = valueBranch.parser();
            if (headerValueParser != null) {
                if (!headerValueParser.equals(headerValueParser2)) return false;
                return true;
            }
            if (headerValueParser2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ValueBranch;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ValueBranch";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "valueIx";
                }
                case 1: {
                    return "parser";
                }
                case 2: {
                    return "branchRootNodeIx";
                }
                case 3: {
                    return "valueCount";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int valueIx() {
            return this.valueIx;
        }

        public HeaderValueParser parser() {
            return this.parser;
        }

        public int branchRootNodeIx() {
            return this.branchRootNodeIx;
        }

        public int valueCount() {
            return this.valueCount;
        }

        public ValueBranch withValueCountIncreased() {
            int n = this.valueCount() + 1;
            int n2 = this.copy$default$1();
            HeaderValueParser headerValueParser = this.copy$default$2();
            int n3 = this.copy$default$3();
            return this.copy(n2, headerValueParser, n3, n);
        }

        public boolean spaceLeft() {
            return this.valueCount() < this.parser().maxValueCount();
        }

        public ValueBranch copy(int valueIx, HeaderValueParser parser, int branchRootNodeIx, int valueCount) {
            return new ValueBranch(valueIx, parser, branchRootNodeIx, valueCount);
        }

        public int copy$default$1() {
            return this.valueIx();
        }

        public HeaderValueParser copy$default$2() {
            return this.parser();
        }

        public int copy$default$3() {
            return this.branchRootNodeIx();
        }

        public int copy$default$4() {
            return this.valueCount();
        }

        public int _1() {
            return this.valueIx();
        }

        public HeaderValueParser _2() {
            return this.parser();
        }

        public int _3() {
            return this.branchRootNodeIx();
        }

        public int _4() {
            return this.valueCount();
        }
    }
}

