/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.parsing;

import java.io.Serializable;
import javax.net.ssl.SSLSession;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.parsing.HttpHeaderParser;
import org.apache.pekko.http.impl.engine.parsing.HttpMessageParser$;
import org.apache.pekko.http.impl.engine.parsing.HttpMessageParser$Trampoline$;
import org.apache.pekko.http.impl.engine.parsing.NotEnoughDataException$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$EntityChunk$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$EntityPart$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$EntityStreamError$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$MessageEnd$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$MessageStartError$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$NeedMoreData$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$StreamEnd$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$StreamedEntityCreator$;
import org.apache.pekko.http.impl.engine.parsing.ParserOutput$StrictEntityCreator$;
import org.apache.pekko.http.impl.engine.parsing.ParsingException;
import org.apache.pekko.http.impl.engine.parsing.package$;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.EntityStreamException$;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.ErrorInfo$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunk$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Chunked$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Default$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$LastChunk$;
import org.apache.pekko.http.scaladsl.model.HttpEntity$Strict$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMessage$;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.IllegalHeaderException;
import org.apache.pekko.http.scaladsl.model.IllegalHeaderException$;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.TransferEncoding;
import org.apache.pekko.http.scaladsl.model.TransferEncodings$chunked$;
import org.apache.pekko.http.scaladsl.model.UniversalEntity;
import org.apache.pekko.http.scaladsl.model.headers.Connection;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType$;
import org.apache.pekko.http.scaladsl.model.headers.EmptyHeader$;
import org.apache.pekko.http.scaladsl.model.headers.Expect;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo;
import org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo$;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ConflictingContentTypeHeaderProcessingMode$Error$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ConflictingContentTypeHeaderProcessingMode$First$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ConflictingContentTypeHeaderProcessingMode$Last$;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$ConflictingContentTypeHeaderProcessingMode$NoContentType$;
import org.apache.pekko.stream.TLSProtocol;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import org.parboiled2.CharUtils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalApi
public interface HttpMessageParser<Output extends ParserOutput> {
    public static Function0<Option<ParserOutput.ErrorOutput>> CompletionIsEntityStreamError() {
        return HttpMessageParser$.MODULE$.CompletionIsEntityStreamError();
    }

    public static Function0<Option<ParserOutput.ErrorOutput>> CompletionIsMessageStartError() {
        return HttpMessageParser$.MODULE$.CompletionIsMessageStartError();
    }

    public static Function0<Option<ParserOutput.ErrorOutput>> CompletionOk() {
        return HttpMessageParser$.MODULE$.CompletionOk();
    }

    public static void $init$(HttpMessageParser $this) {
        $this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result_$eq(null);
        $this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state_$eq((Function1<ByteString, StateResult>)(Function1 & Serializable)_$1 -> this.startNewMessage((ByteString)_$1, 0));
        $this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(HttpProtocols$.MODULE$.HTTP$div1$u002E1());
        $this.completionHandling_$eq(HttpMessageParser$.MODULE$.CompletionOk());
        $this.terminated_$eq(false);
        $this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(null);
        $this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(null);
    }

    public Object org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result();

    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result_$eq(Object var1);

    public Function1<ByteString, StateResult> org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state();

    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state_$eq(Function1<ByteString, StateResult> var1);

    public HttpProtocol org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol();

    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(HttpProtocol var1);

    public Function0<Option<ParserOutput.ErrorOutput>> completionHandling();

    public void completionHandling_$eq(Function0<Option<ParserOutput.ErrorOutput>> var1);

    public boolean terminated();

    public void terminated_$eq(boolean var1);

    public SSLSession org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession();

    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(SSLSession var1);

    public Tls$minusSession$minusInfo org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader();

    public void org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(Tls$minusSession$minusInfo var1);

    public ParserSettings settings();

    public HttpHeaderParser headerParser();

    public boolean isResponseParser();

    public Nothing$ onBadProtocol(ByteString var1);

    public StateResult parseMessage(ByteString var1, int var2);

    public StateResult parseEntity(List<HttpHeader> var1, HttpProtocol var2, ByteString var3, int var4, Option<Content$minusLength> var5, Option<Content$minusType> var6, boolean var7, boolean var8, boolean var9, boolean var10, SSLSession var11);

    public static ListBuffer initialHeaderBuffer$(HttpMessageParser $this) {
        return $this.initialHeaderBuffer();
    }

    default public ListBuffer<HttpHeader> initialHeaderBuffer() {
        if (this.settings().includeTlsSessionInfoHeader() && this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader() != null) {
            return (ListBuffer)new ListBuffer().$plus$eq((Object)this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader());
        }
        return new ListBuffer();
    }

    public static ParserOutput parseSessionBytes$(HttpMessageParser $this, TLSProtocol.SessionBytes input) {
        return $this.parseSessionBytes(input);
    }

    default public Output parseSessionBytes(TLSProtocol.SessionBytes input) {
        if (input.session() != this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession()) {
            this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession_$eq(input.session());
            this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$tlsSessionInfoHeader_$eq(Tls$minusSession$minusInfo$.MODULE$.apply(input.session()));
        }
        return this.parseBytes(input.bytes());
    }

    public static ParserOutput parseBytes$(HttpMessageParser $this, ByteString input) {
        return $this.parseBytes(input);
    }

    default public Output parseBytes(ByteString input) {
        if (this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result() != null) {
            throw new IllegalStateException("Unexpected `onPush`");
        }
        this.run$1(input, this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state());
        return this.doPull();
    }

    public static ParserOutput doPull$(HttpMessageParser $this) {
        return $this.doPull();
    }

    default public Output doPull() {
        Object object = this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result();
        if (object == null) {
            return (Output)((ParserOutput)(this.terminated() ? ParserOutput$StreamEnd$.MODULE$ : ParserOutput$NeedMoreData$.MODULE$));
        }
        if (object instanceof ListBuffer) {
            ListBuffer buffer = (ListBuffer)object;
            ParserOutput head = (ParserOutput)buffer.head();
            buffer.remove(0);
            if (buffer.isEmpty()) {
                this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result_$eq(null);
            }
            return (Output)head;
        }
        if (object instanceof ParserOutput) {
            ParserOutput ele = (ParserOutput)object;
            this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result_$eq(null);
            return (Output)ele;
        }
        throw new MatchError(object);
    }

    public static boolean shouldComplete$(HttpMessageParser $this) {
        return $this.shouldComplete();
    }

    default public boolean shouldComplete() {
        Option option = (Option)this.completionHandling().apply();
        if (option instanceof Some) {
            ParserOutput.ErrorOutput x = (ParserOutput.ErrorOutput)((Some)option).value();
            this.emit(x);
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        this.terminated_$eq(true);
        return this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result() == null;
    }

    public static StateResult startNewMessage$(HttpMessageParser $this, ByteString input, int offset) {
        return $this.startNewMessage(input, offset);
    }

    default public StateResult startNewMessage(ByteString input2, int offset2) {
        StateResult stateResult;
        if (offset2 < input2.length()) {
            this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionIsMessageStartError());
        }
        try {
            stateResult = this.parseMessage(input2, offset2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NotEnoughDataException$.MODULE$.equals(throwable2)) {
                stateResult = this.continue(input2, offset2, (Function2<ByteString, Object, StateResult>)(Function2 & Serializable)(input, offset) -> this.startNewMessage$$anonfun$1((ByteString)input, BoxesRunTime.unboxToInt((Object)offset)));
            }
            throw throwable;
        }
        return stateResult;
    }

    public static int parseProtocol$(HttpMessageParser $this, ByteString input, int cursor) {
        return $this.parseProtocol(input, cursor);
    }

    default public int parseProtocol(ByteString input, int cursor) {
        if (HttpMessageParser.c$1(input, cursor, 0) == 'H' && HttpMessageParser.c$1(input, cursor, 1) == 'T' && HttpMessageParser.c$1(input, cursor, 2) == 'T' && HttpMessageParser.c$1(input, cursor, 3) == 'P' && HttpMessageParser.c$1(input, cursor, 4) == '/' && HttpMessageParser.c$1(input, cursor, 5) == '1' && HttpMessageParser.c$1(input, cursor, 6) == '.') {
            HttpProtocol httpProtocol;
            char c = HttpMessageParser.c$1(input, cursor, 7);
            if ('0' == c) {
                httpProtocol = HttpProtocols$.MODULE$.HTTP$div1$u002E0();
            } else if ('1' == c) {
                httpProtocol = HttpProtocols$.MODULE$.HTTP$div1$u002E1();
            } else {
                throw this.onBadProtocol(input.drop(cursor));
            }
            this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol_$eq(httpProtocol);
            return cursor + 8;
        }
        throw this.onBadProtocol(input.drop(cursor));
    }

    public static StateResult parseHeaderLines$(HttpMessageParser $this, ByteString input, int lineStart, ListBuffer headers, int headerCount, Option ch, Option clh, Option cth, boolean isChunked, boolean e100c, boolean hh) {
        return $this.parseHeaderLines(input, lineStart, (ListBuffer<HttpHeader>)headers, headerCount, (Option<Connection>)ch, (Option<Content$minusLength>)clh, (Option<Content$minusType>)cth, isChunked, e100c, hh);
    }

    default public StateResult parseHeaderLines(ByteString input2, int lineStart2, ListBuffer<HttpHeader> headers, int headerCount, Option<Connection> ch, Option<Content$minusLength> clh, Option<Content$minusType> cth, boolean isChunked, boolean e100c, boolean hh) {
        while (headerCount < this.settings().maxHeaderCount()) {
            HttpHeader resultHeader;
            HttpHeader httpHeader;
            int lineEnd = 0;
            try {
                HttpHeaderParser httpHeaderParser = this.headerParser();
                lineEnd = httpHeaderParser.parseHeaderLine(input2, lineStart2, httpHeaderParser.parseHeaderLine$default$3(input2, lineStart2), httpHeaderParser.parseHeaderLine$default$4(input2, lineStart2));
                httpHeader = this.headerParser().resultHeader();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!NotEnoughDataException$.MODULE$.equals(throwable2)) {
                    throw throwable;
                }
                httpHeader = null;
            }
            HttpHeader httpHeader2 = resultHeader = httpHeader;
            if (httpHeader2 == null) {
                return this.continue(input2, lineStart2, (Function2<ByteString, Object, StateResult>)(Function2 & Serializable)(input, lineStart) -> this.parseHeaderLines$$anonfun$1(headers, headerCount, (Option)ch, (Option)clh, (Option)cth, isChunked, e100c, hh, (ByteString)input, BoxesRunTime.unboxToInt((Object)lineStart)));
            }
            if (EmptyHeader$.MODULE$.equals(httpHeader2)) {
                boolean close = HttpMessage$.MODULE$.connectionCloseExpected(this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol(), (Option<Connection>)ch);
                this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionIsEntityStreamError());
                return this.parseEntity((List<HttpHeader>)headers.toList(), this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$protocol(), input2, lineEnd, (Option<Content$minusLength>)clh, (Option<Content$minusType>)cth, isChunked, e100c, hh, close, this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$lastSession());
            }
            if (httpHeader2 instanceof Content$minusLength) {
                Content$minusLength h = (Content$minusLength)httpHeader2;
                Some some = clh;
                if (None$.MODULE$.equals(some)) {
                    int n = lineEnd;
                    int n2 = headerCount + 1;
                    Some some2 = Some$.MODULE$.apply((Object)h);
                    lineStart2 = n;
                    headerCount = n2;
                    clh = some2;
                    continue;
                }
                if (some instanceof Some) {
                    Content$minusLength content$minusLength = h;
                    Object object = ((Some)some).value();
                    if (!(content$minusLength != null ? !((Object)content$minusLength).equals(object) : object != null)) {
                        lineStart2 = lineEnd;
                        continue;
                    }
                }
                return this.failMessageStart("HTTP message must not contain more than one Content-Length header");
            }
            if (httpHeader2 instanceof Content$minusType) {
                Content$minusType h = (Content$minusType)httpHeader2;
                Some some = cth;
                if (None$.MODULE$.equals(some)) {
                    int n = lineEnd;
                    int n3 = headerCount + 1;
                    Some some3 = Some$.MODULE$.apply((Object)h);
                    lineStart2 = n;
                    headerCount = n3;
                    cth = some3;
                    continue;
                }
                if (some instanceof Some) {
                    Content$minusType content$minusType = (Content$minusType)((Some)some).value();
                    Content$minusType content$minusType2 = h;
                    Content$minusType content$minusType3 = content$minusType;
                    if (!(content$minusType2 != null ? !((Object)content$minusType2).equals(content$minusType3) : content$minusType3 != null)) {
                        lineStart2 = lineEnd;
                        continue;
                    }
                    if (content$minusType != null) {
                        Content$minusType content$minusType4 = Content$minusType$.MODULE$.unapply(content$minusType);
                        ContentType contentType = content$minusType4._1();
                        ContentType.Binary binary = ContentTypes$.MODULE$.NoContentType();
                        ContentType contentType2 = contentType;
                        if (!(binary != null ? !((Object)binary).equals(contentType2) : contentType2 != null)) {
                            int n = lineEnd;
                            ListBuffer listBuffer = (ListBuffer)headers.$plus$eq((Object)h);
                            int n4 = headerCount + 1;
                            lineStart2 = n;
                            headers = listBuffer;
                            headerCount = n4;
                            continue;
                        }
                    }
                    Content$minusType x = content$minusType;
                    ParserSettings.ConflictingContentTypeHeaderProcessingMode conflictingContentTypeHeaderProcessingMode = this.settings().conflictingContentTypeHeaderProcessingMode();
                    if (ParserSettings$ConflictingContentTypeHeaderProcessingMode$Error$.MODULE$.equals(conflictingContentTypeHeaderProcessingMode)) {
                        return this.failMessageStart("HTTP message must not contain more than one Content-Type header");
                    }
                    if (ParserSettings$ConflictingContentTypeHeaderProcessingMode$First$.MODULE$.equals(conflictingContentTypeHeaderProcessingMode)) {
                        int n = lineEnd;
                        ListBuffer listBuffer = (ListBuffer)headers.$plus$eq((Object)h);
                        int n5 = headerCount + 1;
                        lineStart2 = n;
                        headers = listBuffer;
                        headerCount = n5;
                        continue;
                    }
                    if (ParserSettings$ConflictingContentTypeHeaderProcessingMode$Last$.MODULE$.equals(conflictingContentTypeHeaderProcessingMode)) {
                        int n = lineEnd;
                        ListBuffer listBuffer = (ListBuffer)headers.$plus$eq((Object)x);
                        int n6 = headerCount + 1;
                        Some some4 = Some$.MODULE$.apply((Object)h);
                        lineStart2 = n;
                        headers = listBuffer;
                        headerCount = n6;
                        cth = some4;
                        continue;
                    }
                    if (ParserSettings$ConflictingContentTypeHeaderProcessingMode$NoContentType$.MODULE$.equals(conflictingContentTypeHeaderProcessingMode)) {
                        int n = lineEnd;
                        ListBuffer listBuffer = (ListBuffer)headers.$plus$eq((Object)x).$plus$eq((Object)h);
                        int n7 = headerCount + 1;
                        Some some5 = Some$.MODULE$.apply((Object)Content$minusType$.MODULE$.apply(ContentTypes$.MODULE$.NoContentType()));
                        lineStart2 = n;
                        headers = listBuffer;
                        headerCount = n7;
                        cth = some5;
                        continue;
                    }
                    throw new MatchError((Object)conflictingContentTypeHeaderProcessingMode);
                }
                throw new MatchError(some);
            }
            if (httpHeader2 instanceof Transfer$minusEncoding) {
                Transfer$minusEncoding h = (Transfer$minusEncoding)httpHeader2;
                if (!isChunked) {
                    SeqOps seqOps;
                    Seq<TransferEncoding> seq = h.encodings();
                    if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq(seq), 1) == 0) {
                        TransferEncoding transferEncoding = (TransferEncoding)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                        if (TransferEncodings$chunked$.MODULE$.equals(transferEncoding)) {
                            int n = lineEnd;
                            int n8 = headerCount + 1;
                            boolean bl = true;
                            lineStart2 = n;
                            headerCount = n8;
                            isChunked = bl;
                            continue;
                        }
                        TransferEncoding unknown = transferEncoding;
                        return this.failMessageStart(new StringBuilder(32).append("Unsupported Transfer-Encoding '").append(unknown.name()).append("'").toString());
                    }
                    return this.failMessageStart("Multiple Transfer-Encoding entries not supported");
                }
                return this.failMessageStart("Multiple Transfer-Encoding entries not supported");
            }
            if (httpHeader2 instanceof Connection) {
                Connection h = (Connection)httpHeader2;
                Some some = ch;
                if (None$.MODULE$.equals(some)) {
                    int n = lineEnd;
                    ListBuffer listBuffer = (ListBuffer)headers.$plus$eq((Object)h);
                    int n9 = headerCount + 1;
                    Some some6 = Some$.MODULE$.apply((Object)h);
                    lineStart2 = n;
                    headers = listBuffer;
                    headerCount = n9;
                    ch = some6;
                    continue;
                }
                if (some instanceof Some) {
                    Connection x = (Connection)((Some)some).value();
                    int n = lineEnd;
                    Some some7 = Some$.MODULE$.apply((Object)x.append(h.tokens()));
                    lineStart2 = n;
                    ch = some7;
                    continue;
                }
                throw new MatchError(some);
            }
            if (httpHeader2 instanceof Host) {
                Host h = (Host)httpHeader2;
                if (!hh || this.isResponseParser()) {
                    int n = lineEnd;
                    ListBuffer listBuffer = (ListBuffer)headers.$plus$eq((Object)h);
                    int n10 = headerCount + 1;
                    boolean bl = true;
                    lineStart2 = n;
                    headers = listBuffer;
                    headerCount = n10;
                    hh = bl;
                    continue;
                }
                return this.failMessageStart("HTTP message must not contain more than one Host header");
            }
            if (httpHeader2 instanceof Expect) {
                Expect h = (Expect)httpHeader2;
                int n = lineEnd;
                ListBuffer listBuffer = (ListBuffer)headers.$plus$eq((Object)h);
                int n11 = headerCount + 1;
                boolean bl = true;
                lineStart2 = n;
                headers = listBuffer;
                headerCount = n11;
                e100c = bl;
                continue;
            }
            HttpHeader h = httpHeader2;
            int n = lineEnd;
            ListBuffer listBuffer = (ListBuffer)headers.$plus$eq((Object)h);
            int n12 = headerCount + 1;
            lineStart2 = n;
            headers = listBuffer;
            headerCount = n12;
        }
        return this.failMessageStart(new StringBuilder(64).append("HTTP message contains more than the configured limit of ").append(this.settings().maxHeaderCount()).append(" headers").toString());
    }

    public static ListBuffer parseHeaderLines$default$3$(HttpMessageParser $this) {
        return $this.parseHeaderLines$default$3();
    }

    default public ListBuffer<HttpHeader> parseHeaderLines$default$3() {
        return this.initialHeaderBuffer();
    }

    public static int parseHeaderLines$default$4$(HttpMessageParser $this) {
        return $this.parseHeaderLines$default$4();
    }

    default public int parseHeaderLines$default$4() {
        return 0;
    }

    public static Option parseHeaderLines$default$5$(HttpMessageParser $this) {
        return $this.parseHeaderLines$default$5();
    }

    default public Option<Connection> parseHeaderLines$default$5() {
        return None$.MODULE$;
    }

    public static Option parseHeaderLines$default$6$(HttpMessageParser $this) {
        return $this.parseHeaderLines$default$6();
    }

    default public Option<Content$minusLength> parseHeaderLines$default$6() {
        return None$.MODULE$;
    }

    public static Option parseHeaderLines$default$7$(HttpMessageParser $this) {
        return $this.parseHeaderLines$default$7();
    }

    default public Option<Content$minusType> parseHeaderLines$default$7() {
        return None$.MODULE$;
    }

    public static boolean parseHeaderLines$default$8$(HttpMessageParser $this) {
        return $this.parseHeaderLines$default$8();
    }

    default public boolean parseHeaderLines$default$8() {
        return false;
    }

    public static boolean parseHeaderLines$default$9$(HttpMessageParser $this) {
        return $this.parseHeaderLines$default$9();
    }

    default public boolean parseHeaderLines$default$9() {
        return false;
    }

    public static boolean parseHeaderLines$default$10$(HttpMessageParser $this) {
        return $this.parseHeaderLines$default$10();
    }

    default public boolean parseHeaderLines$default$10() {
        return false;
    }

    private StateResult parseHeaderLinesAux(ListBuffer<HttpHeader> headers, int headerCount, Option<Connection> ch, Option<Content$minusLength> clh, Option<Content$minusType> cth, boolean isChunked, boolean e100c, boolean hh, ByteString input, int lineStart) {
        return this.parseHeaderLines(input, lineStart, headers, headerCount, ch, clh, cth, isChunked, e100c, hh);
    }

    public static StateResult parseFixedLengthBody$(HttpMessageParser $this, long remainingBodyBytes, boolean isLastMessage, ByteString input, int bodyStart) {
        return $this.parseFixedLengthBody(remainingBodyBytes, isLastMessage, input, bodyStart);
    }

    default public StateResult parseFixedLengthBody(long remainingBodyBytes, boolean isLastMessage, ByteString input2, int bodyStart2) {
        int remainingInputBytes = input2.length() - bodyStart2;
        if (remainingInputBytes > 0) {
            if ((long)remainingInputBytes < remainingBodyBytes) {
                this.emit(ParserOutput$EntityPart$.MODULE$.apply((ByteString)input2.drop(bodyStart2).compact()));
                long l = remainingBodyBytes - (long)remainingInputBytes;
                return this.continue((Function2<ByteString, Object, StateResult>)(Function2 & Serializable)(input, bodyStart) -> this.parseFixedLengthBody$$anonfun$1(l, isLastMessage, (ByteString)input, BoxesRunTime.unboxToInt((Object)bodyStart)));
            }
            int offset = bodyStart2 + (int)remainingBodyBytes;
            this.emit(ParserOutput$EntityPart$.MODULE$.apply((ByteString)input2.slice(bodyStart2, offset).compact()));
            this.emit(ParserOutput$MessageEnd$.MODULE$);
            this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
            if (isLastMessage) {
                return this.terminate();
            }
            return this.startNewMessage(input2, offset);
        }
        return this.continue(input2, bodyStart2, (Function2<ByteString, Object, StateResult>)(Function2 & Serializable)(input, bodyStart) -> this.parseFixedLengthBody$$anonfun$2(remainingBodyBytes, isLastMessage, (ByteString)input, BoxesRunTime.unboxToInt((Object)bodyStart)));
    }

    public static StateResult parseChunk$(HttpMessageParser $this, ByteString input, int offset, boolean isLastMessage, long totalBytesRead) {
        return $this.parseChunk(input, offset, isLastMessage, totalBytesRead);
    }

    default public StateResult parseChunk(ByteString input, int offset, boolean isLastMessage, long totalBytesRead) {
        StateResult stateResult;
        try {
            stateResult = this.parseSize$1(input, offset, isLastMessage, totalBytesRead, offset, 0L);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NotEnoughDataException$.MODULE$.equals(throwable2)) {
                stateResult = this.continue(input, offset, (Function2<ByteString, Object, StateResult>)(Function2 & Serializable)(_$3, _$4) -> this.parseChunk$$anonfun$1(isLastMessage, totalBytesRead, (ByteString)_$3, BoxesRunTime.unboxToInt((Object)_$4)));
            }
            throw throwable;
        }
        return stateResult;
    }

    public static void emit$(HttpMessageParser $this, ParserOutput output) {
        $this.emit(output);
    }

    default public void emit(Output output) {
        Object object = this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result();
        if (object == null) {
            this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result_$eq(output);
            return;
        }
        if (object instanceof ListBuffer) {
            ListBuffer buffer = (ListBuffer)object;
            buffer.$plus$eq(output);
            return;
        }
        if (object instanceof ParserOutput) {
            ParserOutput old = (ParserOutput)object;
            ListBuffer buffer = new ListBuffer();
            buffer.$plus$eq((Object)old);
            buffer.$plus$eq(output);
            this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$result_$eq(buffer);
            return;
        }
        throw new MatchError(object);
    }

    public static StateResult continue$(HttpMessageParser $this, ByteString input, int offset, Function2 next) {
        return $this.continue(input, offset, (Function2<ByteString, Object, StateResult>)next);
    }

    default public StateResult continue(ByteString input, int offset, Function2<ByteString, Object, StateResult> next) {
        Function1 & Serializable intersect;
        int n = scala.math.package$.MODULE$.signum(offset - input.length());
        switch (n) {
            case -1: {
                ByteString remaining = input.drop(offset);
                intersect = (Function1 & Serializable)more -> (StateResult)next.apply((Object)remaining.$plus$plus(more), (Object)BoxesRunTime.boxToInteger((int)0));
                break;
            }
            case 0: {
                intersect = (Function1 & Serializable)_$5 -> (StateResult)next.apply(_$5, (Object)BoxesRunTime.boxToInteger((int)0));
                break;
            }
            case 1: {
                throw new IllegalStateException();
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state_$eq((Function1<ByteString, StateResult>)intersect);
        return this.done();
    }

    public static StateResult continue$(HttpMessageParser $this, Function2 next) {
        return $this.continue((Function2<ByteString, Object, StateResult>)next);
    }

    default public StateResult continue(Function2<ByteString, Object, StateResult> next) {
        this.org$apache$pekko$http$impl$engine$parsing$HttpMessageParser$$state_$eq((Function1<ByteString, StateResult>)(Function1 & Serializable)_$6 -> (StateResult)next.apply(_$6, (Object)BoxesRunTime.boxToInteger((int)0)));
        return this.done();
    }

    public static StateResult failMessageStart$(HttpMessageParser $this, String summary) {
        return $this.failMessageStart(summary);
    }

    default public StateResult failMessageStart(String summary) {
        return this.failMessageStart(summary, "");
    }

    public static StateResult failMessageStart$(HttpMessageParser $this, String summary, String detail) {
        return $this.failMessageStart(summary, detail);
    }

    default public StateResult failMessageStart(String summary, String detail) {
        return this.failMessageStart(StatusCodes$.MODULE$.BadRequest(), summary, detail);
    }

    public static StateResult failMessageStart$(HttpMessageParser $this, StatusCode status) {
        return $this.failMessageStart(status);
    }

    default public StateResult failMessageStart(StatusCode status) {
        return this.failMessageStart(status, status.defaultMessage(), this.failMessageStart$default$3());
    }

    public static StateResult failMessageStart$(HttpMessageParser $this, StatusCode status, String summary, String detail) {
        return $this.failMessageStart(status, summary, detail);
    }

    default public StateResult failMessageStart(StatusCode status, String summary, String detail) {
        return this.failMessageStart(status, ErrorInfo$.MODULE$.apply(summary, detail));
    }

    public static String failMessageStart$default$3$(HttpMessageParser $this) {
        return $this.failMessageStart$default$3();
    }

    default public String failMessageStart$default$3() {
        return "";
    }

    public static StateResult failMessageStart$(HttpMessageParser $this, StatusCode status, ErrorInfo info) {
        return $this.failMessageStart(status, info);
    }

    default public StateResult failMessageStart(StatusCode status, ErrorInfo info) {
        this.emit(ParserOutput$MessageStartError$.MODULE$.apply(status, info));
        this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
        return this.terminate();
    }

    public static StateResult failEntityStream$(HttpMessageParser $this, String summary) {
        return $this.failEntityStream(summary);
    }

    default public StateResult failEntityStream(String summary) {
        return this.failEntityStream(summary, "");
    }

    public static StateResult failEntityStream$(HttpMessageParser $this, String summary, String detail) {
        return $this.failEntityStream(summary, detail);
    }

    default public StateResult failEntityStream(String summary, String detail) {
        return this.failEntityStream(ErrorInfo$.MODULE$.apply(summary, detail));
    }

    public static StateResult failEntityStream$(HttpMessageParser $this, ErrorInfo info) {
        return $this.failEntityStream(info);
    }

    default public StateResult failEntityStream(ErrorInfo info) {
        this.emit(ParserOutput$EntityStreamError$.MODULE$.apply(info));
        this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
        return this.terminate();
    }

    public static StateResult terminate$(HttpMessageParser $this) {
        return $this.terminate();
    }

    default public StateResult terminate() {
        this.terminated_$eq(true);
        return this.done();
    }

    private StateResult done() {
        return null;
    }

    public static ContentType contentType$(HttpMessageParser $this, Option cth) {
        return $this.contentType((Option<Content$minusType>)cth);
    }

    default public ContentType contentType(Option<Content$minusType> cth) {
        Option<Content$minusType> option = cth;
        if (option instanceof Some) {
            Content$minusType x = (Content$minusType)((Some)option).value();
            return x.contentType();
        }
        if (None$.MODULE$.equals(option)) {
            return ContentTypes$.MODULE$.application$divoctet$minusstream();
        }
        throw new MatchError(option);
    }

    public static ParserOutput.StrictEntityCreator emptyEntity$(HttpMessageParser $this, Option cth) {
        return $this.emptyEntity((Option<Content$minusType>)cth);
    }

    default public ParserOutput.StrictEntityCreator<Output, UniversalEntity> emptyEntity(Option<Content$minusType> cth) {
        return ParserOutput$StrictEntityCreator$.MODULE$.apply(cth.isDefined() ? HttpEntity$.MODULE$.empty(((Content$minusType)cth.get()).contentType()) : HttpEntity$.MODULE$.Empty());
    }

    public static ParserOutput.StrictEntityCreator strictEntity$(HttpMessageParser $this, Option cth, ByteString input, int bodyStart, int contentLength) {
        return $this.strictEntity((Option<Content$minusType>)cth, input, bodyStart, contentLength);
    }

    default public ParserOutput.StrictEntityCreator<Output, UniversalEntity> strictEntity(Option<Content$minusType> cth, ByteString input, int bodyStart, int contentLength) {
        return ParserOutput$StrictEntityCreator$.MODULE$.apply(HttpEntity$Strict$.MODULE$.apply(this.contentType(cth), input.slice(bodyStart, bodyStart + contentLength)));
    }

    public static ParserOutput.StreamedEntityCreator defaultEntity$(HttpMessageParser $this, Option cth, long contentLength) {
        return $this.defaultEntity((Option<Content$minusType>)cth, contentLength);
    }

    default public <A extends ParserOutput> ParserOutput.StreamedEntityCreator<A, UniversalEntity> defaultEntity(Option<Content$minusType> cth, long contentLength) {
        return ParserOutput$StreamedEntityCreator$.MODULE$.apply((Function1 & Serializable)entityParts -> {
            Source data = (Source)entityParts.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(ParserOutput x) {
                    ParserOutput parserOutput = x;
                    if (parserOutput instanceof ParserOutput.EntityPart) {
                        ByteString byteString;
                        ParserOutput.EntityPart entityPart = ParserOutput$EntityPart$.MODULE$.unapply((ParserOutput.EntityPart)parserOutput);
                        ByteString bytes = byteString = entityPart._1();
                        return true;
                    }
                    if (parserOutput instanceof ParserOutput.EntityStreamError) {
                        ErrorInfo errorInfo;
                        ParserOutput.EntityStreamError entityStreamError = ParserOutput$EntityStreamError$.MODULE$.unapply((ParserOutput.EntityStreamError)parserOutput);
                        ErrorInfo info = errorInfo = entityStreamError._1();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(ParserOutput x, Function1 function1) {
                    ParserOutput parserOutput = x;
                    if (parserOutput instanceof ParserOutput.EntityPart) {
                        ByteString byteString;
                        ParserOutput.EntityPart entityPart = ParserOutput$EntityPart$.MODULE$.unapply((ParserOutput.EntityPart)parserOutput);
                        ByteString bytes = byteString = entityPart._1();
                        return bytes;
                    }
                    if (parserOutput instanceof ParserOutput.EntityStreamError) {
                        ErrorInfo errorInfo;
                        ParserOutput.EntityStreamError entityStreamError = ParserOutput$EntityStreamError$.MODULE$.unapply((ParserOutput.EntityStreamError)parserOutput);
                        ErrorInfo info = errorInfo = entityStreamError._1();
                        throw EntityStreamException$.MODULE$.apply(info);
                    }
                    return function1.apply((Object)x);
                }
            });
            return HttpEntity$Default$.MODULE$.apply(this.contentType(cth), contentLength, (Source<ByteString, Object>)data);
        });
    }

    public static ParserOutput.StreamedEntityCreator chunkedEntity$(HttpMessageParser $this, Option cth) {
        return $this.chunkedEntity((Option<Content$minusType>)cth);
    }

    default public <A extends ParserOutput> ParserOutput.StreamedEntityCreator<A, RequestEntity> chunkedEntity(Option<Content$minusType> cth) {
        return ParserOutput$StreamedEntityCreator$.MODULE$.apply((Function1 & Serializable)entityChunks -> {
            Source chunks = (Source)entityChunks.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(ParserOutput x) {
                    ParserOutput parserOutput = x;
                    if (parserOutput instanceof ParserOutput.EntityChunk) {
                        HttpEntity.ChunkStreamPart chunkStreamPart;
                        ParserOutput.EntityChunk entityChunk = ParserOutput$EntityChunk$.MODULE$.unapply((ParserOutput.EntityChunk)parserOutput);
                        HttpEntity.ChunkStreamPart chunk = chunkStreamPart = entityChunk._1();
                        return true;
                    }
                    if (parserOutput instanceof ParserOutput.EntityStreamError) {
                        ErrorInfo errorInfo;
                        ParserOutput.EntityStreamError entityStreamError = ParserOutput$EntityStreamError$.MODULE$.unapply((ParserOutput.EntityStreamError)parserOutput);
                        ErrorInfo info = errorInfo = entityStreamError._1();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(ParserOutput x, Function1 function1) {
                    ParserOutput parserOutput = x;
                    if (parserOutput instanceof ParserOutput.EntityChunk) {
                        HttpEntity.ChunkStreamPart chunkStreamPart;
                        ParserOutput.EntityChunk entityChunk = ParserOutput$EntityChunk$.MODULE$.unapply((ParserOutput.EntityChunk)parserOutput);
                        HttpEntity.ChunkStreamPart chunk = chunkStreamPart = entityChunk._1();
                        return chunk;
                    }
                    if (parserOutput instanceof ParserOutput.EntityStreamError) {
                        ErrorInfo errorInfo;
                        ParserOutput.EntityStreamError entityStreamError = ParserOutput$EntityStreamError$.MODULE$.unapply((ParserOutput.EntityStreamError)parserOutput);
                        ErrorInfo info = errorInfo = entityStreamError._1();
                        throw EntityStreamException$.MODULE$.apply(info);
                    }
                    return function1.apply((Object)x);
                }
            });
            return HttpEntity$Chunked$.MODULE$.apply(this.contentType(cth), (Source<HttpEntity.ChunkStreamPart, Object>)chunks);
        });
    }

    public static void setCompletionHandling$(HttpMessageParser $this, Function0 completionHandling) {
        $this.setCompletionHandling((Function0<Option<ParserOutput.ErrorOutput>>)completionHandling);
    }

    default public void setCompletionHandling(Function0<Option<ParserOutput.ErrorOutput>> completionHandling) {
        this.completionHandling_$eq(completionHandling);
    }

    private StateResult run$1(ByteString input$1, Function1 next) {
        StateResult stateResult;
        while (true) {
            Function1<ByteString, StateResult> function1;
            Function1<ByteString, StateResult> x;
            StateResult stateResult2;
            try {
                stateResult2 = (StateResult)next.apply((Object)input$1);
            }
            catch (ParsingException e) {
                stateResult2 = this.failMessageStart(e.status(), e.info());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (NotEnoughDataException$.MODULE$.equals(throwable2)) {
                    throw new IllegalStateException("unexpected NotEnoughDataException", NotEnoughDataException$.MODULE$);
                }
                if (throwable2 instanceof IllegalHeaderException) {
                    ErrorInfo errorInfo;
                    IllegalHeaderException illegalHeaderException = IllegalHeaderException$.MODULE$.unapply((IllegalHeaderException)throwable2);
                    ErrorInfo error = errorInfo = illegalHeaderException._1();
                    stateResult2 = this.failMessageStart(StatusCodes$.MODULE$.BadRequest(), error);
                }
                throw throwable;
            }
            stateResult = stateResult2;
            if (!(stateResult instanceof Trampoline)) break;
            Trampoline trampoline = HttpMessageParser$Trampoline$.MODULE$.unapply((Trampoline)stateResult);
            next = x = (function1 = trampoline._1());
        }
        StateResult x = stateResult;
        return x;
    }

    private /* synthetic */ StateResult startNewMessage$$anonfun$1(ByteString input, int offset) {
        return this.startNewMessage(input, offset);
    }

    private static char c$1(ByteString input$2, int cursor$2, int ix) {
        return package$.MODULE$.byteChar(input$2, cursor$2 + ix);
    }

    private /* synthetic */ StateResult parseHeaderLines$$anonfun$1(ListBuffer headers$tailLocal1$1, int headerCount$tailLocal1$1, Option ch$tailLocal1$1, Option clh$tailLocal1$1, Option cth$tailLocal1$1, boolean isChunked$tailLocal1$1, boolean e100c$tailLocal1$1, boolean hh$tailLocal1$1, ByteString input, int lineStart) {
        return this.parseHeaderLinesAux((ListBuffer<HttpHeader>)headers$tailLocal1$1, headerCount$tailLocal1$1, (Option<Connection>)ch$tailLocal1$1, (Option<Content$minusLength>)clh$tailLocal1$1, (Option<Content$minusType>)cth$tailLocal1$1, isChunked$tailLocal1$1, e100c$tailLocal1$1, hh$tailLocal1$1, input, lineStart);
    }

    private /* synthetic */ StateResult parseFixedLengthBody$$anonfun$1(long remainingBodyBytes$1$1, boolean isLastMessage$1, ByteString input, int bodyStart) {
        return this.parseFixedLengthBody(remainingBodyBytes$1$1, isLastMessage$1, input, bodyStart);
    }

    private /* synthetic */ StateResult parseFixedLengthBody$$anonfun$2(long remainingBodyBytes$2, boolean isLastMessage$2, ByteString input, int bodyStart) {
        return this.parseFixedLengthBody(remainingBodyBytes$2, isLastMessage$2, input, bodyStart);
    }

    private StateResult parseTrailer$1(ByteString input$3, boolean isLastMessage$3, String extension, int lineStart, List headers, int headerCount) {
        ErrorInfo errorInfo;
        block5: {
            while (true) {
                int lineEnd;
                int n;
                errorInfo = null;
                try {
                    HttpHeaderParser httpHeaderParser = this.headerParser();
                    n = httpHeaderParser.parseHeaderLine(input$3, lineStart, httpHeaderParser.parseHeaderLine$default$3(input$3, lineStart), httpHeaderParser.parseHeaderLine$default$4(input$3, lineStart));
                }
                catch (ParsingException e) {
                    errorInfo = e.info();
                    n = lineEnd = 0;
                }
                if (errorInfo != null) break block5;
                HttpHeader httpHeader = this.headerParser().resultHeader();
                if (EmptyHeader$.MODULE$.equals(httpHeader)) {
                    HttpEntity.LastChunk lastChunk = extension.isEmpty() && headers.isEmpty() ? HttpEntity$LastChunk$.MODULE$ : HttpEntity$LastChunk$.MODULE$.apply(extension, (Seq<HttpHeader>)headers);
                    this.emit(ParserOutput$EntityChunk$.MODULE$.apply(lastChunk));
                    this.emit(ParserOutput$MessageEnd$.MODULE$);
                    this.setCompletionHandling(HttpMessageParser$.MODULE$.CompletionOk());
                    if (isLastMessage$3) {
                        return this.terminate();
                    }
                    return this.startNewMessage(input$3, lineEnd);
                }
                HttpHeader header = httpHeader;
                if (headerCount >= this.settings().maxHeaderCount()) break;
                int n2 = lineEnd;
                List list = headers.$colon$colon((Object)header);
                int n3 = headerCount + 1;
                lineStart = n2;
                headers = list;
                headerCount = n3;
            }
            return this.failEntityStream(new StringBuilder(65).append("Chunk trailer contains more than the configured limit of ").append(this.settings().maxHeaderCount()).append(" headers").toString());
        }
        return this.failEntityStream(errorInfo);
    }

    private static List parseTrailer$default$3$1() {
        return scala.package$.MODULE$.Nil();
    }

    private static int parseTrailer$default$4$1() {
        return 0;
    }

    private Trampoline result$1(ByteString input$5, int cursor$3, int chunkBodyEnd$1, String extension$1, boolean isLastMessage$5, long totalBytesRead$2, int chunkSize$2, int terminatorLen) {
        this.emit(ParserOutput$EntityChunk$.MODULE$.apply(HttpEntity$Chunk$.MODULE$.apply((ByteString)input$5.slice(cursor$3, chunkBodyEnd$1).compact(), extension$1)));
        return HttpMessageParser$Trampoline$.MODULE$.apply((Function1<ByteString, StateResult>)(Function1 & Serializable)_$2 -> this.parseChunk(input$5, chunkBodyEnd$1 + terminatorLen, isLastMessage$5, totalBytesRead$2 + (long)chunkSize$2));
    }

    private StateResult parseChunkBody$1(ByteString input$4, boolean isLastMessage$4, long totalBytesRead$1, int chunkSize, String extension, int cursor) {
        if (chunkSize > 0) {
            int chunkBodyEnd = cursor + chunkSize;
            char c = package$.MODULE$.byteChar(input$4, chunkBodyEnd);
            if ('\r' == c && package$.MODULE$.byteChar(input$4, chunkBodyEnd + 1) == '\n') {
                return this.result$1(input$4, cursor, chunkBodyEnd, extension, isLastMessage$4, totalBytesRead$1, chunkSize, 2);
            }
            if ('\n' == c) {
                return this.result$1(input$4, cursor, chunkBodyEnd, extension, isLastMessage$4, totalBytesRead$1, chunkSize, 1);
            }
            char x = c;
            return this.failEntityStream("Illegal chunk termination");
        }
        return this.parseTrailer$1(input$4, isLastMessage$4, extension, cursor, HttpMessageParser.parseTrailer$default$3$1(), HttpMessageParser.parseTrailer$default$4$1());
    }

    private static String extension$2(ByteString input$8, int startIx$1, int cursor$tailLocal1$1) {
        return package$.MODULE$.asciiString(input$8, startIx$1, cursor$tailLocal1$1);
    }

    private StateResult parseChunkExtensions$1(ByteString input$7, boolean isLastMessage$7, long totalBytesRead$4, int chunkSize, int cursor, int startIx) {
        while (cursor - startIx <= this.settings().maxChunkExtLength()) {
            char c = package$.MODULE$.byteChar(input$7, cursor);
            if ('\r' == c && package$.MODULE$.byteChar(input$7, cursor + 1) == '\n') {
                return this.parseChunkBody$1(input$7, isLastMessage$7, totalBytesRead$4, chunkSize, HttpMessageParser.extension$2(input$7, startIx, cursor), cursor + 2);
            }
            if ('\n' == c) {
                return this.parseChunkBody$1(input$7, isLastMessage$7, totalBytesRead$4, chunkSize, HttpMessageParser.extension$2(input$7, startIx, cursor), cursor + 1);
            }
            ++cursor;
        }
        return this.failEntityStream(new StringBuilder(67).append("HTTP chunk extension length exceeds configured limit of ").append(this.settings().maxChunkExtLength()).append(" characters").toString());
    }

    private static int parseChunkExtensions$default$3$1(int chunkSize, int cursor) {
        return cursor;
    }

    private StateResult parseSize$1(ByteString input$9, int offset$1, boolean isLastMessage$8, long totalBytesRead$5, int cursor, long size) {
        while (size <= Integer.MAX_VALUE) {
            char c;
            char c2 = c = package$.MODULE$.byteChar(input$9, cursor);
            if (CharacterClasses$.MODULE$.HEXDIG().apply(c2)) {
                int n = cursor + 1;
                long l = size * 16L + (long)CharUtils$.MODULE$.hexValue(c2);
                cursor = n;
                size = l;
                continue;
            }
            char c3 = c;
            if (size > (long)this.settings().maxChunkSize()) {
                return this.failEntityStream(new StringBuilder(59).append("HTTP chunk of ").append(size).append(" bytes exceeds the configured limit of ").append(this.settings().maxChunkSize()).append(" bytes").toString());
            }
            if (';' == c && cursor > offset$1) {
                int n = (int)size;
                int n2 = cursor + 1;
                return this.parseChunkExtensions$1(input$9, isLastMessage$8, totalBytesRead$5, n, n2, HttpMessageParser.parseChunkExtensions$default$3$1(n, n2));
            }
            if ('\r' == c && cursor > offset$1 && package$.MODULE$.byteChar(input$9, cursor + 1) == '\n') {
                return this.parseChunkBody$1(input$9, isLastMessage$8, totalBytesRead$5, (int)size, "", cursor + 2);
            }
            if ('\n' == c && cursor > offset$1) {
                return this.parseChunkBody$1(input$9, isLastMessage$8, totalBytesRead$5, (int)size, "", cursor + 1);
            }
            char c4 = c;
            if (CharacterClasses$.MODULE$.WSP().apply(c4)) {
                ++cursor;
                continue;
            }
            char c5 = c;
            return this.failEntityStream(new StringBuilder(35).append("Illegal character '").append(package$.MODULE$.escape(c5)).append("' in chunk start").toString());
        }
        return this.failEntityStream(new StringBuilder(70).append("HTTP chunk size exceeds Integer.MAX_VALUE (").append(Integer.MAX_VALUE).append(") bytes").toString());
    }

    private /* synthetic */ StateResult parseChunk$$anonfun$1(boolean isLastMessage$9, long totalBytesRead$6, ByteString _$3, int _$4) {
        return this.parseChunk(_$3, _$4, isLastMessage$9, totalBytesRead$6);
    }

    public static interface StateResult {
    }

    public static final class Trampoline
    implements StateResult,
    Product,
    Serializable {
        private final Function1 f;

        public static Trampoline apply(Function1<ByteString, StateResult> function1) {
            return HttpMessageParser$Trampoline$.MODULE$.apply(function1);
        }

        public static Trampoline fromProduct(Product product) {
            return HttpMessageParser$Trampoline$.MODULE$.fromProduct(product);
        }

        public static Trampoline unapply(Trampoline trampoline) {
            return HttpMessageParser$Trampoline$.MODULE$.unapply(trampoline);
        }

        public Trampoline(Function1<ByteString, StateResult> f) {
            this.f = f;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Trampoline)) return false;
            Trampoline trampoline = (Trampoline)object;
            Function1<ByteString, StateResult> function1 = this.f();
            Function1<ByteString, StateResult> function12 = trampoline.f();
            if (function1 != null) {
                if (!function1.equals(function12)) return false;
                return true;
            }
            if (function12 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Trampoline;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Trampoline";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "f";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<ByteString, StateResult> f() {
            return this.f;
        }

        public Trampoline copy(Function1<ByteString, StateResult> f) {
            return new Trampoline(f);
        }

        public Function1<ByteString, StateResult> copy$default$1() {
            return this.f();
        }

        public Function1<ByteString, StateResult> _1() {
            return this.f();
        }
    }
}

