/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.model.parser;

import java.nio.charset.Charset;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.model.parser.CharacterClasses$;
import org.apache.pekko.http.impl.model.parser.IpAddressParsing;
import org.apache.pekko.http.impl.model.parser.UriParser$;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.StringRendering;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.Uri$Authority$;
import org.apache.pekko.http.scaladsl.model.Uri$Host$Empty$;
import org.apache.pekko.http.scaladsl.model.Uri$IPv4Host$;
import org.apache.pekko.http.scaladsl.model.Uri$IPv6Host$;
import org.apache.pekko.http.scaladsl.model.Uri$NamedHost$;
import org.apache.pekko.http.scaladsl.model.Uri$ParsingMode$Relaxed$;
import org.apache.pekko.http.scaladsl.model.Uri$ParsingMode$Strict$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$;
import org.apache.pekko.http.scaladsl.model.Uri$Path$Empty$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$Cons$;
import org.apache.pekko.http.scaladsl.model.Uri$Query$Empty$;
import org.apache.pekko.http.scaladsl.model.UriRendering$;
import org.apache.pekko.http.scaladsl.model.headers.Host$;
import org.apache.pekko.http.scaladsl.model.headers.HttpOrigin;
import org.apache.pekko.http.scaladsl.model.headers.HttpOrigin$;
import org.parboiled2.CharPredicate;
import org.parboiled2.CharUtils$;
import org.parboiled2.ErrorFormatter;
import org.parboiled2.ErrorFormatter$;
import org.parboiled2.ParseError;
import org.parboiled2.Parser;
import org.parboiled2.Parser$;
import org.parboiled2.ParserInput;
import org.parboiled2.Rule;
import org.parboiled2.Rule$;
import org.parboiled2.RuleTrace;
import org.parboiled2.StringBuilding;
import org.parboiled2.support.Unpack;
import org.parboiled2.support.Unpack$;
import org.parboiled2.support.hlist.;
import org.parboiled2.support.hlist.HNil;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@InternalApi
public final class UriParser
extends Parser
implements IpAddressParsing,
StringBuilding {
    private StringBuilder sb;
    private ParserInput _input;
    private final Charset uriParsingCharset;
    private final Uri.ParsingMode uriParsingMode;
    private final int maxValueStackSize;
    private final CharPredicate path$minussegment$minuschar;
    private final CharPredicate query$minuschar;
    private final CharPredicate query$minuskey$minuschar;
    private final CharPredicate query$minusvalue$minuschar;
    private final CharPredicate fragment$minuschar;
    private String _scheme;
    private String _userinfo;
    private Uri.Host _host;
    private int _port;
    private Uri.Path _path;
    private Option<String> _rawQueryString;
    private Option<String> _fragment;
    private int _firstPercentIx;

    public static Charset $lessinit$greater$default$2() {
        return UriParser$.MODULE$.$lessinit$greater$default$2();
    }

    public static Uri.ParsingMode $lessinit$greater$default$3() {
        return UriParser$.MODULE$.$lessinit$greater$default$3();
    }

    public UriParser(ParserInput _input, Charset uriParsingCharset, Uri.ParsingMode uriParsingMode, int maxValueStackSize) {
        CharPredicate charPredicate;
        CharPredicate charPredicate2;
        this._input = _input;
        this.uriParsingCharset = uriParsingCharset;
        this.uriParsingMode = uriParsingMode;
        this.maxValueStackSize = maxValueStackSize;
        super(Parser$.MODULE$.$lessinit$greater$default$1(), maxValueStackSize);
        StringBuilding.$init$((StringBuilding)this);
        Uri.ParsingMode parsingMode = uriParsingMode;
        this.path$minussegment$minuschar = Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode) ? CharacterClasses$.MODULE$.pchar$minusbase() : CharacterClasses$.MODULE$.relaxed$minuspath$minussegment$minuschar();
        Uri.ParsingMode parsingMode2 = uriParsingMode;
        this.query$minuschar = Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode2) ? CharacterClasses$.MODULE$.query$minusfragment$minuschar() : CharacterClasses$.MODULE$.relaxed$minusquery$minuschar();
        Uri.ParsingMode parsingMode3 = uriParsingMode;
        if (Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode3)) {
            charPredicate2 = CharacterClasses$.MODULE$.strict$minusquery$minuskey$minuschar();
        } else if (Uri$ParsingMode$Relaxed$.MODULE$.equals(parsingMode3)) {
            charPredicate2 = CharacterClasses$.MODULE$.relaxed$minusquery$minuskey$minuschar();
        } else {
            throw new MatchError((Object)parsingMode3);
        }
        this.query$minuskey$minuschar = charPredicate2;
        Uri.ParsingMode parsingMode4 = uriParsingMode;
        if (Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode4)) {
            charPredicate = CharacterClasses$.MODULE$.strict$minusquery$minusvalue$minuschar();
        } else if (Uri$ParsingMode$Relaxed$.MODULE$.equals(parsingMode4)) {
            charPredicate = CharacterClasses$.MODULE$.relaxed$minusquery$minusvalue$minuschar();
        } else {
            throw new MatchError((Object)parsingMode4);
        }
        this.query$minusvalue$minuschar = charPredicate;
        Uri.ParsingMode parsingMode5 = uriParsingMode;
        this.fragment$minuschar = Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode5) ? CharacterClasses$.MODULE$.query$minusfragment$minuschar() : CharacterClasses$.MODULE$.relaxed$minusfragment$minuschar();
        this._scheme = "";
        this._userinfo = "";
        this._host = Uri$Host$Empty$.MODULE$;
        this._port = 0;
        this._path = Uri$Path$Empty$.MODULE$;
        this._rawQueryString = None$.MODULE$;
        this._fragment = None$.MODULE$;
        this._firstPercentIx = -1;
        Statics.releaseFence();
    }

    public StringBuilder sb() {
        return this.sb;
    }

    public void org$parboiled2$StringBuilding$_setter_$sb_$eq(StringBuilder x$0) {
        this.sb = x$0;
    }

    public Charset uriParsingCharset() {
        return this.uriParsingCharset;
    }

    public Uri.ParsingMode uriParsingMode() {
        return this.uriParsingMode;
    }

    public int maxValueStackSize() {
        return this.maxValueStackSize;
    }

    public ParserInput input() {
        return this._input;
    }

    public UriParser(ParserInput input, Charset uriParsingCharset, Uri.ParsingMode uriParsingMode) {
        this(input, uriParsingCharset, uriParsingMode, 1024);
    }

    public Uri parseAbsoluteUri() {
        Parser.DeliveryScheme scheme$proxy1 = Parser.DeliveryScheme$.MODULE$.Either((Unpack.Aux)Unpack.HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseAbsoluteUri$$anonfun$1, scheme$proxy1);
        if (either instanceof Right) {
            return Uri$.MODULE$.createUnsafe(this._scheme, Uri$Authority$.MODULE$.apply(this._host, this._port, this._userinfo), Uri$.MODULE$.collapseDotSegments(this._path), this._rawQueryString, this._fragment);
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "absolute URI");
        }
        throw new MatchError((Object)either);
    }

    public Uri parseUriReference() {
        Parser.DeliveryScheme scheme$proxy2 = Parser.DeliveryScheme$.MODULE$.Either((Unpack.Aux)Unpack.HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseUriReference$$anonfun$1, scheme$proxy2);
        if (either instanceof Right) {
            return this.createUriReference();
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "URI reference");
        }
        throw new MatchError((Object)either);
    }

    public Uri parseAndResolveUriReference(Uri base) {
        Parser.DeliveryScheme scheme$proxy3 = Parser.DeliveryScheme$.MODULE$.Either((Unpack.Aux)Unpack.HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseAndResolveUriReference$$anonfun$1, scheme$proxy3);
        if (either instanceof Right) {
            return Uri$.MODULE$.resolveUnsafe(this._scheme, this._userinfo, this._host, this._port, this._path, this._rawQueryString, this._fragment, base);
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "URI reference");
        }
        throw new MatchError((Object)either);
    }

    public HttpOrigin parseOrigin() {
        Parser.DeliveryScheme scheme$proxy4 = Parser.DeliveryScheme$.MODULE$.Either((Unpack.Aux)Unpack.HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseOrigin$$anonfun$1, scheme$proxy4);
        if (either instanceof Right) {
            return HttpOrigin$.MODULE$.apply(this._scheme, Host$.MODULE$.apply(this._host.address(), this._port));
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "origin");
        }
        throw new MatchError((Object)either);
    }

    public Uri.Host parseHost() {
        Parser.DeliveryScheme scheme$proxy5 = Parser.DeliveryScheme$.MODULE$.Either((Unpack.Aux)Unpack.HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseHost$$anonfun$1, scheme$proxy5);
        if (either instanceof Right) {
            return this._host;
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "URI host");
        }
        throw new MatchError((Object)either);
    }

    public String parseRawQueryString() {
        Parser.DeliveryScheme scheme$proxy6 = Parser.DeliveryScheme$.MODULE$.Either((Unpack.Aux)Unpack.HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseRawQueryString$$anonfun$1, scheme$proxy6);
        if (either instanceof Right) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = ((Right)either).value();
            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                return this.parseSafeRawQueryString(this.sb().toString());
            }
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "rawQueryString");
        }
        throw new MatchError((Object)either);
    }

    public String parseSafeRawQueryString(String rawQueryString) {
        Uri.ParsingMode parsingMode = this.uriParsingMode();
        if (Uri$ParsingMode$Strict$.MODULE$.equals(parsingMode)) {
            return rawQueryString;
        }
        if (Uri$ParsingMode$Relaxed$.MODULE$.equals(parsingMode)) {
            return ((StringRendering)UriRendering$.MODULE$.encode(new StringRendering(), rawQueryString, this.uriParsingCharset(), CharacterClasses$.MODULE$.query$minusfragment$minuschar().$plus$plus('%'), false)).get();
        }
        throw new MatchError((Object)parsingMode);
    }

    public Uri.Query parseQuery() {
        Parser.DeliveryScheme scheme$proxy7 = Parser.DeliveryScheme$.MODULE$.Either(Unpack$.MODULE$.single());
        Either either = (Either)this.__run(this::parseQuery$$anonfun$1, scheme$proxy7);
        if (either instanceof Right) {
            Uri.Query query = (Uri.Query)((Right)either).value();
            return query;
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "query");
        }
        throw new MatchError((Object)either);
    }

    public Uri.Authority parseAuthority() {
        Parser.DeliveryScheme scheme$proxy8 = Parser.DeliveryScheme$.MODULE$.Either((Unpack.Aux)Unpack.HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseAuthority$$anonfun$1, scheme$proxy8);
        if (either instanceof Right) {
            return Uri$Authority$.MODULE$.apply(this._host, this._port, this._userinfo);
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "authority");
        }
        throw new MatchError((Object)either);
    }

    public Nothing$ fail(ParseError error, String target) {
        ErrorFormatter formatter = new ErrorFormatter(ErrorFormatter$.MODULE$.$lessinit$greater$default$1(), ErrorFormatter$.MODULE$.$lessinit$greater$default$2(), false, ErrorFormatter$.MODULE$.$lessinit$greater$default$4(), ErrorFormatter$.MODULE$.$lessinit$greater$default$5(), ErrorFormatter$.MODULE$.$lessinit$greater$default$6(), ErrorFormatter$.MODULE$.$lessinit$greater$default$7());
        return Uri$.MODULE$.fail(new StringBuilder(10).append("Illegal ").append(target).append(": ").append(formatter.format(error, this.input())).toString(), formatter.formatErrorLine(error, this.input()));
    }

    public void reset(ParserInput newInput) {
        this._input = newInput;
        this._scheme = "";
        this._userinfo = "";
        this._host = Uri$Host$Empty$.MODULE$;
        this._port = 0;
        this._path = Uri$Path$Empty$.MODULE$;
        this._rawQueryString = None$.MODULE$;
        this._fragment = None$.MODULE$;
        this._firstPercentIx = -1;
    }

    private void setScheme(String scheme) {
        this._scheme = scheme;
    }

    private void setUserInfo(String userinfo) {
        this._userinfo = userinfo;
    }

    private void setHost(Uri.Host host) {
        this._host = host;
    }

    private void setPort(int port) {
        this._port = port;
    }

    private void setPath(Uri.Path path) {
        this._path = path;
    }

    private void setRawQueryString(String rawQueryString) {
        this._rawQueryString = Some$.MODULE$.apply((Object)this.parseSafeRawQueryString(rawQueryString));
    }

    private void setFragment(String fragment) {
        this._fragment = Some$.MODULE$.apply((Object)fragment);
    }

    public Rule<HNil, HNil> URI() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$9(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean ll3;
            boolean ll4;
            boolean bl3 = ll4 = this.scheme() != null;
            boolean bl4 = ll4 ? ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance() : (ll3 = false);
            boolean bl5 = ll3 ? this.hier$minuspart() != null : (ll2 = false);
            if (ll2) {
                boolean matched2;
                boolean ll5;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl6 = ll5 = ParserMacroMethods_this.cursorChar() == '?' && ParserMacroMethods_this.__advance();
                boolean bl7 = ll5 ? this.rawQueryString() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                boolean matched3;
                boolean ll6;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl8 = ll6 = ParserMacroMethods_this.cursorChar() == '#' && ParserMacroMethods_this.__advance();
                boolean bl9 = ll6 ? this.fragment() != null : (matched3 = false);
                if (!matched3) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> origin() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$10(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean ll4;
            boolean bl2 = ll4 = this.scheme() != null;
            boolean bl3 = ll4 ? ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance() : (ll3 = false);
            boolean bl4 = ll3 ? ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl5 = ll2 ? ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance() : (ll = false);
            bl = ll ? this.hostAndPort() != null : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> hier$minuspart() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$11(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean l2;
            boolean bl3;
            boolean l3;
            boolean ll;
            boolean ll2;
            boolean ll3;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll3 = ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance();
            boolean bl5 = ll3 ? ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl6 = ll2 ? this.authority() != null : (ll = false);
            boolean bl7 = ll ? this.path$minusabempty() != null : (l3 = false);
            if (!l3) {
                ParserMacroMethods_this.__restoreState(mark);
                bl3 = this.path$minusabsolute() != null;
            } else {
                bl3 = l2 = true;
            }
            if (!l2) {
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = this.path$minusrootless() != null;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.path$minusempty() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> URI$minusreference() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$12(ParserMacroMethods_this);
        } else {
            boolean l;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl2 = l = this.URI() != null;
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.relative$minusref() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, .colon.colon<Uri, HNil>> URI$minusreference$minuspushed() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$13(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.URI$minusreference() != null;
            if (ll) {
                ParserMacroMethods_this.valueStack().push((Object)this.createUriReference());
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> absolute$minusURI() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$14(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean bl2 = ll3 = this.scheme() != null;
            boolean bl3 = ll3 ? ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl4 = ll2 ? this.hier$minuspart() != null : (ll = false);
            if (ll) {
                boolean matched2;
                boolean ll4;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl5 = ll4 = ParserMacroMethods_this.cursorChar() == '?' && ParserMacroMethods_this.__advance();
                boolean bl6 = ll4 ? this.rawQueryString() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> relative$minusref() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$15(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3 = ll2 = this.relative$minuspart() != null;
            if (ll2) {
                boolean matched2;
                boolean ll3;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl4 = ll3 = ParserMacroMethods_this.cursorChar() == '?' && ParserMacroMethods_this.__advance();
                boolean bl5 = ll3 ? this.rawQueryString() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                boolean matched3;
                boolean ll4;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl6 = ll4 = ParserMacroMethods_this.cursorChar() == '#' && ParserMacroMethods_this.__advance();
                boolean bl7 = ll4 ? this.fragment() != null : (matched3 = false);
                if (!matched3) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> relative$minuspart() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$16(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean l2;
            boolean bl3;
            boolean l3;
            boolean ll;
            boolean ll2;
            boolean ll3;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll3 = ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance();
            boolean bl5 = ll3 ? ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl6 = ll2 ? this.authority() != null : (ll = false);
            boolean bl7 = ll ? this.path$minusabempty() != null : (l3 = false);
            if (!l3) {
                ParserMacroMethods_this.__restoreState(mark);
                bl3 = this.path$minusabsolute() != null;
            } else {
                bl3 = l2 = true;
            }
            if (!l2) {
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = this.path$minusnoscheme() != null;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.path$minusempty() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> scheme() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$17(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean ll4;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl3 = ll4 = ParserMacroMethods_this.cursorChar() == 'h' && ParserMacroMethods_this.__advance();
            boolean bl4 = ll4 ? ParserMacroMethods_this.cursorChar() == 't' && ParserMacroMethods_this.__advance() : (ll3 = false);
            boolean bl5 = ll3 ? ParserMacroMethods_this.cursorChar() == 't' && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl6 = ll2 ? ParserMacroMethods_this.cursorChar() == 'p' && ParserMacroMethods_this.__advance() : (ll = false);
            if (ll) {
                boolean l2;
                boolean bl7;
                long mark2 = ParserMacroMethods_this.__saveState();
                long mark3 = ParserMacroMethods_this.__saveState();
                boolean matched2 = ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance();
                ParserMacroMethods_this.__restoreState(mark3);
                boolean ll5 = matched2;
                if (ll5) {
                    this.setScheme("http");
                    bl7 = true;
                } else {
                    bl7 = l2 = false;
                }
                if (!l2) {
                    boolean ll6;
                    boolean bl8;
                    boolean ll7;
                    ParserMacroMethods_this.__restoreState(mark2);
                    boolean bl9 = ll7 = ParserMacroMethods_this.cursorChar() == 's' && ParserMacroMethods_this.__advance();
                    if (ll7) {
                        long mark4 = ParserMacroMethods_this.__saveState();
                        boolean matched3 = ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance();
                        ParserMacroMethods_this.__restoreState(mark4);
                        bl8 = matched3;
                    } else {
                        bl8 = ll6 = false;
                    }
                    if (ll6) {
                        this.setScheme("https");
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = l = false;
            }
            if (!l) {
                boolean ll8;
                boolean bl10;
                boolean ll9;
                boolean bl11;
                boolean ll10;
                boolean ll11;
                boolean ll12;
                ParserMacroMethods_this.__restoreState(mark);
                boolean bl12 = ll12 = this.clearSB() != null;
                boolean bl13 = ll12 ? CharacterClasses$.MODULE$.ALPHA().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance() : (ll11 = false);
                boolean bl14 = ll11 ? this.appendLowered() != null : (ll10 = false);
                if (ll10) {
                    ParserMacroMethods_this.__restoreState(this.rec$2(ParserMacroMethods_this, ParserMacroMethods_this.__saveState()));
                    bl11 = true;
                } else {
                    bl11 = ll9 = false;
                }
                if (ll9) {
                    long mark5 = ParserMacroMethods_this.__saveState();
                    boolean matched4 = ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance();
                    ParserMacroMethods_this.__restoreState(mark5);
                    bl10 = matched4;
                } else {
                    bl10 = ll8 = false;
                }
                if (ll8) {
                    this.setScheme(this.sb().toString());
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rule<HNil, .colon.colon<String, HNil>> scheme$minuspushed() {
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$18(ParserMacroMethods_this);
        } else {
            long firstMark = ParserMacroMethods_this.__saveState();
            long mark = this.rec$4(ParserMacroMethods_this, firstMark);
            if (mark == firstMark) return null;
            ParserMacroMethods_this.__restoreState(mark);
            if (!true) return null;
            boolean bl2 = true;
            boolean ll = bl2;
            if (!ll) return null;
            this.setScheme(this.sb().toString());
            boolean bl3 = true;
            boolean ll2 = bl3;
            if (!ll2) return null;
            ParserMacroMethods_this.valueStack().push((Object)this._scheme);
            bl = true;
        }
        boolean matched = bl;
        if (!matched) return null;
        return (Rule)Rule$.MODULE$;
    }

    public Rule<HNil, HNil> authority() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$19(ParserMacroMethods_this);
        } else {
            boolean matched2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl2 = matched2 = this.userinfo() != null;
            if (!matched2) {
                ParserMacroMethods_this.__restoreState(mark);
            }
            boolean ll = true;
            bl = ll ? this.hostAndPort() != null : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> userinfo() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$20(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean bl2;
            boolean ll3;
            boolean bl3 = ll3 = this.clearSBForDecoding() != null;
            if (ll3) {
                ParserMacroMethods_this.__restoreState(this.rec$6(ParserMacroMethods_this, ParserMacroMethods_this.__saveState()));
                bl2 = true;
            } else {
                bl2 = ll2 = false;
            }
            boolean bl4 = ll2 ? ParserMacroMethods_this.cursorChar() == '@' && ParserMacroMethods_this.__advance() : (ll = false);
            if (ll) {
                this.setUserInfo(this.getDecodedString(this.getDecodedString$default$1()));
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> hostAndPort() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$21(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.host() != null;
            if (ll) {
                boolean matched2;
                boolean ll2;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl3 = ll2 = ParserMacroMethods_this.cursorChar() == ':' && ParserMacroMethods_this.__advance();
                boolean bl4 = ll2 ? this.port() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, .colon.colon<Uri.Host, .colon.colon<Object, HNil>>> hostAndPort$minuspushed() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$22(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3 = ll2 = this.hostAndPort() != null;
            if (ll2) {
                ParserMacroMethods_this.valueStack().push((Object)this._host);
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                ParserMacroMethods_this.valueStack().push((Object)BoxesRunTime.boxToInteger((int)this._port));
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> host() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$23(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean l2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl3 = l2 = this.IP$minusliteral() != null;
            if (!l2) {
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = this.ipv4Host() != null;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.reg$minusname() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> relaxedHost() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$24(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean l2;
            boolean bl3;
            boolean l3;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = l3 = this.IP$minusliteral() != null;
            if (!l3) {
                ParserMacroMethods_this.__restoreState(mark);
                bl3 = this.ipv6Host() != null;
            } else {
                bl3 = l2 = true;
            }
            if (!l2) {
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = this.ipv4Host() != null;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.reg$minusname() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> port() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$25(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3 = ll2 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
            if (ll2) {
                this.setPort(this.lastChar() - 48);
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                boolean matched2;
                boolean bl4;
                boolean ll3;
                boolean bl5;
                boolean ll4;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl6 = ll4 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
                if (ll4) {
                    this.setPort(10 * this._port + this.lastChar() - 48);
                    bl5 = true;
                } else {
                    bl5 = ll3 = false;
                }
                if (ll3) {
                    boolean matched3;
                    boolean bl7;
                    boolean ll5;
                    boolean bl8;
                    boolean ll6;
                    long mark2 = ParserMacroMethods_this.__saveState();
                    boolean bl9 = ll6 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
                    if (ll6) {
                        this.setPort(10 * this._port + this.lastChar() - 48);
                        bl8 = true;
                    } else {
                        bl8 = ll5 = false;
                    }
                    if (ll5) {
                        boolean matched4;
                        boolean bl10;
                        boolean ll7;
                        boolean bl11;
                        boolean ll8;
                        long mark3 = ParserMacroMethods_this.__saveState();
                        boolean bl12 = ll8 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
                        if (ll8) {
                            this.setPort(10 * this._port + this.lastChar() - 48);
                            bl11 = true;
                        } else {
                            bl11 = ll7 = false;
                        }
                        if (ll7) {
                            boolean matched5;
                            boolean bl13;
                            boolean ll9;
                            long mark4 = ParserMacroMethods_this.__saveState();
                            boolean bl14 = ll9 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
                            if (ll9) {
                                this.setPort(10 * this._port + this.lastChar() - 48);
                                bl13 = true;
                            } else {
                                bl13 = matched5 = false;
                            }
                            if (!matched5) {
                                ParserMacroMethods_this.__restoreState(mark4);
                            }
                            bl10 = true;
                        } else {
                            bl10 = matched4 = false;
                        }
                        if (!matched4) {
                            ParserMacroMethods_this.__restoreState(mark3);
                        }
                        bl7 = true;
                    } else {
                        bl7 = matched3 = false;
                    }
                    if (!matched3) {
                        ParserMacroMethods_this.__restoreState(mark2);
                    }
                    bl4 = true;
                } else {
                    bl4 = matched2 = false;
                }
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> IP$minusliteral() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$26(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean bl2 = ll2 = ParserMacroMethods_this.cursorChar() == '[' && ParserMacroMethods_this.__advance();
            boolean bl3 = ll2 ? this.ipv6Host() != null : (ll = false);
            bl = ll ? ParserMacroMethods_this.cursorChar() == ']' && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> ipv4Host() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$27(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3;
            boolean matched2;
            int start1 = ParserMacroMethods_this.cursor();
            boolean bl4 = matched2 = this.ip$minusv4$minusaddress() != null;
            if (matched2) {
                ParserMacroMethods_this.valueStack().push((Object)ParserMacroMethods_this.input().sliceString(start1, ParserMacroMethods_this.cursor()));
                bl3 = true;
            } else {
                bl3 = ll2 = false;
            }
            if (ll2) {
                long mark = ParserMacroMethods_this.__saveState();
                boolean matched3 = CharacterClasses$.MODULE$.colonSlashEOI().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = matched3;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                String a = (String)ParserMacroMethods_this.valueStack().pop();
                byte[] b = (byte[])ParserMacroMethods_this.valueStack().pop();
                this._host = Uri$IPv4Host$.MODULE$.apply(b, a);
                bl = ParserMacroMethods_this.__push(BoxedUnit.UNIT);
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> ipv6Host() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$28(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean matched2;
            int start1 = ParserMacroMethods_this.cursor();
            boolean bl3 = matched2 = this.ip$minusv6$minusaddress() != null;
            if (matched2) {
                ParserMacroMethods_this.valueStack().push((Object)ParserMacroMethods_this.input().sliceString(start1, ParserMacroMethods_this.cursor()));
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                String a = (String)ParserMacroMethods_this.valueStack().pop();
                byte[] b = (byte[])ParserMacroMethods_this.valueStack().pop();
                this.setHost(Uri$IPv6Host$.MODULE$.apply(b, a));
                bl = ParserMacroMethods_this.__push(BoxedUnit.UNIT);
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Rule<HNil, HNil> reg$minusname() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$29(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            boolean bl3;
            boolean ll2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll2 = this.clearSBForDecoding() != null;
            if (ll2) {
                long firstMark = ParserMacroMethods_this.__saveState();
                long mark2 = this.rec$8(ParserMacroMethods_this, firstMark);
                if (mark2 != firstMark) {
                    ParserMacroMethods_this.__restoreState(mark2);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = ll = false;
            }
            if (ll) {
                this.setHost(Uri$NamedHost$.MODULE$.apply(this.getDecodedStringAndLowerIfEncoded(org.parboiled2.package$.MODULE$.UTF8())));
                bl2 = true;
            } else {
                bl2 = l = false;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                this.setHost(Uri$Host$Empty$.MODULE$);
                bl = true;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> path$minusabempty() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$30(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean bl2 = ll2 = this.clearSB() != null;
            boolean bl3 = ll2 ? this.slashSegments() != null : (ll = false);
            bl = ll ? this.savePath() != null : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> path$minusabsolute() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$31(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean ll3;
            boolean ll4;
            boolean bl3 = ll4 = this.clearSB() != null;
            boolean bl4 = ll4 ? ParserMacroMethods_this.cursorChar() == '/' && ParserMacroMethods_this.__advance() : (ll3 = false);
            boolean bl5 = ll3 ? this.appendSB('/') != null : (ll2 = false);
            if (ll2) {
                boolean matched2;
                boolean ll5;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl6 = ll5 = this.segment$minusnz() != null;
                boolean bl7 = ll5 ? this.slashSegments() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl2 = true;
            } else {
                bl2 = ll = false;
            }
            bl = ll ? this.savePath() != null : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> path$minusnoscheme() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$32(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean bl2 = ll3 = this.clearSB() != null;
            boolean bl3 = ll3 ? this.segment$minusnz$minusnc() != null : (ll2 = false);
            boolean bl4 = ll2 ? this.slashSegments() != null : (ll = false);
            bl = ll ? this.savePath() != null : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> path$minusrootless() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$33(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean bl2 = ll3 = this.clearSB() != null;
            boolean bl3 = ll3 ? this.segment$minusnz() != null : (ll2 = false);
            boolean bl4 = ll2 ? this.slashSegments() != null : (ll = false);
            bl = ll ? this.savePath() != null : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> path$minusempty() {
        boolean matched;
        UriParser ParserMacroMethods_this = this;
        boolean bl = ParserMacroMethods_this.__inErrorAnalysis() ? this.wrapped$34(ParserMacroMethods_this) : (matched = this.MATCH() != null);
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> slashSegments() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$35(ParserMacroMethods_this);
        } else {
            ParserMacroMethods_this.__restoreState(this.rec$10(ParserMacroMethods_this, ParserMacroMethods_this.__saveState()));
            bl = matched = true;
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> segment() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$36(ParserMacroMethods_this);
        } else {
            ParserMacroMethods_this.__restoreState(this.rec$12(ParserMacroMethods_this, ParserMacroMethods_this.__saveState()));
            bl = matched = true;
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rule<HNil, HNil> segment$minusnz() {
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$37(ParserMacroMethods_this);
        } else {
            long firstMark = ParserMacroMethods_this.__saveState();
            long mark = this.rec$14(ParserMacroMethods_this, firstMark);
            if (mark == firstMark) return null;
            ParserMacroMethods_this.__restoreState(mark);
            if (!true) return null;
            bl = true;
        }
        boolean matched = bl;
        if (!matched) return null;
        return (Rule)Rule$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rule<HNil, HNil> segment$minusnz$minusnc() {
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$38(ParserMacroMethods_this);
        } else {
            long firstMark = ParserMacroMethods_this.__saveState();
            long mark = this.rec$16(ParserMacroMethods_this, firstMark);
            if (mark == firstMark) return null;
            ParserMacroMethods_this.__restoreState(mark);
            if (!true) return null;
            bl = true;
        }
        boolean matched = bl;
        if (!matched) return null;
        return (Rule)Rule$.MODULE$;
    }

    public Rule<HNil, HNil> pchar() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$39(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean ll;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl2 = ll = this.path$minussegment$minuschar.apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance();
            boolean bl3 = ll ? this.appendSB() != null : (l = false);
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Rule<HNil, HNil> rawQueryString() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$40(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            boolean bl3;
            boolean ll2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll2 = this.clearSB() != null;
            if (ll2) {
                long firstMark = ParserMacroMethods_this.__saveState();
                long mark2 = this.rec$18(ParserMacroMethods_this, firstMark);
                if (mark2 != firstMark) {
                    ParserMacroMethods_this.__restoreState(mark2);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = ll = false;
            }
            if (ll) {
                this.setRawQueryString(this.sb().toString());
                bl2 = true;
            } else {
                bl2 = l = false;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                this.setRawQueryString("");
                bl = true;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, .colon.colon<Uri.Query, HNil>> query() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$45(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl3 = ll = ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance();
            if (ll) {
                ParserMacroMethods_this.valueStack().push((Object)Uri$Query$Empty$.MODULE$);
                bl2 = true;
            } else {
                bl2 = l = false;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.keyValuePairs$1() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Rule<HNil, HNil> fragment() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$46(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            boolean bl3;
            boolean ll2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll2 = this.clearSBForDecoding() != null;
            if (ll2) {
                long firstMark = ParserMacroMethods_this.__saveState();
                long mark2 = this.rec$24(ParserMacroMethods_this, firstMark);
                if (mark2 != firstMark) {
                    ParserMacroMethods_this.__restoreState(mark2);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = ll = false;
            }
            if (ll) {
                this.setFragment(this.getDecodedString(this.getDecodedString$default$1()));
                bl2 = true;
            } else {
                bl2 = l = false;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                this.setFragment("");
                bl = true;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Rule<HNil, HNil> pct$minusencoded() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$47(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean ll2;
            boolean ll3;
            boolean bl2 = ll3 = ParserMacroMethods_this.cursorChar() == '%' && ParserMacroMethods_this.__advance();
            boolean bl3 = ll3 ? CharacterClasses$.MODULE$.HEXDIG().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance() : (ll2 = false);
            boolean bl4 = ll2 ? CharacterClasses$.MODULE$.HEXDIG().apply(ParserMacroMethods_this.cursorChar()) && ParserMacroMethods_this.__advance() : (ll = false);
            if (ll) {
                if (this._firstPercentIx == -1) {
                    this._firstPercentIx = this.sb().length();
                }
                this.sb().append('%').append(this.charAt(-2)).append(this.lastChar());
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rule<HNil, HNil> absolute$minuspath() {
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$48(ParserMacroMethods_this);
        } else {
            if (this.clearSB() == null) return null;
            boolean bl2 = true;
            boolean ll = bl2;
            if (!ll) return null;
            long firstMark = ParserMacroMethods_this.__saveState();
            long mark = this.rec$26(ParserMacroMethods_this, firstMark);
            if (mark == firstMark) return null;
            ParserMacroMethods_this.__restoreState(mark);
            if (!true) return null;
            boolean bl3 = true;
            boolean ll2 = bl3;
            if (!ll2) return null;
            if (this.savePath() == null) return null;
            bl = true;
        }
        boolean matched = bl;
        if (!matched) return null;
        return (Rule)Rule$.MODULE$;
    }

    public Rule<HNil, HNil> request$minustarget() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$49(ParserMacroMethods_this);
        } else {
            boolean l;
            boolean bl2;
            boolean l2;
            boolean bl3;
            boolean ll;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll = this.absolute$minuspath() != null;
            if (ll) {
                boolean matched2;
                boolean ll2;
                long mark2 = ParserMacroMethods_this.__saveState();
                boolean bl5 = ll2 = ParserMacroMethods_this.cursorChar() == '?' && ParserMacroMethods_this.__advance();
                boolean bl6 = ll2 ? this.rawQueryString() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark2);
                }
                bl3 = true;
            } else {
                bl3 = l2 = false;
            }
            if (!l2) {
                ParserMacroMethods_this.__restoreState(mark);
                bl2 = this.absolute$minusURI() != null;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                bl = this.authority() != null;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Uri parseHttpRequestTarget() {
        Parser.DeliveryScheme scheme$proxy9 = Parser.DeliveryScheme$.MODULE$.Either((Unpack.Aux)Unpack.HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseHttpRequestTarget$$anonfun$1, scheme$proxy9);
        if (either instanceof Right) {
            Uri.Path path = this._scheme.isEmpty() ? this._path : Uri$.MODULE$.collapseDotSegments(this._path);
            return Uri$.MODULE$.createUnsafe(this._scheme, Uri$Authority$.MODULE$.apply(this._host, this._port, this._userinfo), path, this._rawQueryString, this._fragment);
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "request-target");
        }
        throw new MatchError((Object)either);
    }

    public Rule<HNil, HNil> http2$minusauthority$minuspseudo$minusheader() {
        return this.hostAndPort();
    }

    public Uri.Authority parseHttp2AuthorityPseudoHeader() {
        Parser.DeliveryScheme scheme$proxy10 = Parser.DeliveryScheme$.MODULE$.Either((Unpack.Aux)Unpack.HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseHttp2AuthorityPseudoHeader$$anonfun$1, scheme$proxy10);
        if (either instanceof Right) {
            return Uri$Authority$.MODULE$.apply(this._host, this._port, Uri$Authority$.MODULE$.$lessinit$greater$default$3());
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "http2-authority-pseudo-header");
        }
        throw new MatchError((Object)either);
    }

    public Rule<HNil, HNil> http2$minuspath$minuspseudo$minusheader() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$52(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.absolute$minuspath() != null;
            if (ll) {
                boolean matched2;
                boolean ll2;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl3 = ll2 = ParserMacroMethods_this.cursorChar() == '?' && ParserMacroMethods_this.__advance();
                boolean bl4 = ll2 ? this.rawQueryString() != null : (matched2 = false);
                if (!matched2) {
                    ParserMacroMethods_this.__restoreState(mark);
                }
                bl = true;
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    public Tuple2<Uri.Path, Option<String>> parseHttp2PathPseudoHeader() {
        Parser.DeliveryScheme scheme$proxy11 = Parser.DeliveryScheme$.MODULE$.Either((Unpack.Aux)Unpack.HNilUnpack$.MODULE$);
        Either either = (Either)this.__run(this::parseHttp2PathPseudoHeader$$anonfun$1, scheme$proxy11);
        if (either instanceof Right) {
            Uri.Path path = Uri$.MODULE$.collapseDotSegments(this._path);
            return Tuple2$.MODULE$.apply((Object)path, this._rawQueryString);
        }
        if (either instanceof Left) {
            ParseError error = (ParseError)((Left)either).value();
            throw this.fail(error, "http2-path-pseudo-header");
        }
        throw new MatchError((Object)either);
    }

    private Rule<HNil, HNil> appendLowered() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$54(ParserMacroMethods_this);
        } else {
            this.sb().append(CharUtils$.MODULE$.toLowerCase(this.lastChar()));
            bl = matched = true;
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    private Rule<HNil, HNil> savePath() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$55(ParserMacroMethods_this);
        } else {
            this.setPath(Uri$Path$.MODULE$.apply(this.sb().toString(), this.uriParsingCharset()));
            bl = matched = true;
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    private Rule<HNil, HNil> clearSBForDecoding() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$56(ParserMacroMethods_this);
        } else {
            this.sb().setLength(0);
            this._firstPercentIx = -1;
            bl = matched = true;
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    private String getDecodedString(Charset charset) {
        if (this._firstPercentIx >= 0) {
            String string = this.sb().toString();
            int n = this._firstPercentIx;
            return Uri$.MODULE$.decode(string, charset, n, Uri$.MODULE$.decode$default$4(string, charset, n));
        }
        return this.sb().toString();
    }

    private Charset getDecodedString$default$1() {
        return this.uriParsingCharset();
    }

    private String getDecodedStringAndLowerIfEncoded(Charset charset) {
        if (this._firstPercentIx >= 0) {
            String string = this.sb().toString();
            int n = this._firstPercentIx;
            return EnhancedString$.MODULE$.toRootLowerCase$extension(org.apache.pekko.http.impl.util.package$.MODULE$.enhanceString_(Uri$.MODULE$.decode(string, charset, n, Uri$.MODULE$.decode$default$4(string, charset, n))));
        }
        return this.sb().toString();
    }

    private Uri createUriReference() {
        Uri.Path path = this._scheme.isEmpty() ? this._path : Uri$.MODULE$.collapseDotSegments(this._path);
        return Uri$.MODULE$.createUnsafe(this._scheme, Uri$Authority$.MODULE$.apply(this._host, Uri$.MODULE$.normalizePort(this._port, this._scheme), this._userinfo), path, this._rawQueryString, this._fragment);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$1(UriParser ParserMacroMethods_this$1) {
        int start = ParserMacroMethods_this$1.cursor();
        try {
            int start2 = ParserMacroMethods_this$1.cursor();
            try {
                if (this.absolute$minusURI() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$1.cursorChar() == this.EOI() && ParserMacroMethods_this$1.__advance()) {
                        if (ParserMacroMethods_this$1.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$1.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$1.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseAbsoluteUri"), start);
        }
    }

    private final Rule parseAbsoluteUri$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$1(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.absolute$minusURI() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$2(UriParser ParserMacroMethods_this$2) {
        int start = ParserMacroMethods_this$2.cursor();
        try {
            int start2 = ParserMacroMethods_this$2.cursor();
            try {
                if (this.URI$minusreference() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$2.cursorChar() == this.EOI() && ParserMacroMethods_this$2.__advance()) {
                        if (ParserMacroMethods_this$2.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$2.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$2.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseUriReference"), start);
        }
    }

    private final Rule parseUriReference$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$2(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.URI$minusreference() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$3(UriParser ParserMacroMethods_this$3) {
        int start = ParserMacroMethods_this$3.cursor();
        try {
            int start2 = ParserMacroMethods_this$3.cursor();
            try {
                if (this.URI$minusreference() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$3.cursorChar() == this.EOI() && ParserMacroMethods_this$3.__advance()) {
                        if (ParserMacroMethods_this$3.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$3.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$3.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseAndResolveUriReference"), start);
        }
    }

    private final Rule parseAndResolveUriReference$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$3(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.URI$minusreference() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$4(UriParser ParserMacroMethods_this$4) {
        int start = ParserMacroMethods_this$4.cursor();
        try {
            int start2 = ParserMacroMethods_this$4.cursor();
            try {
                if (this.origin() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$4.cursorChar() == this.EOI() && ParserMacroMethods_this$4.__advance()) {
                        if (ParserMacroMethods_this$4.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$4.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$4.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseOrigin"), start);
        }
    }

    private final Rule parseOrigin$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$4(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.origin() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$5(UriParser ParserMacroMethods_this$5) {
        int start = ParserMacroMethods_this$5.cursor();
        try {
            int start2 = ParserMacroMethods_this$5.cursor();
            try {
                if (this.relaxedHost() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$5.cursorChar() == this.EOI() && ParserMacroMethods_this$5.__advance()) {
                        if (ParserMacroMethods_this$5.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$5.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$5.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseHost"), start);
        }
    }

    private final Rule parseHost$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$5(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.relaxedHost() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$6(UriParser ParserMacroMethods_this$6) {
        int start = ParserMacroMethods_this$6.cursor();
        try {
            int start2 = ParserMacroMethods_this$6.cursor();
            try {
                if (this.rawQueryString() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$6.cursorChar() == this.EOI() && ParserMacroMethods_this$6.__advance()) {
                        if (ParserMacroMethods_this$6.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$6.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$6.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseRawQueryString"), start);
        }
    }

    private final Rule parseRawQueryString$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$6(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.rawQueryString() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$7(UriParser ParserMacroMethods_this$7) {
        int start = ParserMacroMethods_this$7.cursor();
        try {
            int start2 = ParserMacroMethods_this$7.cursor();
            try {
                if (this.query() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$7.cursorChar() == this.EOI() && ParserMacroMethods_this$7.__advance()) {
                        if (ParserMacroMethods_this$7.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$7.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$7.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseQuery"), start);
        }
    }

    private final Rule parseQuery$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$7(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.query() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$8(UriParser ParserMacroMethods_this$8) {
        int start = ParserMacroMethods_this$8.cursor();
        try {
            int start2 = ParserMacroMethods_this$8.cursor();
            try {
                if (this.authority() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$8.cursorChar() == this.EOI() && ParserMacroMethods_this$8.__advance()) {
                        if (ParserMacroMethods_this$8.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$8.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$8.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseAuthority"), start);
        }
    }

    private final Rule parseAuthority$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$8(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.authority() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$9(UriParser ParserMacroMethods_this$9) {
        start = ParserMacroMethods_this$9.cursor();
        try {
            start = ParserMacroMethods_this$9.cursor();
            start = ParserMacroMethods_this$9.cursor();
            start = ParserMacroMethods_this$9.cursor();
            try {
                start = ParserMacroMethods_this$9.cursor();
                try {
                    if (this.scheme() == null) return false;
                    v0 = true;
                    ll = v0;
                    if (ll == false) return false;
                    try {
                        if (ParserMacroMethods_this$9.cursorChar() != ':' || !ParserMacroMethods_this$9.__advance() || !ParserMacroMethods_this$9.__updateMaxCursor()) {
                            if (ParserMacroMethods_this$9.__registerMismatch() == false) return false;
                        }
                        v1 = true;
                    }
                    catch (Throwable var11_8) {
                        var12_9 = var11_8;
                        if (Parser.StartTracingException$.MODULE$.equals(var12_9) == false) throw var11_8;
                        throw ParserMacroMethods_this$9.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(':'));
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
                ll = v1;
                if (ll == false) return false;
                if (this.hier$minuspart() == null) return false;
                v2 = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
            }
            ll = v2;
            if (ll == false) return false;
            start = ParserMacroMethods_this$9.cursor();
            mark = ParserMacroMethods_this$9.__saveState();
            start = ParserMacroMethods_this$9.cursor();
            try {
                try {
                    v3 = ParserMacroMethods_this$9.cursorChar() == '?' && ParserMacroMethods_this$9.__advance() && ParserMacroMethods_this$9.__updateMaxCursor() || ParserMacroMethods_this$9.__registerMismatch();
                }
                catch (Throwable var21_17) {
                    var22_18 = var21_17;
                    if (Parser.StartTracingException$.MODULE$.equals(var22_18) == false) throw var21_17;
                    throw ParserMacroMethods_this$9.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('?'));
                }
                ll = v3;
                v4 = ll ? this.rawQueryString() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start);
                }
            }
            matched = v4;
            if (!matched) {
                ParserMacroMethods_this$9.__restoreState(mark);
            }
            v5 = true;
lbl-1000:
            // 3 sources

            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            ** try [egrp 19[TRYBLOCK] [18 : 369->376)] { 
            {
            }
lbl67:
            // 1 sources

            ll = v5;
            if (ll == false) return false;
            start = ParserMacroMethods_this$9.cursor();
            mark = ParserMacroMethods_this$9.__saveState();
            start = ParserMacroMethods_this$9.cursor();
            try {
                try {
                    v6 = ParserMacroMethods_this$9.cursorChar() == '#' && ParserMacroMethods_this$9.__advance() && ParserMacroMethods_this$9.__updateMaxCursor() || ParserMacroMethods_this$9.__registerMismatch();
                }
                catch (Throwable var32_28) {
                    var33_29 = var32_28;
                    if (Parser.StartTracingException$.MODULE$.equals(var33_29) == false) throw var32_28;
                    throw ParserMacroMethods_this$9.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('#'));
                }
                ll = v6;
                v7 = ll ? this.fragment() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start);
                }
            }
            matched = v7;
            if (!matched) {
                ParserMacroMethods_this$9.__restoreState(mark);
            }
            v8 = true;
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            return v8;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("URI"), start);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$10(UriParser ParserMacroMethods_this$10) {
        start = ParserMacroMethods_this$10.cursor();
        try {
            block30: {
                start = ParserMacroMethods_this$10.cursor();
                try {
                    block29: {
                        block28: {
                            start = ParserMacroMethods_this$10.cursor();
                            start = ParserMacroMethods_this$10.cursor();
                            start = ParserMacroMethods_this$10.cursor();
                            try {
                                v0 = ll = this.scheme() != null;
                                if (ll) {
                                    try {
                                        v1 = ParserMacroMethods_this$10.cursorChar() == ':' && ParserMacroMethods_this$10.__advance() && ParserMacroMethods_this$10.__updateMaxCursor() || ParserMacroMethods_this$10.__registerMismatch();
                                        break block28;
                                    }
                                    catch (Throwable var11_8) {
                                        var12_9 = var11_8;
                                        if (Parser.StartTracingException$.MODULE$.equals(var12_9) == false) throw var11_8;
                                        throw ParserMacroMethods_this$10.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(':'));
                                    }
                                }
                                v1 = false;
                            }
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                            }
                        }
                        ll = v1;
                        if (!ll) ** GOTO lbl39
                        try {
                            v2 = ParserMacroMethods_this$10.cursorChar() == '/' && ParserMacroMethods_this$10.__advance() && ParserMacroMethods_this$10.__updateMaxCursor() || ParserMacroMethods_this$10.__registerMismatch();
                        }
                        catch (Throwable var14_12) {
                            var15_13 = var14_12;
                            if (Parser.StartTracingException$.MODULE$.equals(var15_13) == false) throw var14_12;
                            throw ParserMacroMethods_this$10.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('/'));
                        }
                        {
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                            }
                        }
                        break block29;
lbl39:
                        // 1 sources

                        v2 = false;
                    }
                    ll = v2;
                    if (!ll) ** GOTO lbl56
                    try {
                        v3 = ParserMacroMethods_this$10.cursorChar() == '/' && ParserMacroMethods_this$10.__advance() && ParserMacroMethods_this$10.__updateMaxCursor() || ParserMacroMethods_this$10.__registerMismatch();
                    }
                    catch (Throwable var17_16) {
                        var18_17 = var17_16;
                        if (Parser.StartTracingException$.MODULE$.equals(var18_17) == false) throw var17_16;
                        throw ParserMacroMethods_this$10.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('/'));
                    }
                    {
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                        }
                    }
                    break block30;
lbl56:
                    // 1 sources

                    v3 = false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            ll = v3;
            if (!ll) {
                return false;
            }
            if (this.hostAndPort() == null) return false;
            return true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("origin"), start);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$11(UriParser ParserMacroMethods_this$11) {
        start = ParserMacroMethods_this$11.cursor();
        try {
            start = ParserMacroMethods_this$11.cursor();
            try {
                mark = ParserMacroMethods_this$11.__saveState();
                start = ParserMacroMethods_this$11.cursor();
                try {
                    block29: {
                        start = ParserMacroMethods_this$11.cursor();
                        try {
                            start = ParserMacroMethods_this$11.cursor();
                            try {
                                v0 = ParserMacroMethods_this$11.cursorChar() == '/' && ParserMacroMethods_this$11.__advance() && ParserMacroMethods_this$11.__updateMaxCursor() || ParserMacroMethods_this$11.__registerMismatch();
                            }
                            catch (Throwable var15_8) {
                                var16_9 = var15_8;
                                if (Parser.StartTracingException$.MODULE$.equals(var16_9) == false) throw var15_8;
                                throw ParserMacroMethods_this$11.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('/'));
                            }
                            ll = v0;
                            if (!ll) ** GOTO lbl33
                            try {
                                v1 = ParserMacroMethods_this$11.cursorChar() == '/' && ParserMacroMethods_this$11.__advance() && ParserMacroMethods_this$11.__updateMaxCursor() || ParserMacroMethods_this$11.__registerMismatch();
                            }
                            catch (Throwable var17_11) {
                                var18_12 = var17_11;
                                if (Parser.StartTracingException$.MODULE$.equals(var18_12) == false) throw var17_11;
                                throw ParserMacroMethods_this$11.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('/'));
                            }
                            {
                                catch (Parser.TracingBubbleException e) {
                                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                }
                            }
                            break block29;
lbl33:
                            // 1 sources

                            v1 = false;
                        }
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                        }
                    }
                    ll = v1;
                    v2 = ll ? this.authority() != null : false;
                    ll = v2;
                    if (ll) {
                        if (this.path$minusabempty() != null) {
                            return true;
                        }
                        v3 = false;
                    } else {
                        v3 = false;
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
                l = v3;
                if (l != false) return true;
                ParserMacroMethods_this$11.__restoreState(mark);
                if (this.path$minusabsolute() != null) {
                    return true;
                }
                v4 = false;
                l = v4;
                if (l != false) return true;
                ParserMacroMethods_this$11.__restoreState(mark);
                if (this.path$minusrootless() != null) {
                    return true;
                }
                v5 = false;
                l = v5;
                if (l) {
                    return true;
                }
                ParserMacroMethods_this$11.__restoreState(mark);
                if (this.path$minusempty() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("hier-part"), start);
        }
    }

    private final boolean wrapped$12(UriParser ParserMacroMethods_this$12) {
        boolean bl;
        int start = ParserMacroMethods_this$12.cursor();
        try {
            int start2 = ParserMacroMethods_this$12.cursor();
            try {
                boolean l;
                long mark = ParserMacroMethods_this$12.__saveState();
                boolean bl2 = l = this.URI() != null;
                if (!l) {
                    ParserMacroMethods_this$12.__restoreState(mark);
                    bl = this.relative$minusref() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("URI-reference"), start);
        }
        return bl;
    }

    private final boolean wrapped$13(UriParser ParserMacroMethods_this$13) {
        boolean bl;
        int start = ParserMacroMethods_this$13.cursor();
        try {
            int start2 = ParserMacroMethods_this$13.cursor();
            try {
                boolean ll;
                boolean bl2 = ll = this.URI$minusreference() != null;
                if (ll) {
                    ParserMacroMethods_this$13.valueStack().push((Object)this.createUriReference());
                    bl = true;
                } else {
                    bl = false;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("URI-reference-pushed"), start);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$14(UriParser ParserMacroMethods_this$14) {
        int start = ParserMacroMethods_this$14.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$14.cursor();
            int start3 = ParserMacroMethods_this$14.cursor();
            try {
                boolean bl3;
                int start4 = ParserMacroMethods_this$14.cursor();
                try {
                    if (this.scheme() == null) return false;
                    boolean bl4 = true;
                    boolean ll = bl4;
                    if (!ll) return false;
                    try {
                        if (ParserMacroMethods_this$14.cursorChar() != ':' || !ParserMacroMethods_this$14.__advance() || !ParserMacroMethods_this$14.__updateMaxCursor()) {
                            if (!ParserMacroMethods_this$14.__registerMismatch()) return false;
                        }
                        bl3 = true;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        throw ParserMacroMethods_this$14.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(':'));
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start4);
                }
                boolean ll = bl3;
                if (!ll) return false;
                if (this.hier$minuspart() == null) return false;
                bl2 = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
            }
            boolean ll = bl2;
            if (!ll) return false;
            int start5 = ParserMacroMethods_this$14.cursor();
            long mark = ParserMacroMethods_this$14.__saveState();
            int start6 = ParserMacroMethods_this$14.cursor();
            try {
                boolean bl5;
                try {
                    bl5 = ParserMacroMethods_this$14.cursorChar() == '?' && ParserMacroMethods_this$14.__advance() && ParserMacroMethods_this$14.__updateMaxCursor() || ParserMacroMethods_this$14.__registerMismatch();
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable3)) throw throwable;
                    throw ParserMacroMethods_this$14.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('?'));
                }
                boolean ll2 = bl5;
                bl = ll2 ? this.rawQueryString() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start6);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start5);
                }
            }
            boolean matched = bl;
            if (!matched) {
                ParserMacroMethods_this$14.__restoreState(mark);
            }
            boolean bl6 = true;
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
                }
            }
            return bl6;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("absolute-URI"), start);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$15(UriParser ParserMacroMethods_this$15) {
        int start = ParserMacroMethods_this$15.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$15.cursor();
            int start3 = ParserMacroMethods_this$15.cursor();
            try {
                if (this.relative$minuspart() == null) return false;
                boolean bl3 = true;
                boolean ll = bl3;
                if (!ll) return false;
                int start4 = ParserMacroMethods_this$15.cursor();
                try {
                    boolean bl4;
                    long mark = ParserMacroMethods_this$15.__saveState();
                    int start5 = ParserMacroMethods_this$15.cursor();
                    try {
                        boolean bl5;
                        try {
                            bl5 = ParserMacroMethods_this$15.cursorChar() == '?' && ParserMacroMethods_this$15.__advance() && ParserMacroMethods_this$15.__updateMaxCursor() || ParserMacroMethods_this$15.__registerMismatch();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                            throw ParserMacroMethods_this$15.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('?'));
                        }
                        boolean ll2 = bl5;
                        bl4 = ll2 ? this.rawQueryString() != null : false;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start5);
                    }
                    boolean matched = bl4;
                    if (!matched) {
                        ParserMacroMethods_this$15.__restoreState(mark);
                    }
                    bl2 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start4);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
            }
            boolean ll = bl2;
            if (!ll) return false;
            int start6 = ParserMacroMethods_this$15.cursor();
            long mark = ParserMacroMethods_this$15.__saveState();
            int start7 = ParserMacroMethods_this$15.cursor();
            try {
                boolean bl6;
                try {
                    bl6 = ParserMacroMethods_this$15.cursorChar() == '#' && ParserMacroMethods_this$15.__advance() && ParserMacroMethods_this$15.__updateMaxCursor() || ParserMacroMethods_this$15.__registerMismatch();
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable3)) throw throwable;
                    throw ParserMacroMethods_this$15.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('#'));
                }
                boolean ll3 = bl6;
                bl = ll3 ? this.fragment() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start7);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start6);
                }
            }
            boolean matched = bl;
            if (!matched) {
                ParserMacroMethods_this$15.__restoreState(mark);
            }
            boolean bl7 = true;
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
                }
            }
            return bl7;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("relative-ref"), start);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$16(UriParser ParserMacroMethods_this$16) {
        start = ParserMacroMethods_this$16.cursor();
        try {
            start = ParserMacroMethods_this$16.cursor();
            try {
                mark = ParserMacroMethods_this$16.__saveState();
                start = ParserMacroMethods_this$16.cursor();
                try {
                    block29: {
                        start = ParserMacroMethods_this$16.cursor();
                        try {
                            start = ParserMacroMethods_this$16.cursor();
                            try {
                                v0 = ParserMacroMethods_this$16.cursorChar() == '/' && ParserMacroMethods_this$16.__advance() && ParserMacroMethods_this$16.__updateMaxCursor() || ParserMacroMethods_this$16.__registerMismatch();
                            }
                            catch (Throwable var15_8) {
                                var16_9 = var15_8;
                                if (Parser.StartTracingException$.MODULE$.equals(var16_9) == false) throw var15_8;
                                throw ParserMacroMethods_this$16.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('/'));
                            }
                            ll = v0;
                            if (!ll) ** GOTO lbl33
                            try {
                                v1 = ParserMacroMethods_this$16.cursorChar() == '/' && ParserMacroMethods_this$16.__advance() && ParserMacroMethods_this$16.__updateMaxCursor() || ParserMacroMethods_this$16.__registerMismatch();
                            }
                            catch (Throwable var17_11) {
                                var18_12 = var17_11;
                                if (Parser.StartTracingException$.MODULE$.equals(var18_12) == false) throw var17_11;
                                throw ParserMacroMethods_this$16.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('/'));
                            }
                            {
                                catch (Parser.TracingBubbleException e) {
                                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                }
                            }
                            break block29;
lbl33:
                            // 1 sources

                            v1 = false;
                        }
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                        }
                    }
                    ll = v1;
                    v2 = ll ? this.authority() != null : false;
                    ll = v2;
                    if (ll) {
                        if (this.path$minusabempty() != null) {
                            return true;
                        }
                        v3 = false;
                    } else {
                        v3 = false;
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
                l = v3;
                if (l != false) return true;
                ParserMacroMethods_this$16.__restoreState(mark);
                if (this.path$minusabsolute() != null) {
                    return true;
                }
                v4 = false;
                l = v4;
                if (l != false) return true;
                ParserMacroMethods_this$16.__restoreState(mark);
                if (this.path$minusnoscheme() != null) {
                    return true;
                }
                v5 = false;
                l = v5;
                if (l) {
                    return true;
                }
                ParserMacroMethods_this$16.__restoreState(mark);
                if (this.path$minusempty() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("relative-part"), start);
        }
    }

    private final long rec$1(UriParser ParserMacroMethods_this$18, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$18.cursor();
            try {
                try {
                    bl = CharacterClasses$.MODULE$.scheme$minuschar().apply(ParserMacroMethods_this$18.cursorChar()) && ParserMacroMethods_this$18.__advance() && ParserMacroMethods_this$18.__updateMaxCursor() || ParserMacroMethods_this$18.__registerMismatch();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) {
                        throw throwable;
                    }
                    RuleTrace.NonTerminal nonTerminal = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("scheme-char"), 0);
                    throw ParserMacroMethods_this$18.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)nonTerminal), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.scheme$minuschar()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
            }
            boolean ll = bl;
            boolean bl2 = ll ? this.appendLowered() != null : false;
            boolean matched = bl2;
            if (!matched) break;
            mark = ParserMacroMethods_this$18.__saveState();
        }
        return mark;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$17(UriParser ParserMacroMethods_this$17) {
        start = ParserMacroMethods_this$17.cursor();
        try {
            block120: {
                block119: {
                    block118: {
                        block116: {
                            block115: {
                                block114: {
                                    block113: {
                                        block112: {
                                            block111: {
                                                block110: {
                                                    block109: {
                                                        start = ParserMacroMethods_this$17.cursor();
                                                        mark = ParserMacroMethods_this$17.__saveState();
                                                        start = ParserMacroMethods_this$17.cursor();
                                                        start = ParserMacroMethods_this$17.cursor();
                                                        start = ParserMacroMethods_this$17.cursor();
                                                        start = ParserMacroMethods_this$17.cursor();
                                                        try {
                                                            v0 = ParserMacroMethods_this$17.cursorChar() == 'h' && ParserMacroMethods_this$17.__advance() && ParserMacroMethods_this$17.__updateMaxCursor() || ParserMacroMethods_this$17.__registerMismatch();
                                                        }
                                                        catch (Throwable var15_9) {
                                                            var16_10 = var15_9;
                                                            if (Parser.StartTracingException$.MODULE$.equals(var16_10) == false) throw var15_9;
                                                            throw ParserMacroMethods_this$17.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('h'));
                                                        }
                                                        ll = v0;
                                                        if (!ll) ** GOTO lbl35
                                                        try {
                                                            v1 = ParserMacroMethods_this$17.cursorChar() == 't' && ParserMacroMethods_this$17.__advance() && ParserMacroMethods_this$17.__updateMaxCursor() || ParserMacroMethods_this$17.__registerMismatch();
                                                        }
                                                        catch (Throwable var17_12) {
                                                            var18_13 = var17_12;
                                                            if (Parser.StartTracingException$.MODULE$.equals(var18_13) == false) throw var17_12;
                                                            throw ParserMacroMethods_this$17.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('t'));
                                                        }
                                                        {
                                                            catch (Parser.TracingBubbleException e) {
                                                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                                            }
                                                        }
                                                        break block109;
lbl35:
                                                        // 1 sources

                                                        v1 = false;
                                                    }
                                                    ll = v1;
                                                    if (!ll) ** GOTO lbl52
                                                    try {
                                                        v2 = ParserMacroMethods_this$17.cursorChar() == 't' && ParserMacroMethods_this$17.__advance() && ParserMacroMethods_this$17.__updateMaxCursor() || ParserMacroMethods_this$17.__registerMismatch();
                                                    }
                                                    catch (Throwable var20_16) {
                                                        var21_17 = var20_16;
                                                        if (Parser.StartTracingException$.MODULE$.equals(var21_17) == false) throw var20_16;
                                                        throw ParserMacroMethods_this$17.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('t'));
                                                    }
                                                    {
                                                        catch (Parser.TracingBubbleException e) {
                                                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                                        }
                                                    }
                                                    break block110;
lbl52:
                                                    // 1 sources

                                                    v2 = false;
                                                }
                                                ll = v2;
                                                if (!ll) ** GOTO lbl69
                                                try {
                                                    v3 = ParserMacroMethods_this$17.cursorChar() == 'p' && ParserMacroMethods_this$17.__advance() && ParserMacroMethods_this$17.__updateMaxCursor() || ParserMacroMethods_this$17.__registerMismatch();
                                                }
                                                catch (Throwable var23_20) {
                                                    var24_21 = var23_20;
                                                    if (Parser.StartTracingException$.MODULE$.equals(var24_21) == false) throw var23_20;
                                                    throw ParserMacroMethods_this$17.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('p'));
                                                }
                                                {
                                                    catch (Parser.TracingBubbleException e) {
                                                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                                    }
                                                }
                                                break block111;
lbl69:
                                                // 1 sources

                                                v3 = false;
                                            }
                                            ll = v3;
                                            if (!ll) ** GOTO lbl184
                                            start = ParserMacroMethods_this$17.cursor();
                                            mark = ParserMacroMethods_this$17.__saveState();
                                            start = ParserMacroMethods_this$17.cursor();
                                            start = ParserMacroMethods_this$17.cursor();
                                            try {
                                                mark = ParserMacroMethods_this$17.__saveState();
                                                try {
                                                    v4 = ParserMacroMethods_this$17.cursorChar() == ':' && ParserMacroMethods_this$17.__advance() && ParserMacroMethods_this$17.__updateMaxCursor() || ParserMacroMethods_this$17.__registerMismatch();
                                                }
                                                catch (Throwable var36_29) {
                                                    var37_30 = var36_29;
                                                    if (Parser.StartTracingException$.MODULE$.equals(var37_30) == false) throw var36_29;
                                                    throw ParserMacroMethods_this$17.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(':'));
                                                }
                                                matched = v4;
                                                ParserMacroMethods_this$17.__restoreState(mark);
                                                v5 = matched;
                                            }
                                            catch (Parser.TracingBubbleException e) {
                                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.AndPredicate$.MODULE$, start);
                                            }
                                            ll = v5;
                                            if (!ll) ** GOTO lbl109
                                            start = ParserMacroMethods_this$17.cursor();
                                            try {
                                                this.setScheme("http");
                                                v6 = true;
                                            }
                                            catch (Parser.TracingBubbleException e) {
                                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                                            }
                                            {
                                                catch (Parser.TracingBubbleException e) {
                                                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                                }
                                            }
                                            break block112;
lbl109:
                                            // 1 sources

                                            v6 = false;
                                        }
                                        l = v6;
                                        if (l) ** GOTO lbl176
                                        ParserMacroMethods_this$17.__restoreState(mark);
                                        start = ParserMacroMethods_this$17.cursor();
                                        start = ParserMacroMethods_this$17.cursor();
                                        try {
                                            v7 = ParserMacroMethods_this$17.cursorChar() == 's' && ParserMacroMethods_this$17.__advance() && ParserMacroMethods_this$17.__updateMaxCursor() || ParserMacroMethods_this$17.__registerMismatch();
                                        }
                                        catch (Throwable var46_40) {
                                            var47_41 = var46_40;
                                            if (Parser.StartTracingException$.MODULE$.equals(var47_41) == false) throw var46_40;
                                            throw ParserMacroMethods_this$17.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('s'));
                                        }
                                        ll = v7;
                                        if (!ll) ** GOTO lbl151
                                        start = ParserMacroMethods_this$17.cursor();
                                        mark = ParserMacroMethods_this$17.__saveState();
                                        try {
                                            v8 = ParserMacroMethods_this$17.cursorChar() == ':' && ParserMacroMethods_this$17.__advance() && ParserMacroMethods_this$17.__updateMaxCursor() || ParserMacroMethods_this$17.__registerMismatch();
                                        }
                                        catch (Throwable var52_45) {
                                            var53_46 = var52_45;
                                            if (Parser.StartTracingException$.MODULE$.equals(var53_46) == false) throw var52_45;
                                            throw ParserMacroMethods_this$17.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(':'));
                                        }
                                        {
                                            catch (Parser.TracingBubbleException e) {
                                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.AndPredicate$.MODULE$, start);
                                            }
                                        }
                                        matched = v8;
                                        ParserMacroMethods_this$17.__restoreState(mark);
                                        v9 = matched;
                                        {
                                            catch (Parser.TracingBubbleException e) {
                                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                            }
                                        }
                                        break block113;
lbl151:
                                        // 1 sources

                                        v9 = false;
                                    }
                                    ll = v9;
                                    if (!ll) ** GOTO lbl168
                                    start = ParserMacroMethods_this$17.cursor();
                                    try {
                                        this.setScheme("https");
                                        v10 = true;
                                    }
                                    catch (Parser.TracingBubbleException e) {
                                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                                    }
                                    {
                                        catch (Parser.TracingBubbleException e) {
                                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                        }
                                    }
                                    break block114;
lbl168:
                                    // 1 sources

                                    v10 = false;
                                    {
                                        catch (Parser.TracingBubbleException e) {
                                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
                                        }
                                    }
                                }
                                break block115;
lbl176:
                                // 1 sources

                                v10 = true;
                                {
                                    catch (Parser.TracingBubbleException e) {
                                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                    }
                                }
                            }
                            break block116;
lbl184:
                            // 1 sources

                            v10 = false;
                        }
                        l = v10;
                        if (l != false) return true;
                        ParserMacroMethods_this$17.__restoreState(mark);
                        start = ParserMacroMethods_this$17.cursor();
                        start = ParserMacroMethods_this$17.cursor();
                        start = ParserMacroMethods_this$17.cursor();
                        start = ParserMacroMethods_this$17.cursor();
                        try {
                            block117: {
                                start = ParserMacroMethods_this$17.cursor();
                                try {
                                    v11 = ll = this.clearSB() != null;
                                    if (ll) {
                                        try {
                                            v12 = CharacterClasses$.MODULE$.ALPHA().apply(ParserMacroMethods_this$17.cursorChar()) && ParserMacroMethods_this$17.__advance() && ParserMacroMethods_this$17.__updateMaxCursor() || ParserMacroMethods_this$17.__registerMismatch();
                                            break block117;
                                        }
                                        catch (Throwable var71_63) {
                                            var72_64 = var71_63;
                                            if (Parser.StartTracingException$.MODULE$.equals(var72_64) == false) throw var71_63;
                                            var73_65 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("ALPHA"), 0);
                                            throw ParserMacroMethods_this$17.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var73_65), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.ALPHA()));
                                        }
                                    }
                                    v12 = false;
                                }
                                catch (Parser.TracingBubbleException e) {
                                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                }
                            }
                            ll = v12;
                            v13 = ll ? this.appendLowered() != null : false;
                        }
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                        }
                        ll = v13;
                        if (!ll) ** GOTO lbl234
                        start = ParserMacroMethods_this$17.cursor();
                        try {
                            ParserMacroMethods_this$17.__restoreState(this.rec$1(ParserMacroMethods_this$17, ParserMacroMethods_this$17.__saveState()));
                            v14 = true;
                        }
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.ZeroOrMore$.MODULE$, start);
                        }
                        {
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                            }
                        }
                        break block118;
lbl234:
                        // 1 sources

                        v14 = false;
                    }
                    ll = v14;
                    if (!ll) ** GOTO lbl262
                    start = ParserMacroMethods_this$17.cursor();
                    mark = ParserMacroMethods_this$17.__saveState();
                    try {
                        v15 = ParserMacroMethods_this$17.cursorChar() == ':' && ParserMacroMethods_this$17.__advance() && ParserMacroMethods_this$17.__updateMaxCursor() || ParserMacroMethods_this$17.__registerMismatch();
                    }
                    catch (Throwable var83_76) {
                        var84_77 = var83_76;
                        if (Parser.StartTracingException$.MODULE$.equals(var84_77) == false) throw var83_76;
                        throw ParserMacroMethods_this$17.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(':'));
                    }
                    {
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.AndPredicate$.MODULE$, start);
                        }
                    }
                    matched = v15;
                    ParserMacroMethods_this$17.__restoreState(mark);
                    v16 = matched;
                    {
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                        }
                    }
                    break block119;
lbl262:
                    // 1 sources

                    v16 = false;
                }
                ll = v16;
                if (!ll) ** GOTO lbl279
                start = ParserMacroMethods_this$17.cursor();
                try {
                    this.setScheme(this.sb().toString());
                    v17 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                }
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                break block120;
lbl279:
                // 1 sources

                v17 = false;
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
                    }
                }
            }
            return v17;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("scheme"), start);
        }
    }

    private final long rec$2(UriParser ParserMacroMethods_this$19, long mark) {
        while (true) {
            boolean matched;
            boolean ll;
            boolean bl = ll = CharacterClasses$.MODULE$.scheme$minuschar().apply(ParserMacroMethods_this$19.cursorChar()) && ParserMacroMethods_this$19.__advance();
            boolean bl2 = ll ? this.appendLowered() != null : (matched = false);
            if (!matched) break;
            mark = ParserMacroMethods_this$19.__saveState();
        }
        return mark;
    }

    private final long rec$3(UriParser ParserMacroMethods_this$21, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$21.cursor();
            try {
                try {
                    bl = CharacterClasses$.MODULE$.scheme$minuschar().apply(ParserMacroMethods_this$21.cursorChar()) && ParserMacroMethods_this$21.__advance() && ParserMacroMethods_this$21.__updateMaxCursor() || ParserMacroMethods_this$21.__registerMismatch();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) {
                        throw throwable;
                    }
                    RuleTrace.NonTerminal nonTerminal = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("scheme-char"), 0);
                    throw ParserMacroMethods_this$21.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)nonTerminal), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.scheme$minuschar()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
            }
            boolean ll = bl;
            boolean bl2 = ll ? this.appendLowered() != null : false;
            boolean matched = bl2;
            if (!matched) break;
            mark = ParserMacroMethods_this$21.__saveState();
        }
        return mark;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$18(UriParser ParserMacroMethods_this$20) {
        start = ParserMacroMethods_this$20.cursor();
        try {
            block18: {
                start = ParserMacroMethods_this$20.cursor();
                try {
                    start = ParserMacroMethods_this$20.cursor();
                    start = ParserMacroMethods_this$20.cursor();
                    try {
                        firstMark = ParserMacroMethods_this$20.__saveState();
                        mark = this.rec$3(ParserMacroMethods_this$20, firstMark);
                        if (mark != firstMark) {
                            ParserMacroMethods_this$20.__restoreState(mark);
                            v0 = true;
                        } else {
                            v0 = false;
                        }
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.OneOrMore$.MODULE$, start);
                    }
                    ll = v0;
                    if (!ll) ** GOTO lbl35
                    start = ParserMacroMethods_this$20.cursor();
                    try {
                        this.setScheme(this.sb().toString());
                        v1 = true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                    }
                    {
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                        }
                    }
                    break block18;
lbl35:
                    // 1 sources

                    v1 = false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            ll = v1;
            if (ll == false) return false;
            ParserMacroMethods_this$20.valueStack().push((Object)this._scheme);
            return true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("scheme-pushed"), start);
        }
    }

    private final long rec$4(UriParser ParserMacroMethods_this$22, long mark) {
        while (true) {
            boolean matched;
            boolean ll;
            boolean bl = ll = CharacterClasses$.MODULE$.scheme$minuschar().apply(ParserMacroMethods_this$22.cursorChar()) && ParserMacroMethods_this$22.__advance();
            boolean bl2 = ll ? this.appendLowered() != null : (matched = false);
            if (!matched) break;
            mark = ParserMacroMethods_this$22.__saveState();
        }
        return mark;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$19(UriParser ParserMacroMethods_this$23) {
        boolean bl;
        int start = ParserMacroMethods_this$23.cursor();
        try {
            int start2 = ParserMacroMethods_this$23.cursor();
            try {
                int start3 = ParserMacroMethods_this$23.cursor();
                try {
                    boolean matched;
                    long mark = ParserMacroMethods_this$23.__saveState();
                    boolean bl2 = matched = this.userinfo() != null;
                    if (!matched) {
                        ParserMacroMethods_this$23.__restoreState(mark);
                    }
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("authority"), start);
        }
        {
            boolean ll = bl;
            if (!ll) {
                return false;
            }
            if (this.hostAndPort() == null) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final long rec$5(UriParser ParserMacroMethods_this$25, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$25.cursor();
            try {
                boolean bl2;
                long mark2 = ParserMacroMethods_this$25.__saveState();
                int start2 = ParserMacroMethods_this$25.cursor();
                try {
                    boolean bl3;
                    try {
                        bl3 = CharacterClasses$.MODULE$.userinfo$minuschar().apply(ParserMacroMethods_this$25.cursorChar()) && ParserMacroMethods_this$25.__advance() && ParserMacroMethods_this$25.__updateMaxCursor() || ParserMacroMethods_this$25.__registerMismatch();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        RuleTrace.NonTerminal nonTerminal = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("userinfo-char"), 0);
                        throw ParserMacroMethods_this$25.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)nonTerminal), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.userinfo$minuschar()));
                    }
                    boolean ll = bl3;
                    bl2 = ll ? this.appendSB() != null : false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
                }
                boolean l = bl2;
                if (!l) {
                    ParserMacroMethods_this$25.__restoreState(mark2);
                    bl = this.pct$minusencoded() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) return mark;
            mark = ParserMacroMethods_this$25.__saveState();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$20(UriParser ParserMacroMethods_this$24) {
        start = ParserMacroMethods_this$24.cursor();
        try {
            start = ParserMacroMethods_this$24.cursor();
            start = ParserMacroMethods_this$24.cursor();
            start = ParserMacroMethods_this$24.cursor();
            try {
                if (this.clearSBForDecoding() == null) return false;
                v0 = true;
                ll = v0;
                if (ll == false) return false;
                start = ParserMacroMethods_this$24.cursor();
                try {
                    ParserMacroMethods_this$24.__restoreState(this.rec$5(ParserMacroMethods_this$24, ParserMacroMethods_this$24.__saveState()));
                    v1 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.ZeroOrMore$.MODULE$, start);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
            }
            ll = v1;
            if (ll == false) return false;
            try {
                v2 = ParserMacroMethods_this$24.cursorChar() == '@' && ParserMacroMethods_this$24.__advance() && ParserMacroMethods_this$24.__updateMaxCursor() || ParserMacroMethods_this$24.__registerMismatch();
            }
            catch (Throwable var12_11) {
                var13_12 = var12_11;
                if (Parser.StartTracingException$.MODULE$.equals(var13_12) == false) throw var12_11;
                throw ParserMacroMethods_this$24.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('@'));
            }
lbl-1000:
            // 2 sources

            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            ** try [egrp 10[TRYBLOCK] [7 : 187->194)] { 
            {
            }
lbl37:
            // 1 sources

            ll = v2;
            if (ll == false) return false;
            start = ParserMacroMethods_this$24.cursor();
            try {
                this.setUserInfo(this.getDecodedString(this.getDecodedString$default$1()));
                v3 = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            return v3;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("userinfo"), start);
        }
    }

    private final long rec$6(UriParser ParserMacroMethods_this$26, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean l;
            boolean ll;
            long mark2 = ParserMacroMethods_this$26.__saveState();
            boolean bl2 = ll = CharacterClasses$.MODULE$.userinfo$minuschar().apply(ParserMacroMethods_this$26.cursorChar()) && ParserMacroMethods_this$26.__advance();
            boolean bl3 = ll ? this.appendSB() != null : (l = false);
            if (!l) {
                ParserMacroMethods_this$26.__restoreState(mark2);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$26.__saveState();
        }
        return mark;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$21(UriParser ParserMacroMethods_this$27) {
        int start = ParserMacroMethods_this$27.cursor();
        try {
            int start2 = ParserMacroMethods_this$27.cursor();
            try {
                if (this.host() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                int start3 = ParserMacroMethods_this$27.cursor();
                try {
                    boolean bl2;
                    long mark = ParserMacroMethods_this$27.__saveState();
                    int start4 = ParserMacroMethods_this$27.cursor();
                    try {
                        boolean bl3;
                        try {
                            bl3 = ParserMacroMethods_this$27.cursorChar() == ':' && ParserMacroMethods_this$27.__advance() && ParserMacroMethods_this$27.__updateMaxCursor() || ParserMacroMethods_this$27.__registerMismatch();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                            throw ParserMacroMethods_this$27.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(':'));
                        }
                        boolean ll2 = bl3;
                        if (ll2) {
                            if (this.port() != null) {
                                return true;
                            }
                            bl2 = false;
                        } else {
                            bl2 = false;
                        }
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start4);
                    }
                    boolean matched = bl2;
                    if (!matched) {
                        ParserMacroMethods_this$27.__restoreState(mark);
                    }
                    return true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("hostAndPort"), start);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$22(UriParser ParserMacroMethods_this$28) {
        boolean bl;
        int start = ParserMacroMethods_this$28.cursor();
        try {
            int start2 = ParserMacroMethods_this$28.cursor();
            try {
                int start3 = ParserMacroMethods_this$28.cursor();
                try {
                    if (this.hostAndPort() == null) return false;
                    boolean bl2 = true;
                    boolean ll = bl2;
                    if (!ll) return false;
                    ParserMacroMethods_this$28.valueStack().push((Object)this._host);
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("hostAndPort-pushed"), start);
        }
        {
            boolean ll = bl;
            if (!ll) return false;
            ParserMacroMethods_this$28.valueStack().push((Object)BoxesRunTime.boxToInteger((int)this._port));
            return true;
        }
    }

    private final boolean wrapped$23(UriParser ParserMacroMethods_this$29) {
        boolean bl;
        int start = ParserMacroMethods_this$29.cursor();
        try {
            int start2 = ParserMacroMethods_this$29.cursor();
            try {
                boolean l;
                boolean bl2;
                boolean l2;
                long mark = ParserMacroMethods_this$29.__saveState();
                boolean bl3 = l2 = this.IP$minusliteral() != null;
                if (!l2) {
                    ParserMacroMethods_this$29.__restoreState(mark);
                    bl2 = this.ipv4Host() != null;
                } else {
                    bl2 = l = true;
                }
                if (!l) {
                    ParserMacroMethods_this$29.__restoreState(mark);
                    bl = this.reg$minusname() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("host"), start);
        }
        return bl;
    }

    private final boolean wrapped$24(UriParser ParserMacroMethods_this$30) {
        boolean bl;
        int start = ParserMacroMethods_this$30.cursor();
        try {
            int start2 = ParserMacroMethods_this$30.cursor();
            try {
                boolean l;
                boolean bl2;
                boolean l2;
                boolean bl3;
                boolean l3;
                long mark = ParserMacroMethods_this$30.__saveState();
                boolean bl4 = l3 = this.IP$minusliteral() != null;
                if (!l3) {
                    ParserMacroMethods_this$30.__restoreState(mark);
                    bl3 = this.ipv6Host() != null;
                } else {
                    bl3 = l2 = true;
                }
                if (!l2) {
                    ParserMacroMethods_this$30.__restoreState(mark);
                    bl2 = this.ipv4Host() != null;
                } else {
                    bl2 = l = true;
                }
                if (!l) {
                    ParserMacroMethods_this$30.__restoreState(mark);
                    bl = this.reg$minusname() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("relaxedHost"), start);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$25(UriParser ParserMacroMethods_this$31) {
        start = ParserMacroMethods_this$31.cursor();
        try {
            block94: {
                block93: {
                    block92: {
                        block91: {
                            block90: {
                                block89: {
                                    block88: {
                                        start = ParserMacroMethods_this$31.cursor();
                                        start = ParserMacroMethods_this$31.cursor();
                                        try {
                                            if (!(CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this$31.cursorChar()) && ParserMacroMethods_this$31.__advance() && ParserMacroMethods_this$31.__updateMaxCursor())) {
                                                if (ParserMacroMethods_this$31.__registerMismatch() == false) return false;
                                            }
                                            v0 = true;
                                        }
                                        catch (Throwable var7_5) {
                                            var8_6 = var7_5;
                                            if (Parser.StartTracingException$.MODULE$.equals(var8_6) == false) throw var7_5;
                                            var9_7 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("DIGIT"), 0);
                                            throw ParserMacroMethods_this$31.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var9_7), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.DIGIT()));
                                        }
                                        ll = v0;
                                        if (ll == false) return false;
                                        start = ParserMacroMethods_this$31.cursor();
                                        try {
                                            this.setPort(this.lastChar() - 48);
                                            v1 = true;
                                        }
                                        catch (Parser.TracingBubbleException e) {
                                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                                        }
lbl-1000:
                                        // 2 sources

                                        {
                                            catch (Parser.TracingBubbleException e) {
                                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                            }
                                        }
                                        ** try [egrp 7[TRYBLOCK] [4 : 177->184)] { 
                                        {
                                        }
lbl31:
                                        // 1 sources

                                        ll = v1;
                                        if (ll == false) return false;
                                        start = ParserMacroMethods_this$31.cursor();
                                        mark = ParserMacroMethods_this$31.__saveState();
                                        start = ParserMacroMethods_this$31.cursor();
                                        start = ParserMacroMethods_this$31.cursor();
                                        try {
                                            v2 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this$31.cursorChar()) && ParserMacroMethods_this$31.__advance() && ParserMacroMethods_this$31.__updateMaxCursor() || ParserMacroMethods_this$31.__registerMismatch();
                                        }
                                        catch (Throwable var21_17) {
                                            var22_18 = var21_17;
                                            if (Parser.StartTracingException$.MODULE$.equals(var22_18) == false) throw var21_17;
                                            var23_19 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("DIGIT"), 0);
                                            throw ParserMacroMethods_this$31.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var23_19), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.DIGIT()));
                                        }
                                        ll = v2;
                                        if (!ll) ** GOTO lbl62
                                        start = ParserMacroMethods_this$31.cursor();
                                        try {
                                            this.setPort(10 * this._port + this.lastChar() - 48);
                                            v3 = true;
                                        }
                                        catch (Parser.TracingBubbleException e) {
                                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                                        }
                                        {
                                            catch (Parser.TracingBubbleException e) {
                                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                            }
                                        }
                                        break block88;
lbl62:
                                        // 1 sources

                                        v3 = false;
                                    }
                                    ll = v3;
                                    if (!ll) ** GOTO lbl213
                                    start = ParserMacroMethods_this$31.cursor();
                                    mark = ParserMacroMethods_this$31.__saveState();
                                    start = ParserMacroMethods_this$31.cursor();
                                    start = ParserMacroMethods_this$31.cursor();
                                    try {
                                        v4 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this$31.cursorChar()) && ParserMacroMethods_this$31.__advance() && ParserMacroMethods_this$31.__updateMaxCursor() || ParserMacroMethods_this$31.__registerMismatch();
                                    }
                                    catch (Throwable var35_29) {
                                        var36_30 = var35_29;
                                        if (Parser.StartTracingException$.MODULE$.equals(var36_30) == false) throw var35_29;
                                        var37_31 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("DIGIT"), 0);
                                        throw ParserMacroMethods_this$31.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var37_31), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.DIGIT()));
                                    }
                                    ll = v4;
                                    if (!ll) ** GOTO lbl96
                                    start = ParserMacroMethods_this$31.cursor();
                                    try {
                                        this.setPort(10 * this._port + this.lastChar() - 48);
                                        v5 = true;
                                    }
                                    catch (Parser.TracingBubbleException e) {
                                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                                    }
                                    {
                                        catch (Parser.TracingBubbleException e) {
                                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                        }
                                    }
                                    break block89;
lbl96:
                                    // 1 sources

                                    v5 = false;
                                }
                                ll = v5;
                                if (!ll) ** GOTO lbl196
                                start = ParserMacroMethods_this$31.cursor();
                                mark = ParserMacroMethods_this$31.__saveState();
                                start = ParserMacroMethods_this$31.cursor();
                                start = ParserMacroMethods_this$31.cursor();
                                try {
                                    v6 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this$31.cursorChar()) && ParserMacroMethods_this$31.__advance() && ParserMacroMethods_this$31.__updateMaxCursor() || ParserMacroMethods_this$31.__registerMismatch();
                                }
                                catch (Throwable var49_41) {
                                    var50_42 = var49_41;
                                    if (Parser.StartTracingException$.MODULE$.equals(var50_42) == false) throw var49_41;
                                    var51_43 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("DIGIT"), 0);
                                    throw ParserMacroMethods_this$31.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var51_43), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.DIGIT()));
                                }
                                ll = v6;
                                if (!ll) ** GOTO lbl130
                                start = ParserMacroMethods_this$31.cursor();
                                try {
                                    this.setPort(10 * this._port + this.lastChar() - 48);
                                    v7 = true;
                                }
                                catch (Parser.TracingBubbleException e) {
                                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                                }
                                {
                                    catch (Parser.TracingBubbleException e) {
                                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                    }
                                }
                                break block90;
lbl130:
                                // 1 sources

                                v7 = false;
                            }
                            ll = v7;
                            if (!ll) ** GOTO lbl179
                            start = ParserMacroMethods_this$31.cursor();
                            mark = ParserMacroMethods_this$31.__saveState();
                            start = ParserMacroMethods_this$31.cursor();
                            try {
                                v8 = CharacterClasses$.MODULE$.DIGIT().apply(ParserMacroMethods_this$31.cursorChar()) && ParserMacroMethods_this$31.__advance() && ParserMacroMethods_this$31.__updateMaxCursor() || ParserMacroMethods_this$31.__registerMismatch();
                            }
                            catch (Throwable var61_52) {
                                var62_53 = var61_52;
                                if (Parser.StartTracingException$.MODULE$.equals(var62_53) == false) throw var61_52;
                                var63_54 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("DIGIT"), 0);
                                throw ParserMacroMethods_this$31.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var63_54), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.DIGIT()));
                            }
                            ll = v8;
                            if (!ll) ** GOTO lbl162
                            start = ParserMacroMethods_this$31.cursor();
                            try {
                                this.setPort(10 * this._port + this.lastChar() - 48);
                                v9 = true;
                            }
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                            }
                            {
                                catch (Parser.TracingBubbleException e) {
                                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                                }
                            }
                            break block91;
lbl162:
                            // 1 sources

                            v9 = false;
                            {
                                catch (Parser.TracingBubbleException e) {
                                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start);
                                }
                            }
                        }
                        matched = v9;
                        if (!matched) {
                            ParserMacroMethods_this$31.__restoreState(mark);
                        }
                        v10 = true;
                        {
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                            }
                        }
                        break block92;
lbl179:
                        // 1 sources

                        v10 = false;
                        {
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start);
                            }
                        }
                    }
                    matched = v10;
                    if (!matched) {
                        ParserMacroMethods_this$31.__restoreState(mark);
                    }
                    v11 = true;
                    {
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                        }
                    }
                    break block93;
lbl196:
                    // 1 sources

                    v11 = false;
                    {
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start);
                        }
                    }
                }
                matched = v11;
                if (!matched) {
                    ParserMacroMethods_this$31.__restoreState(mark);
                }
                v12 = true;
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                break block94;
lbl213:
                // 1 sources

                v12 = false;
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start);
                    }
                }
            }
            matched = v12;
            if (!matched) {
                ParserMacroMethods_this$31.__restoreState(mark);
            }
            v13 = true;
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            return v13;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("port"), start);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$26(UriParser ParserMacroMethods_this$32) {
        int start = ParserMacroMethods_this$32.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$32.cursor();
            int start3 = ParserMacroMethods_this$32.cursor();
            try {
                boolean bl3;
                try {
                    if (ParserMacroMethods_this$32.cursorChar() != '[' || !ParserMacroMethods_this$32.__advance() || !ParserMacroMethods_this$32.__updateMaxCursor()) {
                        if (!ParserMacroMethods_this$32.__registerMismatch()) return false;
                    }
                    bl3 = true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$32.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('['));
                }
                boolean ll = bl3;
                if (!ll) return false;
                if (this.ipv6Host() == null) return false;
                bl2 = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
            }
            boolean ll = bl2;
            if (!ll) return false;
            try {
                bl = ParserMacroMethods_this$32.cursorChar() == ']' && ParserMacroMethods_this$32.__advance() && ParserMacroMethods_this$32.__updateMaxCursor() || ParserMacroMethods_this$32.__registerMismatch();
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                if (!Parser.StartTracingException$.MODULE$.equals(throwable3)) throw throwable;
                throw ParserMacroMethods_this$32.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(']'));
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
                }
            }
            return bl;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("IP-literal"), start);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$27(UriParser ParserMacroMethods_this$33) {
        int start = ParserMacroMethods_this$33.cursor();
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            int start2 = ParserMacroMethods_this$33.cursor();
            int start3 = ParserMacroMethods_this$33.cursor();
            try {
                int start1 = start3;
                if (this.ip$minusv4$minusaddress() == null) return false;
                boolean bl4 = true;
                boolean matched = bl4;
                if (!matched) return false;
                ParserMacroMethods_this$33.valueStack().push((Object)ParserMacroMethods_this$33.input().sliceString(start1, ParserMacroMethods_this$33.cursor()));
                bl3 = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Capture$.MODULE$, start3);
            }
            boolean ll = bl3;
            if (!ll) return false;
            int start4 = ParserMacroMethods_this$33.cursor();
            long mark = ParserMacroMethods_this$33.__saveState();
            try {
                bl2 = CharacterClasses$.MODULE$.colonSlashEOI().apply(ParserMacroMethods_this$33.cursorChar()) && ParserMacroMethods_this$33.__advance() && ParserMacroMethods_this$33.__updateMaxCursor() || ParserMacroMethods_this$33.__registerMismatch();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                RuleTrace.NonTerminal nonTerminal = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("colonSlashEOI"), 0);
                throw ParserMacroMethods_this$33.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)nonTerminal), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.colonSlashEOI()));
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.AndPredicate$.MODULE$, start4);
                }
            }
            boolean matched = bl2;
            ParserMacroMethods_this$33.__restoreState(mark);
            boolean bl5 = matched;
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
                }
            }
            boolean ll2 = bl5;
            if (!ll2) return false;
            int start5 = ParserMacroMethods_this$33.cursor();
            try {
                String a = (String)ParserMacroMethods_this$33.valueStack().pop();
                byte[] b = (byte[])ParserMacroMethods_this$33.valueStack().pop();
                this._host = Uri$IPv4Host$.MODULE$.apply(b, a);
                bl = ParserMacroMethods_this$33.__push(BoxedUnit.UNIT);
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Action$.MODULE$, start5);
            }
            return bl;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("ipv4Host"), start);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$28(UriParser ParserMacroMethods_this$34) {
        boolean bl;
        int start = ParserMacroMethods_this$34.cursor();
        try {
            int start2 = ParserMacroMethods_this$34.cursor();
            try {
                int start3 = ParserMacroMethods_this$34.cursor();
                try {
                    int start1 = start3;
                    if (this.ip$minusv6$minusaddress() == null) return false;
                    boolean bl2 = true;
                    boolean matched = bl2;
                    if (!matched) return false;
                    ParserMacroMethods_this$34.valueStack().push((Object)ParserMacroMethods_this$34.input().sliceString(start1, ParserMacroMethods_this$34.cursor()));
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Capture$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("ipv6Host"), start);
        }
        {
            boolean ll = bl;
            if (!ll) return false;
            int start4 = ParserMacroMethods_this$34.cursor();
            try {
                String a = (String)ParserMacroMethods_this$34.valueStack().pop();
                byte[] b = (byte[])ParserMacroMethods_this$34.valueStack().pop();
                this.setHost(Uri$IPv6Host$.MODULE$.apply(b, a));
                boolean bl3 = ParserMacroMethods_this$34.__push(BoxedUnit.UNIT);
                return bl3;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Action$.MODULE$, start4);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final long rec$7(UriParser ParserMacroMethods_this$36, long mark) {
        while (true) {
            block21: {
                start = ParserMacroMethods_this$36.cursor();
                mark = ParserMacroMethods_this$36.__saveState();
                start = ParserMacroMethods_this$36.cursor();
                try {
                    v0 = CharacterClasses$.MODULE$.lower$minusreg$minusname$minuschar().apply(ParserMacroMethods_this$36.cursorChar()) && ParserMacroMethods_this$36.__advance() && ParserMacroMethods_this$36.__updateMaxCursor() || ParserMacroMethods_this$36.__registerMismatch();
                }
                catch (Throwable var12_12) {
                    var13_13 = var12_12;
                    if (!Parser.StartTracingException$.MODULE$.equals(var13_13)) {
                        throw var12_12;
                    }
                    var14_14 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("lower-reg-name-char"), 0);
                    throw ParserMacroMethods_this$36.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var14_14), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.lower$minusreg$minusname$minuschar()));
                }
                try {
                    ll = v0;
                    v1 = ll ? this.appendSB() != null : false;
                    {
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                        }
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
                }
                l = v1;
                if (l) ** GOTO lbl49
                ParserMacroMethods_this$36.__restoreState(mark);
                start = ParserMacroMethods_this$36.cursor();
                try {
                    v2 = CharacterClasses$.MODULE$.UPPER_ALPHA().apply(ParserMacroMethods_this$36.cursorChar()) && ParserMacroMethods_this$36.__advance() && ParserMacroMethods_this$36.__updateMaxCursor() || ParserMacroMethods_this$36.__registerMismatch();
                }
                catch (Throwable var18_16) {
                    var19_17 = var18_16;
                    if (!Parser.StartTracingException$.MODULE$.equals(var19_17)) {
                        throw var18_16;
                    }
                    var20_18 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("UPPER_ALPHA"), 0);
                    throw ParserMacroMethods_this$36.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var20_18), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.UPPER_ALPHA()));
                }
                ll = v2;
                v3 = ll ? this.appendLowered() != null : false;
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                break block21;
lbl49:
                // 1 sources

                v3 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this$36.__restoreState(mark);
                v4 = this.pct$minusencoded() != null;
            } else {
                v4 = true;
            }
            matched = v4;
            if (!matched) break;
            mark = ParserMacroMethods_this$36.__saveState();
        }
        return mark;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$29(UriParser ParserMacroMethods_this$35) {
        start = ParserMacroMethods_this$35.cursor();
        try {
            block26: {
                block25: {
                    start = ParserMacroMethods_this$35.cursor();
                    mark = ParserMacroMethods_this$35.__saveState();
                    start = ParserMacroMethods_this$35.cursor();
                    start = ParserMacroMethods_this$35.cursor();
                    try {
                        v0 = ll = this.clearSBForDecoding() != null;
                        if (ll) {
                            start = ParserMacroMethods_this$35.cursor();
                            try {
                                firstMark = ParserMacroMethods_this$35.__saveState();
                                mark = this.rec$7(ParserMacroMethods_this$35, firstMark);
                                if (mark != firstMark) {
                                    ParserMacroMethods_this$35.__restoreState(mark);
                                    v1 = true;
                                    break block25;
                                } else {
                                    v1 = false;
                                }
                                break block25;
                            }
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.OneOrMore$.MODULE$, start);
                            }
                        }
                        v1 = false;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                ll = v1;
                if (!ll) ** GOTO lbl44
                start = ParserMacroMethods_this$35.cursor();
                try {
                    this.setHost(Uri$NamedHost$.MODULE$.apply(this.getDecodedStringAndLowerIfEncoded(org.parboiled2.package$.MODULE$.UTF8())));
                    v2 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                }
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                break block26;
lbl44:
                // 1 sources

                v2 = false;
            }
            l = v2;
            if (l != false) return true;
            ParserMacroMethods_this$35.__restoreState(mark);
            start = ParserMacroMethods_this$35.cursor();
            try {
                this.setHost(Uri$Host$Empty$.MODULE$);
                v3 = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
                }
            }
            return v3;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("reg-name"), start);
        }
    }

    private final long rec$8(UriParser ParserMacroMethods_this$37, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean l;
            boolean bl2;
            boolean l2;
            boolean ll;
            long mark2 = ParserMacroMethods_this$37.__saveState();
            boolean bl3 = ll = CharacterClasses$.MODULE$.lower$minusreg$minusname$minuschar().apply(ParserMacroMethods_this$37.cursorChar()) && ParserMacroMethods_this$37.__advance();
            boolean bl4 = ll ? this.appendSB() != null : (l2 = false);
            if (!l2) {
                boolean ll2;
                ParserMacroMethods_this$37.__restoreState(mark2);
                boolean bl5 = ll2 = CharacterClasses$.MODULE$.UPPER_ALPHA().apply(ParserMacroMethods_this$37.cursorChar()) && ParserMacroMethods_this$37.__advance();
                bl2 = ll2 ? this.appendLowered() != null : false;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this$37.__restoreState(mark2);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$37.__saveState();
        }
        return mark;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$30(UriParser ParserMacroMethods_this$38) {
        boolean bl;
        int start = ParserMacroMethods_this$38.cursor();
        try {
            int start2 = ParserMacroMethods_this$38.cursor();
            try {
                int start3 = ParserMacroMethods_this$38.cursor();
                try {
                    if (this.clearSB() == null) return false;
                    boolean bl2 = true;
                    boolean ll = bl2;
                    if (!ll) return false;
                    if (this.slashSegments() == null) return false;
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("path-abempty"), start);
        }
        {
            boolean ll = bl;
            if (!ll) {
                return false;
            }
            if (this.savePath() == null) return false;
            return true;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$31(UriParser ParserMacroMethods_this$39) {
        start = ParserMacroMethods_this$39.cursor();
        try {
            block31: {
                start = ParserMacroMethods_this$39.cursor();
                try {
                    start = ParserMacroMethods_this$39.cursor();
                    start = ParserMacroMethods_this$39.cursor();
                    try {
                        block30: {
                            start = ParserMacroMethods_this$39.cursor();
                            try {
                                v0 = ll = this.clearSB() != null;
                                if (ll) {
                                    try {
                                        v1 = ParserMacroMethods_this$39.cursorChar() == '/' && ParserMacroMethods_this$39.__advance() && ParserMacroMethods_this$39.__updateMaxCursor() || ParserMacroMethods_this$39.__registerMismatch();
                                        break block30;
                                    }
                                    catch (Throwable var11_8) {
                                        var12_9 = var11_8;
                                        if (Parser.StartTracingException$.MODULE$.equals(var12_9) == false) throw var11_8;
                                        throw ParserMacroMethods_this$39.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('/'));
                                    }
                                }
                                v1 = false;
                            }
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                            }
                        }
                        ll = v1;
                        v2 = ll ? this.appendSB('/') != null : false;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                    ll = v2;
                    if (!ll) ** GOTO lbl56
                    start = ParserMacroMethods_this$39.cursor();
                    mark = ParserMacroMethods_this$39.__saveState();
                    start = ParserMacroMethods_this$39.cursor();
                    try {
                        v3 = ll = this.segment$minusnz() != null;
                        v4 = ll ? this.slashSegments() != null : false;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                    {
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start);
                        }
                    }
                    matched = v4;
                    if (!matched) {
                        ParserMacroMethods_this$39.__restoreState(mark);
                    }
                    v5 = true;
                    {
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                        }
                    }
                    break block31;
lbl56:
                    // 1 sources

                    v5 = false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            ll = v5;
            if (!ll) {
                return false;
            }
            if (this.savePath() == null) return false;
            return true;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("path-absolute"), start);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$32(UriParser ParserMacroMethods_this$40) {
        int start = ParserMacroMethods_this$40.cursor();
        try {
            int start2 = ParserMacroMethods_this$40.cursor();
            try {
                boolean bl;
                int start3 = ParserMacroMethods_this$40.cursor();
                try {
                    boolean bl2;
                    int start4 = ParserMacroMethods_this$40.cursor();
                    try {
                        if (this.clearSB() == null) return false;
                        boolean bl3 = true;
                        boolean ll = bl3;
                        if (!ll) return false;
                        if (this.segment$minusnz$minusnc() == null) return false;
                        bl2 = true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start4);
                    }
                    boolean ll = bl2;
                    if (!ll) return false;
                    if (this.slashSegments() == null) return false;
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
                }
                boolean ll = bl;
                if (!ll) {
                    return false;
                }
                if (this.savePath() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("path-noscheme"), start);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$33(UriParser ParserMacroMethods_this$41) {
        int start = ParserMacroMethods_this$41.cursor();
        try {
            int start2 = ParserMacroMethods_this$41.cursor();
            try {
                boolean bl;
                int start3 = ParserMacroMethods_this$41.cursor();
                try {
                    boolean bl2;
                    int start4 = ParserMacroMethods_this$41.cursor();
                    try {
                        if (this.clearSB() == null) return false;
                        boolean bl3 = true;
                        boolean ll = bl3;
                        if (!ll) return false;
                        if (this.segment$minusnz() == null) return false;
                        bl2 = true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start4);
                    }
                    boolean ll = bl2;
                    if (!ll) return false;
                    if (this.slashSegments() == null) return false;
                    bl = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
                }
                boolean ll = bl;
                if (!ll) {
                    return false;
                }
                if (this.savePath() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("path-rootless"), start);
        }
    }

    private final boolean wrapped$34(UriParser ParserMacroMethods_this$42) {
        boolean bl;
        int start = ParserMacroMethods_this$42.cursor();
        try {
            bl = this.MATCH() != null;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("path-empty"), start);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final long rec$9(UriParser ParserMacroMethods_this$44, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$44.cursor();
            try {
                boolean bl2;
                int start2 = ParserMacroMethods_this$44.cursor();
                try {
                    boolean bl3;
                    try {
                        bl3 = ParserMacroMethods_this$44.cursorChar() == '/' && ParserMacroMethods_this$44.__advance() && ParserMacroMethods_this$44.__updateMaxCursor() || ParserMacroMethods_this$44.__registerMismatch();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        throw ParserMacroMethods_this$44.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('/'));
                    }
                    boolean ll = bl3;
                    bl2 = ll ? this.appendSB('/') != null : false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
                }
                boolean ll = bl2;
                bl = ll ? this.segment() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) return mark;
            mark = ParserMacroMethods_this$44.__saveState();
        }
    }

    private final boolean wrapped$35(UriParser ParserMacroMethods_this$43) {
        boolean bl;
        int start = ParserMacroMethods_this$43.cursor();
        try {
            int start2 = ParserMacroMethods_this$43.cursor();
            try {
                ParserMacroMethods_this$43.__restoreState(this.rec$9(ParserMacroMethods_this$43, ParserMacroMethods_this$43.__saveState()));
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.ZeroOrMore$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("slashSegments"), start);
        }
        return bl;
    }

    private final long rec$10(UriParser ParserMacroMethods_this$45, long mark) {
        while (true) {
            boolean matched;
            boolean ll;
            boolean ll2;
            boolean bl = ll2 = ParserMacroMethods_this$45.cursorChar() == '/' && ParserMacroMethods_this$45.__advance();
            boolean bl2 = ll2 ? this.appendSB('/') != null : (ll = false);
            boolean bl3 = ll ? this.segment() != null : (matched = false);
            if (!matched) break;
            mark = ParserMacroMethods_this$45.__saveState();
        }
        return mark;
    }

    private final long rec$11(UriParser ParserMacroMethods_this$47, long mark) {
        while (true) {
            boolean matched;
            boolean bl = matched = this.pchar() != null;
            if (!matched) break;
            mark = ParserMacroMethods_this$47.__saveState();
        }
        return mark;
    }

    private final boolean wrapped$36(UriParser ParserMacroMethods_this$46) {
        boolean bl;
        int start = ParserMacroMethods_this$46.cursor();
        try {
            int start2 = ParserMacroMethods_this$46.cursor();
            try {
                ParserMacroMethods_this$46.__restoreState(this.rec$11(ParserMacroMethods_this$46, ParserMacroMethods_this$46.__saveState()));
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.ZeroOrMore$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("segment"), start);
        }
        return bl;
    }

    private final long rec$12(UriParser ParserMacroMethods_this$48, long mark) {
        while (true) {
            boolean matched;
            boolean bl = matched = this.pchar() != null;
            if (!matched) break;
            mark = ParserMacroMethods_this$48.__saveState();
        }
        return mark;
    }

    private final long rec$13(UriParser ParserMacroMethods_this$50, long mark) {
        while (true) {
            boolean matched;
            boolean bl = matched = this.pchar() != null;
            if (!matched) break;
            mark = ParserMacroMethods_this$50.__saveState();
        }
        return mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean wrapped$37(UriParser ParserMacroMethods_this$49) {
        int start = ParserMacroMethods_this$49.cursor();
        try {
            int start2 = ParserMacroMethods_this$49.cursor();
            try {
                long firstMark = ParserMacroMethods_this$49.__saveState();
                long mark = this.rec$13(ParserMacroMethods_this$49, firstMark);
                if (mark == firstMark) return false;
                ParserMacroMethods_this$49.__restoreState(mark);
                if (!true) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.OneOrMore$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("segment-nz"), start);
        }
    }

    private final long rec$14(UriParser ParserMacroMethods_this$51, long mark) {
        while (true) {
            boolean matched;
            boolean bl = matched = this.pchar() != null;
            if (!matched) break;
            mark = ParserMacroMethods_this$51.__saveState();
        }
        return mark;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final long rec$15(UriParser ParserMacroMethods_this$53, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$53.cursor();
            try {
                boolean bl2;
                int matchEnd = 0;
                try {
                    boolean bl3;
                    long mark2 = ParserMacroMethods_this$53.__saveState();
                    Object saved = ParserMacroMethods_this$53.__enterNotPredicate();
                    try {
                        bl3 = ParserMacroMethods_this$53.cursorChar() == ':' && ParserMacroMethods_this$53.__advance() && ParserMacroMethods_this$53.__updateMaxCursor() || ParserMacroMethods_this$53.__registerMismatch();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        throw ParserMacroMethods_this$53.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(':'));
                    }
                    boolean matched = bl3;
                    ParserMacroMethods_this$53.__exitNotPredicate(saved);
                    matchEnd = ParserMacroMethods_this$53.cursor();
                    ParserMacroMethods_this$53.__restoreState(mark2);
                    bl2 = !matched || ParserMacroMethods_this$53.__registerMismatch();
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable3)) throw throwable;
                    throw ParserMacroMethods_this$53.__bubbleUp((RuleTrace.Terminal)RuleTrace.NotPredicate$.MODULE$.apply((RuleTrace.NotPredicate$.Base)RuleTrace.NotPredicate$.Terminal$.MODULE$.apply((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(':')), matchEnd - ParserMacroMethods_this$53.cursor()));
                }
                boolean ll = bl2;
                bl = ll ? this.pchar() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) return mark;
            mark = ParserMacroMethods_this$53.__saveState();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean wrapped$38(UriParser ParserMacroMethods_this$52) {
        int start = ParserMacroMethods_this$52.cursor();
        try {
            int start2 = ParserMacroMethods_this$52.cursor();
            try {
                long firstMark = ParserMacroMethods_this$52.__saveState();
                long mark = this.rec$15(ParserMacroMethods_this$52, firstMark);
                if (mark == firstMark) return false;
                ParserMacroMethods_this$52.__restoreState(mark);
                if (!true) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.OneOrMore$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("segment-nz-nc"), start);
        }
    }

    private final long rec$16(UriParser ParserMacroMethods_this$54, long mark) {
        while (true) {
            boolean matched;
            boolean ll;
            long mark2 = ParserMacroMethods_this$54.__saveState();
            Object saved = ParserMacroMethods_this$54.__enterNotPredicate();
            boolean matched2 = ParserMacroMethods_this$54.cursorChar() == ':' && ParserMacroMethods_this$54.__advance();
            ParserMacroMethods_this$54.__exitNotPredicate(saved);
            ParserMacroMethods_this$54.__restoreState(mark2);
            boolean bl = ll = !matched2;
            boolean bl2 = ll ? this.pchar() != null : (matched = false);
            if (!matched) break;
            mark = ParserMacroMethods_this$54.__saveState();
        }
        return mark;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$39(UriParser ParserMacroMethods_this$55) {
        int start = ParserMacroMethods_this$55.cursor();
        try {
            int start2 = ParserMacroMethods_this$55.cursor();
            try {
                boolean bl;
                long mark = ParserMacroMethods_this$55.__saveState();
                int start3 = ParserMacroMethods_this$55.cursor();
                try {
                    boolean bl2;
                    try {
                        bl2 = this.path$minussegment$minuschar.apply(ParserMacroMethods_this$55.cursorChar()) && ParserMacroMethods_this$55.__advance() && ParserMacroMethods_this$55.__updateMaxCursor() || ParserMacroMethods_this$55.__registerMismatch();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        RuleTrace.NonTerminal nonTerminal = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("path-segment-char"), 0);
                        throw ParserMacroMethods_this$55.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)nonTerminal), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(this.path$minussegment$minuschar));
                    }
                    boolean ll = bl2;
                    if (ll) {
                        if (this.appendSB() != null) {
                            return true;
                        }
                        bl = false;
                    } else {
                        bl = false;
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
                }
                boolean l = bl;
                if (l) {
                    return true;
                }
                ParserMacroMethods_this$55.__restoreState(mark);
                if (this.pct$minusencoded() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("pchar"), start);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final long rec$17(UriParser ParserMacroMethods_this$57, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$57.cursor();
            try {
                boolean bl2;
                long mark2 = ParserMacroMethods_this$57.__saveState();
                int start2 = ParserMacroMethods_this$57.cursor();
                try {
                    boolean bl3;
                    try {
                        bl3 = this.query$minuschar.apply(ParserMacroMethods_this$57.cursorChar()) && ParserMacroMethods_this$57.__advance() && ParserMacroMethods_this$57.__updateMaxCursor() || ParserMacroMethods_this$57.__registerMismatch();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        RuleTrace.NonTerminal nonTerminal = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("query-char"), 0);
                        throw ParserMacroMethods_this$57.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)nonTerminal), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(this.query$minuschar));
                    }
                    boolean ll = bl3;
                    bl2 = ll ? this.appendSB() != null : false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
                }
                boolean l = bl2;
                if (!l) {
                    ParserMacroMethods_this$57.__restoreState(mark2);
                    bl = this.pct$minusencoded() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) return mark;
            mark = ParserMacroMethods_this$57.__saveState();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$40(UriParser ParserMacroMethods_this$56) {
        start = ParserMacroMethods_this$56.cursor();
        try {
            block26: {
                block25: {
                    start = ParserMacroMethods_this$56.cursor();
                    mark = ParserMacroMethods_this$56.__saveState();
                    start = ParserMacroMethods_this$56.cursor();
                    start = ParserMacroMethods_this$56.cursor();
                    try {
                        v0 = ll = this.clearSB() != null;
                        if (ll) {
                            start = ParserMacroMethods_this$56.cursor();
                            try {
                                firstMark = ParserMacroMethods_this$56.__saveState();
                                mark = this.rec$17(ParserMacroMethods_this$56, firstMark);
                                if (mark != firstMark) {
                                    ParserMacroMethods_this$56.__restoreState(mark);
                                    v1 = true;
                                    break block25;
                                } else {
                                    v1 = false;
                                }
                                break block25;
                            }
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.OneOrMore$.MODULE$, start);
                            }
                        }
                        v1 = false;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                ll = v1;
                if (!ll) ** GOTO lbl44
                start = ParserMacroMethods_this$56.cursor();
                try {
                    this.setRawQueryString(this.sb().toString());
                    v2 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                }
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                break block26;
lbl44:
                // 1 sources

                v2 = false;
            }
            l = v2;
            if (l != false) return true;
            ParserMacroMethods_this$56.__restoreState(mark);
            start = ParserMacroMethods_this$56.cursor();
            try {
                this.setRawQueryString("");
                v3 = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
                }
            }
            return v3;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("rawQueryString"), start);
        }
    }

    private final long rec$18(UriParser ParserMacroMethods_this$58, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean l;
            boolean ll;
            long mark2 = ParserMacroMethods_this$58.__saveState();
            boolean bl2 = ll = this.query$minuschar.apply(ParserMacroMethods_this$58.cursorChar()) && ParserMacroMethods_this$58.__advance();
            boolean bl3 = ll ? this.appendSB() != null : (l = false);
            if (!l) {
                ParserMacroMethods_this$58.__restoreState(mark2);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$58.__saveState();
        }
        return mark;
    }

    /*
     * Unable to fully structure code
     */
    private final long rec$19(UriParser ParserMacroMethods_this$60, CharPredicate query$minuschar$2, long mark) {
        while (true) {
            block21: {
                start = ParserMacroMethods_this$60.cursor();
                mark = ParserMacroMethods_this$60.__saveState();
                start = ParserMacroMethods_this$60.cursor();
                try {
                    v0 = ParserMacroMethods_this$60.cursorChar() == '+' && ParserMacroMethods_this$60.__advance() && ParserMacroMethods_this$60.__updateMaxCursor() || ParserMacroMethods_this$60.__registerMismatch();
                }
                catch (Throwable var13_13) {
                    var14_14 = var13_13;
                    if (!Parser.StartTracingException$.MODULE$.equals(var14_14)) {
                        throw var13_13;
                    }
                    throw ParserMacroMethods_this$60.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('+'));
                }
                try {
                    ll = v0;
                    v1 = ll ? this.appendSB(' ') != null : false;
                    {
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                        }
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
                }
                l = v1;
                if (l) ** GOTO lbl48
                ParserMacroMethods_this$60.__restoreState(mark);
                start = ParserMacroMethods_this$60.cursor();
                try {
                    v2 = query$minuschar$2.apply(ParserMacroMethods_this$60.cursorChar()) && ParserMacroMethods_this$60.__advance() && ParserMacroMethods_this$60.__updateMaxCursor() || ParserMacroMethods_this$60.__registerMismatch();
                }
                catch (Throwable var18_16) {
                    var19_17 = var18_16;
                    if (!Parser.StartTracingException$.MODULE$.equals(var19_17)) {
                        throw var18_16;
                    }
                    var20_18 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("query-char"), 0);
                    throw ParserMacroMethods_this$60.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var20_18), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(query$minuschar$2));
                }
                ll = v2;
                v3 = ll ? this.appendSB() != null : false;
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                break block21;
lbl48:
                // 1 sources

                v3 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this$60.__restoreState(mark);
                v4 = this.pct$minusencoded() != null;
            } else {
                v4 = true;
            }
            matched = v4;
            if (!matched) break;
            mark = ParserMacroMethods_this$60.__saveState();
        }
        return mark;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$41(UriParser ParserMacroMethods_this$59, CharPredicate query$minuschar$1) {
        int start = ParserMacroMethods_this$59.cursor();
        try {
            int start2 = ParserMacroMethods_this$59.cursor();
            try {
                boolean bl;
                long mark = ParserMacroMethods_this$59.__saveState();
                int start3 = ParserMacroMethods_this$59.cursor();
                try {
                    boolean bl2;
                    block20: {
                        int start4 = ParserMacroMethods_this$59.cursor();
                        try {
                            boolean ll;
                            boolean bl3 = ll = this.clearSBForDecoding() != null;
                            if (ll) {
                                int start5 = ParserMacroMethods_this$59.cursor();
                                try {
                                    long firstMark = ParserMacroMethods_this$59.__saveState();
                                    long mark2 = this.rec$19(ParserMacroMethods_this$59, query$minuschar$1, firstMark);
                                    if (mark2 != firstMark) {
                                        ParserMacroMethods_this$59.__restoreState(mark2);
                                        bl2 = true;
                                        break block20;
                                    } else {
                                        bl2 = false;
                                    }
                                    break block20;
                                }
                                catch (Parser.TracingBubbleException e) {
                                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.OneOrMore$.MODULE$, start5);
                                }
                            }
                            bl2 = false;
                        }
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start4);
                        }
                    }
                    boolean ll = bl2;
                    if (ll) {
                        ParserMacroMethods_this$59.valueStack().push((Object)this.getDecodedString(this.getDecodedString$default$1()));
                        return true;
                    }
                    bl = false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
                }
                boolean l = bl;
                if (l) return true;
                ParserMacroMethods_this$59.__restoreState(mark);
                ParserMacroMethods_this$59.valueStack().push((Object)"");
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("part"), start);
        }
    }

    private final long rec$20(UriParser ParserMacroMethods_this$61, CharPredicate query$minuschar$3, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean l;
            boolean bl2;
            boolean l2;
            boolean ll;
            long mark2 = ParserMacroMethods_this$61.__saveState();
            boolean bl3 = ll = ParserMacroMethods_this$61.cursorChar() == '+' && ParserMacroMethods_this$61.__advance();
            boolean bl4 = ll ? this.appendSB(' ') != null : (l2 = false);
            if (!l2) {
                boolean ll2;
                ParserMacroMethods_this$61.__restoreState(mark2);
                boolean bl5 = ll2 = query$minuschar$3.apply(ParserMacroMethods_this$61.cursorChar()) && ParserMacroMethods_this$61.__advance();
                bl2 = ll2 ? this.appendSB() != null : false;
            } else {
                bl2 = l = true;
            }
            if (!l) {
                ParserMacroMethods_this$61.__restoreState(mark2);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$61.__saveState();
        }
        return mark;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Rule part$1(CharPredicate query$minuschar) {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$41(ParserMacroMethods_this, query$minuschar);
        } else {
            boolean l;
            boolean bl2;
            boolean ll;
            boolean bl3;
            boolean ll2;
            long mark = ParserMacroMethods_this.__saveState();
            boolean bl4 = ll2 = this.clearSBForDecoding() != null;
            if (ll2) {
                long firstMark = ParserMacroMethods_this.__saveState();
                long mark2 = this.rec$20(ParserMacroMethods_this, query$minuschar, firstMark);
                if (mark2 != firstMark) {
                    ParserMacroMethods_this.__restoreState(mark2);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = ll = false;
            }
            if (ll) {
                ParserMacroMethods_this.valueStack().push((Object)this.getDecodedString(this.getDecodedString$default$1()));
                bl2 = true;
            } else {
                bl2 = l = false;
            }
            if (!l) {
                ParserMacroMethods_this.__restoreState(mark);
                ParserMacroMethods_this.valueStack().push((Object)"");
                bl = true;
            } else {
                bl = matched = true;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$42(UriParser ParserMacroMethods_this$62) {
        int start = ParserMacroMethods_this$62.cursor();
        try {
            int start2 = ParserMacroMethods_this$62.cursor();
            try {
                if (this.part$1(this.query$minuskey$minuschar) == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                int start3 = ParserMacroMethods_this$62.cursor();
                try {
                    boolean bl2;
                    long mark = ParserMacroMethods_this$62.__saveState();
                    int start4 = ParserMacroMethods_this$62.cursor();
                    try {
                        boolean bl3;
                        try {
                            bl3 = ParserMacroMethods_this$62.cursorChar() == '=' && ParserMacroMethods_this$62.__advance() && ParserMacroMethods_this$62.__updateMaxCursor() || ParserMacroMethods_this$62.__registerMismatch();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                            throw ParserMacroMethods_this$62.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('='));
                        }
                        boolean ll2 = bl3;
                        if (ll2) {
                            if (this.part$1(this.query$minusvalue$minuschar) != null) {
                                return true;
                            }
                            bl2 = false;
                        } else {
                            bl2 = false;
                        }
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start4);
                    }
                    boolean l = bl2;
                    if (l) return true;
                    ParserMacroMethods_this$62.__restoreState(mark);
                    ParserMacroMethods_this$62.valueStack().push((Object)Uri$Query$.MODULE$.EmptyValue());
                    return true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("keyValuePair"), start);
        }
    }

    private final Rule keyValuePair$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$42(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.part$1(this.query$minuskey$minuschar) != null;
            if (ll) {
                boolean l;
                boolean ll2;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl3 = ll2 = ParserMacroMethods_this.cursorChar() == '=' && ParserMacroMethods_this.__advance();
                boolean bl4 = ll2 ? this.part$1(this.query$minusvalue$minuschar) != null : (l = false);
                if (!l) {
                    ParserMacroMethods_this.__restoreState(mark);
                    ParserMacroMethods_this.valueStack().push((Object)Uri$Query$.MODULE$.EmptyValue());
                    bl = true;
                } else {
                    bl = true;
                }
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final long rec$21(UriParser ParserMacroMethods_this$64, long mark) {
        while (true) {
            boolean bl;
            block10: {
                int start = ParserMacroMethods_this$64.cursor();
                try {
                    boolean ll;
                    boolean bl2;
                    try {
                        bl2 = ParserMacroMethods_this$64.cursorChar() == '&' && ParserMacroMethods_this$64.__advance() && ParserMacroMethods_this$64.__updateMaxCursor() || ParserMacroMethods_this$64.__registerMismatch();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        throw ParserMacroMethods_this$64.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('&'));
                    }
                    boolean ll2 = bl2;
                    boolean bl3 = ll2 ? this.keyValuePair$1() != null : (ll = false);
                    if (ll) {
                        int start2 = ParserMacroMethods_this$64.cursor();
                        try {
                            String value = (String)ParserMacroMethods_this$64.valueStack().pop();
                            String key = (String)ParserMacroMethods_this$64.valueStack().pop();
                            Uri.Query.Cons prefix = (Uri.Query.Cons)ParserMacroMethods_this$64.valueStack().pop();
                            bl = ParserMacroMethods_this$64.__push(Uri$Query$Cons$.MODULE$.apply(key, value, prefix));
                            break block10;
                        }
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Action$.MODULE$, start2);
                        }
                    }
                    bl = false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            boolean matched = bl;
            if (!matched) return mark;
            mark = ParserMacroMethods_this$64.__saveState();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$43(UriParser ParserMacroMethods_this$63) {
        start = ParserMacroMethods_this$63.cursor();
        try {
            block23: {
                start = ParserMacroMethods_this$63.cursor();
                start = ParserMacroMethods_this$63.cursor();
                try {
                    if (this.keyValuePair$1() == null) return false;
                    v0 = true;
                    ll = v0;
                    if (ll == false) return false;
                    start = ParserMacroMethods_this$63.cursor();
                    try {
                        value = (String)ParserMacroMethods_this$63.valueStack().pop();
                        key = (String)ParserMacroMethods_this$63.valueStack().pop();
                        v1 = ParserMacroMethods_this$63.__push(Uri$Query$Cons$.MODULE$.apply(key, value, Uri$Query$Empty$.MODULE$));
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Action$.MODULE$, start);
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
                ll = v1;
                if (ll == false) return false;
                start = ParserMacroMethods_this$63.cursor();
                start = ParserMacroMethods_this$63.cursor();
                try {
                    ParserMacroMethods_this$63.__restoreState(this.rec$21(ParserMacroMethods_this$63, ParserMacroMethods_this$63.__saveState()));
                    v2 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.ZeroOrMore$.MODULE$, start);
                }
                ll = v2;
                if (!ll) ** GOTO lbl47
                start = ParserMacroMethods_this$63.cursor();
                try {
                    var17_17 = (Uri.Query.Cons)ParserMacroMethods_this$63.valueStack().pop();
                    v3 = ParserMacroMethods_this$63.__push(var17_17.reverse());
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Action$.MODULE$, start);
                }
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                break block23;
lbl47:
                // 1 sources

                v3 = false;
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
            }
            return v3;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("keyValuePairsWithLimitedStackUse"), start);
        }
    }

    private final long rec$22(UriParser ParserMacroMethods_this$65, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean ll;
            boolean ll2;
            boolean bl2 = ll2 = ParserMacroMethods_this$65.cursorChar() == '&' && ParserMacroMethods_this$65.__advance();
            boolean bl3 = ll2 ? this.keyValuePair$1() != null : (ll = false);
            if (ll) {
                String value = (String)ParserMacroMethods_this$65.valueStack().pop();
                String key = (String)ParserMacroMethods_this$65.valueStack().pop();
                Uri.Query.Cons prefix = (Uri.Query.Cons)ParserMacroMethods_this$65.valueStack().pop();
                bl = ParserMacroMethods_this$65.__push(Uri$Query$Cons$.MODULE$.apply(key, value, prefix));
            } else {
                bl = matched = false;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$65.__saveState();
        }
        return mark;
    }

    private final Rule keyValuePairsWithLimitedStackUse$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$43(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3 = ll2 = this.keyValuePair$1() != null;
            if (ll2) {
                String value = (String)ParserMacroMethods_this.valueStack().pop();
                String key = (String)ParserMacroMethods_this.valueStack().pop();
                bl2 = ParserMacroMethods_this.__push(Uri$Query$Cons$.MODULE$.apply(key, value, Uri$Query$Empty$.MODULE$));
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                ParserMacroMethods_this.__restoreState(this.rec$22(ParserMacroMethods_this, ParserMacroMethods_this.__saveState()));
                boolean ll3 = true;
                if (ll3) {
                    Uri.Query.Cons cons = (Uri.Query.Cons)ParserMacroMethods_this.valueStack().pop();
                    bl = ParserMacroMethods_this.__push(cons.reverse());
                } else {
                    bl = false;
                }
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$44(UriParser ParserMacroMethods_this$66) {
        int start = ParserMacroMethods_this$66.cursor();
        try {
            boolean bl;
            boolean bl2;
            int start2 = ParserMacroMethods_this$66.cursor();
            if (this.keyValuePair$1() == null) return false;
            boolean bl3 = true;
            boolean ll = bl3;
            if (!ll) return false;
            int start3 = ParserMacroMethods_this$66.cursor();
            try {
                boolean bl4;
                long mark = ParserMacroMethods_this$66.__saveState();
                int start4 = ParserMacroMethods_this$66.cursor();
                try {
                    boolean bl5;
                    try {
                        bl5 = ParserMacroMethods_this$66.cursorChar() == '&' && ParserMacroMethods_this$66.__advance() && ParserMacroMethods_this$66.__updateMaxCursor() || ParserMacroMethods_this$66.__registerMismatch();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        throw ParserMacroMethods_this$66.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('&'));
                    }
                    boolean ll2 = bl5;
                    bl4 = ll2 ? this.keyValuePairs$1() != null : false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start4);
                }
                boolean l = bl4;
                if (!l) {
                    ParserMacroMethods_this$66.__restoreState(mark);
                    ParserMacroMethods_this$66.valueStack().push((Object)Uri$Query$Empty$.MODULE$);
                    bl2 = true;
                } else {
                    bl2 = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start3);
            }
            boolean ll3 = bl2;
            if (!ll3) return false;
            int start5 = ParserMacroMethods_this$66.cursor();
            try {
                Uri.Query tail = (Uri.Query)ParserMacroMethods_this$66.valueStack().pop();
                String value = (String)ParserMacroMethods_this$66.valueStack().pop();
                String key = (String)ParserMacroMethods_this$66.valueStack().pop();
                bl = ParserMacroMethods_this$66.__push(Uri$Query$Cons$.MODULE$.apply(key, value, tail));
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Action$.MODULE$, start5);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
                }
            }
            return bl;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("keyValuePairsWithReversalAvoidance"), start);
        }
    }

    private final Rule keyValuePairsWithReversalAvoidance$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$44(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2;
            boolean ll2;
            boolean bl3 = ll2 = this.keyValuePair$1() != null;
            if (ll2) {
                boolean l;
                boolean ll3;
                long mark = ParserMacroMethods_this.__saveState();
                boolean bl4 = ll3 = ParserMacroMethods_this.cursorChar() == '&' && ParserMacroMethods_this.__advance();
                boolean bl5 = ll3 ? this.keyValuePairs$1() != null : (l = false);
                if (!l) {
                    ParserMacroMethods_this.__restoreState(mark);
                    ParserMacroMethods_this.valueStack().push((Object)Uri$Query$Empty$.MODULE$);
                    bl2 = true;
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = ll = false;
            }
            if (ll) {
                Uri.Query tail = (Uri.Query)ParserMacroMethods_this.valueStack().pop();
                String value = (String)ParserMacroMethods_this.valueStack().pop();
                String key = (String)ParserMacroMethods_this.valueStack().pop();
                bl = ParserMacroMethods_this.__push(Uri$Query$Cons$.MODULE$.apply(key, value, tail));
            } else {
                bl = matched = false;
            }
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    private final Rule keyValuePairs$1() {
        if (this.valueStack().size() + 5 <= this.maxValueStackSize()) {
            return this.keyValuePairsWithReversalAvoidance$1();
        }
        return this.keyValuePairsWithLimitedStackUse$1();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$45(UriParser ParserMacroMethods_this$67) {
        int start = ParserMacroMethods_this$67.cursor();
        try {
            int start2 = ParserMacroMethods_this$67.cursor();
            try {
                boolean bl;
                long mark = ParserMacroMethods_this$67.__saveState();
                int start3 = ParserMacroMethods_this$67.cursor();
                try {
                    boolean bl2;
                    try {
                        bl2 = ParserMacroMethods_this$67.cursorChar() == this.EOI() && ParserMacroMethods_this$67.__advance() && ParserMacroMethods_this$67.__updateMaxCursor() || ParserMacroMethods_this$67.__registerMismatch();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        throw ParserMacroMethods_this$67.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                    }
                    boolean ll = bl2;
                    if (ll) {
                        ParserMacroMethods_this$67.valueStack().push((Object)Uri$Query$Empty$.MODULE$);
                        return true;
                    }
                    bl = false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
                }
                boolean l = bl;
                if (l) {
                    return true;
                }
                ParserMacroMethods_this$67.__restoreState(mark);
                if (this.keyValuePairs$1() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("query"), start);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final long rec$23(UriParser ParserMacroMethods_this$69, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$69.cursor();
            try {
                boolean bl2;
                long mark2 = ParserMacroMethods_this$69.__saveState();
                int start2 = ParserMacroMethods_this$69.cursor();
                try {
                    boolean bl3;
                    try {
                        bl3 = this.fragment$minuschar.apply(ParserMacroMethods_this$69.cursorChar()) && ParserMacroMethods_this$69.__advance() && ParserMacroMethods_this$69.__updateMaxCursor() || ParserMacroMethods_this$69.__registerMismatch();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        RuleTrace.NonTerminal nonTerminal = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("fragment-char"), 0);
                        throw ParserMacroMethods_this$69.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)nonTerminal), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(this.fragment$minuschar));
                    }
                    boolean ll = bl3;
                    bl2 = ll ? this.appendSB() != null : false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
                }
                boolean l = bl2;
                if (!l) {
                    ParserMacroMethods_this$69.__restoreState(mark2);
                    bl = this.pct$minusencoded() != null;
                } else {
                    bl = true;
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) return mark;
            mark = ParserMacroMethods_this$69.__saveState();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$46(UriParser ParserMacroMethods_this$68) {
        start = ParserMacroMethods_this$68.cursor();
        try {
            block26: {
                block25: {
                    start = ParserMacroMethods_this$68.cursor();
                    mark = ParserMacroMethods_this$68.__saveState();
                    start = ParserMacroMethods_this$68.cursor();
                    start = ParserMacroMethods_this$68.cursor();
                    try {
                        v0 = ll = this.clearSBForDecoding() != null;
                        if (ll) {
                            start = ParserMacroMethods_this$68.cursor();
                            try {
                                firstMark = ParserMacroMethods_this$68.__saveState();
                                mark = this.rec$23(ParserMacroMethods_this$68, firstMark);
                                if (mark != firstMark) {
                                    ParserMacroMethods_this$68.__restoreState(mark);
                                    v1 = true;
                                    break block25;
                                } else {
                                    v1 = false;
                                }
                                break block25;
                            }
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.OneOrMore$.MODULE$, start);
                            }
                        }
                        v1 = false;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                ll = v1;
                if (!ll) ** GOTO lbl44
                start = ParserMacroMethods_this$68.cursor();
                try {
                    this.setFragment(this.getDecodedString(this.getDecodedString$default$1()));
                    v2 = true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
                }
                {
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                    }
                }
                break block26;
lbl44:
                // 1 sources

                v2 = false;
            }
            l = v2;
            if (l != false) return true;
            ParserMacroMethods_this$68.__restoreState(mark);
            start = ParserMacroMethods_this$68.cursor();
            try {
                this.setFragment("");
                v3 = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start);
                }
            }
            return v3;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("fragment"), start);
        }
    }

    private final long rec$24(UriParser ParserMacroMethods_this$70, long mark) {
        while (true) {
            boolean matched;
            boolean bl;
            boolean l;
            boolean ll;
            long mark2 = ParserMacroMethods_this$70.__saveState();
            boolean bl2 = ll = this.fragment$minuschar.apply(ParserMacroMethods_this$70.cursorChar()) && ParserMacroMethods_this$70.__advance();
            boolean bl3 = ll ? this.appendSB() != null : (l = false);
            if (!l) {
                ParserMacroMethods_this$70.__restoreState(mark2);
                bl = this.pct$minusencoded() != null;
            } else {
                bl = matched = true;
            }
            if (!matched) break;
            mark = ParserMacroMethods_this$70.__saveState();
        }
        return mark;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$47(UriParser ParserMacroMethods_this$71) {
        start = ParserMacroMethods_this$71.cursor();
        try {
            start = ParserMacroMethods_this$71.cursor();
            start = ParserMacroMethods_this$71.cursor();
            start = ParserMacroMethods_this$71.cursor();
            try {
                if (ParserMacroMethods_this$71.cursorChar() != '%' || !ParserMacroMethods_this$71.__advance() || !ParserMacroMethods_this$71.__updateMaxCursor()) {
                    if (ParserMacroMethods_this$71.__registerMismatch() == false) return false;
                }
                v0 = true;
            }
            catch (Throwable var9_6) {
                var10_7 = var9_6;
                if (Parser.StartTracingException$.MODULE$.equals(var10_7) == false) throw var9_6;
                throw ParserMacroMethods_this$71.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('%'));
            }
            ll = v0;
            if (ll == false) return false;
            try {
                v1 = CharacterClasses$.MODULE$.HEXDIG().apply(ParserMacroMethods_this$71.cursorChar()) && ParserMacroMethods_this$71.__advance() && ParserMacroMethods_this$71.__updateMaxCursor() || ParserMacroMethods_this$71.__registerMismatch();
            }
            catch (Throwable var11_9) {
                var12_10 = var11_9;
                if (Parser.StartTracingException$.MODULE$.equals(var12_10) == false) throw var11_9;
                var13_11 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("HEXDIG"), 0);
                throw ParserMacroMethods_this$71.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var13_11), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.HEXDIG()));
            }
lbl-1000:
            // 2 sources

            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            ** try [egrp 8[TRYBLOCK] [4 : 223->230)] { 
            {
            }
lbl33:
            // 1 sources

            ll = v1;
            if (ll == false) return false;
            try {
                v2 = CharacterClasses$.MODULE$.HEXDIG().apply(ParserMacroMethods_this$71.cursorChar()) && ParserMacroMethods_this$71.__advance() && ParserMacroMethods_this$71.__updateMaxCursor() || ParserMacroMethods_this$71.__registerMismatch();
            }
            catch (Throwable var15_14) {
                var16_15 = var15_14;
                if (Parser.StartTracingException$.MODULE$.equals(var16_15) == false) throw var15_14;
                var17_16 = RuleTrace.NonTerminal$.MODULE$.apply((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("HEXDIG"), 0);
                throw ParserMacroMethods_this$71.__bubbleUp(package$.MODULE$.Nil().$colon$colon((Object)var17_16), (RuleTrace.Terminal)RuleTrace.CharPredicateMatch$.MODULE$.apply(CharacterClasses$.MODULE$.HEXDIG()));
            }
lbl-1000:
            // 3 sources

            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            ** try [egrp 12[TRYBLOCK] [10 : 370->377)] { 
            {
            }
lbl48:
            // 1 sources

            ll = v2;
            if (ll == false) return false;
            start = ParserMacroMethods_this$71.cursor();
            try {
                if (this._firstPercentIx == -1) {
                    this._firstPercentIx = this.sb().length();
                }
                this.sb().append('%').append(this.charAt(-2)).append(this.lastChar());
                v3 = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start);
            }
            {
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
                }
            }
            return v3;
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("pct-encoded"), start);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final long rec$25(UriParser ParserMacroMethods_this$73, long mark) {
        while (true) {
            boolean bl;
            int start = ParserMacroMethods_this$73.cursor();
            try {
                boolean bl2;
                int start2 = ParserMacroMethods_this$73.cursor();
                try {
                    boolean bl3;
                    try {
                        bl3 = ParserMacroMethods_this$73.cursorChar() == '/' && ParserMacroMethods_this$73.__advance() && ParserMacroMethods_this$73.__updateMaxCursor() || ParserMacroMethods_this$73.__registerMismatch();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                        throw ParserMacroMethods_this$73.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('/'));
                    }
                    boolean ll = bl3;
                    bl2 = ll ? this.appendSB('/') != null : false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
                }
                boolean ll = bl2;
                bl = ll ? this.segment() != null : false;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start);
            }
            boolean matched = bl;
            if (!matched) return mark;
            mark = ParserMacroMethods_this$73.__saveState();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$48(UriParser ParserMacroMethods_this$72) {
        int start = ParserMacroMethods_this$72.cursor();
        try {
            int start2 = ParserMacroMethods_this$72.cursor();
            try {
                boolean bl;
                int start3 = ParserMacroMethods_this$72.cursor();
                try {
                    if (this.clearSB() == null) return false;
                    boolean bl2 = true;
                    boolean ll = bl2;
                    if (!ll) return false;
                    int start4 = ParserMacroMethods_this$72.cursor();
                    try {
                        long firstMark = ParserMacroMethods_this$72.__saveState();
                        long mark = this.rec$25(ParserMacroMethods_this$72, firstMark);
                        if (mark == firstMark) return false;
                        ParserMacroMethods_this$72.__restoreState(mark);
                        bl = true;
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.OneOrMore$.MODULE$, start4);
                    }
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
                }
                boolean ll = bl;
                if (!ll) {
                    return false;
                }
                if (this.savePath() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("absolute-path"), start);
        }
    }

    private final long rec$26(UriParser ParserMacroMethods_this$74, long mark) {
        while (true) {
            boolean matched;
            boolean ll;
            boolean ll2;
            boolean bl = ll2 = ParserMacroMethods_this$74.cursorChar() == '/' && ParserMacroMethods_this$74.__advance();
            boolean bl2 = ll2 ? this.appendSB('/') != null : (ll = false);
            boolean bl3 = ll ? this.segment() != null : (matched = false);
            if (!matched) break;
            mark = ParserMacroMethods_this$74.__saveState();
        }
        return mark;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$49(UriParser ParserMacroMethods_this$75) {
        int start = ParserMacroMethods_this$75.cursor();
        try {
            int start2 = ParserMacroMethods_this$75.cursor();
            try {
                boolean bl;
                long mark = ParserMacroMethods_this$75.__saveState();
                int start3 = ParserMacroMethods_this$75.cursor();
                try {
                    boolean ll;
                    boolean bl2 = ll = this.absolute$minuspath() != null;
                    if (ll) {
                        int start4 = ParserMacroMethods_this$75.cursor();
                        try {
                            boolean bl3;
                            long mark2 = ParserMacroMethods_this$75.__saveState();
                            int start5 = ParserMacroMethods_this$75.cursor();
                            try {
                                boolean bl4;
                                try {
                                    bl4 = ParserMacroMethods_this$75.cursorChar() == '?' && ParserMacroMethods_this$75.__advance() && ParserMacroMethods_this$75.__updateMaxCursor() || ParserMacroMethods_this$75.__registerMismatch();
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2 = throwable;
                                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                                    throw ParserMacroMethods_this$75.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('?'));
                                }
                                boolean ll2 = bl4;
                                if (ll2) {
                                    if (this.rawQueryString() != null) {
                                        return true;
                                    }
                                    bl3 = false;
                                } else {
                                    bl3 = false;
                                }
                            }
                            catch (Parser.TracingBubbleException e) {
                                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start5);
                            }
                            boolean matched = bl3;
                            if (!matched) {
                                ParserMacroMethods_this$75.__restoreState(mark2);
                            }
                            return true;
                        }
                        catch (Parser.TracingBubbleException e) {
                            throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start4);
                        }
                    }
                    bl = false;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start3);
                }
                boolean l = bl;
                if (l) return true;
                ParserMacroMethods_this$75.__restoreState(mark);
                if (this.absolute$minusURI() != null) {
                    return true;
                }
                boolean bl5 = false;
                boolean l2 = bl5;
                if (l2) {
                    return true;
                }
                ParserMacroMethods_this$75.__restoreState(mark);
                if (this.authority() == null) return false;
                return true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.FirstOf$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("request-target"), start);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$50(UriParser ParserMacroMethods_this$76) {
        int start = ParserMacroMethods_this$76.cursor();
        try {
            int start2 = ParserMacroMethods_this$76.cursor();
            try {
                if (this.request$minustarget() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$76.cursorChar() == this.EOI() && ParserMacroMethods_this$76.__advance()) {
                        if (ParserMacroMethods_this$76.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$76.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$76.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseHttpRequestTarget"), start);
        }
    }

    private final Rule parseHttpRequestTarget$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$50(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.request$minustarget() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$51(UriParser ParserMacroMethods_this$77) {
        int start = ParserMacroMethods_this$77.cursor();
        try {
            int start2 = ParserMacroMethods_this$77.cursor();
            try {
                if (this.http2$minusauthority$minuspseudo$minusheader() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$77.cursorChar() == this.EOI() && ParserMacroMethods_this$77.__advance()) {
                        if (ParserMacroMethods_this$77.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$77.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$77.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseHttp2AuthorityPseudoHeader"), start);
        }
    }

    private final Rule parseHttp2AuthorityPseudoHeader$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$51(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.http2$minusauthority$minuspseudo$minusheader() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$52(UriParser ParserMacroMethods_this$78) {
        int start = ParserMacroMethods_this$78.cursor();
        try {
            int start2 = ParserMacroMethods_this$78.cursor();
            try {
                if (this.absolute$minuspath() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                int start3 = ParserMacroMethods_this$78.cursor();
                try {
                    boolean bl2;
                    long mark = ParserMacroMethods_this$78.__saveState();
                    int start4 = ParserMacroMethods_this$78.cursor();
                    try {
                        boolean bl3;
                        try {
                            bl3 = ParserMacroMethods_this$78.cursorChar() == '?' && ParserMacroMethods_this$78.__advance() && ParserMacroMethods_this$78.__updateMaxCursor() || ParserMacroMethods_this$78.__registerMismatch();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                            throw ParserMacroMethods_this$78.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply('?'));
                        }
                        boolean ll2 = bl3;
                        if (ll2) {
                            if (this.rawQueryString() != null) {
                                return true;
                            }
                            bl2 = false;
                        } else {
                            bl2 = false;
                        }
                    }
                    catch (Parser.TracingBubbleException e) {
                        throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start4);
                    }
                    boolean matched = bl2;
                    if (!matched) {
                        ParserMacroMethods_this$78.__restoreState(mark);
                    }
                    return true;
                }
                catch (Parser.TracingBubbleException e) {
                    throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Optional$.MODULE$, start3);
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("http2-path-pseudo-header"), start);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean wrapped$53(UriParser ParserMacroMethods_this$79) {
        int start = ParserMacroMethods_this$79.cursor();
        try {
            int start2 = ParserMacroMethods_this$79.cursor();
            try {
                if (this.http2$minuspath$minuspseudo$minusheader() == null) return false;
                boolean bl = true;
                boolean ll = bl;
                if (!ll) return false;
                try {
                    if (ParserMacroMethods_this$79.cursorChar() == this.EOI() && ParserMacroMethods_this$79.__advance()) {
                        if (ParserMacroMethods_this$79.__updateMaxCursor()) return true;
                    }
                    if (!ParserMacroMethods_this$79.__registerMismatch()) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!Parser.StartTracingException$.MODULE$.equals(throwable2)) throw throwable;
                    throw ParserMacroMethods_this$79.__bubbleUp((RuleTrace.Terminal)RuleTrace.CharMatch$.MODULE$.apply(this.EOI()));
                }
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Sequence$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("parseHttp2PathPseudoHeader"), start);
        }
    }

    private final Rule parseHttp2PathPseudoHeader$$anonfun$1() {
        boolean matched;
        boolean bl;
        UriParser ParserMacroMethods_this = this;
        if (ParserMacroMethods_this.__inErrorAnalysis()) {
            bl = this.wrapped$53(ParserMacroMethods_this);
        } else {
            boolean ll;
            boolean bl2 = ll = this.http2$minuspath$minuspseudo$minusheader() != null;
            bl = ll ? ParserMacroMethods_this.cursorChar() == this.EOI() && ParserMacroMethods_this.__advance() : (matched = false);
        }
        if (matched) {
            return (Rule)Rule$.MODULE$;
        }
        return null;
    }

    private final boolean wrapped$54(UriParser ParserMacroMethods_this$80) {
        boolean bl;
        int start = ParserMacroMethods_this$80.cursor();
        try {
            int start2 = ParserMacroMethods_this$80.cursor();
            try {
                this.sb().append(CharUtils$.MODULE$.toLowerCase(this.lastChar()));
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("appendLowered"), start);
        }
        return bl;
    }

    private final boolean wrapped$55(UriParser ParserMacroMethods_this$81) {
        boolean bl;
        int start = ParserMacroMethods_this$81.cursor();
        try {
            int start2 = ParserMacroMethods_this$81.cursor();
            try {
                this.setPath(Uri$Path$.MODULE$.apply(this.sb().toString(), this.uriParsingCharset()));
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("savePath"), start);
        }
        return bl;
    }

    private final boolean wrapped$56(UriParser ParserMacroMethods_this$82) {
        boolean bl;
        int start = ParserMacroMethods_this$82.cursor();
        try {
            int start2 = ParserMacroMethods_this$82.cursor();
            try {
                this.sb().setLength(0);
                this._firstPercentIx = -1;
                bl = true;
            }
            catch (Parser.TracingBubbleException e) {
                throw e.bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Run$.MODULE$, start2);
            }
        }
        catch (Parser.TracingBubbleException e) {
            throw e.prepend((RuleTrace.NonTerminalKey)RuleTrace.RuleCall$.MODULE$, start).bubbleUp((RuleTrace.NonTerminalKey)RuleTrace.Named$.MODULE$.apply("clearSBForDecoding"), start);
        }
        return bl;
    }
}

