/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.model;

import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.http.javadsl.model.ContentType;
import org.apache.pekko.http.javadsl.model.HttpCharset;
import org.apache.pekko.http.javadsl.model.MediaRange;

@DoNotInherit
public interface MediaType {
    public String mainType();

    public String subType();

    public boolean isCompressible();

    public boolean binary();

    public boolean isApplication();

    public boolean isAudio();

    public boolean isImage();

    public boolean isMessage();

    public boolean isMultipart();

    public boolean isText();

    public boolean isVideo();

    public MediaRange toRange();

    public MediaRange toRange(float var1);

    public String value();

    public static interface Binary
    extends MediaType {
        public ContentType.Binary toContentType();
    }

    public static interface Compressibility {
        public boolean compressible();
    }

    public static interface Multipart
    extends Binary {
    }

    public static interface NonBinary
    extends MediaType {
    }

    public static interface WithFixedCharset
    extends NonBinary {
        public ContentType.WithFixedCharset toContentType();
    }

    public static interface WithOpenCharset
    extends NonBinary {
        public ContentType.WithCharset toContentType(HttpCharset var1);

        public ContentType.WithMissingCharset toContentTypeWithMissingCharset();
    }
}

