/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl;

import com.typesafe.sslconfig.pekko.PekkoSSLConfig;
import com.typesafe.sslconfig.pekko.PekkoSSLConfig$;
import com.typesafe.sslconfig.pekko.util.PekkoLoggerFactory;
import com.typesafe.sslconfig.ssl.ClientAuth;
import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import com.typesafe.sslconfig.util.LoggerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.stream.TLSClientAuth;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Seq;

public interface DefaultSSLContextCreation {
    public ActorSystem system();

    public static PekkoSSLConfig sslConfig$(DefaultSSLContextCreation $this) {
        return $this.sslConfig();
    }

    default public PekkoSSLConfig sslConfig() {
        return (PekkoSSLConfig)PekkoSSLConfig$.MODULE$.apply((ClassicActorSystemProvider)this.system());
    }

    private LoggingAdapter log() {
        return this.system().log();
    }

    public static void validateAndWarnAboutLooseSettings$(DefaultSSLContextCreation $this) {
        $this.validateAndWarnAboutLooseSettings();
    }

    default public void validateAndWarnAboutLooseSettings() {
    }

    public static HttpsConnectionContext createDefaultClientHttpsContext$(DefaultSSLContextCreation $this) {
        return $this.createDefaultClientHttpsContext();
    }

    default public HttpsConnectionContext createDefaultClientHttpsContext() {
        return this.createClientHttpsContext((PekkoSSLConfig)PekkoSSLConfig$.MODULE$.apply((ClassicActorSystemProvider)this.system()));
    }

    public static HttpsConnectionContext createServerHttpsContext$(DefaultSSLContextCreation $this, PekkoSSLConfig sslConfig) {
        return $this.createServerHttpsContext(sslConfig);
    }

    default public HttpsConnectionContext createServerHttpsContext(PekkoSSLConfig sslConfig) {
        this.log().warning("Automatic server-side configuration is not supported yet, will attempt to use client-side settings. Instead it is recommended to construct the Servers HttpsConnectionContext manually (via SSLContext).");
        return this.createClientHttpsContext(sslConfig);
    }

    public static HttpsConnectionContext createClientHttpsContext$(DefaultSSLContextCreation $this, PekkoSSLConfig sslConfig) {
        return $this.createClientHttpsContext(sslConfig);
    }

    default public HttpsConnectionContext createClientHttpsContext(PekkoSSLConfig sslConfig) {
        None$ none$;
        SSLContext sSLContext;
        SSLConfigSettings config = sslConfig.config();
        LoggingAdapter log = Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromClass());
        PekkoLoggerFactory mkLogger = new PekkoLoggerFactory(this.system());
        if (sslConfig.config().default()) {
            log.debug("buildSSLContext: ssl-config.default is true, using default SSLContext");
            sslConfig.validateDefaultTrustManager(config);
            sSLContext = SSLContext.getDefault();
        } else {
            KeyManagerFactoryWrapper keyManagerFactory = sslConfig.buildKeyManagerFactory(config);
            TrustManagerFactoryWrapper trustManagerFactory = sslConfig.buildTrustManagerFactory(config);
            sSLContext = new ConfigSSLContextBuilder((LoggerFactory)mkLogger, config, keyManagerFactory, trustManagerFactory).build();
        }
        SSLContext sslContext = sSLContext;
        SSLParameters defaultParams = sslContext.getDefaultSSLParameters();
        Object[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = sslConfig.configureProtocols((String[])defaultProtocols, config);
        defaultParams.setProtocols(protocols);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        Object[] cipherSuites = sslConfig.configureCipherSuites(defaultCiphers, config);
        defaultParams.setCipherSuites((String[])cipherSuites);
        ClientAuth clientAuth = config.sslParametersConfig().clientAuth();
        if (ClientAuth.Default$.MODULE$.equals(clientAuth)) {
            none$ = None$.MODULE$;
        } else if (ClientAuth.Want$.MODULE$.equals(clientAuth)) {
            none$ = Some$.MODULE$.apply((Object)TLSClientAuth.Want$.MODULE$);
        } else if (ClientAuth.Need$.MODULE$.equals(clientAuth)) {
            none$ = Some$.MODULE$.apply((Object)TLSClientAuth.Need$.MODULE$);
        } else if (ClientAuth.None$.MODULE$.equals(clientAuth)) {
            none$ = Some$.MODULE$.apply((Object)TLSClientAuth.None$.MODULE$);
        } else {
            throw new MatchError((Object)clientAuth);
        }
        None$ clientAuth2 = none$;
        if (!sslConfig.config().loose().disableHostnameVerification()) {
            defaultParams.setEndpointIdentificationAlgorithm("https");
        }
        return new HttpsConnectionContext(sslContext, (Option<PekkoSSLConfig>)Some$.MODULE$.apply((Object)sslConfig), (Option<Seq<String>>)Some$.MODULE$.apply((Object)Predef$.MODULE$.wrapRefArray(cipherSuites).toList()), (Option<Seq<String>>)Some$.MODULE$.apply((Object)Predef$.MODULE$.wrapRefArray(defaultProtocols).toList()), (Option<TLSClientAuth>)clientAuth2, (Option<SSLParameters>)Some$.MODULE$.apply((Object)defaultParams));
    }
}

